/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.torrent.MetaDataUpdateListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.TorrentListView;
import com.aelitis.azureus.ui.swt.views.TorrentListViewListener;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListView;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.PublishUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;

public class MediaList
extends SkinView {
    private static final int ASYOUTYPE_UPDATEDELAY = 150;
    private SWTSkinObjectText lblCountAreaNotOurs;
    private SWTSkinObjectText lblCountAreaOurs;
    private TorrentListView view;
    private String PREFIX = "my-media-";
    private AzureusCore core;
    private SWTSkinObjectImage skinImgThumb;
    private SWTSkinObjectText skinDetailInfo;
    private MetaDataUpdateListener listener;
    protected String sLastSearch = "";
    private Text txtFilter;
    private boolean bRegexSearch;
    private Label lblX;
    private TimerEvent searchUpdateEvent;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        Control control;
        SelectedContentManager.changeCurrentlySelectedContent(this.PREFIX, null, this.view);
        this.core = AzureusCoreFactory.getSingleton();
        this.view = new TorrentListView(this, this.PREFIX, 2, false, true){

            public boolean isOurDownload(DownloadManager dm) {
                if (PlatformTorrentUtils.getAdId(dm.getTorrent()) != null) {
                    return false;
                }
                if (MediaList.this.sLastSearch.length() == 0) {
                    return true;
                }
                boolean bOurs = true;
                try {
                    String[][] names = new String[][]{{"", dm.getDisplayName()}, {"t:", dm.getTorrent().getAnnounceURL().getHost()}, {"st:", "" + dm.getState()}};
                    String name = names[0][1];
                    String tmpSearch = MediaList.this.sLastSearch;
                    for (int i = 0; i < names.length; ++i) {
                        if (!tmpSearch.startsWith(names[i][0])) continue;
                        tmpSearch = tmpSearch.substring(names[i][0].length());
                        name = names[i][1];
                    }
                    String s = MediaList.this.bRegexSearch ? tmpSearch : "\\Q" + tmpSearch.replaceAll("[|;]", "\\\\E|\\\\Q") + "\\E";
                    Pattern pattern = Pattern.compile(s, 2);
                    if (!pattern.matcher(name).find()) {
                        bOurs = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bOurs;
            }
        };
        if (this.view instanceof ListView) {
            this.view.addCountChangeListener(new TableCountChangeListener(){

                public void rowRemoved(TableRowCore row) {
                }

                public void rowAdded(TableRowCore row) {
                    Object dataSource = row.getDataSource(true);
                    if (dataSource instanceof DownloadManager) {
                        MediaList.this.updateRowFGColor((DownloadManager)dataSource);
                    }
                }
            });
        }
        this.view.addListener(new TorrentListViewListener(){
            boolean countChanging = false;

            public void stateChanged(DownloadManager manager) {
                MediaList.this.updateRowFGColor(manager);
            }

            public void countChanged() {
                if (this.countChanging) {
                    return;
                }
                this.countChanging = true;
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        int count;
                        countChanging = false;
                        long totalOurs = 0L;
                        long totalNotOurs = 0L;
                        GlobalManager globalManager = MediaList.this.core.getGlobalManager();
                        Object[] dms = globalManager.getDownloadManagers().toArray();
                        for (int i = 0; i < dms.length; ++i) {
                            DownloadManager dm = (DownloadManager)dms[i];
                            if (!dm.isDownloadComplete(false)) continue;
                            if (PublishUtils.isPublished(dm)) {
                                ++totalOurs;
                                continue;
                            }
                            ++totalNotOurs;
                        }
                        if (MediaList.this.lblCountAreaOurs != null) {
                            MediaList.this.lblCountAreaOurs.setText(MessageText.getString("v3.MainWindow." + MediaList.this.PREFIX + "ours.count", new String[]{"" + totalOurs}));
                        }
                        if (MediaList.this.lblCountAreaNotOurs != null) {
                            MediaList.this.lblCountAreaNotOurs.setText(MessageText.getString("v3.MainWindow." + MediaList.this.PREFIX + "notours.count", new String[]{"" + totalNotOurs}));
                            MediaList.this.lblCountAreaNotOurs.getControl().getParent().layout(true, true);
                        }
                        if ((count = MediaList.this.view.getSelectedRowsSize()) == 0 || count > 1) {
                            MediaList.this.updateDetailsInfo();
                        }
                    }
                });
            }
        });
        skinObject = this.getSkinObject(this.PREFIX + "bigthumb");
        if (skinObject instanceof SWTSkinObjectImage) {
            this.listener = new MetaDataUpdateListener(){

                public void metaDataUpdated(TOTorrent torrent) {
                    DownloadManager dm;
                    ListRow rowFocused = MediaList.this.view.getRowFocused();
                    if (rowFocused != null && (dm = (DownloadManager)rowFocused.getDataSource(true)).getTorrent().equals(torrent)) {
                        MediaList.this.update();
                    }
                }
            };
            PlatformTorrentUtils.addListener(this.listener);
            this.skinImgThumb = (SWTSkinObjectImage)skinObject;
            this.view.addSelectionListener(new TableSelectionAdapter(){

                public void deselected(TableRowCore[] rows) {
                    MediaList.this.update();
                }

                public void selected(TableRowCore[] rows) {
                    MediaList.this.update();
                }

                public void focusChanged(TableRowCore focusedRow) {
                    MediaList.this.update();
                }
            }, false);
        }
        if ((skinObject = this.getSkinObject(this.PREFIX + "detail-info")) instanceof SWTSkinObjectText) {
            this.skinDetailInfo = (SWTSkinObjectText)skinObject;
            this.view.addSelectionListener(new TableSelectionAdapter(){

                public void deselected(TableRowCore[] rows) {
                    MediaList.this.updateDetailsInfo();
                }

                public void selected(TableRowCore[] rows) {
                    MediaList.this.updateDetailsInfo();
                }

                public void focusChanged(TableRowCore focusedRow) {
                    MediaList.this.updateDetailsInfo();
                }
            }, true);
        }
        if ((skinObject = this.getSkinObject(this.PREFIX + "filter-box")) != null && (control = skinObject.getControl()) instanceof Composite) {
            Composite composite = (Composite)control;
            this.txtFilter = new Text(composite, 2048);
            this.txtFilter.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MediaList.this.sLastSearch = ((Text)e.widget).getText();
                    MediaList.this.updateLastSearch();
                }
            });
            FormData formData = Utils.getFilledFormData();
            formData.top = null;
            this.txtFilter.setLayoutData((Object)formData);
            composite.layout();
            int h = this.txtFilter.getClientArea().height - (Constants.isOSX ? 0 : 2);
            Font font = Utils.getFontWithHeight(this.txtFilter.getFont(), null, h);
            composite.getParent().layout();
            if (font != null) {
                final Font fFont = font;
                this.txtFilter.setFont(fFont);
                this.txtFilter.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (fFont != null && !fFont.isDisposed()) {
                            MediaList.this.txtFilter.setFont(null);
                            fFont.dispose();
                        }
                    }
                });
            }
            this.txtFilter.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    int key = e.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (e.stateMask == 262144 && key == 120) {
                        MediaList.this.bRegexSearch = !MediaList.this.bRegexSearch;
                        e.doit = false;
                        MediaList.this.updateLastSearch();
                    }
                }
            });
            this.view.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    int key = e.character;
                    if (key <= 26 && key > 0) {
                        key += 96;
                    }
                    if (e.stateMask == 262144 && key == 120) {
                        MediaList.this.bRegexSearch = !MediaList.this.bRegexSearch;
                        e.doit = false;
                        MediaList.this.updateLastSearch();
                        return;
                    }
                    if (e.keyCode != 8 && ((e.stateMask & 0xFFFDFFFF) != 0 || e.character < ' ' || e.character == '\u007f')) {
                        return;
                    }
                    if (e.keyCode == 8) {
                        if (e.stateMask == 262144) {
                            MediaList.this.sLastSearch = "";
                        } else if (MediaList.this.sLastSearch.length() > 0) {
                            MediaList.this.sLastSearch = MediaList.this.sLastSearch.substring(0, MediaList.this.sLastSearch.length() - 1);
                        }
                    } else {
                        MediaList.this.sLastSearch = MediaList.this.sLastSearch + String.valueOf(e.character);
                    }
                    if (MediaList.this.txtFilter != null && !MediaList.this.txtFilter.isDisposed()) {
                        MediaList.this.txtFilter.setFocus();
                    }
                    MediaList.this.updateLastSearch();
                    e.doit = false;
                }
            });
        }
        return null;
    }

    protected void updateRowFGColor(DownloadManager manager) {
        if (manager == null) {
            return;
        }
        TableRowSWT row = this.view.getRowSWT(manager);
        if (row == null) {
            return;
        }
        if (manager.isDownloadComplete(false)) {
            row.setForeground((Color)null);
        } else {
            Color c = this.view.getSkinProperties().getColor("color.library.incomplete");
            row.setForeground(c);
        }
    }

    protected void updateLastSearch() {
        if (this.txtFilter != null && !this.txtFilter.isDisposed()) {
            if (!this.sLastSearch.equals(this.txtFilter.getText())) {
                this.txtFilter.setText(this.sLastSearch);
                this.txtFilter.setSelection(this.sLastSearch.length());
            }
            if (this.bRegexSearch) {
                try {
                    Pattern.compile(this.sLastSearch, 2);
                    Display display = this.txtFilter.getDisplay();
                    this.txtFilter.setBackground(display.getSystemColor(29));
                    this.txtFilter.setForeground(display.getSystemColor(28));
                    Messages.setLanguageTooltip((Widget)this.txtFilter, "MyTorrentsView.filter.tooltip");
                }
                catch (Exception e) {
                    this.txtFilter.setBackground(Colors.colorErrorBG);
                    this.txtFilter.setForeground(null);
                    this.txtFilter.setToolTipText(e.getMessage());
                }
            } else {
                this.txtFilter.setBackground(null);
                this.txtFilter.setForeground(null);
                Messages.setLanguageTooltip((Widget)this.txtFilter, "MyTorrentsView.filter.tooltip");
            }
        }
        if (this.lblX != null && !this.lblX.isDisposed()) {
            Image img = ImageRepository.getImage(this.sLastSearch.length() > 0 ? "smallx" : "smallx-gray");
            this.lblX.setImage(img);
        }
        if (this.searchUpdateEvent != null) {
            this.searchUpdateEvent.cancel();
        }
        this.searchUpdateEvent = SimpleTimer.addEvent("SearchUpdate", SystemTime.getOffsetTime(150L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (MediaList.this.searchUpdateEvent.isCancelled()) {
                    MediaList.this.searchUpdateEvent = null;
                    return;
                }
                MediaList.this.searchUpdateEvent = null;
                MediaList.this.doFilter();
            }
        });
    }

    protected void doFilter() {
        this.view.tableStructureChanged();
    }

    private void updateDetailsInfo() {
        if (this.skinDetailInfo == null) {
            return;
        }
        int count = this.view.getSelectedRowsSize();
        if (count == 0 || count > 1) {
            int completed = 0;
            ListRow[] rowsUnsorted = this.view.getRowsUnsorted();
            int all = rowsUnsorted.length;
            for (int i = 0; i < all; ++i) {
                ListRow row = rowsUnsorted[i];
                DownloadManager dm = (DownloadManager)row.getDataSource(true);
                if (dm == null || !dm.isDownloadComplete(false)) continue;
                ++completed;
            }
            this.skinDetailInfo.setText(MessageText.getString("v3.MainWindow.myMedia.noneSelected", new String[]{"" + all, "" + completed}));
            return;
        }
        TableRowCore[] rows = this.view.getSelectedRows();
        String sText = "";
        DownloadManager dm = (DownloadManager)rows[0].getDataSource(true);
        if (dm != null) {
            TOTorrent torrent = dm.getTorrent();
            String s = PlatformTorrentUtils.getContentTitle(torrent);
            if (s != null) {
                sText = sText + s + "\n\n";
            }
            if ((s = PlatformTorrentUtils.getContentDescription(torrent)) != null) {
                sText = sText + s + "\n";
            }
        }
        this.skinDetailInfo.setText(sText);
    }

    private void update() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                byte[] imageBytes;
                int count = MediaList.this.view.getSelectedRowsSize();
                if (count != 1) {
                    MediaList.this.skinImgThumb.setImage(null);
                    return;
                }
                TableRowCore[] rows = MediaList.this.view.getSelectedRows();
                Image image = null;
                DownloadManager dm = (DownloadManager)rows[0].getDataSource(true);
                if (dm != null && (imageBytes = PlatformTorrentUtils.getContentThumbnail(dm.getTorrent())) != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);
                    image = new Image((Device)MediaList.this.skinImgThumb.getControl().getDisplay(), (InputStream)bais);
                }
                Image oldImage = MediaList.this.skinImgThumb.getImage();
                Utils.disposeSWTObjects(new Object[]{oldImage});
                MediaList.this.skinImgThumb.setImage(image);
            }
        });
    }
}

