/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SBC_ActivityTableView;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.Utils;

public class SBC_ActivityView
extends SkinView {
    public static final String ID = "activity-list";
    public static final int MODE_BIGTABLE = -1;
    public static final int MODE_SMALLTABLE = 0;
    public static final int MODE_DEFAULT = 0;
    private static final String[] modeViewIDs = new String[]{"activity-small-area"};
    private static final String[] modeIDs = new String[]{"activity.table.small"};
    private int viewMode = -1;
    private SWTSkinButtonUtility btnSmallTable;
    private SWTSkinButtonUtility btnBigTable;
    private SWTSkinObject soListArea;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.soListArea = this.getSkinObject("activity-list-area");
        SWTSkinObject so = this.getSkinObject("activity-list-button-smalltable");
        if (so != null) {
            this.btnSmallTable = new SWTSkinButtonUtility(so);
            this.btnSmallTable.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_ActivityView.this.setViewMode(0, true);
                }
            });
        }
        if ((so = this.getSkinObject("activity-list-button-bigtable")) != null) {
            this.btnBigTable = new SWTSkinButtonUtility(so);
            this.btnBigTable.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_ActivityView.this.setViewMode(-1, true);
                }
            });
        }
        if ((so = this.getSkinObject("activity-list-button-right")) != null) {
            so.setVisible(true);
            SWTSkinButtonUtility btnReadAll = new SWTSkinButtonUtility(so);
            btnReadAll.setTextID("v3.activity.button.readall");
            btnReadAll.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    VuzeActivitiesEntry[] allEntries = VuzeActivitiesManager.getAllEntries();
                    for (int i = 0; i < allEntries.length; ++i) {
                        VuzeActivitiesEntry entry = allEntries[i];
                        entry.setRead(true);
                    }
                }
            });
        }
        this.setViewMode(COConfigurationManager.getIntParameter("activity-list.viewmode", 0), false);
        return null;
    }

    public int getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(int viewMode, boolean save) {
        SideBarEntrySWT entry;
        SWTSkinObject soViewArea;
        SWTSkinObject soOldViewArea;
        if (viewMode >= modeViewIDs.length || viewMode < 0) {
            viewMode = 0;
        }
        if (viewMode == this.viewMode) {
            return;
        }
        int oldViewMode = this.viewMode;
        this.viewMode = viewMode;
        this.soListArea = this.getSkinObject("activity-list-area");
        this.soListArea.getControl().setData("ViewMode", (Object)new Long(viewMode));
        if (oldViewMode >= 0 && oldViewMode < modeViewIDs.length && (soOldViewArea = this.getSkinObject(modeViewIDs[oldViewMode])) != null) {
            soOldViewArea.setVisible(false);
        }
        if ((soViewArea = this.getSkinObject(modeViewIDs[viewMode])) == null) {
            soViewArea = this.skin.createSkinObject(modeIDs[viewMode], modeIDs[viewMode], this.soListArea);
            this.skin.layout();
            soViewArea.setVisible(true);
            soViewArea.getControl().setLayoutData((Object)Utils.getFilledFormData());
        } else {
            soViewArea.setVisible(true);
        }
        if (this.btnSmallTable != null) {
            this.btnSmallTable.getSkinObject().switchSuffix(viewMode == 0 ? "-selected" : "");
        }
        if (this.btnBigTable != null) {
            this.btnBigTable.getSkinObject().switchSuffix(viewMode == -1 ? "-selected" : "");
        }
        if (save) {
            COConfigurationManager.setParameter("activity-list.viewmode", viewMode);
        }
        if ((entry = SideBar.getSideBarInfo("Activity")) != null) {
            entry.setLogID("Activity-" + viewMode);
        }
    }

    protected void removeSelected() {
        SBC_ActivityTableView tv = (SBC_ActivityTableView)SkinViewManager.getBySkinObjectID(modeIDs[this.viewMode]);
        if (tv != null) {
            tv.removeSelected();
        }
    }

    public int getNumSelected() {
        SBC_ActivityTableView tv = (SBC_ActivityTableView)SkinViewManager.getBySkinObjectID(modeIDs[this.viewMode]);
        if (tv != null) {
            return tv.getView().getSelectedRowsSize();
        }
        return 0;
    }
}

