/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.shells.LightBoxBrowserWindow;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.utils.SWTLoginUtils;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.ILoginInfoListener;
import com.aelitis.azureus.util.ImageDownloader;
import com.aelitis.azureus.util.LoginInfoManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.Utils;

public class UserAreaUtils {
    private SWTSkin skin;
    private UIFunctionsSWT uiFunctions = null;
    private boolean firstLoginStateSync = true;
    private SWTSkinObjectImage soImage;

    public UserAreaUtils(SWTSkin skin, UIFunctionsSWT uiFunctions) {
        this.skin = skin;
        this.uiFunctions = uiFunctions;
        this.updateLoginLabels(null);
        this.hookListeners();
    }

    private void hookListeners() {
        SWTSkinObject skinObject = this.skin.getSkinObject("user-info-image");
        if (skinObject != null) {
            final Control control = skinObject.getControl();
            final Menu menu = new Menu((Decorations)control.getShell(), 8);
            this.fillUserInfoMenu(menu);
            menu.addListener(22, new Listener(){

                public void handleEvent(Event event2) {
                    MenuItem[] menuItems = menu.getItems();
                    for (int i = 0; i < menuItems.length; ++i) {
                        menuItems[i].dispose();
                    }
                    UserAreaUtils.this.fillUserInfoMenu(menu);
                }
            });
            SWTSkinButtonUtility btnGo = new SWTSkinButtonUtility(skinObject);
            btnGo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    Point point = control.getShell().toDisplay(control.getParent().getLocation());
                    point.y += control.getSize().y / 2 + 10;
                    menu.setLocation(point);
                    menu.setVisible(true);
                }
            });
        }
        if ((skinObject = this.skin.getSkinObject("user-info-name")) != null) {
            SWTSkinButtonUtility btnGo = new SWTSkinButtonUtility(skinObject);
            btnGo.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    if (LoginInfoManager.getInstance().isLoggedIn()) {
                        if (null != UserAreaUtils.this.uiFunctions) {
                            String url = ConstantsV3.URL_PREFIX + "profile.start" + "?" + ConstantsV3.URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
                            UserAreaUtils.this.uiFunctions.viewURL(url, "browse", 0, 0, true, true);
                        }
                    } else {
                        SWTLoginUtils.openLoginWindow();
                    }
                }
            });
        }
        if ((skinObject = this.skin.getSkinObject("user-info-profile-image")) instanceof SWTSkinObjectImage) {
            this.soImage = (SWTSkinObjectImage)skinObject;
        }
        LoginInfoManager.getInstance().addListener(new ILoginInfoListener(){

            public void loginUpdate(LoginInfoManager.LoginInfo info, boolean isNewLoginID) {
                UserAreaUtils.this.synchLoginStates(info, isNewLoginID);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void avatarURLUpdated(String newAvatarURL) {
                final File cache = new File(SystemProperties.getUserPath(), "friends" + File.separator + newAvatarURL.hashCode() + ".ico");
                if (cache.exists()) {
                    try {
                        FileInputStream fis = new FileInputStream(cache);
                        try {
                            byte[] content = FileUtil.readInputStreamAsByteArray(fis);
                            VuzeBuddyManager.log("Using cached login avatar");
                            this.updateImage(content);
                            return;
                        }
                        finally {
                            fis.close();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                VuzeBuddyManager.log("Downloading login avatar");
                ImageDownloader.loadImage(newAvatarURL, new ImageDownloader.ImageDownloaderListener(){

                    public void imageDownloaded(byte[] image) {
                        this.updateImage(image);
                        FileUtil.writeBytesAsFile(cache.getAbsolutePath(), image);
                    }
                });
            }

            protected void updateImage(final byte[] image) {
                Utils.execSWTThread(new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        if (UserAreaUtils.this.soImage != null) {
                            Display display = Utils.getDisplay();
                            if (display == null) {
                                return;
                            }
                            ByteArrayInputStream is = new ByteArrayInputStream(image);
                            Image bigAvatarImage = new Image((Device)display, (InputStream)is);
                            Image avatarImage = new Image((Device)display, 40, 40);
                            GC gc = new GC((Drawable)avatarImage);
                            try {
                                Rectangle bounds = bigAvatarImage.getBounds();
                                try {
                                    gc.setInterpolation(2);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                gc.drawImage(bigAvatarImage, 0, 0, bounds.width, bounds.height, 0, 0, 40, 40);
                            }
                            finally {
                                gc.dispose();
                            }
                            bigAvatarImage.dispose();
                            UserAreaUtils.this.soImage.setImage(avatarImage);
                        }
                    }
                });
            }
        });
    }

    private void synchLoginStates(LoginInfoManager.LoginInfo info, boolean isNewLoginID) {
        this.updateLoginLabels(info);
        if (this.firstLoginStateSync) {
            this.firstLoginStateSync = false;
            return;
        }
        if (isNewLoginID) {
            if (null == info.userName) {
                this.resetBrowserPage("browse");
                this.resetBrowserPage("publish");
            } else {
                this.refreshBrowserPage("browse");
                this.refreshBrowserPage("publish");
            }
        }
    }

    private void updateLoginLabels(LoginInfoManager.LoginInfo info) {
        SWTSkinObject skinObjectName;
        if (info != null && null != info.userName) {
            skinObjectName = this.skin.getSkinObject("user-info-name");
            if (skinObjectName instanceof SWTSkinObjectText) {
                if (null != info.displayName) {
                    ((SWTSkinObjectText)skinObjectName).setText(info.displayName);
                } else {
                    ((SWTSkinObjectText)skinObjectName).setText(info.userName);
                }
            }
        } else {
            skinObjectName = this.skin.getSkinObject("user-info-name");
            if (skinObjectName instanceof SWTSkinObjectText) {
                ((SWTSkinObjectText)skinObjectName).setTextID("v3.MainWindow.text.log.in");
            }
        }
        SWTSkinObject skinObject = this.skin.getSkinObject("user-info");
        if (null != skinObject && !skinObject.isVisible()) {
            skinObject.setVisible(true);
        }
        Utils.execSWTThread(new Runnable(){

            public void run() {
                SWTSkinObject skinObject = UserAreaUtils.this.skin.getSkinObject("user-area");
                if (null != skinObject) {
                    Utils.relayout(skinObject.getControl());
                }
            }
        });
    }

    private void resetBrowserPage(String targetViewID) {
        SWTSkinObject skinObject = this.skin.getSkinObject(targetViewID);
        if (skinObject instanceof SWTSkinObjectBrowser) {
            ((SWTSkinObjectBrowser)skinObject).restart();
        }
    }

    private void refreshBrowserPage(final String targetViewID) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                SWTSkinObject skinObject = UserAreaUtils.this.skin.getSkinObject(targetViewID);
                if (skinObject instanceof SWTSkinObjectBrowser) {
                    ((SWTSkinObjectBrowser)skinObject).getBrowser().refresh();
                }
            }
        });
    }

    private void fillUserInfoMenu(Menu menu) {
        if (LoginInfoManager.getInstance().isLoggedIn()) {
            MenuItem item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("v3.MainWindow.text.my.account"));
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (null != UserAreaUtils.this.uiFunctions) {
                        String url = ConstantsV3.URL_PREFIX + "account.start" + "?" + ConstantsV3.URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
                        UserAreaUtils.this.uiFunctions.viewURL(url, "browse", 0, 0, true, true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("v3.MainWindow.text.my.profile"));
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (LoginInfoManager.getInstance().isLoggedIn()) {
                        if (null != UserAreaUtils.this.uiFunctions) {
                            String url = ConstantsV3.URL_PREFIX + "profile.start" + "?" + ConstantsV3.URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
                            UserAreaUtils.this.uiFunctions.viewURL(url, "browse", 0, 0, true, true);
                        }
                    } else {
                        SWTLoginUtils.openLoginWindow();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            item = new MenuItem(menu, 2);
            item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("v3.MainWindow.text.log.out"));
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    String url = ConstantsV3.URL_PREFIX + "logout.start" + "?" + ConstantsV3.URL_SUFFIX;
                    SWTSkinObject skinObject = UserAreaUtils.this.skin.getSkinObject("browse");
                    if (skinObject instanceof SWTSkinObjectBrowser) {
                        String existingURL;
                        Browser browser = ((SWTSkinObjectBrowser)skinObject).getBrowser();
                        if (null != browser && (null == (existingURL = browser.getUrl()) || existingURL.length() < 1)) {
                            ((SWTSkinObjectBrowser)skinObject).setStartURL(ConstantsV3.URL_PREFIX + "browse.start" + "?" + ConstantsV3.URL_SUFFIX);
                        }
                        ((SWTSkinObjectBrowser)skinObject).setURL(url);
                    }
                }
            });
        } else {
            LoginInfoManager.LoginInfo info = LoginInfoManager.getInstance().getUserInfo();
            MenuItem item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("v3.MainWindow.text.my.account"));
            item.setEnabled(false);
            item = new MenuItem(menu, 8);
            item.setText(MessageText.getString("v3.MainWindow.text.my.profile"));
            item.setEnabled(false);
            if (info.isRegistrationStillOpen) {
                item = new MenuItem(menu, 2);
                item = new MenuItem(menu, 8);
                item.setText(MessageText.getString("v3.MainWindow.text.get.started"));
                item.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (null != UserAreaUtils.this.uiFunctions) {
                            String url = ConstantsV3.URL_PREFIX + "register.start" + "?" + ConstantsV3.URL_SUFFIX;
                            new LightBoxBrowserWindow(url, "vuzePage", 460, 577);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
            }
        }
    }
}

