/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class PublishUtils {
    private static final String CONTENTMAP_KEY = "Plugin.azdirector.ContentMap";
    private static final String COMPLETE_ATTRIBUTE_KEY = "COMPLETE";
    public static final String PUBLISH_ATTRIBUTE_KEY = "DIRECTOR PUBLISH";

    public static boolean isPublished(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        try {
            Map mapAttr = dm.getDownloadState().getMapAttribute(CONTENTMAP_KEY);
            return mapAttr != null && mapAttr.containsKey(PUBLISH_ATTRIBUTE_KEY);
        }
        catch (Exception e) {
            Debug.out("baH", e);
            return false;
        }
    }

    public static boolean isPublished(Download download) {
        if (download instanceof DownloadImpl) {
            return PublishUtils.isPublished(((DownloadImpl)download).getDownload());
        }
        return false;
    }

    public static void setPublished(Torrent torrent) {
        if (torrent instanceof TorrentImpl) {
            PublishUtils.setPublished(((TorrentImpl)torrent).getTorrent());
        }
    }

    public static void setPublished(TOTorrent torrent) {
        try {
            if (torrent == null) {
                return;
            }
            Map map = torrent.getAdditionalMapProperty("attributes");
            if (map != null) {
                Map mapAttr = (Map)map.get(CONTENTMAP_KEY);
                mapAttr.put(PUBLISH_ATTRIBUTE_KEY, new Long(1L));
            }
        }
        catch (Exception e) {
            Debug.out("baH", e);
        }
    }

    public static void setPublished(DownloadManager dm, boolean isPublishedContent) {
        if (isPublishedContent) {
            PublishUtils.setPublished(dm);
            return;
        }
        try {
            HashMap mapAttr = dm.getDownloadState().getMapAttribute(CONTENTMAP_KEY);
            if (mapAttr == null) {
                return;
            }
            Object remove = (mapAttr = new HashMap(mapAttr)).remove(PUBLISH_ATTRIBUTE_KEY);
            if (remove != null) {
                dm.getDownloadState().setMapAttribute(CONTENTMAP_KEY, mapAttr);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static void setPublished(DownloadManager dm) {
        try {
            HashMap<String, Long> mapAttr = dm.getDownloadState().getMapAttribute(CONTENTMAP_KEY);
            mapAttr = mapAttr == null ? new HashMap<String, Long>() : new HashMap(mapAttr);
            mapAttr.put(PUBLISH_ATTRIBUTE_KEY, new Long(1L));
            dm.getDownloadState().setMapAttribute(CONTENTMAP_KEY, mapAttr);
        }
        catch (Exception e) {
            Debug.out("baH", e);
        }
    }

    public static void setPublished(Download download) {
        if (download instanceof DownloadImpl) {
            PublishUtils.setPublished(((DownloadImpl)download).getDownload());
        }
    }

    public static void setPublishComplete(DownloadManager dm) {
        try {
            HashMap<String, Long> mapAttr = dm.getDownloadState().getMapAttribute(CONTENTMAP_KEY);
            mapAttr = mapAttr == null ? new HashMap<String, Long>() : new HashMap(mapAttr);
            mapAttr.put(COMPLETE_ATTRIBUTE_KEY, new Long(1L));
            dm.getDownloadState().setMapAttribute(CONTENTMAP_KEY, mapAttr);
        }
        catch (Exception e) {
            Debug.out("baH", e);
        }
    }

    public static boolean isPublishComplete(DownloadManager dm) {
        Map mapAttr = dm.getDownloadState().getMapAttribute(CONTENTMAP_KEY);
        if (mapAttr == null) {
            return false;
        }
        Long complete = (Long)mapAttr.get(COMPLETE_ATTRIBUTE_KEY);
        return complete != null;
    }
}

