/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.protocol.AzURLStreamHandlerFactory;

public class COConfigurationManager {
    public static final int CONFIG_DEFAULT_MIN_MAX_UPLOAD_SPEED = 5;
    public static final int CONFIG_DEFAULT_MAX_DOWNLOAD_SPEED = 0;
    public static final int CONFIG_DEFAULT_MAX_CONNECTIONS_PER_TORRENT = 50;
    public static final int CONFIG_DEFAULT_MAX_CONNECTIONS_GLOBAL = 250;
    public static final int CONFIG_CACHE_SIZE_MAX_MB;
    public static final boolean ENABLE_MULTIPLE_UDP_PORTS = false;
    private static boolean pre_initialised;

    public static synchronized void preInitialise() {
        if (!pre_initialised) {
            pre_initialised = true;
            try {
                URL.setURLStreamHandlerFactory(new AzURLStreamHandlerFactory());
                System.setProperty("sun.net.inetaddr.ttl", "60");
                System.setProperty("networkaddress.cache.ttl", "60");
                System.setProperty("sun.net.client.defaultConnectTimeout", "120000");
                System.setProperty("sun.net.client.defaultReadTimeout", "60000");
                if (Constants.isOSX) {
                    System.setProperty("java.nio.preferSelect", "true");
                }
                SystemProperties.determineApplicationName();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static ConfigurationManager initialise() {
        COConfigurationManager.preInitialise();
        return ConfigurationManager.getInstance();
    }

    public static ConfigurationManager initialiseFromMap(Map data) {
        COConfigurationManager.preInitialise();
        return ConfigurationManager.getInstance(data);
    }

    public static final boolean isNewInstall() {
        return ConfigurationManager.getInstance().isNewInstall();
    }

    public static String getStringParameter(String _name) {
        return ConfigurationManager.getInstance().getStringParameter(_name);
    }

    public static String getStringParameter(String _name, String _default) {
        return ConfigurationManager.getInstance().getStringParameter(_name, _default);
    }

    public static boolean setParameter(String parameter, String value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static boolean verifyParameter(String parameter, String value) {
        return ConfigurationManager.getInstance().verifyParameter(parameter, value);
    }

    public static boolean getBooleanParameter(String _name) {
        return ConfigurationManager.getInstance().getBooleanParameter(_name);
    }

    public static boolean getBooleanParameter(String _name, boolean _default) {
        return ConfigurationManager.getInstance().getBooleanParameter(_name, _default);
    }

    public static boolean setParameter(String parameter, boolean value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static int getIntParameter(String _name) {
        return ConfigurationManager.getInstance().getIntParameter(_name);
    }

    public static int getIntParameter(String _name, int _default) {
        return ConfigurationManager.getInstance().getIntParameter(_name, _default);
    }

    public static boolean setParameter(String parameter, int value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static boolean setParameter(String parameter, long value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static long getLongParameter(String _name) {
        return ConfigurationManager.getInstance().getLongParameter(_name);
    }

    public static long getLongParameter(String _name, long _def) {
        return ConfigurationManager.getInstance().getLongParameter(_name, _def);
    }

    public static byte[] getByteParameter(String _name) {
        return ConfigurationManager.getInstance().getByteParameter(_name);
    }

    public static byte[] getByteParameter(String _name, byte[] _default) {
        return ConfigurationManager.getInstance().getByteParameter(_name, _default);
    }

    public static boolean setParameter(String parameter, byte[] value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static String getDirectoryParameter(String _name) throws IOException {
        return ConfigurationManager.getInstance().getDirectoryParameter(_name);
    }

    public static boolean setRGBParameter(String parameter, int red, int green, int blue) {
        return ConfigurationManager.getInstance().setRGBParameter(parameter, red, green, blue);
    }

    public static boolean setRGBParameter(String parameter, int[] rgb, boolean override) {
        return ConfigurationManager.getInstance().setRGBParameter(parameter, rgb, override);
    }

    public static float getFloatParameter(String _name) {
        return ConfigurationManager.getInstance().getFloatParameter(_name);
    }

    public static float getFloatParameter(String _name, float _def) {
        return ConfigurationManager.getInstance().getFloatParameter(_name, _def);
    }

    public static boolean setParameter(String parameter, float value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static boolean setParameter(String parameter, StringList value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static StringList getStringListParameter(String parameter) {
        return ConfigurationManager.getInstance().getStringListParameter(parameter);
    }

    public static boolean setParameter(String parameter, List value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static List getListParameter(String parameter, List def) {
        return ConfigurationManager.getInstance().getListParameter(parameter, def);
    }

    public static boolean setParameter(String parameter, Map value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static Map getMapParameter(String parameter, Map def) {
        return ConfigurationManager.getInstance().getMapParameter(parameter, def);
    }

    public static boolean hasParameter(String parameter, boolean explicit) {
        return ConfigurationManager.getInstance().hasParameter(parameter, explicit);
    }

    public static void save() {
        ConfigurationManager.getInstance().save();
    }

    public static void setDirty() {
        ConfigurationManager.getInstance().setDirty();
    }

    public static void addListener(COConfigurationListener listener) {
        ConfigurationManager.getInstance().addListener(listener);
    }

    public static void addParameterListener(String parameter, ParameterListener listener) {
        ConfigurationManager.getInstance().addParameterListener(parameter, listener);
    }

    public static void addParameterListener(String[] ids, ParameterListener listener) {
        ConfigurationManager instance = ConfigurationManager.getInstance();
        for (int i = 0; i < ids.length; ++i) {
            instance.addParameterListener(ids[i], listener);
        }
    }

    public static void addAndFireParameterListener(String parameter, ParameterListener listener) {
        ConfigurationManager.getInstance().addParameterListener(parameter, listener);
        listener.parameterChanged(parameter);
    }

    public static void addAndFireParameterListeners(String[] parameters, ParameterListener listener) {
        for (int i = 0; i < parameters.length; ++i) {
            ConfigurationManager.getInstance().addParameterListener(parameters[i], listener);
        }
        listener.parameterChanged(null);
    }

    public static void removeParameterListener(String parameter, ParameterListener listener) {
        ConfigurationManager.getInstance().removeParameterListener(parameter, listener);
    }

    public static void removeListener(COConfigurationListener listener) {
        ConfigurationManager.getInstance().removeListener(listener);
    }

    public static Set getAllowedParameters() {
        return ConfigurationDefaults.getInstance().getAllowedParameters();
    }

    public static Set getDefinedParameters() {
        return ConfigurationManager.getInstance().getDefinedParameters();
    }

    public static Object getParameter(String name) {
        return ConfigurationManager.getInstance().getParameter(name);
    }

    public static boolean doesParameterDefaultExist(String parameter) {
        return ConfigurationDefaults.getInstance().doesParameterDefaultExist(parameter);
    }

    public static boolean doesParameterNonDefaultExist(String parameter) {
        return ConfigurationManager.getInstance().doesParameterNonDefaultExist(parameter);
    }

    public static void registerExternalDefaults(Map addmap) {
        ConfigurationDefaults.getInstance().registerExternalDefaults(addmap);
    }

    public static void setBooleanDefault(String parameter, boolean _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static void setFloatDefault(String parameter, float _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static void setIntDefault(String parameter, int _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static void setLongDefault(String parameter, long _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static void setStringDefault(String parameter, String _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static void setByteDefault(String parameter, byte[] _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static Object getDefault(String parameter) {
        return ConfigurationDefaults.getInstance().getParameter(parameter);
    }

    public static boolean removeParameter(String parameter) {
        return ConfigurationManager.getInstance().removeParameter(parameter);
    }

    public static boolean removeRGBParameter(String parameter) {
        return ConfigurationManager.getInstance().removeRGBParameter(parameter);
    }

    static {
        long mb_1;
        long mb_32;
        long max_mem_bytes = Runtime.getRuntime().maxMemory();
        int size = (int)((max_mem_bytes - (mb_32 = 32L * (mb_1 = 0x100000L))) / mb_1);
        if (size > 1024) {
            size = 1024;
        }
        if (size < 1) {
            size = 1;
        }
        CONFIG_CACHE_SIZE_MAX_MB = size;
    }

    public static interface ParameterVerifier {
        public boolean verify(String var1, Object var2);
    }
}

