/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk;

import java.io.File;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;

public interface DiskManager {
    public static final int INITIALIZING = 1;
    public static final int ALLOCATING = 2;
    public static final int CHECKING = 3;
    public static final int READY = 4;
    public static final int FAULTY = 10;
    public static final int BLOCK_SIZE_KB = 16;
    public static final int BLOCK_SIZE = 16384;

    public void start();

    public void stop(boolean var1);

    public boolean filesExist();

    public DirectByteBuffer readBlock(int var1, int var2, int var3);

    public DiskManagerWriteRequest createWriteRequest(int var1, int var2, DirectByteBuffer var3, Object var4);

    public void enqueueWriteRequest(DiskManagerWriteRequest var1, DiskManagerWriteRequestListener var2);

    public boolean hasOutstandingWriteRequestForPiece(int var1);

    public DiskManagerReadRequest createReadRequest(int var1, int var2, int var3);

    public void enqueueReadRequest(DiskManagerReadRequest var1, DiskManagerReadRequestListener var2);

    public boolean hasOutstandingReadRequestForPiece(int var1);

    public DiskManagerCheckRequest createCheckRequest(int var1, Object var2);

    public void enqueueCheckRequest(DiskManagerCheckRequest var1, DiskManagerCheckRequestListener var2);

    public boolean hasOutstandingCheckRequestForPiece(int var1);

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest var1, DiskManagerCheckRequestListener var2);

    public void setPieceCheckingEnabled(boolean var1);

    public void saveResumeData(boolean var1) throws Exception;

    public DiskManagerPiece[] getPieces();

    public int getNbPieces();

    public DiskManagerFileInfo[] getFiles();

    public DiskManagerFileInfoSet getFileSet();

    public DiskManagerPiece getPiece(int var1);

    public DMPieceList getPieceList(int var1);

    public int getState();

    public long getTotalLength();

    public int getPieceLength();

    public int getPieceLength(int var1);

    public long getRemaining();

    public long getRemainingExcludingDND();

    public int getPercentDone();

    public String getErrorMessage();

    public void downloadEnded();

    public void downloadRemoved();

    public void moveDataFiles(File var1, String var2);

    public int getCompleteRecheckStatus();

    public boolean checkBlockConsistencyForWrite(String var1, int var2, int var3, DirectByteBuffer var4);

    public boolean checkBlockConsistencyForRead(String var1, int var2, int var3, int var4);

    public boolean checkBlockConsistencyForHint(String var1, int var2, int var3, int var4);

    public TOTorrent getTorrent();

    public File getSaveLocation();

    public void addListener(DiskManagerListener var1);

    public void removeListener(DiskManagerListener var1);

    public void saveState();

    public boolean isInteresting(int var1);

    public boolean isDone(int var1);

    public int getCacheMode();

    public void generateEvidence(IndentWriter var1);
}

