/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Vector;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.StringInterner;

public class TOTorrentFileImpl
implements TOTorrentFile {
    private final TOTorrent torrent;
    private final long file_length;
    private final byte[][] path_components;
    private final int first_piece_number;
    private final int last_piece_number;
    private final Map additional_properties = new LightHashMap(1);
    private final boolean is_utf8;

    protected TOTorrentFileImpl(TOTorrent _torrent, long _torrent_offset, long _len, String _path) throws TOTorrentException {
        this.torrent = _torrent;
        this.file_length = _len;
        this.first_piece_number = (int)(_torrent_offset / this.torrent.getPieceLength());
        this.last_piece_number = (int)((_torrent_offset + this.file_length - 1L) / this.torrent.getPieceLength());
        this.is_utf8 = true;
        try {
            Vector<byte[]> temp = new Vector<byte[]>();
            int pos = 0;
            while (true) {
                int p1;
                if ((p1 = _path.indexOf(File.separator, pos)) == -1) break;
                temp.add(_path.substring(pos, p1).getBytes("UTF8"));
                pos = p1 + 1;
            }
            temp.add(_path.substring(pos).getBytes("UTF8"));
            this.path_components = new byte[temp.size()][];
            temp.copyInto((Object[])this.path_components);
            this.checkComponents();
        }
        catch (UnsupportedEncodingException e) {
            throw new TOTorrentException("Unsupported encoding for '" + _path + "'", 7);
        }
    }

    protected TOTorrentFileImpl(TOTorrent _torrent, long _torrent_offset, long _len, byte[][] _path_components) throws TOTorrentException {
        this.torrent = _torrent;
        this.file_length = _len;
        this.path_components = _path_components;
        this.first_piece_number = (int)(_torrent_offset / this.torrent.getPieceLength());
        this.last_piece_number = (int)((_torrent_offset + this.file_length - 1L) / this.torrent.getPieceLength());
        this.is_utf8 = false;
        this.checkComponents();
    }

    protected void checkComponents() throws TOTorrentException {
        for (int i = 0; i < this.path_components.length; ++i) {
            byte[] comp2 = this.path_components[i];
            if (comp2.length == 2 && comp2[0] == 46 && comp2[1] == 46) {
                throw new TOTorrentException("Torrent file contains illegal '..' component", 6);
            }
            if (i >= this.path_components.length - 1) continue;
            this.path_components[i] = StringInterner.internBytes(this.path_components[i]);
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public long getLength() {
        return this.file_length;
    }

    public byte[][] getPathComponents() {
        return this.path_components;
    }

    protected boolean isUTF8() {
        return this.is_utf8;
    }

    protected void setAdditionalProperty(String name, Object value) {
        this.additional_properties.put(name, value);
    }

    protected Map getAdditionalProperties() {
        return this.additional_properties;
    }

    public int getFirstPieceNumber() {
        return this.first_piece_number;
    }

    public int getLastPieceNumber() {
        return this.last_piece_number;
    }

    public int getNumberOfPieces() {
        return this.getLastPieceNumber() - this.getFirstPieceNumber() + 1;
    }

    public String getRelativePath() {
        if (this.torrent == null) {
            return "";
        }
        String sRelativePath = "";
        LocaleUtilDecoder decoder = null;
        try {
            decoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(this.torrent);
            if (decoder == null) {
                LocaleUtil localeUtil = LocaleUtil.getSingleton();
                decoder = localeUtil.getSystemDecoder();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (decoder != null) {
            for (int j = 0; j < this.path_components.length; ++j) {
                try {
                    String comp2;
                    try {
                        comp2 = decoder.decodeString(this.path_components[j]);
                    }
                    catch (UnsupportedEncodingException e) {
                        System.out.println("file - unsupported encoding!!!!");
                        try {
                            comp2 = new String(this.path_components[j]);
                        }
                        catch (Exception e2) {
                            comp2 = "UnsupportedEncoding";
                        }
                    }
                    comp2 = FileUtil.convertOSSpecificChars(comp2, j != this.path_components.length - 1);
                    sRelativePath = sRelativePath + (j == 0 ? "" : File.separator) + comp2;
                    continue;
                }
                catch (Exception ex) {
                    Debug.out(ex);
                }
            }
        }
        return sRelativePath;
    }
}

