/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.File;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class AETemporaryFileHandler {
    private static final String PREFIX = "AZU";
    private static final String SUFFIX = ".tmp";
    private static boolean started_up;
    private static File tmp_dir;

    public static synchronized void startup() {
        block10: {
            if (started_up) {
                return;
            }
            started_up = true;
            try {
                tmp_dir = FileUtil.getUserFile("tmp");
                if (tmp_dir.exists()) {
                    File[] files = tmp_dir.listFiles();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            File file = files[i];
                            if (!file.getName().startsWith(PREFIX) || !file.getName().endsWith(SUFFIX)) continue;
                            if (file.isDirectory()) {
                                FileUtil.recursiveDelete(file);
                                continue;
                            }
                            file.delete();
                        }
                    }
                } else {
                    tmp_dir.mkdir();
                }
            }
            catch (Throwable e) {
                try {
                    tmp_dir = File.createTempFile(PREFIX, SUFFIX).getParentFile();
                }
                catch (Throwable f) {
                    tmp_dir = new File("");
                }
                if (e instanceof NoClassDefFoundError) break block10;
                Debug.printStackTrace(e);
            }
        }
    }

    public static File createTempFile() throws IOException {
        AETemporaryFileHandler.startup();
        return File.createTempFile(PREFIX, SUFFIX, tmp_dir);
    }

    public static File createTempDir() throws IOException {
        AETemporaryFileHandler.startup();
        for (int i = 0; i < 16; ++i) {
            File f = File.createTempFile(PREFIX, SUFFIX, tmp_dir);
            f.delete();
            if (!f.mkdirs()) continue;
            return f;
        }
        throw new IOException("Failed to create temporary directory in " + tmp_dir);
    }
}

