/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;

public class Average {
    private int refreshRate;
    private int period;
    private int nbElements;
    private long lastUpdate;
    private long[] values;

    protected Average(int _refreshRate, int _period) {
        this.refreshRate = _refreshRate;
        this.period = _period;
        this.nbElements = _period * 1000 / _refreshRate + 2;
        this.lastUpdate = this.getEffectiveTime() / (long)_refreshRate;
    }

    public static Average getInstance(int refreshRate, int period) {
        if (refreshRate < 100) {
            return null;
        }
        if (period * 1000 < refreshRate) {
            return null;
        }
        return new Average(refreshRate, period);
    }

    private synchronized void update(long timeFactor) {
        if (this.lastUpdate < timeFactor - (long)this.nbElements) {
            this.lastUpdate = timeFactor - (long)this.nbElements - 1L;
        }
        if (this.values != null) {
            for (long i = this.lastUpdate + 1L; i <= timeFactor; ++i) {
                this.values[(int)(i % (long)this.nbElements)] = 0L;
            }
            this.values[(int)((timeFactor + 1L) % (long)this.nbElements)] = 0L;
        }
        this.lastUpdate = timeFactor;
    }

    public void addValue(long value) {
        if (this.values == null && value != 0L) {
            this.values = new long[this.nbElements];
        }
        if (this.values != null) {
            long timeFactor = this.getEffectiveTime() / (long)this.refreshRate;
            this.update(timeFactor);
            int n = (int)(timeFactor % (long)this.nbElements);
            this.values[n] = this.values[n] + value;
        }
    }

    public long getAverage() {
        return this.getSum() / (long)this.period;
    }

    public double getDoubleAverage() {
        return (double)this.getSum() / (double)this.period;
    }

    public String getDoubleAverageAsString(int precision) {
        return DisplayFormatters.formatDecimal(this.getDoubleAverage(), precision);
    }

    public long getAverage(int average_period) {
        int slots;
        int n = slots = average_period <= 0 ? this.nbElements - 2 : average_period / this.refreshRate;
        if (slots <= 0) {
            slots = 1;
        } else if (slots > this.nbElements - 2) {
            slots = this.nbElements - 2;
        }
        if (slots == 1) {
            return this.getPointValue();
        }
        long res = this.getSum(slots) / (long)(this.period * slots / (this.nbElements - 2));
        return res;
    }

    public long getPointValue() {
        long timeFactor = this.getEffectiveTime() / (long)this.refreshRate;
        this.update(timeFactor);
        return this.values != null ? this.values[(int)((timeFactor - 1L) % (long)this.nbElements)] : 0L;
    }

    protected final long getSum() {
        long sum = 0L;
        if (this.values != null) {
            long timeFactor = this.getEffectiveTime() / (long)this.refreshRate;
            this.update(timeFactor);
            for (long i = timeFactor + 2L; i < timeFactor + (long)this.nbElements; ++i) {
                sum += this.values[(int)(i % (long)this.nbElements)];
            }
        }
        return sum;
    }

    protected final long getSum(int slots) {
        long timeFactor = this.getEffectiveTime() / (long)this.refreshRate;
        this.update(timeFactor);
        long sum = 0L;
        if (slots < 1) {
            slots = 1;
        } else if (slots > this.nbElements - 2) {
            slots = this.nbElements - 2;
        }
        long end_slot = timeFactor + (long)this.nbElements;
        long start_slot = end_slot - (long)slots;
        if (this.values != null) {
            for (long i = start_slot; i < end_slot; ++i) {
                sum += this.values[(int)(i % (long)this.nbElements)];
            }
        }
        return sum;
    }

    protected long getEffectiveTime() {
        return SystemTime.getMonotonousTime();
    }
}

