/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.gudy.azureus2.core3.util.LightHashMap;

public class LightHashSet
extends AbstractSet
implements Cloneable {
    private static final Object THOMBSTONE = new Object();
    private static final Object NULLKEY = new Object();
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_CAPACITY = 8;
    final float loadFactor;
    int size;
    Object[] data;

    public LightHashSet() {
        this(8, 0.75f);
    }

    public LightHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LightHashSet(Collection c) {
        this(0);
        if (c instanceof LightHashSet) {
            LightHashSet lightMap = (LightHashSet)c;
            this.size = lightMap.size;
            this.data = (Object[])lightMap.data.clone();
        } else {
            this.addAll(c);
        }
    }

    public Object clone() {
        try {
            LightHashMap newMap = (LightHashMap)super.clone();
            newMap.data = (Object[])this.data.clone();
            return newMap;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public LightHashSet(int initialCapacity, float loadFactor) {
        int capacity;
        if (loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must not be > 1");
        }
        this.loadFactor = loadFactor;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.data = new Object[capacity];
    }

    public Iterator iterator() {
        return new HashIterator();
    }

    public boolean add(Object key) {
        this.checkCapacity(1);
        return this.addInternal(key, false);
    }

    public int size() {
        return this.size;
    }

    public boolean addAll(Collection c) {
        this.checkCapacity(c.size());
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            changed |= this.addInternal(it.next(), true);
        }
        return changed;
    }

    public int capacity() {
        return this.data.length;
    }

    public Object get(Object key) {
        int idx;
        if (key == null) {
            key = NULLKEY;
        }
        if (this.keysEqual(this.data[idx = this.nonModifyingFindIndex(key)], key)) {
            return this.data[idx];
        }
        return null;
    }

    private boolean addInternal(Object key, boolean bulkAdd) {
        int idx;
        if (key == null) {
            key = NULLKEY;
        }
        int n = idx = bulkAdd ? this.nonModifyingFindIndex(key) : this.findIndex(key);
        if (this.data[idx] == null || this.data[idx] == THOMBSTONE) {
            this.data[idx] = key;
            ++this.size;
            return true;
        }
        return false;
    }

    public boolean remove(Object key) {
        int idx;
        if (this.size == 0) {
            return false;
        }
        if (key == null) {
            key = NULLKEY;
        }
        if (this.keysEqual(key, this.data[idx = this.findIndex(key)])) {
            this.removeForIndex(idx);
            return true;
        }
        return false;
    }

    private void removeForIndex(int idx) {
        this.data[idx] = THOMBSTONE;
        --this.size;
    }

    public void clear() {
        int capacity;
        this.size = 0;
        for (capacity = 1; capacity < 8; capacity <<= 1) {
        }
        this.data = new Object[capacity];
    }

    public boolean contains(Object key) {
        if (this.size == 0) {
            return false;
        }
        if (key == null) {
            key = NULLKEY;
        }
        return this.keysEqual(key, this.data[this.nonModifyingFindIndex(key)]);
    }

    private final boolean keysEqual(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o2 != null && o1.hashCode() == o2.hashCode() && o1.equals(o2);
    }

    private int findIndex(Object keyToFind) {
        int hash = keyToFind.hashCode();
        int probe = 1;
        int newIndex = hash & this.data.length - 1;
        int thombStoneIndex = -1;
        int thombStoneCount = 0;
        int thombStoneThreshold = Math.min(this.data.length - this.size, 100);
        while (this.data[newIndex] != null && !this.keysEqual(this.data[newIndex], keyToFind)) {
            if (this.data[newIndex] == THOMBSTONE) {
                if (thombStoneIndex == -1) {
                    thombStoneIndex = newIndex;
                }
                if (++thombStoneCount * 2 > thombStoneThreshold) {
                    this.compactify(0.0f);
                    thombStoneIndex = -1;
                    probe = 0;
                    thombStoneCount = 0;
                }
            }
            newIndex = hash + (probe + probe * probe >> 1) & this.data.length - 1;
            ++probe;
        }
        if (thombStoneIndex != -1 && !this.keysEqual(this.data[newIndex], keyToFind)) {
            return thombStoneIndex;
        }
        return newIndex;
    }

    private int nonModifyingFindIndex(Object keyToFind) {
        int hash = keyToFind.hashCode();
        int newIndex = hash & this.data.length - 1;
        int thombStoneIndex = -1;
        for (int probe = 1; this.data[newIndex] != null && !this.keysEqual(this.data[newIndex], keyToFind) && probe < this.data.length; ++probe) {
            if (this.data[newIndex] == THOMBSTONE && thombStoneIndex == -1) {
                thombStoneIndex = newIndex;
            }
            newIndex = hash + (probe + probe * probe >> 1) & this.data.length - 1;
        }
        if (thombStoneIndex != -1 && !this.keysEqual(this.data[newIndex], keyToFind)) {
            return thombStoneIndex;
        }
        return newIndex;
    }

    private void checkCapacity(int n) {
        int currentCapacity = this.data.length;
        if ((float)(this.size + n) < (float)currentCapacity * this.loadFactor) {
            return;
        }
        int newCapacity = currentCapacity;
        while ((float)(newCapacity <<= 1) * this.loadFactor < (float)(this.size + n)) {
        }
        this.adjustCapacity(newCapacity);
    }

    public void compactify(float compactingLoadFactor) {
        int newCapacity = 1;
        float adjustedLoadFactor = Math.abs(compactingLoadFactor);
        if (adjustedLoadFactor <= 0.0f || adjustedLoadFactor >= 1.0f) {
            adjustedLoadFactor = this.loadFactor;
        }
        while ((float)newCapacity * adjustedLoadFactor < (float)(this.size + 1)) {
            newCapacity <<= 1;
        }
        if (newCapacity < this.data.length || compactingLoadFactor >= 0.0f) {
            this.adjustCapacity(newCapacity);
        }
    }

    private void adjustCapacity(int newSize) {
        Object[] oldData = this.data;
        this.data = new Object[newSize];
        this.size = 0;
        for (int i = 0; i < oldData.length; ++i) {
            if (oldData[i] == null || oldData[i] == THOMBSTONE) continue;
            this.addInternal(oldData[i], true);
        }
    }

    static void test() {
        int i;
        Random rnd = new Random();
        byte[] buffer = new byte[5];
        String[] fillData = new String[975175];
        for (int i2 = 0; i2 < fillData.length; ++i2) {
            rnd.nextBytes(buffer);
            fillData[i2] = new String(buffer);
            fillData[i2].hashCode();
        }
        HashSet<String> s1 = new HashSet<String>();
        LightHashSet s2 = new LightHashSet();
        System.out.println("fill:");
        long time = System.currentTimeMillis();
        for (i = 0; i < fillData.length; ++i) {
            s1.add(fillData[i]);
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (i = 0; i < fillData.length; ++i) {
            s2.add(fillData[i]);
        }
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("replace-fill:");
        time = System.currentTimeMillis();
        for (i = 0; i < fillData.length; ++i) {
            s1.add(fillData[i]);
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (i = 0; i < fillData.length; ++i) {
            s2.add(fillData[i]);
        }
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("get:");
        time = System.currentTimeMillis();
        for (i = 0; i < fillData.length; ++i) {
            s1.contains(fillData[i]);
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (i = 0; i < fillData.length; ++i) {
            s2.contains(fillData[i]);
        }
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("compactify light map");
        time = System.currentTimeMillis();
        s2.compactify(0.95f);
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("transfer to hashmap");
        time = System.currentTimeMillis();
        new HashSet(s1);
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        new HashSet(s2);
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("transfer to lighthashmap");
        time = System.currentTimeMillis();
        new LightHashSet(s1);
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        new LightHashSet(s2);
        System.out.println(System.currentTimeMillis() - time);
        System.out.println("remove entry by entry");
        time = System.currentTimeMillis();
        for (i = 0; i < fillData.length; ++i) {
            s1.remove(fillData[i]);
        }
        System.out.println(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (i = 0; i < fillData.length; ++i) {
            s2.remove(fillData[i]);
        }
        System.out.println(System.currentTimeMillis() - time);
    }

    public static void main(String[] args) {
        int random;
        int i;
        System.out.println("Call with -Xmx300m -Xcomp -server");
        Thread.currentThread().setPriority(10);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        LightHashSet.test();
        System.out.println("-------------------------------------");
        System.gc();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        LightHashSet.test();
        System.out.println("\n\nPerforming sanity tests");
        Random rnd = new Random();
        byte[] buffer = new byte[25];
        String[] fillData = new String[1048];
        for (int i2 = 0; i2 < fillData.length; ++i2) {
            rnd.nextBytes(buffer);
            fillData[i2] = new String(buffer);
            fillData[i2].hashCode();
        }
        HashSet<String> s1 = new HashSet<String>();
        LightHashSet s2 = new LightHashSet();
        for (i = 0; i < fillData.length * 10; ++i) {
            random = rnd.nextInt(fillData.length);
            s1.add(null);
            s2.add(null);
            if (!((Object)s1).equals(s2)) {
                System.out.println("Error 0");
            }
            s1.add(fillData[random]);
            s2.add(fillData[random]);
            if (((Object)s1).equals(s2)) continue;
            System.out.println("Error 1");
        }
        for (i = 0; i < fillData.length / 2; ++i) {
            random = rnd.nextInt(fillData.length);
            s1.remove(fillData[random]);
            s2.remove(fillData[random]);
            if (((Object)s1).equals(s2)) continue;
            System.out.println("Error 2");
        }
        for (i = 0; i < fillData.length * 10; ++i) {
            random = rnd.nextInt(fillData.length);
            s1.add(fillData[random]);
            s1.add(null);
            s2.add(fillData[random]);
            s2.add(null);
            if (((Object)s1).equals(s2)) continue;
            System.out.println("Error 3");
        }
        Iterator i1 = s1.iterator();
        Iterator i2 = s2.iterator();
        while (i1.hasNext()) {
            i1.next();
            i1.remove();
            i2.next();
            i2.remove();
        }
        if (!((Object)s1).equals(s2)) {
            System.out.println("Error 4");
        }
        s2.clear();
        for (int i3 = 0; i3 < 100000; ++i3) {
            rnd.nextBytes(buffer);
            String s = new String(buffer);
            s2.add(s);
            s2.contains(s);
            s2.remove(s);
        }
        System.out.println("checks done");
    }

    private class HashIterator
    implements Iterator {
        private int nextIdx = -1;
        private int currentIdx = -1;
        private Object[] itData;

        public HashIterator() {
            this.itData = LightHashSet.this.data;
            this.findNext();
        }

        private void findNext() {
            do {
                ++this.nextIdx;
            } while (this.nextIdx < this.itData.length && (this.itData[this.nextIdx] == null || this.itData[this.nextIdx] == THOMBSTONE));
        }

        public void remove() {
            if (this.currentIdx == -1) {
                new IllegalStateException("No entry to delete, use next() first");
            }
            if (this.itData != LightHashSet.this.data) {
                throw new ConcurrentModificationException("removal opperation not supported as concurrent structural modification occured");
            }
            LightHashSet.this.removeForIndex(this.currentIdx);
            this.currentIdx = -1;
        }

        public boolean hasNext() {
            return this.nextIdx < this.itData.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No more entries");
            }
            this.currentIdx = this.nextIdx;
            this.findNext();
            Object key = this.itData[this.currentIdx];
            return key != NULLKEY ? key : null;
        }
    }
}

