/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;

public class SystemTime {
    public static final long TIME_GRANULARITY_MILLIS = 25L;
    private static SystemTimeProvider instance;
    private static volatile List systemTimeConsumers;
    private static volatile List monotoneTimeConsumers;
    private static volatile List clock_change_list;
    private static HighPrecisionCounter high_precision_counter;
    private static long hpc_base_time;
    private static long hpc_last_time;

    public static void useRawProvider() {
        if (!(instance instanceof RawProvider)) {
            instance = new RawProvider();
        }
    }

    public static long getCurrentTime() {
        return instance.getTime();
    }

    public static long getMonotonousTime() {
        return instance.getMonoTime();
    }

    public static long getSteppedMonotonousTime() {
        return instance.getSteppedMonoTime();
    }

    public static long getOffsetTime(long offsetMS) {
        return instance.getTime() + offsetMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConsumer(TickConsumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<TickConsumer> new_list = new ArrayList<TickConsumer>(systemTimeConsumers);
            new_list.add(c);
            systemTimeConsumers = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterConsumer(TickConsumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList new_list = new ArrayList(systemTimeConsumers);
            new_list.remove(c);
            systemTimeConsumers = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMonotonousConsumer(TickConsumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<TickConsumer> new_list = new ArrayList<TickConsumer>(monotoneTimeConsumers);
            new_list.add(c);
            monotoneTimeConsumers = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterMonotonousConsumer(TickConsumer c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList new_list = new ArrayList(monotoneTimeConsumers);
            new_list.remove(c);
            monotoneTimeConsumers = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClockChangeListener(ChangeListener c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList<ChangeListener> new_list = new ArrayList<ChangeListener>(clock_change_list);
            new_list.add(c);
            clock_change_list = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterClockChangeListener(ChangeListener c) {
        SystemTimeProvider systemTimeProvider = instance;
        synchronized (systemTimeProvider) {
            ArrayList new_list = new ArrayList(clock_change_list);
            new_list.remove(c);
            clock_change_list = new_list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getHighPrecisionCounter() {
        if (high_precision_counter == null) {
            AEDiagnostics.load15Stuff();
            Class<SystemTime> clazz = SystemTime.class;
            synchronized (SystemTime.class) {
                long now = SystemTime.getCurrentTime();
                if (now < hpc_last_time) {
                    long gone_back_by_at_least = hpc_last_time - now;
                    hpc_base_time -= gone_back_by_at_least;
                }
                hpc_last_time = now;
                // ** MonitorExit[var0] (shouldn't be in output)
                return (now - hpc_base_time) * 1000000L;
            }
        }
        return high_precision_counter.nanoTime();
    }

    public static void registerHighPrecisionCounter(HighPrecisionCounter counter) {
        high_precision_counter = counter;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1; ++i) {
            new Thread(){

                public void run() {
                    long cstart = SystemTime.getCurrentTime();
                    long mstart = SystemTime.getMonotonousTime();
                    System.out.println("alter system clock to see differences between monotonous and current time");
                    long cLastRound = cstart;
                    long mLastRound = mstart;
                    while (true) {
                        long mnow = SystemTime.getMonotonousTime();
                        long cnow = SystemTime.getCurrentTime();
                        System.out.println("current: " + (cnow - cstart) + " monotonous:" + (mnow - mstart) + " delta current:" + (cnow - cLastRound) + " delta monotonous:" + (mnow - mLastRound));
                        cLastRound = cnow;
                        mLastRound = mnow;
                        try {
                            Thread.sleep(15L);
                        }
                        catch (Throwable e) {
                        }
                    }
                }
            }.start();
        }
    }

    static {
        try {
            if (System.getProperty("azureus.time.use.raw.provider", "0").equals("1")) {
                System.out.println("Warning: Using Raw Provider, monotonous time might be inaccurate");
                instance = new RawProvider();
            } else {
                instance = new SteppedProvider();
            }
        }
        catch (Throwable e) {
            instance = new SteppedProvider();
        }
        systemTimeConsumers = new ArrayList();
        monotoneTimeConsumers = new ArrayList();
        clock_change_list = new ArrayList();
    }

    public static interface ChangeListener {
        public void clockChanged(long var1, long var3);
    }

    public static interface HighPrecisionCounter {
        public long nanoTime();
    }

    protected static class RawProvider
    implements SystemTimeProvider {
        private static final int STEPS_PER_SECOND = 40;
        private final Thread updater;
        private volatile long adjustedTimeOffset;

        private RawProvider() {
            System.out.println("SystemTime: using raw time provider");
            this.updater = new Thread("SystemTime"){
                long last_time;

                public void run() {
                    while (true) {
                        long offset;
                        long current_time = RawProvider.this.getTime();
                        if (this.last_time != 0L && ((offset = current_time - this.last_time) < 0L || offset > 5000L)) {
                            RawProvider.this.adjustedTimeOffset += offset;
                            Iterator it = clock_change_list.iterator();
                            while (it.hasNext()) {
                                ((ChangeListener)it.next()).clockChanged(current_time, offset);
                            }
                        }
                        this.last_time = current_time;
                        List consumer_list_ref = systemTimeConsumers;
                        for (int i = 0; i < consumer_list_ref.size(); ++i) {
                            TickConsumer cons = (TickConsumer)consumer_list_ref.get(i);
                            try {
                                cons.consume(current_time);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        consumer_list_ref = monotoneTimeConsumers;
                        long adjustedTime = current_time - RawProvider.this.adjustedTimeOffset;
                        for (int i = 0; i < consumer_list_ref.size(); ++i) {
                            TickConsumer cons = (TickConsumer)consumer_list_ref.get(i);
                            try {
                                cons.consume(adjustedTime);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.updater.setDaemon(true);
            this.updater.setPriority(10);
            this.updater.start();
        }

        public long getTime() {
            return System.currentTimeMillis();
        }

        public long getMonoTime() {
            return this.getTime() - this.adjustedTimeOffset;
        }

        public long getSteppedMonoTime() {
            return this.getMonoTime();
        }
    }

    protected static class SteppedProvider
    implements SystemTimeProvider {
        private static final int STEPS_PER_SECOND = 40;
        private final Thread updater;
        private volatile long stepped_time = 0L;
        private volatile long currentTimeOffset = System.currentTimeMillis();
        private volatile long last_approximate_time;
        private volatile int access_count;
        private volatile int slice_access_count;
        private volatile int access_average_per_slice;
        private volatile int drift_adjusted_granularity;
        private volatile long stepped_mono_time;

        private SteppedProvider() {
            this.updater = new Thread("SystemTime"){

                public void run() {
                    long adjustedTimeOffset = SteppedProvider.this.currentTimeOffset;
                    Average access_average = Average.getInstance(1000, 10);
                    Average drift_average = Average.getInstance(1000, 10);
                    long lastOffset = adjustedTimeOffset;
                    long lastSecond = -1000L;
                    int tick_count = 0;
                    while (true) {
                        long rawTime;
                        long newMonotoneTime;
                        long delta;
                        if ((delta = (newMonotoneTime = (rawTime = System.currentTimeMillis()) - adjustedTimeOffset) - SteppedProvider.this.stepped_time) < 0L || delta > 1000L) {
                            SteppedProvider.this.stepped_time += 25L;
                            adjustedTimeOffset = rawTime - SteppedProvider.this.stepped_time;
                        } else {
                            SteppedProvider.this.stepped_time = newMonotoneTime;
                        }
                        if (++tick_count == 40) {
                            if (lastOffset != adjustedTimeOffset) {
                                long change = adjustedTimeOffset - lastOffset;
                                Iterator it = clock_change_list.iterator();
                                while (it.hasNext()) {
                                    ((ChangeListener)it.next()).clockChanged(rawTime, change);
                                }
                                lastOffset = adjustedTimeOffset;
                                SteppedProvider.this.currentTimeOffset = adjustedTimeOffset;
                            }
                            long drift = SteppedProvider.this.stepped_time - lastSecond - 1000L;
                            lastSecond = SteppedProvider.this.stepped_time;
                            drift_average.addValue(drift);
                            SteppedProvider.this.drift_adjusted_granularity = (int)(25L + drift_average.getAverage() / 40L);
                            access_average.addValue(SteppedProvider.this.access_count);
                            SteppedProvider.this.access_average_per_slice = (int)(access_average.getAverage() / 40L);
                            SteppedProvider.this.access_count = 0;
                            tick_count = 0;
                        }
                        SteppedProvider.this.slice_access_count = 0;
                        SteppedProvider.this.stepped_mono_time = SteppedProvider.this.stepped_time;
                        List consumersRef = monotoneTimeConsumers;
                        for (int i = 0; i < consumersRef.size(); ++i) {
                            TickConsumer cons = (TickConsumer)consumersRef.get(i);
                            try {
                                cons.consume(SteppedProvider.this.stepped_time);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        consumersRef = systemTimeConsumers;
                        long adjustedTime = SteppedProvider.this.stepped_time + SteppedProvider.this.currentTimeOffset;
                        for (int i = 0; i < consumersRef.size(); ++i) {
                            TickConsumer cons = (TickConsumer)consumersRef.get(i);
                            try {
                                cons.consume(adjustedTime);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        try {
                            Thread.sleep(25L);
                            continue;
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                            continue;
                        }
                        break;
                    }
                }
            };
            this.updater.setDaemon(true);
            this.updater.setPriority(10);
            this.updater.start();
        }

        public long getTime() {
            return this.getMonoTime() + this.currentTimeOffset;
        }

        public long getMonoTime() {
            long adjusted_time = this.stepped_time;
            long averageSliceStep = this.access_average_per_slice;
            if (averageSliceStep > 0L) {
                long sliceStep = (long)(this.drift_adjusted_granularity * this.slice_access_count) / averageSliceStep;
                if (sliceStep >= (long)this.drift_adjusted_granularity) {
                    sliceStep = this.drift_adjusted_granularity - 1;
                }
                adjusted_time += sliceStep;
            }
            ++this.access_count;
            ++this.slice_access_count;
            if (adjusted_time < this.last_approximate_time) {
                adjusted_time = this.last_approximate_time;
            } else {
                this.last_approximate_time = adjusted_time;
            }
            return adjusted_time;
        }

        public long getSteppedMonoTime() {
            return this.stepped_mono_time;
        }
    }

    protected static interface SystemTimeProvider {
        public long getTime();

        public long getMonoTime();

        public long getSteppedMonoTime();
    }

    public static interface TickConsumer {
        public void consume(long var1);
    }
}

