/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class TimerEvent
extends ThreadPoolTask
implements Comparable {
    private String name;
    private Timer timer;
    private long created;
    private long when;
    private TimerEventPerformer performer;
    private boolean absolute;
    private boolean cancelled;
    private boolean has_run;
    private long unique_id = 1L;

    protected TimerEvent(Timer _timer, long _unique_id, long _created, long _when, boolean _absolute, TimerEventPerformer _performer) {
        this.timer = _timer;
        this.unique_id = _unique_id;
        this.when = _when;
        this.absolute = _absolute;
        this.performer = _performer;
        this.created = _created;
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public String getName() {
        return this.name;
    }

    public long getCreatedTime() {
        return this.created;
    }

    public long getWhen() {
        return this.when;
    }

    protected void setWhen(long new_when) {
        this.when = new_when;
    }

    protected AERunnable getRunnable() {
        return this;
    }

    protected TimerEventPerformer getPerformer() {
        return this.performer;
    }

    protected boolean isAbsolute() {
        return this.absolute;
    }

    public void runSupport() {
        this.performer.perform(this);
    }

    public synchronized void cancel() {
        this.cancelled = true;
        this.timer.cancelEvent(this);
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected void setHasRun() {
        this.has_run = true;
    }

    public boolean hasRun() {
        return this.has_run;
    }

    protected long getUniqueId() {
        return this.unique_id;
    }

    public int compareTo(Object other) {
        long res = this.when - ((TimerEvent)other).getWhen();
        if (res == 0L) {
            return (int)(this.unique_id - ((TimerEvent)other).getUniqueId());
        }
        return res < 0L ? -1 : 1;
    }

    public void interruptTask() {
    }

    public String getString() {
        if (this.performer instanceof TimerEventPeriodic) {
            TimerEventPeriodic tep = (TimerEventPeriodic)this.performer;
            return "when=" + this.getWhen() + ",run=" + this.hasRun() + ", can=" + this.isCancelled() + "/" + tep.isCancelled() + ",freq=" + tep.getFrequency() + ",target=" + tep.getPerformer() + (this.name == null ? "" : ",name=" + this.name);
        }
        return "when=" + this.getWhen() + ",run=" + this.hasRun() + ", can=" + this.isCancelled() + ",target=" + this.getPerformer() + (this.name == null ? "" : ",name=" + this.name);
    }
}

