/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.protocol.azplug;

import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ipc.IPCException;
import org.gudy.azureus2.plugins.ipc.IPCInterface;

public class AZPluginConnection
extends HttpURLConnection {
    private InputStream input_stream;

    protected AZPluginConnection(URL _url) {
        super(_url);
    }

    public void connect() throws IOException {
        String url = this.getURL().toString();
        int pos = url.indexOf("?");
        if (pos == -1) {
            throw new IOException("Malformed URL - ? missing");
        }
        url = url.substring(pos + 1);
        String[] bits = url.split("&");
        HashMap<String, String> args = new HashMap<String, String>();
        for (int i = 0; i < bits.length; ++i) {
            String bit = bits[i];
            String[] x = bit.split("=");
            if (x.length != 2) continue;
            String lhs = x[0];
            String rhs = URLDecoder.decode(x[1], "UTF-8");
            args.put(lhs.toLowerCase(), rhs);
        }
        String plugin_id = (String)args.get("id");
        if (plugin_id == null) {
            throw new IOException("Plugin id missing");
        }
        String plugin_name = (String)args.get("name");
        String arg = (String)args.get("arg");
        String plugin_str = plugin_id + (plugin_name == null ? "" : " (" + plugin_name + ")");
        PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID(plugin_id);
        if (pi == null) {
            throw new IOException("Plugin id " + plugin_str + " not installed");
        }
        IPCInterface ipc = pi.getIPC();
        try {
            this.input_stream = (InputStream)ipc.invoke("handleURLProtocol", new String[]{arg});
        }
        catch (IPCException e) {
            throw new IOException("Communication error with plugin '" + plugin_str + "': " + Debug.getNestedExceptionMessage(e));
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.input_stream;
    }

    public int getResponseCode() {
        return 200;
    }

    public String getResponseMessage() {
        return "OK";
    }

    public boolean usingProxy() {
        return false;
    }

    public void disconnect() {
    }
}

