/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.download.impl.DownloadManagerDefaultPaths;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadEventNotifier;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadManagerStats;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.download.savelocation.DefaultSaveLocationManager;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadEventNotifierImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;

public class DownloadManagerImpl
implements DownloadManager,
DownloadManagerInitialisationAdapter {
    protected static DownloadManagerImpl singleton;
    protected static AEMonitor class_mon;
    private GlobalManager global_manager;
    private DownloadManagerStats stats;
    private DownloadEventNotifierImpl global_dl_notifier;
    private List listeners = new ArrayList();
    private CopyOnWriteList dwba_listeners = new CopyOnWriteList();
    private AEMonitor listeners_mon = new AEMonitor("DownloadManager:L");
    private List downloads = new ArrayList();
    private Map pending_dls = new HashMap();
    private Map download_map = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadManagerImpl getSingleton(AzureusCore azureus_core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new DownloadManagerImpl(azureus_core);
            }
            DownloadManagerImpl downloadManagerImpl = singleton;
            return downloadManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected DownloadManagerImpl(AzureusCore _azureus_core) {
        this.global_manager = _azureus_core.getGlobalManager();
        this.stats = new DownloadManagerStatsImpl(this.global_manager);
        this.global_dl_notifier = new DownloadEventNotifierImpl(this);
        this.global_manager.addListener(new GlobalManagerListener(){

            public void downloadManagerAdded(org.gudy.azureus2.core3.download.DownloadManager dm) {
                DownloadManagerImpl.this.addDownloadManager(dm);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void downloadManagerRemoved(org.gudy.azureus2.core3.download.DownloadManager dm) {
                List listeners_ref = null;
                DownloadImpl dl = null;
                try {
                    DownloadManagerImpl.this.listeners_mon.enter();
                    dl = (DownloadImpl)DownloadManagerImpl.this.download_map.get(dm);
                    if (dl == null) {
                        System.out.println("DownloadManager:unknown manager removed");
                    } else {
                        DownloadManagerImpl.this.downloads.remove(dl);
                        DownloadManagerImpl.this.download_map.remove(dm);
                        DownloadManagerImpl.this.pending_dls.remove(dm);
                        dl.destroy();
                        listeners_ref = DownloadManagerImpl.this.listeners;
                    }
                }
                finally {
                    DownloadManagerImpl.this.listeners_mon.exit();
                }
                if (dl != null) {
                    for (int i = 0; i < listeners_ref.size(); ++i) {
                        ((DownloadManagerListener)listeners_ref.get(i)).downloadRemoved(dl);
                    }
                }
            }

            public void destroyInitiated() {
            }

            public void destroyed() {
            }

            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }
        });
        this.global_manager.addDownloadWillBeRemovedListener(new GlobalManagerDownloadWillBeRemovedListener(){

            public void downloadWillBeRemoved(org.gudy.azureus2.core3.download.DownloadManager dm, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
                DownloadImpl download = (DownloadImpl)DownloadManagerImpl.this.download_map.get(dm);
                if (download != null) {
                    try {
                        download.isRemovable();
                    }
                    catch (DownloadRemovalVetoException e) {
                        throw new GlobalManagerDownloadRemovalVetoException(e.getMessage(), e.isSilent());
                    }
                }
            }
        });
    }

    public void addDownload(File fileName) {
        UIManagerImpl.fireEvent(2, fileName);
    }

    public void addDownload(URL url) {
        this.addDownload(url, null, true, null);
    }

    public void addDownload(URL url, boolean auto_download) throws DownloadException {
        this.addDownload(url, null, auto_download, null);
    }

    public void addDownload(URL url, URL referrer) {
        this.addDownload(url, referrer, true, null);
    }

    public void addDownload(URL url, Map request_properties) {
        this.addDownload(url, null, true, request_properties);
    }

    public void addDownload(URL url, URL referrer, boolean auto_download, Map request_properties) {
        UIManagerImpl.fireEvent(3, new Object[]{url, referrer, new Boolean(auto_download), request_properties});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDownloadManager(org.gudy.azureus2.core3.download.DownloadManager dm) {
        List listeners_ref = null;
        DownloadImpl dl = null;
        try {
            this.listeners_mon.enter();
            if (this.download_map.get(dm) == null) {
                dl = (DownloadImpl)this.pending_dls.remove(dm);
                if (dl == null) {
                    dl = new DownloadImpl(dm);
                }
                this.downloads.add(dl);
                this.download_map.put(dm, dl);
                listeners_ref = this.listeners;
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        if (dl != null) {
            for (int i = 0; i < listeners_ref.size(); ++i) {
                try {
                    ((DownloadManagerListener)listeners_ref.get(i)).downloadAdded(dl);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public Download addDownload(Torrent torrent) throws DownloadException {
        return this.addDownload(torrent, null, null);
    }

    public Download addDownload(Torrent torrent, File torrent_file, File data_location) throws DownloadException {
        return this.addDownload(torrent, torrent_file, data_location, this.getInitialState());
    }

    public Download addDownload(Torrent torrent, File torrent_file, File data_location, int initial_state) throws DownloadException {
        if (torrent_file == null) {
            String torrent_dir = null;
            if (COConfigurationManager.getBooleanParameter("Save Torrent Files")) {
                try {
                    torrent_dir = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                }
                catch (Exception egnore) {
                    // empty catch block
                }
            }
            if (torrent_dir == null || torrent_dir.length() == 0) {
                throw new DownloadException("DownloadManager::addDownload: default torrent save directory must be configured");
            }
            torrent_file = new File(torrent_dir + File.separator + torrent.getName() + ".torrent");
            try {
                torrent.writeToFile(torrent_file);
            }
            catch (TorrentException e) {
                throw new DownloadException("DownloadManager::addDownload: failed to write torrent to '" + torrent_file.toString() + "'", e);
            }
        }
        if (!torrent_file.exists()) {
            throw new DownloadException("DownloadManager::addDownload: torrent file does not exist - " + torrent_file.toString());
        }
        if (!torrent_file.isFile()) {
            throw new DownloadException("DownloadManager::addDownload: torrent filepath given is not a file - " + torrent_file.toString());
        }
        if (data_location == null) {
            String data_dir = COConfigurationManager.getStringParameter("Default save path");
            if (data_dir == null || data_dir.length() == 0) {
                throw new DownloadException("DownloadManager::addDownload: default data save directory must be configured");
            }
            data_location = new File(data_dir);
            FileUtil.mkdirs(data_location);
        }
        byte[] hash = null;
        try {
            hash = torrent.getHash();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean for_seeding = torrent.isComplete();
        org.gudy.azureus2.core3.download.DownloadManager dm = this.global_manager.addDownloadManager(torrent_file.toString(), hash, data_location.toString(), initial_state, true, for_seeding, null);
        if (dm == null) {
            throw new DownloadException("DownloadManager::addDownload - failed, download may already in the process of being added");
        }
        this.addDownloadManager(dm);
        return this.getDownload(dm);
    }

    public Download addDownloadStopped(Torrent torrent, File torrent_location, File data_location) throws DownloadException {
        return this.addDownload(torrent, torrent_location, data_location, 70);
    }

    public Download addNonPersistentDownload(Torrent torrent, File torrent_file, File data_location) throws DownloadException {
        byte[] hash = null;
        try {
            hash = torrent.getHash();
        }
        catch (Exception e) {
            // empty catch block
        }
        org.gudy.azureus2.core3.download.DownloadManager dm = this.global_manager.addDownloadManager(torrent_file.toString(), hash, data_location.toString(), this.getInitialState(), false);
        if (dm == null) {
            throw new DownloadException("DownloadManager::addDownload - failed");
        }
        this.addDownloadManager(dm);
        return this.getDownload(dm);
    }

    protected int getInitialState() {
        boolean default_start_stopped = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
        return default_start_stopped ? 70 : 0;
    }

    protected DownloadImpl getDownload(org.gudy.azureus2.core3.download.DownloadManager dm) throws DownloadException {
        DownloadImpl dl = (DownloadImpl)this.download_map.get(dm);
        if (dl == null) {
            throw new DownloadException("DownloadManager::getDownload: download not found");
        }
        return dl;
    }

    public static DownloadImpl[] getDownloadStatic(org.gudy.azureus2.core3.download.DownloadManager[] dm) {
        ArrayList<DownloadImpl> res = new ArrayList<DownloadImpl>(dm.length);
        for (int i = 0; i < dm.length; ++i) {
            try {
                res.add(DownloadManagerImpl.getDownloadStatic(dm[i]));
                continue;
            }
            catch (DownloadException downloadException) {
                // empty catch block
            }
        }
        return res.toArray(new DownloadImpl[res.size()]);
    }

    public static DownloadImpl getDownloadStatic(org.gudy.azureus2.core3.download.DownloadManager dm) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(dm);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public static Download getDownloadStatic(DiskManager dm) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(dm);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public Download getDownload(DiskManager dm) throws DownloadException {
        List dls = this.global_manager.getDownloadManagers();
        for (int i = 0; i < dls.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager man = (org.gudy.azureus2.core3.download.DownloadManager)dls.get(i);
            if (man.getDiskManager() != dm) continue;
            return this.getDownload(man.getTorrent());
        }
        return null;
    }

    protected Download getDownload(TOTorrent torrent) throws DownloadException {
        if (torrent != null) {
            for (int i = 0; i < this.downloads.size(); ++i) {
                Download dl = (Download)this.downloads.get(i);
                TorrentImpl t = (TorrentImpl)dl.getTorrent();
                if (t == null || !t.getTorrent().hasSameHashAs(torrent)) continue;
                return dl;
            }
        }
        throw new DownloadException("DownloadManager::getDownload: download not found");
    }

    public static Download getDownloadStatic(TOTorrent torrent) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(torrent);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public Download getDownload(Torrent _torrent) {
        TorrentImpl torrent = (TorrentImpl)_torrent;
        try {
            return this.getDownload(torrent.getTorrent());
        }
        catch (DownloadException downloadException) {
            return null;
        }
    }

    public Download getDownload(byte[] hash) {
        List dls = this.global_manager.getDownloadManagers();
        for (int i = 0; i < dls.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager man = (org.gudy.azureus2.core3.download.DownloadManager)dls.get(i);
            TOTorrent torrent = man.getTorrent();
            if (torrent == null) continue;
            try {
                if (!Arrays.equals(torrent.getHash(), hash)) continue;
                return this.getDownload(torrent);
            }
            catch (DownloadException e) {
                continue;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Download[] getDownloads() {
        LinkedHashSet<Object> res_l = new LinkedHashSet<Object>();
        List dms = this.global_manager.getDownloadManagers();
        try {
            int i;
            this.listeners_mon.enter();
            for (i = 0; i < dms.size(); ++i) {
                Object dl = this.download_map.get(dms.get(i));
                if (dl == null) continue;
                res_l.add(dl);
            }
            if (res_l.size() < this.downloads.size()) {
                for (i = 0; i < this.downloads.size(); ++i) {
                    Download download = (Download)this.downloads.get(i);
                    if (res_l.contains(download)) continue;
                    res_l.add(download);
                }
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        Download[] res = new Download[res_l.size()];
        res_l.toArray(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Download[] getDownloads(boolean bSorted) {
        if (bSorted) {
            return this.getDownloads();
        }
        try {
            this.listeners_mon.enter();
            Download[] res = new Download[this.downloads.size()];
            this.downloads.toArray(res);
            Download[] downloadArray = res;
            return downloadArray;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void pauseDownloads() {
        this.global_manager.pauseDownloads();
    }

    public boolean canPauseDownloads() {
        return this.global_manager.canPauseDownloads();
    }

    public void resumeDownloads() {
        this.global_manager.resumeDownloads();
    }

    public boolean canResumeDownloads() {
        return this.global_manager.canResumeDownloads();
    }

    public void startAllDownloads() {
        this.global_manager.startAllDownloads();
    }

    public void stopAllDownloads() {
        this.global_manager.stopAllDownloads();
    }

    public DownloadManagerStats getStats() {
        return this.stats;
    }

    public boolean isSeedingOnly() {
        return this.global_manager.isSeedingOnly();
    }

    public void addListener(DownloadManagerListener l) {
        this.addListener(l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadManagerListener l, boolean notify_of_current_downloads) {
        ArrayList downloads_copy = null;
        try {
            this.listeners_mon.enter();
            ArrayList<DownloadManagerListener> new_listeners = new ArrayList<DownloadManagerListener>(this.listeners);
            new_listeners.add(l);
            this.listeners = new_listeners;
            if (notify_of_current_downloads) {
                downloads_copy = new ArrayList(this.downloads);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        if (downloads_copy != null) {
            for (int i = 0; i < downloads_copy.size(); ++i) {
                try {
                    l.downloadAdded((Download)downloads_copy.get(i));
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void removeListener(DownloadManagerListener l) {
        this.removeListener(l, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadManagerListener l, boolean notify_of_current_downloads) {
        ArrayList downloads_copy = null;
        try {
            this.listeners_mon.enter();
            ArrayList new_listeners = new ArrayList(this.listeners);
            new_listeners.remove(l);
            this.listeners = new_listeners;
            if (notify_of_current_downloads) {
                downloads_copy = new ArrayList(this.downloads);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        if (downloads_copy != null) {
            for (int i = 0; i < downloads_copy.size(); ++i) {
                try {
                    l.downloadRemoved((Download)downloads_copy.get(i));
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialised(org.gudy.azureus2.core3.download.DownloadManager manager) {
        DownloadImpl dl;
        try {
            this.listeners_mon.enter();
            dl = new DownloadImpl(manager);
            this.pending_dls.put(manager, dl);
        }
        finally {
            this.listeners_mon.exit();
        }
        Iterator it = this.dwba_listeners.iterator();
        while (it.hasNext()) {
            try {
                ((DownloadWillBeAddedListener)it.next()).initialised(dl);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadWillBeAddedListener(DownloadWillBeAddedListener listener) {
        try {
            this.listeners_mon.enter();
            this.dwba_listeners.add(listener);
            if (this.dwba_listeners.size() == 1) {
                this.global_manager.addDownloadManagerInitialisationAdapter(this);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadWillBeAddedListener(DownloadWillBeAddedListener listener) {
        try {
            this.listeners_mon.enter();
            this.dwba_listeners.remove(listener);
            if (this.dwba_listeners.size() == 0) {
                this.global_manager.removeDownloadManagerInitialisationAdapter(this);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalDownload(Download download) {
        List listeners_ref = null;
        try {
            this.listeners_mon.enter();
            if (this.downloads.contains(download)) {
                return;
            }
            this.downloads.add(download);
            listeners_ref = this.listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
        for (int i = 0; i < listeners_ref.size(); ++i) {
            try {
                ((DownloadManagerListener)listeners_ref.get(i)).downloadAdded(download);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalDownload(Download download) {
        List listeners_ref = null;
        try {
            this.listeners_mon.enter();
            if (!this.downloads.contains(download)) {
                return;
            }
            this.downloads.remove(download);
            listeners_ref = this.listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
        for (int i = 0; i < listeners_ref.size(); ++i) {
            try {
                ((DownloadManagerListener)listeners_ref.get(i)).downloadRemoved(download);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public DownloadEventNotifier getGlobalDownloadEventNotifier() {
        return this.global_dl_notifier;
    }

    public void setSaveLocationManager(SaveLocationManager manager) {
        if (manager == null) {
            manager = this.getDefaultSaveLocationManager();
        }
        DownloadManagerMoveHandler.CURRENT_HANDLER = manager;
    }

    public SaveLocationManager getSaveLocationManager() {
        return DownloadManagerMoveHandler.CURRENT_HANDLER;
    }

    public DefaultSaveLocationManager getDefaultSaveLocationManager() {
        return DownloadManagerDefaultPaths.DEFAULT_HANDLER;
    }

    static {
        class_mon = new AEMonitor("DownloadManager:class");
    }
}

