/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.network;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.Transport;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.network.ConnectionListener;
import org.gudy.azureus2.plugins.network.IncomingMessageQueue;
import org.gudy.azureus2.plugins.network.OutgoingMessageQueue;
import org.gudy.azureus2.pluginsimpl.local.network.IncomingMessageQueueImpl;
import org.gudy.azureus2.pluginsimpl.local.network.OutgoingMessageQueueImpl;
import org.gudy.azureus2.pluginsimpl.local.network.TransportImpl;

public class ConnectionImpl
implements Connection {
    private final NetworkConnection core_connection;
    private final OutgoingMessageQueueImpl out_queue;
    private final IncomingMessageQueueImpl in_queue;
    private final TransportImpl transport;
    private final boolean incoming;

    public ConnectionImpl(NetworkConnection core_connection, boolean incoming) {
        this.core_connection = core_connection;
        this.out_queue = new OutgoingMessageQueueImpl(core_connection.getOutgoingMessageQueue());
        this.in_queue = new IncomingMessageQueueImpl(core_connection.getIncomingMessageQueue());
        this.transport = new TransportImpl(core_connection);
        this.incoming = incoming;
    }

    public void connect(final ConnectionListener listener) {
        this.core_connection.connect(2, new NetworkConnection.ConnectionListener(){

            public void connectStarted() {
                listener.connectStarted();
            }

            public void connectSuccess(ByteBuffer remaining_initial_data) {
                listener.connectSuccess();
            }

            public void connectFailure(Throwable failure_msg) {
                listener.connectFailure(failure_msg);
            }

            public void exceptionThrown(Throwable error) {
                listener.exceptionThrown(error);
            }

            public String getDescription() {
                return "plugin connection: " + ConnectionImpl.this.core_connection.getString();
            }
        });
    }

    public void close() {
        this.core_connection.close();
    }

    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.out_queue;
    }

    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.in_queue;
    }

    public void startMessageProcessing() {
        this.core_connection.startMessageProcessing();
        this.core_connection.enableEnhancedMessageProcessing(true);
    }

    public org.gudy.azureus2.plugins.network.Transport getTransport() {
        return this.transport;
    }

    public NetworkConnection getCoreConnection() {
        return this.core_connection;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public String getString() {
        Transport t = this.core_connection.getTransport();
        if (t == null) {
            return "";
        }
        return t.getEncryption(false);
    }
}

