/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import com.aelitis.azureus.core.util.DeleteFileOnCloseInputStream;
import com.aelitis.azureus.core.util.Java15Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderURLImpl
extends ResourceDownloaderBaseImpl
implements SEPasswordListener {
    private static final int BUFFER_SIZE = 32768;
    private static final int MAX_IN_MEM_READ_SIZE = 262144;
    protected URL original_url;
    protected boolean auth_supplied;
    protected String user_name;
    protected String password;
    protected InputStream input_stream;
    protected boolean cancel_download = false;
    protected boolean download_initiated;
    protected long size = -2L;
    protected boolean force_no_proxy = false;
    private final String post_data;

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url) {
        this(_parent, _url, false, null, null);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, String _user_name, String _password) {
        this(_parent, _url, true, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, boolean _auth_supplied, String _user_name, String _password) {
        this(_parent, _url, null, _auth_supplied, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, String _data, boolean _auth_supplied, String _user_name, String _password) {
        super(_parent);
        this.original_url = _url;
        this.post_data = _data;
        this.auth_supplied = _auth_supplied;
        this.user_name = _user_name;
        this.password = _password;
    }

    protected void setForceNoProxy(boolean force_no_proxy) {
        this.force_no_proxy = force_no_proxy;
    }

    protected URL getURL() {
        return this.original_url;
    }

    public String getName() {
        return this.original_url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                ResourceDownloaderURLImpl c = (ResourceDownloaderURLImpl)this.getClone(this);
                this.addReportListener(c);
                this.size = c.getSizeSupport();
                this.setProperties(c);
            }
            finally {
                if (this.size == -2L) {
                    this.size = -1L;
                }
            }
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
    }

    public void setProperty(String name, Object value) throws ResourceDownloaderException {
        this.setPropertySupport(name, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            String protocol = this.original_url.getProtocol().toLowerCase();
            if (protocol.equals("magnet")) return -1L;
            if (protocol.equals("dht")) {
                return -1L;
            }
            this.reportActivity(this, "Getting size of " + this.original_url);
            try {
                URL url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                url = AddressUtils.adjustURL(url);
                try {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(url, this);
                    }
                    int i = 0;
                    while (i < 2) {
                        try {
                            HttpURLConnection con;
                            if (url.getProtocol().equalsIgnoreCase("https")) {
                                HttpsURLConnection ssl_con = (HttpsURLConnection)this.openConnection(url);
                                ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                    public boolean verify(String host, SSLSession session) {
                                        return true;
                                    }
                                });
                                con = ssl_con;
                            } else {
                                con = (HttpURLConnection)this.openConnection(url);
                            }
                            con.setRequestMethod("HEAD");
                            con.setRequestProperty("User-Agent", "Azureus 4.0.0.4");
                            this.setRequestProperties(con, false);
                            con.connect();
                            int response = con.getResponseCode();
                            if (response != 202 && response != 200) {
                                this.setProperty("URL_HTTP_Response", new Long(response));
                                throw new ResourceDownloaderException("Error on connect for '" + this.trimForDisplay(url) + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                            }
                            this.getRequestProperties(con);
                            long l = con.getContentLength();
                            return l;
                        }
                        catch (SSLException e) {
                            if (i != 0) throw e;
                            if (SESecurityManager.installServerCertificates(url) == null) throw e;
                            ++i;
                        }
                    }
                    throw new ResourceDownloaderException("Should never get here");
                }
                finally {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(url, null);
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException("Exception while parsing URL '" + this.original_url + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException("Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException("I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", e);
            }
        }
        catch (Throwable e) {
            ResourceDownloaderException rde;
            if (e instanceof ResourceDownloaderException) {
                rde = (ResourceDownloaderException)e;
                throw rde;
            }
            rde = new ResourceDownloaderException("Unexpected error", e);
            throw rde;
        }
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderURLImpl c = new ResourceDownloaderURLImpl(parent, this.original_url, this.post_data, this.auth_supplied, this.user_name, this.password);
        c.setSize(this.size);
        c.setProperties(this);
        c.setForceNoProxy(this.force_no_proxy);
        return c;
    }

    public void asyncDownload() {
        final Object parent_tls = TorrentUtils.getTLS();
        AEThread2 t = new AEThread2("ResourceDownloader:asyncDownload - " + this.trimForDisplay(this.original_url), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object child_tls = TorrentUtils.getTLS();
                TorrentUtils.setTLS(parent_tls);
                try {
                    ResourceDownloaderURLImpl.this.download();
                }
                catch (ResourceDownloaderException resourceDownloaderException) {
                }
                finally {
                    TorrentUtils.setTLS(child_tls);
                }
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream download() throws ResourceDownloaderException {
        try {
            this.reportActivity(this, this.getLogIndent() + "Downloading: " + this.trimForDisplay(this.original_url));
            try {
                this.this_mon.enter();
                if (this.download_initiated) {
                    throw new ResourceDownloaderException("Download already initiated");
                }
                this.download_initiated = true;
            }
            finally {
                this.this_mon.exit();
            }
            try {
                url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                protocol = url.getProtocol().toLowerCase();
                if (url.getPort() == -1 && !protocol.equals("magnet") && !protocol.equals("dht")) {
                    target_port = protocol.equals("http") != false ? 80 : 443;
                    try {
                        str = this.original_url.toString().replaceAll(" ", "%20");
                        pos = str.indexOf("://");
                        pos = str.indexOf("/", pos + 4);
                        url = pos == -1 ? new URL(str + ":" + target_port + "/") : new URL(str.substring(0, pos) + ":" + target_port + str.substring(pos));
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                url = AddressUtils.adjustURL(url);
                try {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(url, this);
                    }
                    use_compression = true;
                    follow_redirect = true;
                    redirect_loop = 0;
                    while (redirect_loop < 2) {
                        if (follow_redirect == false) throw new ResourceDownloaderException("Should never get here");
                        follow_redirect = false;
                        for (ssl_loop = 0; ssl_loop < 2; ++ssl_loop) {
                            block65: {
                                block64: {
                                    temp_file = null;
                                    try {
                                        if (url.getProtocol().equalsIgnoreCase("https")) {
                                            ssl_con = (HttpsURLConnection)this.openConnection(url);
                                            ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                                public boolean verify(String host, SSLSession session) {
                                                    return true;
                                                }
                                            });
                                            con = ssl_con;
                                        } else {
                                            con = (HttpURLConnection)this.openConnection(url);
                                        }
                                        con.setRequestProperty("User-Agent", "Azureus 4.0.0.4");
                                        con.setRequestProperty("Connection", "close");
                                        if (use_compression) {
                                            con.addRequestProperty("Accept-Encoding", "gzip");
                                        }
                                        this.setRequestProperties(con, use_compression);
                                        if (this.post_data != null) {
                                            con.setDoOutput(true);
                                            con.setRequestMethod("POST");
                                            wr = new OutputStreamWriter(con.getOutputStream());
                                            wr.write(this.post_data);
                                            wr.flush();
                                        }
                                        con.connect();
                                        response = con.getResponseCode();
                                        if (response != 302 && response != 301 || (move_to = con.getHeaderField("location")) == null || !url.getProtocol().equalsIgnoreCase("http")) break block64;
                                        try {
                                            move_to_url = new URL(URLDecoder.decode(move_to, "UTF-8"));
                                            if (move_to_url.getProtocol().equalsIgnoreCase("https")) {
                                                url = move_to_url;
                                                follow_redirect = true;
                                                if (temp_file == null) break;
                                                temp_file.delete();
                                                break;
                                            }
                                        }
                                        catch (Throwable e) {
                                            // empty catch block
                                        }
                                    }
                                    catch (SSLException e) {
                                        if (ssl_loop == 0 && SESecurityManager.installServerCertificates(url) != null) {
                                            if (temp_file == null) continue;
                                            temp_file.delete();
                                            continue;
                                        }
                                        throw e;
                                        catch (ZipException e) {
                                            if (ssl_loop != 0) continue;
                                            use_compression = false;
                                            continue;
                                        }
                                        catch (IOException e) {
                                            if (ssl_loop != 0 || (msg = e.getMessage()) == null || (msg = msg.toLowerCase()).indexOf("gzip") == -1) throw e;
                                            use_compression = false;
                                            if (temp_file == null) continue;
                                            temp_file.delete();
                                            continue;
                                        }
                                        finally {
                                            if (temp_file != null) {
                                                temp_file.delete();
                                            }
                                        }
                                    }
                                }
                                if (response != 202 && response != 200) {
                                    this.setProperty("URL_HTTP_Response", new Long(response));
                                    throw new ResourceDownloaderException("Error on connect for '" + this.trimForDisplay(url) + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                                }
                                this.getRequestProperties(con);
                                compressed = false;
                                try {
                                    this.this_mon.enter();
                                    this.input_stream = con.getInputStream();
                                    encoding = con.getHeaderField("content-encoding");
                                    if (encoding == null) break block65;
                                    if (encoding.equalsIgnoreCase("gzip")) {
                                        compressed = true;
                                        this.input_stream = new GZIPInputStream(this.input_stream);
                                        break block65;
                                    }
                                    if (encoding.equalsIgnoreCase("deflate")) {
                                        compressed = true;
                                        this.input_stream = new InflaterInputStream(this.input_stream);
                                    }
                                }
                                finally {
                                    this.this_mon.exit();
                                }
                            }
                            baos = null;
                            fos = null;
                            try {
                                buf = new byte[32768];
                                total_read = 0;
                                v0 = size = compressed != false ? -1 : con.getContentLength();
                                v1 = size > 0 ? new ByteArrayOutputStream(size > 262144 ? 262144 : size) : (baos = new ByteArrayOutputStream());
                                while (!this.cancel_download && (read = this.input_stream.read(buf)) > 0) {
                                    if (total_read > 262144) {
                                        if (fos == null) {
                                            temp_file = AETemporaryFileHandler.createTempFile();
                                            fos = new FileOutputStream(temp_file);
                                            fos.write(baos.toByteArray());
                                            baos = null;
                                        }
                                        fos.write(buf, 0, read);
                                    } else {
                                        baos.write(buf, 0, read);
                                    }
                                    this.informAmountComplete(total_read += read);
                                    if (size <= 0) continue;
                                    this.informPercentDone(100 * total_read / size);
                                }
                                if (size > 0 && total_read != size) {
                                    if (total_read <= size) throw new IOException("Premature end of stream");
                                    Debug.outNoStack("Inconsistent stream length for '" + this.trimForDisplay(this.original_url) + "': expected = " + size + ", actual = " + total_read);
                                }
                            }
                            finally {
                                if (fos != null) {
                                    fos.close();
                                }
                                this.input_stream.close();
                            }
                            if (temp_file != null) {
                                res = new DeleteFileOnCloseInputStream(temp_file);
                                temp_file = null;
                            } else {
                                res = new ByteArrayInputStream(baos.toByteArray());
                            }
                            handed_over = false;
                            if (!this.informComplete(res)) ** GOTO lbl173
                            handed_over = true;
                            var15_32 = res;
                            if (!handed_over) {
                            }
                            ** GOTO lbl169
                            {
                                catch (Throwable var18_35) {
                                    if (handed_over != false) throw var18_35;
                                    res.close();
                                    throw var18_35;
                                }
                                res.close();
lbl169:
                                // 2 sources

                                if (temp_file == null) return var15_32;
                                temp_file.delete();
                                return var15_32;
lbl173:
                                // 1 sources

                                if (handed_over != false) throw new ResourceDownloaderException("Contents downloaded but rejected: '" + this.trimForDisplay(this.original_url) + "'");
                                res.close();
                                throw new ResourceDownloaderException("Contents downloaded but rejected: '" + this.trimForDisplay(this.original_url) + "'");
                            }
                        }
                        ++redirect_loop;
                    }
                    throw new ResourceDownloaderException("Should never get here");
                }
                finally {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(url, null);
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException("Exception while parsing URL '" + this.trimForDisplay(this.original_url) + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException("Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException("I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", e);
            }
        }
        catch (Throwable e) {
            rde = e instanceof ResourceDownloaderException != false ? (ResourceDownloaderException)e : new ResourceDownloaderException("Unexpected error", e);
            this.informFailed(rde);
            throw rde;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        this.cancel_download = true;
        try {
            this.this_mon.enter();
            if (this.input_stream != null) {
                try {
                    this.input_stream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        this.informFailed(new ResourceDownloaderCancelledException());
    }

    protected void setRequestProperties(HttpURLConnection con, boolean use_compression) {
        Map properties = this.getLCKeyProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!key.startsWith("url_") || !(value instanceof String) || (key = key.substring(4)).equals("accept-encoding") && !use_compression) continue;
            con.setRequestProperty(key, (String)value);
        }
    }

    protected void getRequestProperties(HttpURLConnection con) {
        try {
            this.setProperty("ContentType", con.getContentType());
            this.setProperty("URL_URL", con.getURL());
            Map<String, List<String>> headers = con.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                List<String> val = entry.getValue();
                if (key == null) continue;
                this.setProperty("URL_" + key, val);
            }
            this.setPropertiesSet();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        if (this.user_name == null || this.password == null) {
            String user_info = tracker.getUserInfo();
            if (user_info == null) {
                return null;
            }
            String user_bit = user_info;
            String pw_bit = "";
            int pos = user_info.indexOf(58);
            if (pos != -1) {
                user_bit = user_info.substring(0, pos);
                pw_bit = user_info.substring(pos + 1);
            }
            return new PasswordAuthentication(user_bit, pw_bit.toCharArray());
        }
        return new PasswordAuthentication(this.user_name, this.password.toCharArray());
    }

    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
    }

    public void clearPasswords() {
    }

    private URLConnection openConnection(URL url) throws IOException {
        if (this.force_no_proxy) {
            return Java15Utils.openConnectionForceNoProxy(url);
        }
        return url.openConnection();
    }

    protected String trimForDisplay(URL url) {
        String str = url.toString();
        int pos = str.indexOf(63);
        if (pos != -1) {
            str = str.substring(0, pos);
        }
        return str;
    }
}

