/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.common.util;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import java.applet.Applet;
import java.applet.AudioClip;
import java.io.File;
import java.net.URL;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.minibar.DownloadBar;

public class UserAlerts {
    private AudioClip audio_clip = null;
    private String audio_resource = "";
    private AEMonitor this_mon = new AEMonitor("UserAlerts");
    private boolean startup = true;

    public UserAlerts(GlobalManager global_manager) {
        final DownloadManagerAdapter download_manager_listener = new DownloadManagerAdapter(){

            public void downloadComplete(DownloadManager manager) {
                if (!manager.getDownloadState().getFlag(16L)) {
                    UserAlerts.this.activityFinished(true, manager.getDisplayName(), manager);
                }
            }

            public void stateChanged(final DownloadManager manager, int state) {
                boolean lowNoise = manager.getDownloadState().getFlag(16L);
                if (lowNoise) {
                    return;
                }
                if (state == 50 || state == 60) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            boolean complete = manager.isDownloadComplete(false);
                            if (!complete && COConfigurationManager.getBooleanParameter("Open Details")) {
                                UIFunctionsManagerSWT.getUIFunctionsSWT().openView(5, manager);
                            }
                            if (!complete && COConfigurationManager.getBooleanParameter("Open Bar Incomplete") || complete && COConfigurationManager.getBooleanParameter("Open Bar Complete")) {
                                DownloadBar.open(manager, Utils.findAnyShell());
                            }
                        }
                    });
                }
            }
        };
        final DiskManagerListener disk_listener = new DiskManagerListener(){

            public void stateChanged(int oldState, int newState) {
            }

            public void filePriorityChanged(DiskManagerFileInfo file) {
            }

            public void pieceDoneChanged(DiskManagerPiece piece) {
            }

            public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
                DownloadManager dm = file.getDownloadManager();
                if (!(old_mode != 2 || new_mode != 1 || dm != null && dm.getDownloadState().getFlag(16L))) {
                    UserAlerts.this.activityFinished(false, file.getFile(true).getName(), file.getDiskManager());
                }
            }
        };
        final DownloadManagerDiskListener dm_disk_listener = new DownloadManagerDiskListener(){

            public void diskManagerAdded(DiskManager dm) {
                dm.addListener(disk_listener);
            }

            public void diskManagerRemoved(DiskManager dm) {
                dm.removeListener(disk_listener);
            }
        };
        global_manager.addListener(new GlobalManagerAdapter(){

            public void downloadManagerAdded(DownloadManager manager) {
                boolean bPopup;
                if (!UserAlerts.this.startup && manager.isPersistent() && (bPopup = COConfigurationManager.getBooleanParameter("Popup Download Added")) && !manager.getDownloadState().getFlag(16L)) {
                    String popup_text = MessageText.getString("popup.download.added", new String[]{manager.getDisplayName()});
                    Logger.log(new LogAlert((Object)manager, true, 0, popup_text));
                }
                manager.addListener(download_manager_listener);
                manager.addDiskListener(dm_disk_listener);
            }

            public void downloadManagerRemoved(DownloadManager manager) {
                manager.removeListener(download_manager_listener);
                manager.removeDiskListener(dm_disk_listener);
            }

            public void destroyed() {
                UserAlerts.this.tidyUp();
            }
        });
        this.startup = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activityFinished(boolean download, String item_name, Object relatedObject) {
        block21: {
            String popup_def_text;
            String popup_enabler;
            String speech_text;
            String speech_enabler;
            String sound_file;
            String sound_enabler;
            String default_sound = "org/gudy/azureus2/ui/icons/downloadFinished.wav";
            if (download) {
                sound_enabler = "Play Download Finished";
                sound_file = "Play Download Finished File";
                speech_enabler = "Play Download Finished Announcement";
                speech_text = "Play Download Finished Announcement Text";
                popup_enabler = "Popup Download Finished";
                popup_def_text = "popup.download.finished";
            } else {
                sound_enabler = "Play File Finished";
                sound_file = "Play File Finished File";
                speech_enabler = "Play File Finished Announcement";
                speech_text = "Play File Finished Announcement Text";
                popup_enabler = "Popup File Finished";
                popup_def_text = "popup.file.finished";
            }
            try {
                this.this_mon.enter();
                if (COConfigurationManager.getBooleanParameter(popup_enabler)) {
                    String popup_text = MessageText.getString(popup_def_text, new String[]{item_name});
                    Logger.log(new LogAlert(relatedObject, true, 0, popup_text));
                }
                if (Constants.isOSX) {
                    new AEThread("DownloadSound"){

                        public void runSupport() {
                            try {
                                if (COConfigurationManager.getBooleanParameter(speech_enabler)) {
                                    Runtime.getRuntime().exec(new String[]{"say", COConfigurationManager.getStringParameter(speech_text)});
                                }
                                if (COConfigurationManager.getBooleanParameter(sound_enabler)) {
                                    Runtime.getRuntime().exec(new String[]{"osascript", "-e", "beep"});
                                }
                                Thread.sleep(2500L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                    break block21;
                }
                if (!COConfigurationManager.getBooleanParameter(sound_enabler, false)) break block21;
                String file = COConfigurationManager.getStringParameter(sound_file);
                if ((file = file.trim()).startsWith("<")) {
                    file = "";
                }
                if (this.audio_clip == null || !file.equals(this.audio_resource)) {
                    this.audio_clip = null;
                    if (file.length() != 0) {
                        File f = new File(file);
                        try {
                            if (f.exists()) {
                                URL file_url = f.toURL();
                                this.audio_clip = Applet.newAudioClip(file_url);
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        finally {
                            if (this.audio_clip == null) {
                                Logger.log(new LogAlert(relatedObject, false, 3, "Failed to load audio file '" + file + "'"));
                            }
                        }
                    }
                    if (this.audio_clip == null) {
                        this.audio_clip = Applet.newAudioClip(UserAlerts.class.getClassLoader().getResource("org/gudy/azureus2/ui/icons/downloadFinished.wav"));
                    }
                    this.audio_resource = file;
                }
                if (this.audio_clip != null) {
                    new AEThread("DownloadSound"){

                        public void runSupport() {
                            try {
                                UserAlerts.this.audio_clip.play();
                                Thread.sleep(2500L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }.start();
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void tidyUp() {
        try {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            Thread[] threadList = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(threadList);
            for (int i = 0; i < threadList.length; ++i) {
                if (threadList[i] == null || !"Java Sound event dispatcher".equals(threadList[i].getName())) continue;
                threadList[i].interrupt();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void requestUserAttention(int type, Object data) {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        if (pm.hasCapability(PlatformManagerCapabilities.RequestUserAttention)) {
            try {
                pm.requestUserAttention(type, data);
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

