/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.control.DHTControlStats;
import com.aelitis.azureus.core.dht.db.DHTDBStats;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.router.DHTRouterStats;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;
import org.gudy.azureus2.ui.console.commands.TorrentFilter;

public class Show
extends IConsoleCommand {
    public Show() {
        super("show", "sh");
    }

    public String getCommandDescriptions() {
        return "show [<various options>]\tsh\tShow info. Use without parameter to get a list of available options.";
    }

    public void printHelpExtra(PrintStream out, List args) {
        out.println("> -----");
        out.println("'show' options: ");
        out.println("<#>\t\t\t\tFurther info on a single torrent. Run 'show torrents' first for the number.");
        out.println("options\t\t\to\tShow list of options for 'set' (also available by 'set' without parameters).");
        out.println("files\t\t\tf\tShow list of files found from the 'add -f' command (also available by 'add -l')");
        out.println("dht\t\t\td\tShow distributed database statistics");
        out.println("nat\t\t\tn\tShow NAT status");
        out.println("stats [pattern] [on|off]\ts\tShow stats [with a given pattern] [turn averages on/off]");
        out.println("torrents [opts] [expr]\tt\tShow list of torrents. torrent options may be any (or none) of:");
        out.println("\t\ttransferring\tx\tShow only transferring torrents.");
        out.println("\t\tactive\t\ta\tShow only active torrents.");
        out.println("\t\tcomplete\tc\tShow only complete torrents.");
        out.println("\t\tincomplete\ti\tShow only incomplete torrents.");
        out.println("\te.g. show t a *Az* - shows all active torrents with 'Az' occurring in their name.");
        out.println("> -----");
    }

    public void execute(String commandName, ConsoleInput ci, List args) {
        if (args.isEmpty()) {
            this.printHelp(ci.out, args);
            return;
        }
        String subCommand = (String)args.remove(0);
        if (subCommand.equalsIgnoreCase("options") || subCommand.equalsIgnoreCase("o")) {
            ci.invokeCommand("set", null);
        } else if (subCommand.equalsIgnoreCase("files") || subCommand.equalsIgnoreCase("f")) {
            ci.invokeCommand("add", Arrays.asList("--list"));
        } else if (subCommand.equalsIgnoreCase("torrents") || subCommand.equalsIgnoreCase("t")) {
            Iterator torrent;
            ci.out.println("> -----");
            ci.torrents.clear();
            ci.torrents.addAll(ci.getGlobalManager().getDownloadManagers());
            Collections.sort(ci.torrents, new TorrentComparator());
            if (ci.torrents.isEmpty()) {
                ci.out.println("No Torrents");
                ci.out.println("> -----");
                return;
            }
            long totalReceived = 0L;
            long totalSent = 0L;
            long totalDiscarded = 0L;
            int connectedSeeds = 0;
            int connectedPeers = 0;
            boolean bShowOnlyActive = false;
            boolean bShowOnlyComplete = false;
            boolean bShowOnlyIncomplete = false;
            boolean bShowOnlyTransferring = false;
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                String arg = (String)iter.next();
                if ("active".equalsIgnoreCase(arg) || "a".equalsIgnoreCase(arg)) {
                    bShowOnlyActive = true;
                    iter.remove();
                    continue;
                }
                if ("complete".equalsIgnoreCase(arg) || "c".equalsIgnoreCase(arg)) {
                    bShowOnlyComplete = true;
                    iter.remove();
                    continue;
                }
                if ("incomplete".equalsIgnoreCase(arg) || "i".equalsIgnoreCase(arg)) {
                    bShowOnlyIncomplete = true;
                    iter.remove();
                    continue;
                }
                if (!"transferring".equalsIgnoreCase(arg) && !"x".equalsIgnoreCase(arg)) continue;
                bShowOnlyTransferring = true;
                bShowOnlyActive = true;
                iter.remove();
            }
            if (args.size() > 0) {
                List matchedTorrents = new TorrentFilter().getTorrents(ci.torrents, args);
                torrent = matchedTorrents.iterator();
            } else {
                torrent = ci.torrents.iterator();
            }
            ArrayList<DownloadManager> shown_torrents = new ArrayList<DownloadManager>();
            while (torrent.hasNext()) {
                PEPeerManagerStats ps;
                boolean bCanShow;
                DownloadManager dm = (DownloadManager)torrent.next();
                DownloadManagerStats stats = dm.getStats();
                boolean bDownloadCompleted = stats.getDownloadCompleted(false) == 1000;
                boolean bl = bCanShow = bShowOnlyComplete == bShowOnlyIncomplete || bDownloadCompleted && bShowOnlyComplete || !bDownloadCompleted && bShowOnlyIncomplete;
                if (bCanShow && bShowOnlyActive) {
                    int dmstate = dm.getState();
                    boolean bl2 = bCanShow = dmstate == 60 || dmstate == 50 || dmstate == 30 || dmstate == 5 || dmstate == 20;
                }
                if (bCanShow && bShowOnlyTransferring) {
                    try {
                        ps = dm.getPeerManager().getStats();
                        bCanShow = ps.getDataSendRate() > 0L || ps.getDataReceiveRate() > 0L;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!bCanShow) continue;
                shown_torrents.add(dm);
                try {
                    ps = dm.getPeerManager().getStats();
                }
                catch (Exception e) {
                    ps = null;
                }
                if (ps != null) {
                    totalReceived += dm.getStats().getTotalDataBytesReceived();
                    totalSent += dm.getStats().getTotalDataBytesSent();
                    totalDiscarded += ps.getTotalDiscarded();
                    connectedSeeds += dm.getNbSeeds();
                    connectedPeers += dm.getNbPeers();
                }
                ci.out.print((shown_torrents.size() < 10 ? " " : "") + shown_torrents.size() + " ");
                ci.out.println(this.getTorrentSummary(dm));
                ci.out.println();
            }
            ci.torrents.clear();
            ci.torrents.addAll(shown_torrents);
            GlobalManager gm = ci.getGlobalManager();
            ci.out.println("Total Speed (down/up): " + DisplayFormatters.formatByteCountToKiBEtcPerSec(gm.getStats().getDataReceiveRate() + gm.getStats().getProtocolReceiveRate()) + " / " + DisplayFormatters.formatByteCountToKiBEtcPerSec(gm.getStats().getDataSendRate() + gm.getStats().getProtocolSendRate()));
            ci.out.println("Transferred Volume (down/up/discarded): " + DisplayFormatters.formatByteCountToKiBEtc(totalReceived) + " / " + DisplayFormatters.formatByteCountToKiBEtc(totalSent) + " / " + DisplayFormatters.formatByteCountToKiBEtc(totalDiscarded));
            ci.out.println("Total Connected Peers (seeds/peers): " + Integer.toString(connectedSeeds) + " / " + Integer.toString(connectedPeers));
            ci.out.println("> -----");
        } else if (subCommand.equalsIgnoreCase("dht") || subCommand.equalsIgnoreCase("d")) {
            this.showDHTStats(ci);
        } else if (subCommand.equalsIgnoreCase("nat") || subCommand.equalsIgnoreCase("n")) {
            IndentWriter iw = new IndentWriter(new PrintWriter(ci.out));
            iw.setForce(true);
            NetworkAdmin.getSingleton().logNATStatus(iw);
        } else if (subCommand.equalsIgnoreCase("stats") || subCommand.equalsIgnoreCase("s")) {
            String pattern = ".*";
            if (args.size() > 0 && (pattern = (String)args.get(0)).equals("*")) {
                pattern = ".*";
            }
            if (args.size() > 1) {
                AzureusCoreStats.setEnableAverages(((String)args.get(1)).equalsIgnoreCase("on"));
            }
            HashSet<String> types = new HashSet<String>();
            types.add(pattern);
            Map reply = AzureusCoreStats.getStats(types);
            Iterator it = reply.entrySet().iterator();
            ArrayList<String> lines = new ArrayList<String>();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                lines.add(entry.getKey() + " -> " + entry.getValue());
            }
            Collections.sort(lines);
            for (int i = 0; i < lines.size(); ++i) {
                ci.out.println(lines.get(i));
            }
        } else if (subCommand.equalsIgnoreCase("diag") || subCommand.equalsIgnoreCase("z")) {
            try {
                ci.out.println("Writing diagnostics to file 'az.diag'");
                FileWriter fw = new FileWriter("az.diag");
                PrintWriter pw = new PrintWriter(fw);
                AEDiagnostics.generateEvidence(pw);
                pw.flush();
                fw.close();
            }
            catch (Throwable e) {
                ci.out.println(e);
            }
        } else {
            if (ci.torrents == null || ci.torrents != null && ci.torrents.isEmpty()) {
                ci.out.println("> Command 'show': No torrents in list (try 'show torrents' first).");
                return;
            }
            try {
                int number = Integer.parseInt(subCommand);
                if (number == 0 || number > ci.torrents.size()) {
                    ci.out.println("> Command 'show': Torrent #" + number + " unknown.");
                    return;
                }
                DownloadManager dm = (DownloadManager)ci.torrents.get(number - 1);
                Show.printTorrentDetails(ci.out, dm, number, args.size() > 0);
            }
            catch (Exception e) {
                ci.out.println("> Command 'show': Subcommand '" + subCommand + "' unknown.");
                return;
            }
        }
    }

    protected String getTorrentSummary(DownloadManager dm) {
        StringBuffer tstate = new StringBuffer();
        String summaryFormat = this.getDefaultSummaryFormat();
        int lastch = 48;
        char[] summaryChars = summaryFormat.toCharArray();
        for (int i = 0; i < summaryChars.length; ++i) {
            int ch = summaryChars[i];
            if (ch == 37 && lastch != 92) {
                if (++i >= summaryChars.length) {
                    tstate.append('%');
                } else {
                    tstate.append(this.expandVariable(summaryChars[i], dm));
                }
            } else {
                tstate.append((char)ch);
            }
            lastch = ch;
        }
        return tstate.toString();
    }

    protected String expandVariable(char variable, DownloadManager dm) {
        switch (variable) {
            case 'a': {
                return Show.getShortStateString(dm.getState());
            }
            case 'c': {
                DecimalFormat df = new DecimalFormat("000.0%");
                return df.format((double)dm.getStats().getCompleted() / 1000.0);
            }
            case 't': {
                if (dm.getState() == 100) {
                    return dm.getErrorDetails();
                }
                if (dm.getDisplayName() == null) {
                    return "?";
                }
                return dm.getDisplayName();
            }
            case 'z': {
                return DisplayFormatters.formatByteCountToKiBEtc(dm.getSize());
            }
            case 'e': {
                return DisplayFormatters.formatETA(dm.getStats().getETA());
            }
            case 'r': {
                DiskManagerFileInfo[] files;
                long to = 0L;
                long tot = 0L;
                if (dm.getDiskManager() != null && (files = dm.getDiskManager().getFiles()) != null && files.length > 1) {
                    int c = 0;
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i] == null || files[i].isSkipped()) continue;
                        ++c;
                        tot += files[i].getLength();
                        to += files[i].getDownloaded();
                    }
                    if (c == files.length) {
                        tot = 0L;
                    }
                }
                DecimalFormat df1 = new DecimalFormat("000.0%");
                if (tot > 0L) {
                    return "      (" + df1.format((double)to * 1.0 / (double)tot) + ")";
                }
                return "\t";
            }
            case 'd': {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(dm.getStats().getDataReceiveRate());
            }
            case 'u': {
                return DisplayFormatters.formatByteCountToKiBEtcPerSec(dm.getStats().getDataSendRate());
            }
            case 'D': {
                return DisplayFormatters.formatDownloaded(dm.getStats());
            }
            case 'U': {
                return DisplayFormatters.formatByteCountToKiBEtc(dm.getStats().getTotalDataBytesSent());
            }
            case 's': {
                return Integer.toString(dm.getNbSeeds());
            }
            case 'p': {
                return Integer.toString(dm.getNbPeers());
            }
            case 'v': {
                return Integer.toString(dm.getMaxUploads());
            }
            case 'I': {
                int downloadSpeed = dm.getStats().getDownloadRateLimitBytesPerSecond();
                if (downloadSpeed <= 0) {
                    return "";
                }
                return "(max " + DisplayFormatters.formatByteCountToKiBEtcPerSec(downloadSpeed) + ")";
            }
            case 'O': {
                int uploadSpeed = dm.getStats().getUploadRateLimitBytesPerSecond();
                if (uploadSpeed <= 0) {
                    return "";
                }
                return "(max " + DisplayFormatters.formatByteCountToKiBEtcPerSec(uploadSpeed) + ")";
            }
            case 'P': 
            case 'S': {
                TRTrackerScraperResponse hd = dm.getTrackerScrapeResponse();
                if (hd == null || !hd.isValid()) {
                    return "?";
                }
                if (variable == 'S') {
                    return Integer.toString(hd.getSeeds());
                }
                return Integer.toString(hd.getPeers());
            }
        }
        return "??" + variable + "??";
    }

    protected String getDefaultSummaryFormat() {
        return "[%a] %c\t%t (%z) ETA: %e\r\n%r\tSpeed: %d%I / %u%O\tAmount: %D / %U\tConnections: %s(%S) / %p(%P)";
    }

    private static String getShortStateString(int dmstate) {
        switch (dmstate) {
            case 5: {
                return "I";
            }
            case 20: {
                return "A";
            }
            case 30: {
                return "C";
            }
            case 50: {
                return ">";
            }
            case 100: {
                return "E";
            }
            case 60: {
                return "*";
            }
            case 70: {
                return "!";
            }
            case 0: {
                return ".";
            }
            case 40: {
                return ":";
            }
            case 75: {
                return "-";
            }
        }
        return "?";
    }

    private static void printTorrentDetails(PrintStream out, DownloadManager dm, int torrentNum, boolean verbose) {
        String name = dm.getDisplayName();
        if (name == null) {
            name = "?";
        }
        out.println("> -----");
        out.println("Info on Torrent #" + torrentNum + " (" + name + ")");
        out.println("- General Info -");
        String[] health = new String[]{"- no info -", "stopped", "no remote connections", "no tracker", "OK", "ko"};
        try {
            out.println("Health: " + health[dm.getHealthStatus()]);
        }
        catch (Exception e) {
            out.println("Health: " + health[0]);
        }
        out.println("State: " + Integer.toString(dm.getState()));
        if (dm.getState() == 100) {
            out.println("Error: " + dm.getErrorDetails());
        }
        out.println("Hash: " + TorrentUtils.nicePrintTorrentHash(dm.getTorrent(), true));
        out.println("- Torrent file -");
        out.println("Torrent Filename: " + dm.getTorrentFileName());
        out.println("Saving to: " + dm.getSaveLocation());
        out.println("Created By: " + dm.getTorrentCreatedBy());
        out.println("Comment: " + dm.getTorrentComment());
        out.println("- Tracker Info -");
        TRTrackerAnnouncer trackerclient = dm.getTrackerClient();
        if (trackerclient != null) {
            String timestr;
            out.println("URL: " + trackerclient.getTrackerUrl());
            try {
                int time = trackerclient.getTimeUntilNextUpdate();
                if (time < 0) {
                    timestr = MessageText.getString("GeneralView.label.updatein.querying");
                } else {
                    int minutes = time / 60;
                    int seconds = time % 60;
                    String strSeconds = "" + seconds;
                    if (seconds < 10) {
                        strSeconds = "0" + seconds;
                    }
                    timestr = minutes + ":" + strSeconds;
                }
            }
            catch (Exception e) {
                timestr = "unknown";
            }
            out.println("Time till next Update: " + timestr);
            out.println("Status: " + trackerclient.getStatusString());
        } else {
            out.println("  Not available");
        }
        out.println("- Files Info -");
        DiskManagerFileInfo[] files = dm.getDiskManagerFileInfo();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                out.print((i < 9 ? "   " : "  ") + Integer.toString(i + 1) + " (");
                String tmp = ">";
                if (files[i].isPriority()) {
                    tmp = "+";
                }
                if (files[i].isSkipped()) {
                    tmp = "!";
                }
                out.print(tmp + ") ");
                if (files[i] != null) {
                    long fLen = files[i].getLength();
                    if (fLen > 0L) {
                        DecimalFormat df = new DecimalFormat("000.0%");
                        out.print(df.format((double)files[i].getDownloaded() * 1.0 / (double)fLen));
                        out.println("\t" + files[i].getFile(true).getName());
                        continue;
                    }
                    out.println("Info not available.");
                    continue;
                }
                out.println("Info not available.");
            }
        } else {
            out.println("  Info not available.");
        }
        if (verbose) {
            out.println("Pieces");
            PEPeerManager pm = dm.getPeerManager();
            if (pm != null) {
                PiecePicker picker = pm.getPiecePicker();
                PEPiece[] pieces = pm.getPieces();
                String line = "";
                for (int i = 0; i < pieces.length; ++i) {
                    String str = picker.getPieceString(i);
                    line = line + (line.length() == 0 ? i + " " : ",") + str;
                    PEPiece piece = pieces[i];
                    if (piece != null) {
                        line = line + ":" + piece.getString();
                    }
                    if ((i + 1) % 10 != 0) continue;
                    out.println(line);
                    line = "";
                }
                if (line.length() > 0) {
                    out.println(line);
                }
            }
        }
        out.println("> -----");
    }

    protected void showDHTStats(ConsoleInput ci) {
        try {
            PluginInterface def = ci.azureus_core.getPluginManager().getDefaultPluginInterface();
            PluginInterface dht_pi = def.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                ci.out.println("\tDHT isn't present");
                return;
            }
            DHTPlugin dht_plugin = (DHTPlugin)dht_pi.getPlugin();
            if (dht_plugin.getStatus() != 3) {
                ci.out.println("\tDHT isn't running yet (disabled or initialising)");
                return;
            }
            DHT[] dhts = dht_plugin.getDHTs();
            for (int i = 0; i < dhts.length; ++i) {
                if (i > 0) {
                    ci.out.println("");
                }
                DHT dht = dhts[i];
                DHTTransport transport = dht.getTransport();
                DHTTransportStats t_stats = transport.getStats();
                DHTDBStats d_stats = dht.getDataBase().getStats();
                DHTControlStats c_stats = dht.getControl().getStats();
                DHTRouterStats r_stats = dht.getRouter().getStats();
                long[] rs = r_stats.getStats();
                DHTNetworkPosition[] nps = transport.getLocalContact().getNetworkPositions();
                String np_str = "";
                for (int j = 0; j < nps.length; ++j) {
                    np_str = np_str + (j == 0 ? "" : ",") + nps[j];
                }
                ci.out.println("DHT:ip=" + transport.getLocalContact().getAddress() + ",net=" + transport.getNetwork() + ",prot=V" + transport.getProtocolVersion() + ",np=" + np_str);
                ci.out.println("Router:nodes=" + rs[0] + ",leaves=" + rs[1] + ",contacts=" + rs[2] + ",replacement=" + rs[3] + ",live=" + rs[4] + ",unknown=" + rs[5] + ",failing=" + rs[6]);
                ci.out.println("Transport:" + t_stats.getString());
                int[] dbv_details = d_stats.getValueDetails();
                ci.out.println("Control:dht=" + c_stats.getEstimatedDHTSize() + ", Database:keys=" + d_stats.getKeyCount() + ",vals=" + dbv_details[0] + ",loc=" + dbv_details[1] + ",dir=" + dbv_details[2] + ",ind=" + dbv_details[3] + ",div_f=" + dbv_details[4] + ",div_s=" + dbv_details[5]);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(ci.out);
        }
    }

    private static final class TorrentComparator
    implements Comparator {
        private TorrentComparator() {
        }

        public final int compare(Object a, Object b) {
            boolean bIsComplete;
            DownloadManager aDL = (DownloadManager)a;
            DownloadManager bDL = (DownloadManager)b;
            boolean aIsComplete = aDL.getStats().getDownloadCompleted(false) == 1000;
            boolean bl = bIsComplete = bDL.getStats().getDownloadCompleted(false) == 1000;
            if (aIsComplete && !bIsComplete) {
                return 1;
            }
            if (!aIsComplete && bIsComplete) {
                return -1;
            }
            return aDL.getPosition() - bDL.getPosition();
        }
    }
}

