/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.util.GeneralUtils;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UIStatusTextClickListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.shells.MessageSlideShell;

public class Alerts {
    private static List alert_queue = new ArrayList();
    private static AEMonitor alert_queue_mon = new AEMonitor("Alerts:Q");
    private static List alert_history = new ArrayList();
    private static AEMonitor alert_history_mon = new AEMonitor("Alerts:H");
    private static boolean initialisation_complete = false;
    private static boolean has_unshown_messages = false;
    private static transient boolean stopping;
    private static List listeners;

    private Alerts() {
    }

    private static void showWarningMessageBox(Object[] relatedTo, String message, int timeoutSecs) {
        Alerts.showMessageBoxUsingResourceString(relatedTo, 8, "AlertMessageBox.warning", message, timeoutSecs);
    }

    private static void showMessageBoxUsingResourceString(Object[] relatedTo, int type, String key, String message, int timeoutSecs) {
        Alerts.showMessageBox(relatedTo, type, MessageText.getString(key), message, null, timeoutSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showMessageBox(Object[] relatedTo, final int type, String title, String message, String details, int timeoutSecs) {
        final Display display = SWTThread.getInstance().getDisplay();
        if (stopping || display.isDisposed()) {
            try {
                alert_queue_mon.enter();
                List close_alerts = COConfigurationManager.getListParameter("Alerts.raised.at.close", new ArrayList());
                HashMap<String, Object> alert_map = new HashMap<String, Object>();
                alert_map.put("type", new Long(type));
                alert_map.put("title", title);
                alert_map.put("message", message);
                alert_map.put("timeout", new Long(timeoutSecs));
                if (details != null) {
                    alert_map.put("details", details);
                }
                close_alerts.add(alert_map);
                COConfigurationManager.setParameter("Alerts.raised.at.close", close_alerts);
                return;
            }
            finally {
                alert_queue_mon.exit();
            }
        }
        if (display.isDisposed()) {
            return;
        }
        final String message2 = message != null && COConfigurationManager.getBooleanParameter("Show Timestamp For Alerts") ? "[" + DisplayFormatters.formatDateShort(SystemTime.getCurrentTime()) + "] " + message : (message == null ? "" : message);
        boolean suppress_popups = COConfigurationManager.getBooleanParameter("Suppress Alerts");
        boolean use_message_box = COConfigurationManager.getBooleanParameter("Use Message Box For Popups");
        MessageSlideShell.recordMessage(type, title, message2 == null ? "" : message2, details, relatedTo, timeoutSecs);
        for (AlertListener l : listeners) {
            if (l.allowPopup(relatedTo, type)) continue;
            suppress_popups = true;
            return;
        }
        if (suppress_popups) {
            try {
                UIFunctions ui_functions;
                alert_queue_mon.enter();
                if (!has_unshown_messages && (ui_functions = UIFunctionsManager.getUIFunctions()) != null) {
                    ui_functions.setStatusText(1, MessageText.getString("AlertMessageBox.unread"), new UIStatusTextClickListener(){

                        public void UIStatusTextClicked() {
                            MessageSlideShell.displayLastMessage(display, true);
                            ui_functions.setStatusText("");
                            has_unshown_messages = false;
                        }
                    });
                    has_unshown_messages = true;
                }
                return;
            }
            finally {
                alert_queue_mon.exit();
            }
        }
        if (!use_message_box) {
            MessageSlideShell.displayLastMessage(display, true);
        } else {
            String amb_key_suffix;
            switch (type) {
                case 1: {
                    amb_key_suffix = "error";
                    break;
                }
                case 2: {
                    amb_key_suffix = "information";
                    break;
                }
                case 8: {
                    amb_key_suffix = "warning";
                    break;
                }
                default: {
                    amb_key_suffix = null;
                }
            }
            final String title2 = amb_key_suffix != null && title.equals(MessageText.getString("AlertMessageBox." + amb_key_suffix)) ? Constants.APP_NAME : title;
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    Shell s = Utils.findAnyShell();
                    if (s == null) {
                        return;
                    }
                    MessageBox mb = new MessageBox(s, type | 0x20);
                    mb.setText(title2);
                    mb.setMessage(GeneralUtils.stripOutHyperlinks(message2));
                    mb.open();
                }
            });
        }
    }

    public static void showErrorMessageBoxUsingResourceString(Object[] relatedTo, String title_key, Throwable error, int timeoutSecs) {
        Alerts.showErrorMessageBox(relatedTo, MessageText.getString(title_key), error, timeoutSecs);
    }

    private static void showErrorMessageBox(Object[] relatedTo, String message, Throwable error, int timeoutSecs) {
        String error_message = Debug.getStackTrace(error);
        Alerts.showMessageBox(relatedTo, 1, MessageText.getString("AlertMessageBox.error"), message + "\n" + Debug.getExceptionMessage(error), error_message, timeoutSecs);
    }

    private static void showErrorMessageBox(Object[] relatedTo, String message, int timeoutSecs) {
        Alerts.showMessageBoxUsingResourceString(relatedTo, 1, "AlertMessageBox.error", message, timeoutSecs);
    }

    private static void showCommentMessageBox(Object[] relatedTo, String message, int timeoutSecs) {
        Alerts.showMessageBoxUsingResourceString(relatedTo, 2, "AlertMessageBox.information", message, timeoutSecs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void showAlert(LogAlert alert) {
        String key = alert.err == null ? alert.text : alert.text + ":" + alert.err.toString();
        try {
            alert_history_mon.enter();
            if (!alert.repeatable) {
                if (alert_history.contains(key)) {
                    return;
                }
                alert_history.add(key);
                if (alert_history.size() > 512) {
                    alert_history.remove(0);
                }
            }
        }
        finally {
            alert_history_mon.exit();
        }
        if (alert.err == null) {
            if (alert.entryType == 0) {
                Alerts.showCommentMessageBox(alert.relatedTo, alert.text, alert.timeoutSecs);
            } else if (alert.entryType == 1) {
                Alerts.showWarningMessageBox(alert.relatedTo, alert.text, alert.timeoutSecs);
            } else {
                Alerts.showErrorMessageBox(alert.relatedTo, alert.text, alert.timeoutSecs);
            }
        } else {
            Alerts.showErrorMessageBox(alert.relatedTo, alert.text, alert.err, alert.timeoutSecs);
        }
    }

    public static void initComplete() {
        new AEThread2("Init Complete", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    alert_queue_mon.enter();
                    initialisation_complete = true;
                    for (int i = 0; i < alert_queue.size(); ++i) {
                        LogAlert alert = (LogAlert)alert_queue.get(i);
                        Alerts.showAlert(alert);
                    }
                    List close_alerts = COConfigurationManager.getListParameter("Alerts.raised.at.close", new ArrayList());
                    if (close_alerts.size() > 0) {
                        COConfigurationManager.setParameter("Alerts.raised.at.close", new ArrayList());
                        String intro = MessageText.getString("alert.raised.at.close") + "\n";
                        for (int i = 0; i < close_alerts.size(); ++i) {
                            try {
                                Map alert_map = (Map)close_alerts.get(i);
                                byte[] details = (byte[])alert_map.get("details");
                                Long l_timeout = (Long)alert_map.get("timeout");
                                int timeout = l_timeout == null ? -1 : l_timeout.intValue();
                                Alerts.showMessageBox(null, ((Long)alert_map.get("type")).intValue(), new String((byte[])alert_map.get("title")), intro + new String((byte[])alert_map.get("message")), details == null ? null : new String(details), timeout);
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                    alert_queue.clear();
                }
                finally {
                    alert_queue_mon.exit();
                }
            }
        }.start();
    }

    public static void stopInitiated() {
        stopping = true;
    }

    public static void init() {
        Logger.addListener(new ILogAlertListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alertRaised(LogAlert alert) {
                if (!initialisation_complete) {
                    try {
                        alert_queue_mon.enter();
                        alert_queue.add(alert);
                    }
                    finally {
                        alert_queue_mon.exit();
                    }
                    return;
                }
                Alerts.showAlert(alert);
            }
        });
    }

    public static void addListener(AlertListener l) {
        listeners.add(l);
    }

    static {
        listeners = new ArrayList();
    }

    public static interface AlertListener {
        public boolean allowPopup(Object[] var1, int var2);
    }
}

