/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.ui.swt.Utils;

public class ImageRepository {
    private static boolean NO_IMAGES = false;
    private static Display display;
    private static final HashMap imagesToPath;
    private static final HashMap images;
    private static final HashMap registry;
    private static final String[] noCacheExtList;
    private static final boolean forceNoAWT;
    static org.eclipse.swt.graphics.Image onlyOneImage;

    public static void loadImagesForSplashWindow(Display display) {
        ImageRepository.display = display;
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/a16.png", "azureus");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/a32.png", "azureus32");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/a64.png", "azureus64");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/a128.jpg", "azureus128");
        ImageRepository.addPath("org/gudy/azureus2/ui/splash/splash_frog.jpg", "azureus_splash");
    }

    public static void loadImages(Display display) {
        if (Constants.isOSX) {
            ImageRepository.addPath("org/gudy/azureus2/ui/icons/az3_osx_tray_white.png", "azureus_white");
            ImageRepository.addPath("org/gudy/azureus2/ui/icons/az3_osx_tray.png", "azureus_grey");
        }
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/Azureus_big.png", "tray");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/dragger.gif", "dragger");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/folder.gif", "folder");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/ipfilter.png", "ipfilter");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/start.gif", "start");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/stop.gif", "stop");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/bar.gif", "downloadBar");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/delete.gif", "delete");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/lock.gif", "lock");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/host.gif", "host");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/publish.gif", "publish");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/run.gif", "run");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/details.gif", "details");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/up.png", "up");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/down.png", "down");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/top.gif", "top");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/bottom.gif", "bottom");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/recheck.gif", "recheck");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/export.gif", "export");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/move.gif", "move");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/add_tracker.gif", "add_tracker");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/edit_trackers.gif", "edit_trackers");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/columns.gif", "columns");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/speed.gif", "speed");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/openFolder16x12.gif", "openFolderButton");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/forcestart.gif", "forcestart");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/greenled.gif", "greenled");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/redled.gif", "redled");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/yellowled.gif", "yellowled");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/grayled.gif", "grayled");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/popup.png", "popup");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/error.gif", "error");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/info.gif", "info");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/warning.gif", "warning");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/subitem.gif", "subitem");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/comment.png", "comment");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/comment_blank.png", "no_comment");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/foldersmall.png", "foldersmall");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/open.gif", "cb_open");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/open_no_default.gif", "cb_open_no_default");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/open_folder.gif", "cb_open_folder");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/open_url.gif", "cb_open_url");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/new.gif", "cb_new");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/up.gif", "cb_up");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/down.gif", "cb_down");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/top.gif", "cb_top");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/bottom.gif", "cb_bottom");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/run.gif", "cb_run");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/start.gif", "cb_start");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/stop.gif", "cb_stop");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/remove.gif", "cb_remove");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/switchui.png", "cb_switch");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/toolbar/editcolumns.gif", "cb_editcolumns");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/ok.gif", "st_ok");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/ko.gif", "st_ko");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/stopped.gif", "st_stopped");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/error.gif", "st_error");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/no_tracker.gif", "st_no_tracker");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/no_remote.gif", "st_no_remote");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/ok_shared.gif", "st_ok_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/ko_shared.gif", "st_ko_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/error_shared.gif", "st_error_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/stopped_shared.gif", "st_stopped_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/no_tracker_shared.gif", "st_no_tracker_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/no_remote_shared.gif", "st_no_remote_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/explain.gif", "st_explain");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/status/shared.gif", "st_shared");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/statusbar/status_warning.gif", "sb_warning");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/statusbar/user_count.png", "sb_count");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/statusbar/bbb_notloggedin.png", "bbb_nli");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/statusbar/bbb_idle.png", "bbb_idle");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/statusbar/bbb_boosting.png", "bbb_out");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/statusbar/bbb_boosted.png", "bbb_in");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/smallx.png", "smallx");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/smallx-gray.png", "smallx-gray");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/working.gif", "working");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/search.png", "search");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/progress_viewer_has_error.png", "progress_error");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/progress_viewer_has_info.png", "progress_info");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/progress_viewer.png", "progress_viewer");
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/spinning_indicator_big_black_white.gif", "spinner_big");
        if (Utils.isAZ2UI()) {
            ImageRepository.addPath("org/gudy/azureus2/ui/icons/recheck.gif", "progress_retry");
            ImageRepository.addPath("org/gudy/azureus2/ui/icons/stop.gif", "progress_cancel");
            ImageRepository.addPath("org/gudy/azureus2/ui/icons/delete.gif", "progress_remove");
        } else {
            ImageRepository.addPath("org/gudy/azureus2/ui/icons/progress_retry.png", "progress_retry");
            ImageRepository.addPath("org/gudy/azureus2/ui/icons/progress_cancel.png", "progress_cancel");
            ImageRepository.addPath("org/gudy/azureus2/ui/icons/progress_remove.png", "progress_remove");
        }
    }

    public static void addPath(String path, String id) {
        imagesToPath.put(id, path);
    }

    private static org.eclipse.swt.graphics.Image loadImage(Display display, String res, String name) {
        return ImageRepository.loadImage(display, res, name, 255);
    }

    private static org.eclipse.swt.graphics.Image loadImage(Display display, String res, String name, int alpha) {
        return ImageRepository.loadImage(ImageRepository.class.getClassLoader(), display, res, name, alpha);
    }

    private static org.eclipse.swt.graphics.Image loadImage(ClassLoader loader, Display display, String res, String name, int alpha) {
        org.eclipse.swt.graphics.Image im;
        block10: {
            if (NO_IMAGES) {
                if (onlyOneImage == null) {
                    onlyOneImage = new org.eclipse.swt.graphics.Image((Device)display, 1, 1);
                }
                return onlyOneImage;
            }
            imagesToPath.put(name, res);
            im = ImageRepository.getImage(name, false);
            if (null == im) {
                try {
                    InputStream is = loader.getResourceAsStream(res);
                    if (null != is) {
                        try {
                            if (alpha == 255) {
                                im = new org.eclipse.swt.graphics.Image((Device)display, is);
                            } else {
                                ImageData icone = new ImageData(is);
                                icone.alpha = alpha;
                                im = new org.eclipse.swt.graphics.Image((Device)display, icone);
                            }
                            images.put(name, im);
                            break block10;
                        }
                        catch (SWTException e) {
                            return null;
                        }
                    }
                    Debug.outNoStack("ImageRepository:loadImage:: Resource not found: " + res);
                    im = new org.eclipse.swt.graphics.Image((Device)display, 1, 1);
                    images.put(name, im);
                }
                catch (Throwable e) {
                    Debug.outNoStack("ImageRepository:loadImage:: Resource not found: " + res + " - " + Debug.getNestedExceptionMessage(e));
                    im = new org.eclipse.swt.graphics.Image((Device)display, 1, 1);
                    images.put(name, im);
                }
            }
        }
        return im;
    }

    public static void unLoadImages() {
        for (org.eclipse.swt.graphics.Image im : images.values()) {
            im.dispose();
        }
        for (org.eclipse.swt.graphics.Image im : registry.values()) {
            if (im == null) continue;
            im.dispose();
        }
    }

    public static org.eclipse.swt.graphics.Image getRandomImage() {
        Object[] imageArray = images.values().toArray();
        int rnd = (int)(Math.random() * (double)imageArray.length);
        return (org.eclipse.swt.graphics.Image)imageArray[rnd];
    }

    public static org.eclipse.swt.graphics.Image getImage(String name) {
        if (NO_IMAGES) {
            if (onlyOneImage == null) {
                onlyOneImage = new org.eclipse.swt.graphics.Image((Device)display, 1, 1);
            }
            return onlyOneImage;
        }
        return ImageRepository.getImage(name, true);
    }

    public static InputStream getImageAsStream(String name) {
        String path = (String)imagesToPath.get(name);
        if (path == null) {
            System.out.println("ImageRepository: Unknown image name '" + name + "'");
            return null;
        }
        return ImageRepository.class.getClassLoader().getResourceAsStream(path);
    }

    private static org.eclipse.swt.graphics.Image getImage(String name, boolean allowLoading) {
        String path;
        org.eclipse.swt.graphics.Image result = (org.eclipse.swt.graphics.Image)images.get(name);
        if (allowLoading && result == null && (path = (String)imagesToPath.get(name)) != null) {
            return ImageRepository.loadImage(display, path, name);
        }
        return result;
    }

    public static org.eclipse.swt.graphics.Image getIconFromExtension(String ext) {
        return ImageRepository.getIconFromExtension(ext, false, false);
    }

    public static org.eclipse.swt.graphics.Image getIconFromExtension(String ext, boolean bBig, boolean minifolder) {
        org.eclipse.swt.graphics.Image image;
        block12: {
            image = null;
            try {
                Program program;
                String id = ext;
                if (bBig) {
                    id = id + "-big";
                }
                if (minifolder) {
                    id = id + "-fold";
                }
                if ((image = (org.eclipse.swt.graphics.Image)images.get(id)) != null) break block12;
                ImageData imageData = null;
                if (Constants.isWindows && bBig) {
                    try {
                        Class<?> ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.win32.Win32UIEnhancer");
                        Method method = ehancerClass.getMethod("getBigImageData", String.class);
                        imageData = (ImageData)method.invoke(null, ext);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (imageData == null && (program = Program.findProgram((String)ext)) != null) {
                    imageData = program.getImageData();
                }
                if (imageData != null) {
                    image = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), imageData);
                    if (!bBig) {
                        image = ImageRepository.force16height(image);
                    }
                    if (minifolder) {
                        image = ImageRepository.minifolderize(image, bBig);
                    }
                    images.put(id, image);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (image == null) {
            return ImageRepository.getImage(minifolder ? "folder" : "transparent");
        }
        return image;
    }

    private static org.eclipse.swt.graphics.Image minifolderize(org.eclipse.swt.graphics.Image img, boolean big) {
        org.eclipse.swt.graphics.Image imgFolder = ImageRepository.getImage(big ? "folder" : "foldersmall");
        Rectangle folderBounds = imgFolder.getBounds();
        Rectangle dstBounds = img.getBounds();
        org.eclipse.swt.graphics.Image tempImg = Utils.renderTransparency(Display.getCurrent(), img, imgFolder, new Point(dstBounds.width - folderBounds.width, dstBounds.height - folderBounds.height), 204);
        if (tempImg != null) {
            img.dispose();
            img = tempImg;
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static org.eclipse.swt.graphics.Image force16height(org.eclipse.swt.graphics.Image image) {
        if (image == null) {
            return image;
        }
        Rectangle bounds = image.getBounds();
        if (bounds.height != 16) {
            org.eclipse.swt.graphics.Image newImage = new org.eclipse.swt.graphics.Image(image.getDevice(), 16, 16);
            GC gc = new GC((Drawable)newImage);
            try {
                if (!Constants.isUnix) {
                    gc.setAdvanced(true);
                }
                gc.drawImage(image, 0, 0, bounds.width, bounds.height, 0, 0, 16, 16);
            }
            finally {
                gc.dispose();
            }
            image.dispose();
            image = newImage;
        }
        return image;
    }

    public static org.eclipse.swt.graphics.Image getFolderImage() {
        return ImageRepository.getImage("folder", true);
    }

    public static org.eclipse.swt.graphics.Image getPathIcon(String path) {
        return ImageRepository.getPathIcon(path, false, false);
    }

    public static org.eclipse.swt.graphics.Image getPathIcon(String path, boolean minifolder) {
        return ImageRepository.getPathIcon(path, false, minifolder);
    }

    public static org.eclipse.swt.graphics.Image getPathIcon(String path, boolean bBig, boolean minifolder) {
        String ext;
        if (path == null) {
            return null;
        }
        File file = null;
        boolean bDeleteFile = false;
        boolean noAWT = forceNoAWT || !bBig;
        try {
            Object sfInstance;
            Method method;
            org.eclipse.swt.graphics.Image image;
            String key;
            file = new File(path);
            if (file.isDirectory()) {
                if (noAWT) {
                    return ImageRepository.getFolderImage();
                }
                key = file.getPath();
            } else {
                int lookIndex = file.getName().lastIndexOf(".");
                if (lookIndex == -1) {
                    if (noAWT) {
                        return ImageRepository.getFolderImage();
                    }
                    key = "?!blank";
                } else {
                    String ext2;
                    key = ext2 = file.getName().substring(lookIndex);
                    if (noAWT) {
                        return ImageRepository.getIconFromExtension(ext2, bBig, minifolder);
                    }
                    for (int i = 0; i < noCacheExtList.length; ++i) {
                        if (!noCacheExtList[i].equalsIgnoreCase(ext2)) continue;
                        key = file.getPath();
                        break;
                    }
                }
            }
            if (bBig) {
                key = key + "-big";
            }
            if (minifolder) {
                key = key + "-fold";
            }
            if ((image = (org.eclipse.swt.graphics.Image)registry.get(key)) != null) {
                return image;
            }
            boolean bl = bDeleteFile = !file.exists();
            if (bDeleteFile) {
                file = File.createTempFile("AZ_", FileUtil.getExtension(path));
            }
            Image awtImage = null;
            Class<?> sfClass = Class.forName("sun.awt.shell.ShellFolder");
            if (sfClass != null && file != null && (method = sfClass.getMethod("getShellFolder", File.class)) != null && (sfInstance = method.invoke(null, file)) != null && (method = sfClass.getMethod("getIcon", Boolean.TYPE)) != null) {
                awtImage = (Image)method.invoke(sfInstance, new Boolean(bBig));
            }
            if (awtImage != null) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)((BufferedImage)awtImage), "png", outStream);
                ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
                image = new org.eclipse.swt.graphics.Image((Device)Display.getDefault(), (InputStream)inStream);
                if (!bBig) {
                    image = ImageRepository.force16height(image);
                }
                if (minifolder) {
                    image = ImageRepository.minifolderize(image, bBig);
                }
                registry.put(key, image);
                if (bDeleteFile && file != null && file.exists()) {
                    file.delete();
                }
                return image;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bDeleteFile && file != null && file.exists()) {
            file.delete();
        }
        if ((ext = FileUtil.getExtension(path)).length() == 0) {
            return ImageRepository.getFolderImage();
        }
        return ImageRepository.getIconFromExtension(ext, bBig, minifolder);
    }

    public static org.eclipse.swt.graphics.Image getImageWithSize(String name, Point canvasSize) {
        String key = new StringBuffer().append(name).append('.').append(canvasSize.x).append('.').append(canvasSize.y).toString();
        org.eclipse.swt.graphics.Image newImage = (org.eclipse.swt.graphics.Image)images.get(key);
        if (newImage == null) {
            org.eclipse.swt.graphics.Image oldImage = ImageRepository.getImage(name);
            if (oldImage == null) {
                return null;
            }
            newImage = new org.eclipse.swt.graphics.Image((Device)Display.getCurrent(), canvasSize.x, canvasSize.y);
            GC gc = new GC((Drawable)newImage);
            int x = Math.max(0, (canvasSize.x - oldImage.getBounds().width) / 2);
            int y = Math.max(0, (canvasSize.y - oldImage.getBounds().height) / 2);
            gc.drawImage(oldImage, x, y);
            gc.dispose();
            images.put(key, newImage);
        }
        return newImage;
    }

    public static void unloadImage(String name) {
        org.eclipse.swt.graphics.Image img = (org.eclipse.swt.graphics.Image)images.get(name);
        if (img != null) {
            images.remove(name);
            if (!img.isDisposed()) {
                img.dispose();
            }
        }
    }

    public static void unloadPathIcon(String path) {
        String key = ImageRepository.getKey(path);
        org.eclipse.swt.graphics.Image img = (org.eclipse.swt.graphics.Image)registry.get(key);
        if (img != null) {
            registry.remove(key);
            if (!img.isDisposed()) {
                img.dispose();
            }
        }
    }

    private static String getKey(String path) {
        String key;
        File file = new File(path);
        if (file.isDirectory()) {
            key = file.getPath();
        } else {
            int lookIndex = file.getName().lastIndexOf(".");
            if (lookIndex == -1) {
                key = "?!blank";
            } else {
                String ext;
                key = ext = file.getName().substring(lookIndex);
                for (int i = 0; i < noCacheExtList.length; ++i) {
                    if (!noCacheExtList[i].equalsIgnoreCase(ext)) continue;
                    key = file.getPath();
                }
            }
        }
        return key;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new FillLayout(512));
        final Label label = new Label((Composite)shell, 2048);
        final Text text = new Text((Composite)shell, 2048);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                org.eclipse.swt.graphics.Image pathIcon = ImageRepository.getPathIcon(text.getText(), false);
                label.setImage(pathIcon);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    static {
        noCacheExtList = new String[]{".exe"};
        forceNoAWT = Constants.isOSX;
        images = new HashMap(150);
        imagesToPath = new HashMap(150);
        registry = new HashMap();
        onlyOneImage = null;
    }
}

