/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;

public class PropertiesWindow {
    private final Shell shell;

    public PropertiesWindow(String object_name, String[] keys, String[] values) {
        Shell any_shell = Utils.findAnyShell();
        this.shell = new Shell(any_shell.getDisplay(), 65648);
        this.shell.setText(MessageText.getString("props.window.title", new String[]{object_name}));
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout((Layout)layout);
        final ScrolledComposite scrollable = new ScrolledComposite((Composite)this.shell, 768);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 3;
        scrollable.setLayoutData((Object)gridData);
        final Composite main = new Composite((Composite)scrollable, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        main.setLayout((Layout)layout);
        scrollable.setContent((Control)main);
        scrollable.setExpandVertical(true);
        scrollable.setExpandHorizontal(true);
        scrollable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrollable.getClientArea();
                scrollable.setMinSize(main.computeSize(r.width, -1));
            }
        });
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        main.setLayoutData((Object)gridData);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null || values[i] == null) continue;
            BufferedLabel msg_label = new BufferedLabel(main, 0);
            msg_label.setText(MessageText.getString(keys[i]) + ":");
            gridData = new GridData();
            gridData.verticalAlignment = 16;
            msg_label.setLayoutData(gridData);
            BufferedLabel val_label = new BufferedLabel(main, 64);
            val_label.setText(values[i]);
            gridData = new GridData(768);
            gridData.horizontalIndent = 6;
            val_label.setLayoutData(gridData);
        }
        Label labelSeparator = new Label((Composite)this.shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData((Object)gridData);
        new Label((Composite)this.shell, 0);
        Button bOk = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)bOk, "Button.ok");
        gridData = new GridData(896);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 70;
        bOk.setLayoutData((Object)gridData);
        bOk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PropertiesWindow.this.close();
            }
        });
        Button bCancel = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)bCancel, "Button.cancel");
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 70;
        bCancel.setLayoutData((Object)gridData);
        bCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PropertiesWindow.this.close();
            }
        });
        this.shell.setDefaultButton(bOk);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    PropertiesWindow.this.close();
                }
            }
        });
        this.shell.pack();
        int shell_width = 400;
        int main_height = main.computeSize((int)shell_width, (int)-1).y;
        int shell_height = main_height + (this.shell.getSize().y - scrollable.getSize().y);
        shell_height = Math.min(shell_height, 600);
        this.shell.setSize(shell_width, shell_height);
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    protected void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }
}

