/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AERunnableBoolean;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class UIExitUtilsSWT {
    private static boolean skipCloseCheck = false;

    public static void setSkipCloseCheck(boolean b) {
        skipCloseCheck = b;
    }

    public static boolean canClose(GlobalManager globalManager, boolean bForRestart) {
        if (skipCloseCheck) {
            return true;
        }
        Shell mainShell = UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell();
        if (mainShell != null && (!mainShell.isVisible() || mainShell.getMinimized()) && COConfigurationManager.getBooleanParameter("Password enabled") && !PasswordWindow.showPasswordWindow(Display.getCurrent())) {
            return false;
        }
        if (COConfigurationManager.getBooleanParameter("confirmationOnExit") && !UIExitUtilsSWT.getExitConfirmation(bForRestart)) {
            return false;
        }
        if (globalManager != null) {
            ArrayList<DownloadManager> listUnfinished = new ArrayList<DownloadManager>();
            Object[] dms = globalManager.getDownloadManagers().toArray();
            for (int i = 0; i < dms.length; ++i) {
                DownloadManager dm = (DownloadManager)dms[i];
                if (dm.getState() != 60 || !dm.getDownloadState().isOurContent() || !(dm.getStats().getAvailability() < 2.0f)) continue;
                TRTrackerScraperResponse scrape = dm.getTrackerScrapeResponse();
                int numSeeds = scrape.getSeeds();
                long seedingStartedOn = dm.getStats().getTimeStartedSeeding();
                if (numSeeds > 0 && seedingStartedOn > 0L && scrape.getScrapeStartTime() > seedingStartedOn) {
                    --numSeeds;
                }
                if (numSeeds != 0) continue;
                listUnfinished.add(dm);
            }
            if (listUnfinished.size() > 0) {
                final ArrayList<DownloadManager> flistUnfinished = listUnfinished;
                boolean allowQuit = listUnfinished.size() == 1 ? Utils.execSWTThreadWithBool("quitSeeding", new AERunnableBoolean(){

                    public boolean runSupport() {
                        String title = MessageText.getString("Content.alert.notuploaded.title");
                        String text = MessageText.getString("Content.alert.notuploaded.text", new String[]{((DownloadManager)flistUnfinished.get(0)).getDisplayName(), MessageText.getString("Content.alert.notuploaded.quit")});
                        MessageBoxShell mb = new MessageBoxShell(Utils.findAnyShell(), title, text, new String[]{MessageText.getString("UpdateWindow.quit"), MessageText.getString("Content.alert.notuploaded.button.abort")}, 1, null, null, false, 0);
                        mb.setRelatedObject((DownloadManager)flistUnfinished.get(0));
                        return mb.open() == 0;
                    }
                }, 0L) : Utils.execSWTThreadWithBool("quitSeeding", new AERunnableBoolean(){

                    public boolean runSupport() {
                        String sList = "";
                        for (int i = 0; i < flistUnfinished.size() && i < 5; ++i) {
                            DownloadManager dm = (DownloadManager)flistUnfinished.get(i);
                            if (sList != "") {
                                sList = sList + "\n";
                            }
                            sList = sList + dm.getDisplayName();
                        }
                        String title = MessageText.getString("Content.alert.notuploaded.multi.title");
                        String text = MessageText.getString("Content.alert.notuploaded.multi.text", new String[]{"" + flistUnfinished.size(), MessageText.getString("Content.alert.notuploaded.quit"), sList});
                        MessageBoxShell mb = new MessageBoxShell(Utils.findAnyShell(), title, text, new String[]{MessageText.getString("UpdateWindow.quit"), MessageText.getString("Content.alert.notuploaded.button.abort")}, 1, null, null, false, 0);
                        return mb.open() == 0;
                    }
                }, 0L);
                return allowQuit;
            }
        }
        return true;
    }

    private static boolean getExitConfirmation(boolean for_restart) {
        int result = Utils.openMessageBox(Utils.findAnyShell(), 200, for_restart ? "MainWindow.dialog.restartconfirmation" : "MainWindow.dialog.exitconfirmation", (String[])null);
        return result == 64;
    }

    public static void uiShutdown() {
        if (SystemProperties.isJavaWebStartInstance()) {
            AEThread close = new AEThread("JWS Force Terminate"){

                public void runSupport() {
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    SESecurityManager.exitVM(1);
                }
            };
            close.setDaemon(true);
            close.start();
        }
    }
}

