/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.ui.menus.MenuContext;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.pluginsimpl.local.ui.menus.MenuContextImpl;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntry;
import org.gudy.azureus2.ui.swt.plugins.UISWTStatusEntryListener;

public class UISWTStatusEntryImpl
implements UISWTStatusEntry,
MainStatusBar.CLabelUpdater {
    private AEMonitor this_mon = new AEMonitor("UISWTStatusEntryImpl@" + Integer.toHexString(this.hashCode()));
    private UISWTStatusEntryListener listener = null;
    private MenuContextImpl menu_context = MenuContextImpl.create("status_entry");
    private boolean needs_update = false;
    private String text = null;
    private String tooltip = null;
    private boolean image_enabled = false;
    private Image image = null;
    private boolean is_visible = false;
    private boolean needs_disposing = false;
    private boolean is_destroyed = false;
    private Menu menu;

    private void checkDestroyed() {
        if (this.is_destroyed) {
            throw new RuntimeException("object is destroyed, cannot be reused");
        }
    }

    public MenuContext getMenuContext() {
        return this.menu_context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CLabel label) {
        if (this.needs_disposing && !label.isDisposed()) {
            if (this.menu != null && !this.menu.isDisposed()) {
                this.menu.dispose();
                this.menu = null;
            }
            label.dispose();
            return;
        }
        if (this.menu_context.is_dirty) {
            this.needs_update = true;
            this.menu_context.is_dirty = false;
        }
        if (!this.needs_update) {
            return;
        }
        try {
            this.this_mon.enter();
            this.update0(label);
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void update0(final CLabel label) {
        label.setText(this.text);
        label.setToolTipText(this.tooltip);
        label.setImage(this.image_enabled ? this.image : null);
        label.setVisible(this.is_visible);
        MenuItem[] items = MenuItemManager.getInstance().getAllAsArray(this.menu_context.context);
        if (items.length > 0 & this.menu == null) {
            this.menu = new Menu((Control)label);
            label.setMenu(this.menu);
            MenuBuildUtils.addMaintenanceListenerForMenu(this.menu, new MenuBuildUtils.MenuBuilder(){

                public void buildMenu(Menu menu) {
                    MenuItem[] items = MenuItemManager.getInstance().getAllAsArray(((UISWTStatusEntryImpl)UISWTStatusEntryImpl.this).menu_context.context);
                    MenuBuildUtils.addPluginMenuItems((Composite)label, items, menu, true, true, MenuBuildUtils.BASIC_MENU_ITEM_CONTROLLER);
                }
            });
        } else if (this.menu != null && items.length == 0) {
            label.setMenu(null);
            if (!this.menu.isDisposed()) {
                this.menu.dispose();
            }
            this.menu = null;
        }
        this.needs_update = false;
    }

    void onClick() {
        UISWTStatusEntryListener listener0 = this.listener;
        if (listener0 != null) {
            this.listener.entryClicked(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.this_mon.enter();
            this.is_visible = false;
            this.listener = null;
            this.image = null;
            this.needs_disposing = true;
            this.is_destroyed = true;
            MenuItemManager.getInstance().removeAllMenuItems(this.menu_context.context);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void setImage(int image_id) {
        String img_name;
        switch (image_id) {
            case 3: {
                img_name = "greenled";
                break;
            }
            case 1: {
                img_name = "redled";
                break;
            }
            case 2: {
                img_name = "yellowled";
                break;
            }
            default: {
                img_name = "grayled";
            }
        }
        this.setImage(ImageRepository.getImage(img_name));
    }

    public void setImage(Image image) {
        this.checkDestroyed();
        this.this_mon.enter();
        this.image = image;
        this.needs_update = true;
        this.this_mon.exit();
    }

    public void setImageEnabled(boolean enabled) {
        this.checkDestroyed();
        this.this_mon.enter();
        this.image_enabled = enabled;
        this.needs_update = true;
        this.this_mon.exit();
    }

    public void setListener(UISWTStatusEntryListener listener) {
        this.checkDestroyed();
        this.listener = listener;
    }

    public void setText(String text) {
        this.checkDestroyed();
        this.this_mon.enter();
        this.text = text;
        this.needs_update = true;
        this.this_mon.exit();
    }

    public void setTooltipText(String text) {
        this.checkDestroyed();
        this.this_mon.enter();
        this.tooltip = text;
        this.needs_update = true;
        this.this_mon.exit();
    }

    public void setVisible(boolean visible) {
        this.checkDestroyed();
        this.this_mon.enter();
        this.is_visible = visible;
        this.needs_update = true;
        this.this_mon.exit();
    }
}

