/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.progress;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.AZProgressBar;
import org.gudy.azureus2.ui.swt.ITwistieListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.TwistieSection;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.progress.IMessage;
import org.gudy.azureus2.ui.swt.progress.IProgressReport;
import org.gudy.azureus2.ui.swt.progress.IProgressReportConstants;
import org.gudy.azureus2.ui.swt.progress.IProgressReporter;
import org.gudy.azureus2.ui.swt.progress.IProgressReporterListener;
import org.gudy.azureus2.ui.swt.progress.ProgressReportingManager;

public class ProgressReporterPanel
extends Composite
implements IProgressReportConstants,
IProgressReporterListener {
    private Color normalColor = null;
    private Color errorColor = null;
    public IProgressReporter pReporter = null;
    private Label imageLabel = null;
    private Label nameLabel = null;
    private Label statusLabel = null;
    private StyledText detailListWidget = null;
    private GridData detailSectionData = null;
    private AZProgressBar pBar = null;
    private Composite progressPanel = null;
    private TwistieSection detailSection = null;
    private int style;
    private Label actionLabel_cancel = null;
    private Label actionLabel_remove = null;
    private Label actionLabel_retry = null;
    private int maxPreferredDetailPanelHeight = 200;
    private int maxPreferredDetailPanelHeight_Standalone = 600;
    private int maxPreferredWidth = 900;
    private String lastStatusError = null;

    public ProgressReporterPanel(Composite parent, IProgressReporter reporter, int style) {
        super(parent, (style & 0x10) != 0 ? 2048 : 0);
        if (null == reporter) {
            throw new NullPointerException("IProgressReporter can not be null");
        }
        this.pReporter = reporter;
        this.style = style;
        this.normalColor = Colors.blue;
        this.errorColor = Colors.colorError;
        this.setLayoutData(new GridData(4, 128, true, false));
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.marginWidth = 25;
        gLayout.marginTop = 15;
        gLayout.marginBottom = 10;
        this.setLayout((Layout)gLayout);
        this.createControls(this.pReporter.getProgressReport());
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ProgressReporterPanel.this.resizeContent();
            }
        });
        this.pReporter.addListener(this);
    }

    public int report(IProgressReport pReport) {
        return this.handleEvents(pReport);
    }

    private void createControls(IProgressReport pReport) {
        this.imageLabel = new Label((Composite)this, 0);
        this.imageLabel.setLayoutData((Object)new GridData(1, 128, false, false, 1, 3));
        this.progressPanel = new Composite((Composite)this, 0);
        this.progressPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout rightLayout = new GridLayout(4, false);
        rightLayout.marginHeight = 0;
        rightLayout.marginWidth = 0;
        this.progressPanel.setLayout((Layout)rightLayout);
        this.nameLabel = new Label(this.progressPanel, 64);
        this.nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.pBar = new AZProgressBar(this.progressPanel, pReport.isIndeterminate());
        this.pBar.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.actionLabel_cancel = new Label(this.progressPanel, 0);
        this.actionLabel_cancel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.actionLabel_remove = new Label(this.progressPanel, 0);
        this.actionLabel_remove.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.actionLabel_retry = new Label(this.progressPanel, 0);
        this.actionLabel_retry.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.statusLabel = new Label(this.progressPanel, 0);
        this.statusLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        this.createDetailSection(pReport);
        this.initControls(pReport);
        this.actionLabel_cancel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ProgressReporterPanel.this.pReporter.cancel();
            }
        });
        this.actionLabel_retry.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ProgressReporterPanel.this.pReporter.retry();
            }
        });
        this.actionLabel_remove.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ProgressReportingManager.getInstance().remove(ProgressReporterPanel.this.pReporter);
                ProgressReporterPanel.this.dispose();
            }
        });
    }

    private void initControls(IProgressReport pReport) {
        if (null != pReport.getImage()) {
            this.imageLabel.setImage(pReport.getImage());
        } else {
            this.imageLabel.setImage(this.getDisplay().getSystemImage(2));
        }
        this.nameLabel.setText(this.formatForDisplay(pReport.getName()));
        this.actionLabel_cancel.setImage(ImageRepository.getImage("progress_cancel"));
        this.actionLabel_remove.setImage(ImageRepository.getImage("progress_remove"));
        this.actionLabel_retry.setImage(ImageRepository.getImage("progress_retry"));
        this.actionLabel_cancel.setToolTipText(MessageText.getString("Progress.reporting.action.label.cancel.tooltip"));
        this.actionLabel_remove.setToolTipText(MessageText.getString("Progress.reporting.action.label.remove.tooltip"));
        this.actionLabel_retry.setToolTipText(MessageText.getString("Progress.reporting.action.label.retry.tooltip"));
        if (pReport.isInErrorState()) {
            this.updateStatusLabel(MessageText.getString("Progress.reporting.default.error"), true);
        } else if (pReport.isDone()) {
            this.updateStatusLabel(MessageText.getString("Progress.reporting.status.finished"), false);
        } else if (pReport.isCanceled()) {
            this.updateStatusLabel(MessageText.getString("Progress.reporting.status.canceled"), false);
        } else if (pReport.isIndeterminate()) {
            this.updateStatusLabel("\u221e", false);
        } else {
            this.updateStatusLabel(pReport.getPercentage() + "%", false);
        }
        this.synchProgressBar(pReport);
        this.synchActionLabels(pReport);
    }

    private void createDetailSection(IProgressReport pReport) {
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(4, 128, true, false));
        this.detailSection = new TwistieSection(this, 2);
        this.detailSection.setTitle(MessageText.getString("Progress.reporting.action.label.detail"));
        Composite sectionContent = this.detailSection.getContent();
        this.detailSectionData = new GridData(4, 4, true, true);
        this.detailSection.setLayoutData(this.detailSectionData);
        GridLayout sectionLayout = new GridLayout();
        sectionLayout.marginHeight = 0;
        sectionLayout.marginWidth = 0;
        sectionContent.setLayout((Layout)sectionLayout);
        this.detailSection.setEnabled(false);
        this.detailListWidget = new StyledText(sectionContent, 2624);
        this.detailListWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        IMessage[] messages = this.pReporter.getMessageHistory();
        for (int i = 0; i < messages.length; ++i) {
            if (messages[i].getType() == 4) {
                this.appendToDetail(this.formatForDisplay(messages[i].getValue()), true);
                continue;
            }
            this.appendToDetail(this.formatForDisplay(messages[i].getValue()), false);
        }
        this.resizeDetailSection();
        this.detailSection.addTwistieListener(new ITwistieListener(){

            public void isCollapsed(boolean value) {
                ProgressReporterPanel.this.resizeDetailSection();
                ProgressReporterPanel.this.layout(true, true);
            }
        });
    }

    private void resizeDetailSection() {
        Point computedSize = this.detailSection.computeSize(-1, -1);
        this.detailSectionData.heightHint = computedSize.y;
        if ((8 & this.style) != 0) {
            if (computedSize.y > this.maxPreferredDetailPanelHeight_Standalone) {
                this.detailSectionData.heightHint = this.maxPreferredDetailPanelHeight_Standalone;
            }
        } else if (computedSize.y > this.maxPreferredDetailPanelHeight) {
            this.detailSectionData.heightHint = this.maxPreferredDetailPanelHeight;
        }
        if (computedSize.x > this.maxPreferredWidth) {
            this.detailSectionData.widthHint = this.maxPreferredWidth;
        }
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        Point newSize = super.computeSize(hint, hint2, changed);
        if (newSize.x > this.maxPreferredWidth) {
            newSize.x = this.maxPreferredWidth;
        }
        return newSize;
    }

    private int handleEvents(final IProgressReport pReport) {
        if (null == pReport || this.isDisposed() || null == this.getDisplay()) {
            return 0;
        }
        switch (pReport.getReportType()) {
            case 6: {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (null != ProgressReporterPanel.this.nameLabel && !ProgressReporterPanel.this.nameLabel.isDisposed()) {
                            ProgressReporterPanel.this.nameLabel.setText(pReport.getName());
                        }
                        if (pReport.isIndeterminate()) {
                            ProgressReporterPanel.this.updateStatusLabel("\u221e", false);
                        } else {
                            ProgressReporterPanel.this.updateStatusLabel(pReport.getPercentage() + "%", false);
                        }
                        ProgressReporterPanel.this.appendToDetail(pReport.getMessage(), false);
                        ProgressReporterPanel.this.appendToDetail(pReport.getDetailMessage(), false);
                        ProgressReporterPanel.this.synchProgressBar(pReport);
                        ProgressReporterPanel.this.synchActionLabels(pReport);
                        ProgressReporterPanel.this.resizeContent();
                    }
                });
                break;
            }
            case 1: {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ProgressReporterPanel.this.synchProgressBar(pReport);
                        ProgressReporterPanel.this.updateStatusLabel(MessageText.getString("Progress.reporting.status.canceled"), false);
                        ProgressReporterPanel.this.appendToDetail(pReport.getMessage(), false);
                        ProgressReporterPanel.this.synchActionLabels(pReport);
                        ProgressReporterPanel.this.resizeContent();
                    }
                });
                break;
            }
            case 2: {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if ((ProgressReporterPanel.this.style & 2) != 0) {
                            ProgressReporterPanel.this.dispose();
                        } else {
                            ProgressReporterPanel.this.synchProgressBar(pReport);
                            ProgressReporterPanel.this.updateStatusLabel(MessageText.getString("Progress.reporting.status.finished"), false);
                            ProgressReporterPanel.this.appendToDetail(MessageText.getString("Progress.reporting.status.finished"), false);
                            ProgressReporterPanel.this.synchActionLabels(pReport);
                            ProgressReporterPanel.this.resizeContent();
                        }
                    }
                });
                return 1;
            }
            case 3: {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (null != ProgressReporterPanel.this.pBar && !ProgressReporterPanel.this.pBar.isDisposed()) {
                            ProgressReporterPanel.this.pBar.setIndeterminate(pReport.isIndeterminate());
                        }
                    }
                });
                break;
            }
            case 4: {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ProgressReporterPanel.this.updateStatusLabel(MessageText.getString("Progress.reporting.default.error"), true);
                        ProgressReporterPanel.this.appendToDetail(pReport.getErrorMessage(), true);
                        ProgressReporterPanel.this.synchActionLabels(pReport);
                        ProgressReporterPanel.this.synchProgressBar(pReport);
                        ProgressReporterPanel.this.resizeContent();
                    }
                });
                break;
            }
            case 5: {
                this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ProgressReporterPanel.this.updateStatusLabel(pReport.getMessage(), false);
                        ProgressReporterPanel.this.appendToDetail(MessageText.getString("Progress.reporting.status.retrying"), false);
                        ProgressReporterPanel.this.synchActionLabels(pReport);
                        ProgressReporterPanel.this.synchProgressBar(pReport);
                        ProgressReporterPanel.this.resizeContent();
                    }
                });
                break;
            }
        }
        return 0;
    }

    private void synchProgressBar(IProgressReport pReport) {
        if (null == this.pBar || this.pBar.isDisposed() || null == pReport) {
            return;
        }
        if (pReport.isInErrorState()) {
            this.pBar.setIndeterminate(false);
            this.pBar.setSelection(pReport.getMinimum());
        } else {
            this.pBar.setIndeterminate(pReport.isIndeterminate());
            if (!pReport.isIndeterminate()) {
                this.pBar.setMinimum(pReport.getMinimum());
                this.pBar.setMaximum(pReport.getMaximum());
            }
            this.pBar.setSelection(pReport.getSelection());
        }
    }

    private void updateStatusLabel(String text, boolean showAsError) {
        if (null == this.statusLabel || this.statusLabel.isDisposed()) {
            return;
        }
        if (showAsError) {
            this.lastStatusError = text;
        }
        if (this.lastStatusError != null) {
            showAsError = true;
            text = this.lastStatusError;
        }
        this.statusLabel.setText(this.formatForDisplay(text));
        if (!showAsError) {
            this.statusLabel.setForeground(this.normalColor);
        } else {
            this.statusLabel.setForeground(this.errorColor);
        }
        this.statusLabel.update();
    }

    private void synchActionLabels(IProgressReport pReport) {
        if (null == this.actionLabel_remove || null == this.actionLabel_cancel || null == this.actionLabel_retry || this.actionLabel_remove.isDisposed() || this.actionLabel_cancel.isDisposed() || this.actionLabel_retry.isDisposed()) {
            return;
        }
        this.showActionLabel(this.actionLabel_cancel, false);
        this.showActionLabel(this.actionLabel_remove, false);
        this.showActionLabel(this.actionLabel_retry, false);
        if (pReport.isDone()) {
            this.showActionLabel(this.actionLabel_remove, true);
        } else if (pReport.isInErrorState()) {
            if (pReport.isRetryAllowed()) {
                this.showActionLabel(this.actionLabel_retry, true);
                this.showActionLabel(this.actionLabel_remove, true);
            } else {
                this.showActionLabel(this.actionLabel_remove, true);
            }
        } else if (pReport.isCanceled()) {
            if (pReport.isRetryAllowed()) {
                this.showActionLabel(this.actionLabel_retry, true);
                this.showActionLabel(this.actionLabel_remove, true);
            } else {
                this.showActionLabel(this.actionLabel_remove, true);
            }
        } else {
            this.showActionLabel(this.actionLabel_cancel, true);
            this.actionLabel_cancel.setEnabled(pReport.isCancelAllowed());
        }
    }

    private void showActionLabel(Label label, boolean showIt) {
        ((GridData)label.getLayoutData()).widthHint = true == showIt ? 16 : 0;
    }

    public void resizeContent() {
        if (!this.isDisposed()) {
            this.layout(true, true);
        }
    }

    private String formatForDisplay(String string) {
        string = null == string ? "" : string;
        return string.replaceAll("&", "&&");
    }

    public void addTwistieListener(ITwistieListener listener) {
        this.detailSection.addTwistieListener(listener);
    }

    public void removeTwistieListener(ITwistieListener listener) {
        this.detailSection.removeTwistieListener(listener);
    }

    private void appendToDetail(String value, boolean isError) {
        if (null == value || value.length() < 1) {
            return;
        }
        if (null == this.detailListWidget || this.detailListWidget.isDisposed()) {
            return;
        }
        int charCount = this.detailListWidget.getCharCount();
        this.detailListWidget.append(value + "\n");
        if (isError) {
            StyleRange style2 = new StyleRange();
            style2.start = charCount;
            style2.length = value.length();
            style2.foreground = this.errorColor;
            this.detailListWidget.setStyleRange(style2);
        }
        this.detailSection.setEnabled(true);
    }

    public IProgressReporter getProgressReporter() {
        return this.pReporter;
    }

    public int getStyle() {
        return this.style;
    }
}

