/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.updater2;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.update.UpdateChecker;

public class SWTVersionGetter {
    private static final LogIDs LOGID = LogIDs.GUI;
    private String platform = SWT.getPlatform();
    private int currentVersion = SWT.getVersion();
    private int latestVersion;
    private UpdateChecker checker;
    private String[] mirrors;
    private String infoURL;

    public SWTVersionGetter(UpdateChecker _checker) {
        PlatformManager p_man;
        if (this.currentVersion == 3232 && Constants.isOSX && (p_man = PlatformManagerFactory.getPlatformManager()) != null && !p_man.hasCapability(PlatformManagerCapabilities.GetVersion)) {
            this.currentVersion = 3231;
        }
        this.latestVersion = 0;
        this.checker = _checker;
    }

    public boolean needsUpdate() {
        try {
            this.downloadLatestVersion();
            String msg = "SWT: current version = " + this.currentVersion + ", latest version = " + this.latestVersion;
            this.checker.reportProgress(msg);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, msg));
            }
            return this.latestVersion > this.currentVersion;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void downloadLatestVersion() {
        byte[] info_bytes;
        byte[] url_bytes;
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Requesting latest SWT version and url from version check client."));
        }
        Map reply = VersionCheckClient.getSingleton().getVersionCheckInfo("sw");
        String msg = "SWT version check received:";
        byte[] version_bytes = (byte[])reply.get("swt_version");
        if (version_bytes != null) {
            this.latestVersion = Integer.parseInt(new String(version_bytes));
            msg = msg + " version=" + this.latestVersion;
        }
        if ((url_bytes = (byte[])reply.get("swt_url")) != null) {
            this.mirrors = new String[]{new String(url_bytes)};
            msg = msg + " url=" + this.mirrors[0];
        }
        if ((info_bytes = (byte[])reply.get("swt_info_url")) != null) {
            byte[] sig = (byte[])reply.get("swt_info_sig");
            if (sig == null) {
                Logger.log(new LogEvent(LogIDs.LOGGER, "swt info signature check failed - missing signature"));
            } else {
                try {
                    this.infoURL = new String(info_bytes);
                    try {
                        AEVerifier.verifyData(this.infoURL, sig);
                    }
                    catch (Throwable e) {
                        Logger.log(new LogEvent(LogIDs.LOGGER, "swt info signature check failed", e));
                        this.infoURL = null;
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "swt info_url", e));
                }
            }
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, msg));
        }
    }

    public int getLatestVersion() {
        return this.latestVersion;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String[] getMirrors() {
        return this.mirrors;
    }

    public String getInfoURL() {
        return this.infoURL;
    }
}

