/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPieceListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.piece.MyPieceDistributionView;
import org.gudy.azureus2.ui.swt.views.piece.PieceInfoView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.AvailabilityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.BlockCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.BlocksItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.CompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.PieceNumberItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.PriorityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.RequestedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.ReservedByItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.SpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.TypeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.pieces.WritersItem;

public class PiecesView
extends TableViewTab
implements DownloadManagerPeerListener,
DownloadManagerPieceListener,
TableDataSourceChangedListener,
TableLifeCycleListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new PieceNumberItem(), new SizeItem(), new BlockCountItem(), new BlocksItem(), new CompletedItem(), new AvailabilityItem(), new TypeItem(), new ReservedByItem(), new WritersItem(), new PriorityItem(), new SpeedItem(), new RequestedItem()};
    DownloadManager manager;
    private TableViewSWTImpl tv = new TableViewSWTImpl("Pieces", "PiecesView", basicItems, basicItems[0].getName(), 0x10010004);
    private Composite legendComposite;
    private PieceInfoView pieceInfoView;
    private MyPieceDistributionView pieceDistView;

    public PiecesView() {
        this.setTableView(this.tv);
        this.tv.setEnableTabViews(true);
        this.pieceInfoView = new PieceInfoView();
        this.pieceDistView = new MyPieceDistributionView();
        this.tv.setCoreTabViews(new IView[]{this.pieceInfoView, this.pieceDistView});
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addLifeCycleListener(this);
    }

    public void tableDataSourceChanged(Object newDataSource) {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
            this.manager.removePieceListener(this);
        }
        this.manager = newDataSource == null ? null : (newDataSource instanceof Object[] ? (DownloadManager)((Object[])newDataSource)[0] : (DownloadManager)newDataSource);
        if (this.manager != null) {
            this.manager.addPeerListener(this, false);
            this.manager.addPieceListener(this, false);
            this.addExistingDatasources();
        }
        if (this.pieceInfoView != null) {
            this.pieceInfoView.dataSourceChanged(this.manager);
        }
        if (this.pieceDistView != null) {
            this.pieceDistView.dataSourceChanged(this.manager);
        }
    }

    public void tableViewInitialized() {
        if (this.legendComposite != null && this.tv instanceof TableViewSWT) {
            Composite composite = this.tv.getTableComposite();
            this.legendComposite = Legend.createLegendComposite(composite, BlocksItem.colors, new String[]{"PiecesView.legend.requested", "PiecesView.legend.written", "PiecesView.legend.downloaded", "PiecesView.legend.incache"});
        }
        if (this.manager != null) {
            this.manager.removePeerListener(this);
            this.manager.removePieceListener(this);
            this.manager.addPeerListener(this, false);
            this.manager.addPieceListener(this, false);
            this.addExistingDatasources();
        }
    }

    public void tableViewDestroyed() {
        if (this.legendComposite != null && this.legendComposite.isDisposed()) {
            this.legendComposite.dispose();
        }
        if (this.manager != null) {
            this.manager.removePeerListener(this);
            this.manager.removePieceListener(this);
        }
    }

    public void pieceAdded(PEPiece created) {
        this.tv.addDataSource(created);
    }

    public void pieceRemoved(PEPiece removed) {
        this.tv.removeDataSource(removed);
    }

    public void peerAdded(PEPeer peer) {
    }

    public void peerRemoved(PEPeer peer) {
    }

    public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
    }

    public void peerManagerAdded(PEPeerManager manager) {
    }

    public void peerManagerRemoved(PEPeerManager manager) {
        this.tv.removeAllTableRows();
    }

    private void addExistingDatasources() {
        if (this.manager == null || this.tv.isDisposed()) {
            return;
        }
        Object[] dataSources = this.manager.getCurrentPieces();
        if (dataSources == null || dataSources.length == 0) {
            return;
        }
        this.tv.addDataSources(dataSources);
        this.tv.processDataSourceQueue();
    }

    public DownloadManager getManager() {
        return this.manager;
    }
}

