/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.BooleanParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterRepository;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.DualChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.plugins.PluginParameter;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.views.ConfigView;

public class ConfigSectionPlugins
implements UISWTConfigSection,
ParameterListener {
    private static final String HEADER_PREFIX = "ConfigView.pluginlist.column.";
    private static final String[] COLUMN_HEADERS = new String[]{"loadAtStartup", "type", "name", "version", "directory", "unloadable"};
    private static final int[] COLUMN_SIZES = new int[]{110, 50, 150, 75, 100, 50};
    private static final int[] COLUMN_ALIGNS = new int[]{0x1000000, 16384, 16384, 131072, 16384, 0x1000000};
    private ConfigView configView;
    private AzureusCore azureusCore;
    FilterComparator comparator;
    List pluginIFs;
    private Table table;

    public ConfigSectionPlugins(ConfigView _configView, AzureusCore _azureusCore) {
        this.configView = _configView;
        this.azureusCore = _azureusCore;
        this.comparator = new FilterComparator();
    }

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "plugins";
    }

    public void configSectionSave() {
    }

    public int maxUserMode() {
        return 0;
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        String sAppPluginDir;
        String sUserPluginDir;
        Composite infoGroup = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        infoGroup.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        infoGroup.setLayout((Layout)layout);
        infoGroup.setLayout((Layout)new GridLayout());
        if (SWT.getVersion() < 3105) {
            infoGroup.addControlListener((ControlListener)new Utils.LabelWrapControlListener());
        }
        String sep = System.getProperty("file.separator");
        File fUserPluginDir = FileUtil.getUserFile("plugins");
        try {
            sUserPluginDir = fUserPluginDir.getCanonicalPath();
        }
        catch (Throwable e) {
            sUserPluginDir = fUserPluginDir.toString();
        }
        if (!sUserPluginDir.endsWith(sep)) {
            sUserPluginDir = sUserPluginDir + sep;
        }
        File fAppPluginDir = FileUtil.getApplicationFile("plugins");
        try {
            sAppPluginDir = fAppPluginDir.getCanonicalPath();
        }
        catch (Throwable e) {
            sAppPluginDir = fAppPluginDir.toString();
        }
        if (!sAppPluginDir.endsWith(sep)) {
            sAppPluginDir = sAppPluginDir + sep;
        }
        Label label = new Label(infoGroup, 64);
        label.setLayoutData((Object)new GridData(768));
        Messages.setLanguageText((Widget)label, "ConfigView.pluginlist.whereToPut");
        label = new Label(infoGroup, 64);
        gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        label.setLayoutData((Object)gridData);
        label.setText(sUserPluginDir.replaceAll("&", "&&"));
        label.setForeground(Colors.blue);
        label.setCursor(Cursors.handCursor);
        final String _sUserPluginDir = sUserPluginDir;
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                if (_sUserPluginDir.endsWith("/plugins/") || _sUserPluginDir.endsWith("\\plugins\\")) {
                    File f = new File(_sUserPluginDir);
                    if (f.exists() && f.isDirectory()) {
                        Utils.launch(_sUserPluginDir);
                    } else {
                        String azureusDir = _sUserPluginDir.substring(0, _sUserPluginDir.length() - 9);
                        System.out.println(azureusDir);
                        Utils.launch(azureusDir);
                    }
                }
            }
        });
        label = new Label(infoGroup, 64);
        label.setLayoutData((Object)new GridData(768));
        Messages.setLanguageText((Widget)label, "ConfigView.pluginlist.whereToPutOr");
        label = new Label(infoGroup, 64);
        gridData = new GridData(768);
        gridData.horizontalIndent = 10;
        label.setLayoutData((Object)gridData);
        label.setText(sAppPluginDir.replaceAll("&", "&&"));
        label.setForeground(Colors.blue);
        label.setCursor(Cursors.handCursor);
        final String _sAppPluginDir = sAppPluginDir;
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                if (_sAppPluginDir.endsWith("/plugins/") || _sAppPluginDir.endsWith("\\plugins\\")) {
                    File f = new File(_sAppPluginDir);
                    if (f.exists() && f.isDirectory()) {
                        Utils.launch(_sAppPluginDir);
                    } else {
                        String azureusDir = _sAppPluginDir.substring(0, _sAppPluginDir.length() - 9);
                        System.out.println(azureusDir);
                        Utils.launch(azureusDir);
                    }
                }
            }
        });
        this.pluginIFs = this.rebuildPluginIFs();
        Collections.sort(this.pluginIFs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((PluginInterface)o1).getPluginName().compareToIgnoreCase(((PluginInterface)o2).getPluginName());
            }
        });
        Label labelInfo = new Label(infoGroup, 64);
        labelInfo.setLayoutData((Object)new GridData(768));
        Messages.setLanguageText((Widget)labelInfo, "ConfigView.pluginlist.info");
        this.table = new Table(infoGroup, 268503076);
        gridData = new GridData(1808);
        gridData.heightHint = 200;
        gridData.widthHint = 200;
        this.table.setLayoutData((Object)gridData);
        for (int i = 0; i < COLUMN_HEADERS.length; ++i) {
            final TableColumn tc = new TableColumn(this.table, COLUMN_ALIGNS[i]);
            tc.setWidth(COLUMN_SIZES[i]);
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean ascending = ConfigSectionPlugins.this.comparator.setField(ConfigSectionPlugins.this.table.indexOf(tc));
                    try {
                        ConfigSectionPlugins.this.table.setSortColumn(tc);
                        ConfigSectionPlugins.this.table.setSortDirection(ascending ? 128 : 1024);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    Collections.sort(ConfigSectionPlugins.this.pluginIFs, ConfigSectionPlugins.this.comparator);
                    ConfigSectionPlugins.this.table.clearAll();
                }
            });
            Messages.setLanguageText((Widget)tc, HEADER_PREFIX + COLUMN_HEADERS[i]);
        }
        this.table.setHeaderVisible(true);
        Composite cButtons = new Composite(infoGroup, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        cButtons.setLayout((Layout)layout);
        cButtons.setLayoutData((Object)new GridData());
        final Button btnUnload = new Button(cButtons, 8);
        btnUnload.setLayoutData((Object)new GridData());
        Messages.setLanguageText((Widget)btnUnload, "ConfigView.pluginlist.unloadSelected");
        btnUnload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] items = ConfigSectionPlugins.this.table.getSelectionIndices();
                for (int i = 0; i < items.length; ++i) {
                    int index = items[i];
                    if (index < 0 || index >= ConfigSectionPlugins.this.pluginIFs.size()) continue;
                    PluginInterface pluginIF = (PluginInterface)ConfigSectionPlugins.this.pluginIFs.get(index);
                    if (pluginIF.getPluginState().isOperational() && pluginIF.getPluginState().isUnloadable()) {
                        try {
                            pluginIF.getPluginState().unload();
                        }
                        catch (PluginException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ConfigSectionPlugins.this.pluginIFs = ConfigSectionPlugins.this.rebuildPluginIFs();
                    ConfigSectionPlugins.this.table.setItemCount(ConfigSectionPlugins.this.pluginIFs.size());
                    Collections.sort(ConfigSectionPlugins.this.pluginIFs, ConfigSectionPlugins.this.comparator);
                    ConfigSectionPlugins.this.table.clearAll();
                }
            }
        });
        btnUnload.setEnabled(false);
        final Button btnLoad = new Button(cButtons, 8);
        btnUnload.setLayoutData((Object)new GridData());
        Messages.setLanguageText((Widget)btnLoad, "ConfigView.pluginlist.loadSelected");
        btnLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] items = ConfigSectionPlugins.this.table.getSelectionIndices();
                for (int i = 0; i < items.length; ++i) {
                    PluginInterface pluginIF;
                    int index = items[i];
                    if (index < 0 || index >= ConfigSectionPlugins.this.pluginIFs.size() || (pluginIF = (PluginInterface)ConfigSectionPlugins.this.pluginIFs.get(index)).getPluginState().isOperational()) continue;
                    if (pluginIF.getPluginState().isDisabled()) {
                        if (pluginIF.getPluginState().hasFailed()) continue;
                        pluginIF.getPluginState().setDisabled(false);
                    }
                    try {
                        pluginIF.getPluginState().reload();
                    }
                    catch (PluginException e1) {
                        Debug.printStackTrace(e1);
                    }
                    ConfigSectionPlugins.this.pluginIFs = ConfigSectionPlugins.this.rebuildPluginIFs();
                    ConfigSectionPlugins.this.table.setItemCount(ConfigSectionPlugins.this.pluginIFs.size());
                    Collections.sort(ConfigSectionPlugins.this.pluginIFs, ConfigSectionPlugins.this.comparator);
                    ConfigSectionPlugins.this.table.clearAll();
                }
            }
        });
        btnLoad.setEnabled(false);
        Button btnScan = new Button(cButtons, 8);
        btnScan.setLayoutData((Object)new GridData());
        Messages.setLanguageText((Widget)btnScan, "ConfigView.pluginlist.scan");
        btnScan.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigSectionPlugins.this.azureusCore.getPluginManager().refreshPluginList(false);
                ConfigSectionPlugins.this.pluginIFs = ConfigSectionPlugins.this.rebuildPluginIFs();
                ConfigSectionPlugins.this.table.setItemCount(ConfigSectionPlugins.this.pluginIFs.size());
                Collections.sort(ConfigSectionPlugins.this.pluginIFs, ConfigSectionPlugins.this.comparator);
                ConfigSectionPlugins.this.table.clearAll();
            }
        });
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                TableItem item = (TableItem)event2.item;
                int index = ConfigSectionPlugins.this.table.indexOf(item);
                PluginInterface pluginIF = (PluginInterface)ConfigSectionPlugins.this.pluginIFs.get(index);
                for (int i = 0; i < COLUMN_HEADERS.length; ++i) {
                    String sText;
                    if (i == 2) {
                        item.setImage(i, ImageRepository.getImage(pluginIF.getPluginState().isOperational() ? "greenled" : "redled"));
                    }
                    if ((sText = ConfigSectionPlugins.this.comparator.getFieldValue(i, pluginIF)) == null) {
                        sText = "";
                    }
                    item.setText(i, sText);
                }
                item.setGrayed(pluginIF.getPluginState().isMandatory());
                boolean bEnabled = pluginIF.getPluginState().isLoadedAtStartup();
                Utils.setCheckedInSetData(item, bEnabled);
                item.setData("PluginID", (Object)pluginIF.getPluginID());
                Utils.alternateRowBackground(item);
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                int index = ConfigSectionPlugins.this.table.indexOf(item);
                PluginInterface pluginIF = (PluginInterface)ConfigSectionPlugins.this.pluginIFs.get(index);
                if (e.detail == 32) {
                    if (item.getGrayed()) {
                        if (!item.getChecked()) {
                            item.setChecked(true);
                        }
                        return;
                    }
                    pluginIF.getPluginState().setDisabled(!item.getChecked());
                    pluginIF.getPluginState().setLoadedAtStartup(item.getChecked());
                }
                btnUnload.setEnabled(pluginIF.getPluginState().isOperational() && pluginIF.getPluginState().isUnloadable());
                btnLoad.setEnabled(!pluginIF.getPluginState().isOperational() && !pluginIF.getPluginState().hasFailed());
            }
        });
        this.table.setItemCount(this.pluginIFs.size());
        return infoGroup;
    }

    private List rebuildPluginIFs() {
        List<PluginInterface> pluginIFs = Arrays.asList(this.azureusCore.getPluginManager().getPlugins());
        for (PluginInterface pi : pluginIFs) {
            COConfigurationManager.addParameterListener("PluginInfo." + pi.getPluginID() + ".enabled", (ParameterListener)this);
        }
        return pluginIFs;
    }

    public void parameterChanged(String parameterName) {
        if (this.table != null) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (ConfigSectionPlugins.this.table != null && !ConfigSectionPlugins.this.table.isDisposed()) {
                        ConfigSectionPlugins.this.table.clearAll();
                    }
                }
            });
        }
    }

    public void initPluginSubSections() {
        TreeItem treePlugins = this.configView.findTreeItem("plugins");
        ParameterRepository repository = ParameterRepository.getInstance();
        Object[] names = repository.getNames();
        Arrays.sort(names);
        for (int i = 0; i < names.length; ++i) {
            Parameter parameter;
            int j;
            Object pluginName = names[i];
            Parameter[] parameters = repository.getParameterBlock((String)pluginName);
            boolean bUsePrefix = MessageText.keyExists("ConfigView.section.plugins." + (String)pluginName);
            Composite pluginGroup = this.configView.createConfigSection(treePlugins, (String)pluginName, -2, bUsePrefix);
            GridLayout pluginLayout = new GridLayout();
            pluginLayout.numColumns = 3;
            pluginGroup.setLayout((Layout)pluginLayout);
            HashMap<Parameter, PluginParameter> parameterToPluginParameter = new HashMap<Parameter, PluginParameter>();
            for (j = 0; j < parameters.length; ++j) {
                parameter = parameters[j];
                parameterToPluginParameter.put(parameter, new PluginParameter(pluginGroup, parameter));
            }
            for (j = 0; j < parameters.length; ++j) {
                Control[] cd;
                parameter = parameters[j];
                if (!(parameter instanceof BooleanParameterImpl)) continue;
                List parametersToEnable = ((BooleanParameterImpl)parameter).getEnabledOnSelectionParameters();
                ArrayList<Control> controlsToEnable = new ArrayList<Control>();
                for (Parameter parameterToEnable : parametersToEnable) {
                    PluginParameter pp = (PluginParameter)parameterToPluginParameter.get(parameterToEnable);
                    Control[] controls = pp.getControls();
                    for (int k = 0; k < controls.length; ++k) {
                        controlsToEnable.add(controls[k]);
                    }
                }
                List parametersToDisable = ((BooleanParameterImpl)parameter).getDisabledOnSelectionParameters();
                ArrayList<Control> controlsToDisable = new ArrayList<Control>();
                for (Parameter parameterToDisable : parametersToDisable) {
                    PluginParameter pp = (PluginParameter)parameterToPluginParameter.get(parameterToDisable);
                    Control[] controls = pp.getControls();
                    for (int k = 0; k < controls.length; ++k) {
                        controlsToDisable.add(controls[k]);
                    }
                }
                Control[] ce = new Control[controlsToEnable.size()];
                if (ce.length + (cd = new Control[controlsToDisable.size()]).length <= 0) continue;
                DualChangeSelectionActionPerformer ap = new DualChangeSelectionActionPerformer(controlsToEnable.toArray(ce), controlsToDisable.toArray(cd));
                PluginParameter pp = (PluginParameter)parameterToPluginParameter.get(parameter);
                pp.setAdditionalActionPerfomer(ap);
            }
        }
    }

    class FilterComparator
    implements Comparator {
        boolean ascending = true;
        static final int FIELD_LOAD = 0;
        static final int FIELD_TYPE = 1;
        static final int FIELD_NAME = 2;
        static final int FIELD_VERSION = 3;
        static final int FIELD_DIRECTORY = 4;
        static final int FIELD_UNLOADABLE = 5;
        int field = 2;
        String sUserPluginDir;
        String sAppPluginDir;

        public FilterComparator() {
            String sep = System.getProperty("file.separator");
            this.sUserPluginDir = FileUtil.getUserFile("plugins").toString();
            if (!this.sUserPluginDir.endsWith(sep)) {
                this.sUserPluginDir = this.sUserPluginDir + sep;
            }
            this.sAppPluginDir = FileUtil.getApplicationFile("plugins").toString();
            if (!this.sAppPluginDir.endsWith(sep)) {
                this.sAppPluginDir = this.sAppPluginDir + sep;
            }
        }

        public int compare(Object arg0, Object arg1) {
            PluginInterface if0 = (PluginInterface)arg0;
            PluginInterfaceImpl if1 = (PluginInterfaceImpl)arg1;
            int result = 0;
            switch (this.field) {
                case 0: {
                    boolean b0 = if0.getPluginState().isLoadedAtStartup();
                    boolean b1 = if1.getPluginState().isLoadedAtStartup();
                    int n = b0 == b1 ? 0 : (result = b0 ? -1 : 1);
                    if (result != 0) break;
                    result = if0.getPluginID().compareToIgnoreCase(if1.getPluginID());
                    break;
                }
                case 1: 
                case 4: {
                    result = this.getFieldValue(this.field, if0).compareToIgnoreCase(this.getFieldValue(this.field, if1));
                    break;
                }
                case 3: {
                    String s0 = if0.getPluginVersion();
                    String s1 = if1.getPluginVersion();
                    if (s0 == null) {
                        s0 = "";
                    }
                    if (s1 == null) {
                        s1 = "";
                    }
                    result = s0.compareToIgnoreCase(s1);
                    break;
                }
                case 5: {
                    boolean b0 = if0.getPluginState().isUnloadable();
                    boolean b1 = if1.getPluginState().isUnloadable();
                    result = b0 == b1 ? 0 : (b0 ? -1 : 1);
                    break;
                }
            }
            if (result == 0) {
                result = if0.getPluginName().compareToIgnoreCase(if1.getPluginName());
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }

        public boolean setField(int newField) {
            this.ascending = this.field == newField ? !this.ascending : true;
            this.field = newField;
            return this.ascending;
        }

        public String getFieldValue(int iField, PluginInterface pluginIF) {
            switch (iField) {
                case 0: {
                    return pluginIF.getPluginID();
                }
                case 4: {
                    String sDirName = pluginIF.getPluginDirectoryName();
                    if (sDirName.length() > this.sUserPluginDir.length() && sDirName.substring(0, this.sUserPluginDir.length()).equals(this.sUserPluginDir)) {
                        return sDirName.substring(this.sUserPluginDir.length());
                    }
                    if (sDirName.length() > this.sAppPluginDir.length() && sDirName.substring(0, this.sAppPluginDir.length()).equals(this.sAppPluginDir)) {
                        return sDirName.substring(this.sAppPluginDir.length());
                    }
                    return sDirName;
                }
                case 2: {
                    return pluginIF.getPluginName();
                }
                case 1: {
                    String sDirName = pluginIF.getPluginDirectoryName();
                    String sKey = sDirName.length() > this.sUserPluginDir.length() && sDirName.substring(0, this.sUserPluginDir.length()).equals(this.sUserPluginDir) ? "perUser" : (sDirName.length() > this.sAppPluginDir.length() && sDirName.substring(0, this.sAppPluginDir.length()).equals(this.sAppPluginDir) ? "shared" : "builtIn");
                    return MessageText.getString("ConfigView.pluginlist.column.type." + sKey);
                }
                case 3: {
                    return pluginIF.getPluginVersion();
                }
                case 5: {
                    return MessageText.getString("Button." + (pluginIF.getPluginState().isUnloadable() ? "yes" : "no")).replaceAll("&", "");
                }
            }
            return "";
        }
    }
}

