/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionStats
implements UISWTConfigSection {
    private static final int defaultStatsPeriod = 30;
    private static final int[] statsPeriods = new int[]{1, 2, 3, 4, 5, 10, 15, 20, 25, 30, 40, 50, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600, 900, 1200, 1800, 2400, 3000, 3600, 7200, 10800, 14400, 21600, 43200, 86400};

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "stats";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 0;
    }

    public Composite configSectionCreate(final Composite parent) {
        Image imgOpenFolder = ImageRepository.getImage("openFolderButton");
        Composite gStats = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        gStats.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        gStats.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        BooleanParameter enableStats = new BooleanParameter(gStats, "Stats Enable", "ConfigView.section.stats.enable");
        enableStats.setLayoutData(gridData);
        Control[] controls = new Control[14];
        Label lStatsPath = new Label(gStats, 0);
        Messages.setLanguageText((Widget)lStatsPath, "ConfigView.section.stats.defaultsavepath");
        gridData = new GridData();
        gridData.widthHint = 150;
        final StringParameter pathParameter = new StringParameter(gStats, "Stats Dir", "");
        pathParameter.setLayoutData(gridData);
        controls[0] = lStatsPath;
        controls[1] = pathParameter.getControl();
        Button browse = new Button(gStats, 8);
        browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse.getBackground());
        browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        controls[2] = browse;
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(pathParameter.getValue());
                dialog.setText(MessageText.getString("ConfigView.section.stats.choosedefaultsavepath"));
                String path = dialog.open();
                if (path != null) {
                    pathParameter.setValue(path);
                }
            }
        });
        Label lSaveFile = new Label(gStats, 0);
        Messages.setLanguageText((Widget)lSaveFile, "ConfigView.section.stats.savefile");
        controls[3] = lSaveFile;
        gridData = new GridData();
        gridData.widthHint = 150;
        StringParameter fileParameter = new StringParameter(gStats, "Stats File", "Azureus_Stats.xml");
        fileParameter.setLayoutData(gridData);
        controls[4] = fileParameter.getControl();
        new Label(gStats, 0);
        Label lxslFile = new Label(gStats, 0);
        Messages.setLanguageText((Widget)lxslFile, "ConfigView.section.stats.xslfile");
        controls[5] = lxslFile;
        gridData = new GridData();
        gridData.widthHint = 150;
        StringParameter xslParameter = new StringParameter(gStats, "Stats XSL File", "");
        xslParameter.setLayoutData(gridData);
        controls[6] = xslParameter.getControl();
        Label lxslDetails = new Label(gStats, 0);
        Messages.setLanguageText((Widget)lxslDetails, "ConfigView.section.stats.xslfiledetails");
        String linkFAQ = "http://azureus.sourceforge.net/faq.php#20";
        lxslDetails.setCursor(Cursors.handCursor);
        lxslDetails.setForeground(Colors.blue);
        lxslDetails.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch("http://azureus.sourceforge.net/faq.php#20");
            }

            public void mouseDown(MouseEvent arg0) {
                Utils.launch("http://azureus.sourceforge.net/faq.php#20");
            }
        });
        controls[7] = lxslDetails;
        Label lSaveFreq = new Label(gStats, 0);
        Messages.setLanguageText((Widget)lSaveFreq, "ConfigView.section.stats.savefreq");
        controls[8] = lSaveFreq;
        String[] spLabels = new String[statsPeriods.length];
        int[] spValues = new int[statsPeriods.length];
        for (int i = 0; i < statsPeriods.length; ++i) {
            int num = statsPeriods[i];
            spLabels[i] = num % 3600 == 0 ? " " + statsPeriods[i] / 3600 + " " + MessageText.getString("ConfigView.section.stats.hours") : (num % 60 == 0 ? " " + statsPeriods[i] / 60 + " " + MessageText.getString("ConfigView.section.stats.minutes") : " " + statsPeriods[i] + " " + MessageText.getString("ConfigView.section.stats.seconds"));
            spValues[i] = statsPeriods[i];
        }
        controls[9] = lSaveFreq;
        controls[10] = new IntListParameter(gStats, "Stats Period", 30, spLabels, spValues).getControl();
        new Label(gStats, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        BooleanParameter exportPeers = new BooleanParameter(gStats, "Stats Export Peer Details", "ConfigView.section.stats.exportpeers");
        exportPeers.setLayoutData(gridData);
        controls[11] = exportPeers.getControl();
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        BooleanParameter exportFiles = new BooleanParameter(gStats, "Stats Export File Details", "ConfigView.section.stats.exportfiles");
        exportFiles.setLayoutData(gridData);
        controls[12] = exportFiles.getControl();
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        BooleanParameter graph_dividers = new BooleanParameter(gStats, "Stats Graph Dividers", "ConfigView.section.stats.graph_update_dividers");
        graph_dividers.setLayoutData(gridData);
        controls[13] = graph_dividers.getControl();
        enableStats.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(controls));
        return gStats;
    }
}

