/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingZone;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.components.graphics.PingGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.Plot3D;
import org.gudy.azureus2.ui.swt.components.graphics.ValueFormater;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class TransferStatsView
extends AbstractIView {
    GlobalManager manager;
    AzureusCore core;
    GlobalManagerStats stats;
    SpeedManager speedManager;
    OverallStats totalStats;
    Composite mainPanel;
    Composite blahPanel;
    BufferedLabel asn;
    BufferedLabel estUpCap;
    BufferedLabel estDownCap;
    Composite generalPanel;
    BufferedLabel nowUp;
    BufferedLabel nowDown;
    BufferedLabel sessionDown;
    BufferedLabel sessionUp;
    BufferedLabel session_ratio;
    BufferedLabel sessionTime;
    BufferedLabel totalDown;
    BufferedLabel totalUp;
    BufferedLabel total_ratio;
    BufferedLabel totalTime;
    Group autoSpeedPanel;
    StackLayout autoSpeedPanelLayout;
    Composite autoSpeedInfoPanel;
    Composite autoSpeedDisabledPanel;
    PingGraphic pingGraph;
    plotView[] plot_views;
    zoneView[] zone_views;
    limitToTextHelper limit_to_text = new limitToTextHelper();
    private final DecimalFormat formatter = new DecimalFormat("##.#");

    public TransferStatsView(GlobalManager manager, AzureusCore core) {
        this.core = core;
        this.manager = manager;
        this.stats = manager.getStats();
        this.totalStats = StatsFactory.getStats();
        this.speedManager = core.getSpeedManager();
    }

    public void initialize(Composite composite) {
        this.mainPanel = new Composite(composite, 0);
        GridLayout mainLayout = new GridLayout();
        this.mainPanel.setLayout((Layout)mainLayout);
        this.createGeneralPanel();
        this.createBlahPanel();
        this.createAutoSpeedPanel();
    }

    private void createGeneralPanel() {
        this.generalPanel = new Composite(this.mainPanel, 2048);
        GridData generalPanelData = new GridData(768);
        this.generalPanel.setLayoutData((Object)generalPanelData);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 5;
        panelLayout.makeColumnsEqualWidth = true;
        this.generalPanel.setLayout((Layout)panelLayout);
        Label lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.downloaded");
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uploaded");
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.ratio");
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uptime");
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.now");
        this.nowDown = new BufferedLabel(this.generalPanel, 0);
        GridData gridData = new GridData(768);
        this.nowDown.setLayoutData(gridData);
        this.nowUp = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.nowUp.setLayoutData(gridData);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.session");
        this.sessionDown = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.sessionDown.setLayoutData(gridData);
        this.sessionUp = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.sessionUp.setLayoutData(gridData);
        this.session_ratio = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.session_ratio.setLayoutData(gridData);
        this.sessionTime = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.sessionTime.setLayoutData(gridData);
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.total");
        this.totalDown = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.totalDown.setLayoutData(gridData);
        this.totalUp = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.totalUp.setLayoutData(gridData);
        this.total_ratio = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.total_ratio.setLayoutData(gridData);
        this.totalTime = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.totalTime.setLayoutData(gridData);
    }

    private void createBlahPanel() {
        this.blahPanel = new Composite(this.mainPanel, 0);
        GridData blahPanelData = new GridData(768);
        this.blahPanel.setLayoutData((Object)blahPanelData);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 8;
        this.blahPanel.setLayout((Layout)panelLayout);
        Label label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.asn");
        this.asn = new BufferedLabel(this.blahPanel, 0);
        GridData gridData = new GridData(768);
        this.asn.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.estupcap");
        this.estUpCap = new BufferedLabel(this.blahPanel, 0);
        gridData = new GridData(768);
        this.estUpCap.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.estdowncap");
        this.estDownCap = new BufferedLabel(this.blahPanel, 0);
        gridData = new GridData(768);
        this.estDownCap.setLayoutData(gridData);
        label = new Label(this.blahPanel, 0);
        label = new Label(this.blahPanel, 0);
    }

    private void createAutoSpeedPanel() {
        this.autoSpeedPanel = new Group(this.mainPanel, 0);
        GridData generalPanelData = new GridData(1808);
        this.autoSpeedPanel.setLayoutData((Object)generalPanelData);
        Messages.setLanguageText((Widget)this.autoSpeedPanel, "SpeedView.stats.autospeed");
        this.autoSpeedPanelLayout = new StackLayout();
        this.autoSpeedPanel.setLayout((Layout)this.autoSpeedPanelLayout);
        this.autoSpeedInfoPanel = new Composite((Composite)this.autoSpeedPanel, 0);
        this.autoSpeedInfoPanel.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 8;
        layout.makeColumnsEqualWidth = true;
        this.autoSpeedInfoPanel.setLayout((Layout)layout);
        Canvas pingCanvas = new Canvas(this.autoSpeedInfoPanel, 262144);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        pingCanvas.setLayoutData((Object)gridData);
        this.pingGraph = PingGraphic.getInstance();
        this.pingGraph.initialize(pingCanvas);
        TabFolder folder = new TabFolder(this.autoSpeedInfoPanel, 16384);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        folder.setLayoutData((Object)gridData);
        folder.setBackground(Colors.background);
        ValueFormater speed_formatter = new ValueFormater(){

            public String format(int value) {
                return DisplayFormatters.formatByteCountToKiBEtc(value);
            }
        };
        ValueFormater time_formatter = new ValueFormater(){

            public String format(int value) {
                return value + " ms";
            }
        };
        ValueFormater[] formatters = new ValueFormater[]{speed_formatter, speed_formatter, time_formatter};
        String[] labels = new String[]{"up", "down", "ping"};
        SpeedManagerPingMapper[] mappers = this.speedManager.getMappers();
        this.plot_views = new plotView[mappers.length];
        this.zone_views = new zoneView[mappers.length];
        for (int i = 0; i < mappers.length; ++i) {
            SpeedManagerPingMapper mapper = mappers[i];
            TabItem plot_item = new TabItem(folder, 0);
            plot_item.setText("Plot " + mapper.getName());
            Canvas plotCanvas = new Canvas((Composite)folder, 262144);
            gridData = new GridData(1808);
            plotCanvas.setLayoutData((Object)gridData);
            this.plot_views[i] = new plotView(mapper, plotCanvas, labels, formatters);
            plot_item.setControl((Control)plotCanvas);
            TabItem zones_item = new TabItem(folder, 0);
            zones_item.setText("Zones " + mapper.getName());
            Canvas zoneCanvas = new Canvas((Composite)folder, 262144);
            gridData = new GridData(1808);
            zoneCanvas.setLayoutData((Object)gridData);
            this.zone_views[i] = new zoneView(mapper, zoneCanvas, labels, formatters);
            zones_item.setControl((Control)zoneCanvas);
        }
        this.autoSpeedDisabledPanel = new Composite((Composite)this.autoSpeedPanel, 0);
        this.autoSpeedDisabledPanel.setLayout((Layout)new GridLayout());
        Label disabled = new Label(this.autoSpeedDisabledPanel, 0);
        disabled.setEnabled(false);
        Messages.setLanguageText((Widget)disabled, "SpeedView.stats.autospeed.disabled");
        disabled.setLayoutData((Object)new GridData(832));
        SpeedManager speedManager = this.core.getSpeedManager();
        this.autoSpeedPanelLayout.topControl = speedManager.isAvailable() ? this.autoSpeedInfoPanel : this.autoSpeedDisabledPanel;
        gridData = new GridData(768);
        gridData.horizontalSpan = 8;
        Legend.createLegendComposite(this.autoSpeedInfoPanel, PingGraphic.colors, new String[]{"TransferStatsView.legend.pingaverage", "TransferStatsView.legend.ping1", "TransferStatsView.legend.ping2", "TransferStatsView.legend.ping3"}, gridData);
    }

    public void delete() {
        int i;
        Utils.disposeComposite(this.generalPanel);
        Utils.disposeComposite(this.blahPanel);
        this.pingGraph.dispose();
        for (i = 0; i < this.plot_views.length; ++i) {
            this.plot_views[i].dispose();
        }
        for (i = 0; i < this.zone_views.length; ++i) {
            this.zone_views[i].dispose();
        }
    }

    public String getFullTitle() {
        return MessageText.getString("SpeedView.title.full");
    }

    public Composite getComposite() {
        return this.mainPanel;
    }

    public void refresh() {
        this.refreshGeneral();
        this.refreshBlahPanel();
        this.refreshPingPanel();
    }

    private void refreshGeneral() {
        int now_prot_down_rate = this.stats.getProtocolReceiveRate();
        int now_prot_up_rate = this.stats.getProtocolSendRate();
        int now_total_down_rate = this.stats.getDataReceiveRate() + now_prot_down_rate;
        int now_total_up_rate = this.stats.getDataSendRate() + now_prot_up_rate;
        float now_perc_down = (float)(now_prot_down_rate * 100) / (float)(now_total_down_rate == 0 ? 1 : now_total_down_rate);
        float now_perc_up = (float)(now_prot_up_rate * 100) / (float)(now_total_up_rate == 0 ? 1 : now_total_up_rate);
        this.nowDown.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(now_total_down_rate) + "  (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(now_prot_down_rate) + ", " + this.formatter.format(now_perc_down) + "%)");
        this.nowUp.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(now_total_up_rate) + "  (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(now_prot_up_rate) + ", " + this.formatter.format(now_perc_up) + "%)");
        long session_prot_received = this.stats.getTotalProtocolBytesReceived();
        long session_prot_sent = this.stats.getTotalProtocolBytesSent();
        long session_total_received = this.stats.getTotalDataBytesReceived() + session_prot_received;
        long session_total_sent = this.stats.getTotalDataBytesSent() + session_prot_sent;
        float session_perc_received = (float)(session_prot_received * 100L) / (float)(session_total_received == 0L ? 1L : session_total_received);
        float session_perc_sent = (float)(session_prot_sent * 100L) / (float)(session_total_sent == 0L ? 1L : session_total_sent);
        this.sessionDown.setText(DisplayFormatters.formatByteCountToKiBEtc(session_total_received) + "  (" + DisplayFormatters.formatByteCountToKiBEtc(session_prot_received) + ", " + this.formatter.format(session_perc_received) + "%)");
        this.sessionUp.setText(DisplayFormatters.formatByteCountToKiBEtc(session_total_sent) + "  (" + DisplayFormatters.formatByteCountToKiBEtc(session_prot_sent) + ", " + this.formatter.format(session_perc_sent) + "%)");
        this.totalDown.setText(DisplayFormatters.formatByteCountToKiBEtc(this.totalStats.getDownloadedBytes()));
        this.totalUp.setText(DisplayFormatters.formatByteCountToKiBEtc(this.totalStats.getUploadedBytes()));
        this.sessionTime.setText(DisplayFormatters.formatETA(this.totalStats.getSessionUpTime()));
        this.totalTime.setText(DisplayFormatters.formatETA(this.totalStats.getTotalUpTime()));
        long dl_bytes = this.totalStats.getDownloadedBytes();
        long t_ratio_raw = 1000L * this.totalStats.getUploadedBytes() / (dl_bytes == 0L ? 1L : dl_bytes);
        long s_ratio_raw = 1000L * session_total_sent / (session_total_received == 0L ? 1L : session_total_received);
        String t_ratio = "";
        String s_ratio = "";
        String partial = String.valueOf(t_ratio_raw % 1000L);
        while (partial.length() < 3) {
            partial = "0" + partial;
        }
        t_ratio = t_ratio_raw / 1000L + "." + partial;
        partial = String.valueOf(s_ratio_raw % 1000L);
        while (partial.length() < 3) {
            partial = "0" + partial;
        }
        s_ratio = s_ratio_raw / 1000L + "." + partial;
        this.total_ratio.setText(t_ratio);
        this.session_ratio.setText(s_ratio);
    }

    private void refreshBlahPanel() {
        this.asn.setText(this.speedManager.getASN());
        this.estUpCap.setText(this.limit_to_text.getLimitText(this.speedManager.getEstimatedUploadCapacityBytesPerSec()));
        this.estDownCap.setText(this.limit_to_text.getLimitText(this.speedManager.getEstimatedDownloadCapacityBytesPerSec()));
    }

    private void refreshPingPanel() {
        SpeedManager speedManager = this.core.getSpeedManager();
        if (speedManager.isAvailable() && speedManager.isEnabled()) {
            int i;
            this.autoSpeedPanelLayout.topControl = this.autoSpeedInfoPanel;
            this.autoSpeedPanel.layout();
            this.pingGraph.refresh();
            for (i = 0; i < this.plot_views.length; ++i) {
                this.plot_views[i].refresh();
            }
            for (i = 0; i < this.zone_views.length; ++i) {
                this.zone_views[i].refresh();
            }
        } else {
            this.autoSpeedPanelLayout.topControl = this.autoSpeedDisabledPanel;
            this.autoSpeedPanel.layout();
        }
    }

    public void periodicUpdate() {
        SpeedManagerPingSource[] sources;
        if (this.speedManager.isAvailable() && this.speedManager.isEnabled() && (sources = this.speedManager.getPingSources()).length > 0) {
            int i;
            int[] pings = new int[sources.length];
            for (i = 0; i < sources.length; ++i) {
                pings[i] = sources[i].getPingTime();
            }
            this.pingGraph.addIntsValue(pings);
            for (i = 0; i < this.plot_views.length; ++i) {
                this.plot_views[i].update();
            }
            for (i = 0; i < this.zone_views.length; ++i) {
                this.zone_views[i].update();
            }
        }
    }

    public String getData() {
        return "TransferStatsView.title.full";
    }

    protected String getMapperTitle(SpeedManagerPingMapper mapper) {
        if (mapper.isActive()) {
            SpeedManagerLimitEstimate up_1 = mapper.getEstimatedUploadLimit(false);
            SpeedManagerLimitEstimate up_2 = mapper.getEstimatedUploadLimit(true);
            SpeedManagerLimitEstimate down_1 = mapper.getEstimatedDownloadLimit(false);
            SpeedManagerLimitEstimate down_2 = mapper.getEstimatedDownloadLimit(true);
            return "ul=" + DisplayFormatters.formatByteCountToKiBEtc(up_1.getBytesPerSec()) + ":" + DisplayFormatters.formatByteCountToKiBEtc(up_2.getBytesPerSec()) + ",dl=" + DisplayFormatters.formatByteCountToKiBEtc(down_1.getBytesPerSec()) + ":" + DisplayFormatters.formatByteCountToKiBEtc(down_2.getBytesPerSec()) + ",mr=" + DisplayFormatters.formatDecimal(mapper.getCurrentMetricRating(), 2);
        }
        return "";
    }

    public static class limitToTextHelper {
        String msg_text_unknown = MessageText.getString("SpeedView.stats.unknown");
        String msg_text_estimate = MessageText.getString("SpeedView.stats.estimate");
        String msg_text_choke_estimate = MessageText.getString("SpeedView.stats.estimatechoke");
        String msg_text_measured_min;
        String msg_text_measured = MessageText.getString("SpeedView.stats.measured");
        String msg_text_manual;
        String msg_unlimited;
        String[] setable_types;

        public limitToTextHelper() {
            this.msg_text_measured_min = MessageText.getString("SpeedView.stats.measuredmin");
            this.msg_text_manual = MessageText.getString("SpeedView.stats.manual");
            this.msg_unlimited = MessageText.getString("ConfigView.unlimited");
            this.setable_types = new String[]{"", this.msg_text_estimate, this.msg_text_measured, this.msg_text_manual};
        }

        public String[] getSettableTypes() {
            return this.setable_types;
        }

        public String getSettableType(SpeedManagerLimitEstimate limit) {
            float type = limit.getEstimateType();
            String text = type == -0.1f ? "" : (type == 1.0f ? this.msg_text_manual : (type == 0.9f ? this.msg_text_measured : (type == 0.8f ? this.msg_text_measured : (type == 0.5f ? this.msg_text_estimate : this.msg_text_estimate))));
            return text;
        }

        public String typeToText(float type) {
            String text = type == -0.1f ? this.msg_text_unknown : (type == 1.0f ? this.msg_text_manual : (type == 0.9f ? this.msg_text_measured : (type == 0.8f ? this.msg_text_measured_min : (type == 0.5f ? this.msg_text_choke_estimate : this.msg_text_estimate))));
            return text;
        }

        public float textToType(String text) {
            if (text.equals(this.msg_text_estimate)) {
                return 0.0f;
            }
            if (text.equals(this.msg_text_choke_estimate)) {
                return 0.5f;
            }
            if (text.equals(this.msg_text_measured)) {
                return 0.9f;
            }
            if (text.equals(this.msg_text_manual)) {
                return 1.0f;
            }
            return -0.1f;
        }

        public String getLimitText(SpeedManagerLimitEstimate limit) {
            float type = limit.getEstimateType();
            String text = this.typeToText(type);
            int l = limit.getBytesPerSec();
            if (l == 0) {
                return this.msg_unlimited + " (" + text + ")";
            }
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(l) + " (" + text + ")";
        }

        public String getUnlimited() {
            return this.msg_unlimited;
        }
    }

    class plotView {
        private SpeedManagerPingMapper mapper;
        private Plot3D plotGraph;

        protected plotView(SpeedManagerPingMapper _mapper, Canvas _canvas, String[] _labels, ValueFormater[] _formatters) {
            this.mapper = _mapper;
            this.plotGraph = new Plot3D(_labels, _formatters);
            this.plotGraph.initialize(_canvas);
        }

        protected void update() {
            int[][] history = this.mapper.getHistory();
            this.plotGraph.update(history);
            this.plotGraph.setTitle(TransferStatsView.this.getMapperTitle(this.mapper));
        }

        protected void refresh() {
            this.plotGraph.refresh();
        }

        protected void dispose() {
            this.plotGraph.dispose();
        }
    }

    class zoneView
    implements ParameterListener {
        private SpeedManagerPingMapper mapper;
        private SpeedManagerPingZone[] zones = new SpeedManagerPingZone[0];
        private Canvas canvas;
        private ValueFormater[] formatters;
        private String[] labels;
        private String title = "";
        private int refresh_count;
        private int graphicsUpdate;
        private Point old_size;
        protected Image buffer_image;

        protected zoneView(SpeedManagerPingMapper _mapper, Canvas _canvas, String[] _labels, ValueFormater[] _formatters) {
            this.mapper = _mapper;
            this.canvas = _canvas;
            this.labels = _labels;
            this.formatters = _formatters;
            COConfigurationManager.addAndFireParameterListener("Graphics Update", this);
        }

        public void parameterChanged(String name) {
            this.graphicsUpdate = COConfigurationManager.getIntParameter(name);
        }

        protected void update() {
            this.zones = this.mapper.getZones();
            this.title = TransferStatsView.this.getMapperTitle(this.mapper);
        }

        private void refresh() {
            if (this.canvas.isDisposed()) {
                return;
            }
            Rectangle bounds = this.canvas.getClientArea();
            if (bounds.height < 30 || bounds.width < 100 || bounds.width > 2000 || bounds.height > 2000) {
                return;
            }
            boolean size_changed = this.old_size == null || this.old_size.x != bounds.width || this.old_size.y != bounds.height;
            this.old_size = new Point(bounds.width, bounds.height);
            ++this.refresh_count;
            if (this.refresh_count > this.graphicsUpdate) {
                this.refresh_count = 0;
            }
            if (this.refresh_count == 0 || size_changed) {
                if (this.buffer_image != null && !this.buffer_image.isDisposed()) {
                    this.buffer_image.dispose();
                }
                this.buffer_image = this.draw(bounds);
            }
            if (this.buffer_image != null) {
                GC gc = new GC((Drawable)this.canvas);
                gc.drawImage(this.buffer_image, bounds.x, bounds.y);
                gc.dispose();
            }
        }

        private Image draw(Rectangle bounds) {
            SpeedManagerLimitEstimate[] bad_down;
            SpeedManagerLimitEstimate[] bad_up;
            int i;
            int i2;
            int PAD_TOP = 10;
            int PAD_BOTTOM = 10;
            int PAD_RIGHT = 10;
            int PAD_LEFT = 10;
            int usable_width = bounds.width - 10 - 10;
            int usable_height = bounds.height - 10 - 10;
            Image image = new Image((Device)this.canvas.getDisplay(), bounds);
            GC gc = new GC((Drawable)image);
            try {
                gc.setAntialias(1);
            }
            catch (Exception e) {
                // empty catch block
            }
            int font_height = gc.getFontMetrics().getHeight();
            int char_width = gc.getFontMetrics().getAverageCharWidth();
            Color[] colours = TransferStatsView.this.plot_views[0].plotGraph.getColours();
            int max_x = 0;
            int max_y = 0;
            if (this.zones.length > 0) {
                int max_metric = 0;
                for (int i3 = 0; i3 < this.zones.length; ++i3) {
                    SpeedManagerPingZone zone = this.zones[i3];
                    int metric = zone.getMetric();
                    if (metric <= 0) continue;
                    max_metric = Math.max(max_metric, metric);
                    max_x = Math.max(max_x, zone.getUploadEndBytesPerSec());
                    max_y = Math.max(max_y, zone.getDownloadEndBytesPerSec());
                }
                if (max_x > 0 && max_y > 0) {
                    int i4;
                    double x_ratio = (double)usable_width / (double)max_x;
                    double y_ratio = (double)usable_height / (double)max_y;
                    ArrayList<Object[]> texts = new ArrayList<Object[]>();
                    for (i2 = 0; i2 < this.zones.length; ++i2) {
                        SpeedManagerPingZone zone = this.zones[i2];
                        int metric = zone.getMetric();
                        int x1 = zone.getUploadStartBytesPerSec();
                        int y1 = zone.getDownloadStartBytesPerSec();
                        int x2 = zone.getUploadEndBytesPerSec();
                        int y2 = zone.getDownloadEndBytesPerSec();
                        if (metric <= 0) continue;
                        int colour_index = (int)((float)metric * (float)colours.length / (float)max_metric);
                        if (colour_index >= colours.length) {
                            colour_index = colours.length - 1;
                        }
                        gc.setBackground(colours[colour_index]);
                        int x = 10 + (int)((double)x1 * x_ratio);
                        int y = 10 + (int)((double)y1 * y_ratio);
                        int width = (int)Math.ceil((double)(x2 - x1 + 1) * x_ratio);
                        int height = (int)Math.ceil((double)(y2 - y1 + 1) * y_ratio);
                        int y_draw = usable_height + 10 + 10 - y - height;
                        gc.fillRectangle(x, y_draw, width, height);
                        int text_metric = zone.getMetric();
                        String text = String.valueOf(metric);
                        int text_width = text.length() * char_width + 4;
                        if (width < text_width || height < font_height) continue;
                        Rectangle text_rect = new Rectangle(x + (width - text_width) / 2, y_draw + (height - font_height) / 2, text_width, font_height);
                        Iterator it = texts.iterator();
                        while (it.hasNext()) {
                            Object[] old = (Object[])it.next();
                            Rectangle old_coords = (Rectangle)old[1];
                            if (!old_coords.intersects(text_rect)) continue;
                            it.remove();
                        }
                        texts.add(new Object[]{new Integer(text_metric), text_rect});
                    }
                    int text_num = texts.size();
                    int n = i4 = text_num > 100 ? text_num - 100 : 0;
                    while (i4 < text_num) {
                        Object[] entry = (Object[])texts.get(i4);
                        String str = String.valueOf(entry[0]);
                        Rectangle rect = (Rectangle)entry[1];
                        gc.drawText(str, rect.x, rect.y, 1);
                        ++i4;
                    }
                }
            }
            int x_axis_left_x = 10;
            int x_axis_left_y = usable_height + 10;
            int x_axis_right_x = 10 + usable_width;
            int x_axis_right_y = x_axis_left_y;
            gc.drawLine(x_axis_left_x, x_axis_left_y, x_axis_right_x, x_axis_right_y);
            gc.drawLine(usable_width, x_axis_right_y - 4, x_axis_right_x, x_axis_right_y);
            gc.drawLine(usable_width, x_axis_right_y + 4, x_axis_right_x, x_axis_right_y);
            for (int i5 = 1; i5 < 10; ++i5) {
                int x = x_axis_left_x + (x_axis_right_x - x_axis_left_x) * i5 / 10;
                gc.drawLine(x, x_axis_left_y, x, x_axis_left_y + 4);
            }
            SpeedManagerLimitEstimate le = this.mapper.getEstimatedUploadLimit(false);
            if (le != null) {
                gc.setForeground(Colors.grey);
                int[][] segs = le.getSegments();
                if (segs.length > 0) {
                    int max_metric = 0;
                    int max_pos = 0;
                    for (int i6 = 0; i6 < segs.length; ++i6) {
                        int[] seg = segs[i6];
                        max_metric = Math.max(max_metric, seg[0]);
                        max_pos = Math.max(max_pos, seg[2]);
                    }
                    double metric_ratio = max_metric == 0 ? 1.0 : (double)(50.0f / (float)max_metric);
                    double pos_ratio = max_pos == 0 ? 1.0 : (double)((float)usable_width / (float)max_pos);
                    int prev_x = 1;
                    int prev_y = 1;
                    for (i = 0; i < segs.length; ++i) {
                        int[] seg = segs[i];
                        int next_x = (int)((double)(seg[1] + (seg[2] - seg[1]) / 2) * pos_ratio) + 1;
                        int next_y = (int)((double)seg[0] * metric_ratio) + 1;
                        gc.drawLine(x_axis_left_x + prev_x, x_axis_left_y - prev_y, x_axis_left_x + next_x, x_axis_left_y - next_y);
                        prev_x = next_x;
                        prev_y = next_y;
                    }
                }
                gc.setForeground(Colors.black);
            }
            if ((bad_up = this.mapper.getBadUploadHistory()).length > 0) {
                gc.setLineWidth(3);
                gc.setForeground(Colors.red);
                for (i2 = 0; i2 < bad_up.length; ++i2) {
                    int speed = bad_up[i2].getBytesPerSec();
                    int x = max_x == 0 ? 0 : speed * usable_width / max_x;
                    gc.drawLine(x_axis_left_x + x, x_axis_left_y - 0, x_axis_left_x + x, x_axis_left_y - 10);
                }
                gc.setForeground(Colors.black);
                gc.setLineWidth(1);
            }
            String x_text = this.labels[0] + " - " + this.formatters[0].format(max_x + 1);
            gc.drawText(x_text, x_axis_right_x - 20 - x_text.length() * char_width, x_axis_right_y - font_height - 2, 1);
            int y_axis_bottom_x = 10;
            int y_axis_bottom_y = usable_height + 10;
            int y_axis_top_x = 10;
            int y_axis_top_y = 10;
            gc.drawLine(y_axis_bottom_x, y_axis_bottom_y, y_axis_top_x, y_axis_top_y);
            gc.drawLine(y_axis_top_x - 4, y_axis_top_y + 10, y_axis_top_x, y_axis_top_y);
            gc.drawLine(y_axis_top_x + 4, y_axis_top_y + 10, y_axis_top_x, y_axis_top_y);
            for (int i7 = 1; i7 < 10; ++i7) {
                int y = y_axis_bottom_y + (y_axis_top_y - y_axis_bottom_y) * i7 / 10;
                gc.drawLine(y_axis_bottom_x, y, y_axis_bottom_x - 4, y);
            }
            le = this.mapper.getEstimatedDownloadLimit(false);
            if (le != null) {
                gc.setForeground(Colors.grey);
                int[][] segs = le.getSegments();
                if (segs.length > 0) {
                    int max_metric = 0;
                    int max_pos = 0;
                    for (i = 0; i < segs.length; ++i) {
                        int[] seg = segs[i];
                        max_metric = Math.max(max_metric, seg[0]);
                        max_pos = Math.max(max_pos, seg[2]);
                    }
                    double metric_ratio = max_metric == 0 ? 1.0 : (double)(50.0f / (float)max_metric);
                    double pos_ratio = max_pos == 0 ? 1.0 : (double)((float)usable_height / (float)max_pos);
                    int prev_x = 1;
                    int prev_y = 1;
                    for (int i8 = 0; i8 < segs.length; ++i8) {
                        int[] seg = segs[i8];
                        int next_x = (int)((double)seg[0] * metric_ratio) + 1;
                        int next_y = (int)((double)(seg[1] + (seg[2] - seg[1]) / 2) * pos_ratio) + 1;
                        gc.drawLine(y_axis_bottom_x + prev_x, y_axis_bottom_y - prev_y, y_axis_bottom_x + next_x, y_axis_bottom_y - next_y);
                        prev_x = next_x;
                        prev_y = next_y;
                    }
                }
                gc.setForeground(Colors.black);
            }
            if ((bad_down = this.mapper.getBadDownloadHistory()).length > 0) {
                gc.setForeground(Colors.red);
                gc.setLineWidth(3);
                for (int i9 = 0; i9 < bad_down.length; ++i9) {
                    int speed = bad_down[i9].getBytesPerSec();
                    int y = max_y == 0 ? 0 : speed * usable_height / max_y;
                    gc.drawLine(y_axis_bottom_x + 0, y_axis_bottom_y - y, y_axis_bottom_x + 10, y_axis_bottom_y - y);
                }
                gc.setForeground(Colors.black);
                gc.setLineWidth(1);
            }
            String y_text = this.labels[1] + " - " + this.formatters[1].format(max_y + 1);
            gc.drawText(y_text, y_axis_top_x + 4, y_axis_top_y + 2, 1);
            gc.drawText(this.title, (bounds.width - this.title.length() * char_width) / 2, 1, 1);
            gc.dispose();
            return image;
        }

        protected void dispose() {
            if (this.buffer_image != null && !this.buffer_image.isDisposed()) {
                this.buffer_image.dispose();
            }
            COConfigurationManager.removeParameterListener("Graphics Update", this);
        }
    }
}

