/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.stats.VivaldiPanel;

public class VivaldiView
extends AbstractIView {
    public static final int DHT_TYPE_MAIN = 0;
    public static final int DHT_TYPE_CVS = 1;
    public static final int DHT_TYPE_MAIN_V6 = 3;
    DHT dht;
    Composite panel;
    VivaldiPanel drawPanel;
    private final boolean autoAlpha;
    private final int dht_type;

    public VivaldiView(int dht_type) {
        this.dht_type = dht_type;
        this.autoAlpha = false;
        this.init();
    }

    public VivaldiView(boolean autoAlpha) {
        this.dht_type = 0;
        this.autoAlpha = autoAlpha;
        this.init();
    }

    private void init() {
        try {
            PluginInterface dht_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                return;
            }
            DHT[] dhts = ((DHTPlugin)dht_pi.getPlugin()).getDHTs();
            for (int i = 0; i < dhts.length; ++i) {
                if (dhts[i].getTransport().getNetwork() != this.dht_type) continue;
                this.dht = dhts[i];
                break;
            }
            if (this.dht == null) {
                return;
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new FillLayout());
        this.drawPanel = new VivaldiPanel(this.panel);
        this.drawPanel.setAutoAlpha(this.autoAlpha);
    }

    public Composite getComposite() {
        return this.panel;
    }

    public void refresh() {
        if (this.dht == null) {
            this.init();
        }
        if (this.dht != null) {
            List l = this.dht.getControl().getContacts();
            this.drawPanel.refreshContacts(l, this.dht.getControl().getTransport().getLocalContact());
        }
    }

    public String getData() {
        return this.getFullTitle();
    }

    public String getFullTitle() {
        if (this.dht_type == 0) {
            return "VivaldiView.title.full";
        }
        if (this.dht_type == 1) {
            return "VivaldiView.title.fullcvs";
        }
        return "VivaldiView.title.full_v6";
    }

    public void delete() {
        this.drawPanel.delete();
        super.delete();
    }
}

