/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableGroupRowVisibilityRunner;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectedRowsListener;
import com.aelitis.azureus.ui.common.table.TableStructureEventDispatcher;
import com.aelitis.azureus.ui.common.table.TableStructureModificationListener;
import com.aelitis.azureus.ui.common.table.impl.TableViewImpl;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.LightHashSet;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRowRefreshListener;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableContextMenuItemImpl;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTPanelCreator;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableRowImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableTooltips;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnEditorWindow;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.table.utils.TableContextMenuManager;
import org.gudy.azureus2.ui.swt.views.utils.VerticalAligner;

public class TableViewSWTImpl
extends TableViewImpl
implements ParameterListener,
TableViewSWT,
TableStructureModificationListener,
ObfusticateImage {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final boolean DISABLEVIRTUAL = SWT.getVersion() < 3138;
    private static final boolean COLUMN_CLICK_DELAY = Constants.isOSX && SWT.getVersion() >= 3221 && SWT.getVersion() <= 3222;
    private static final boolean DEBUG_SORTER = false;
    private static final ConfigurationManager configMan = ConfigurationManager.getInstance();
    private static final String CFG_SORTDIRECTION = "config.style.table.defaultSortOrder";
    private static final long BREAKOFF_ADDTOMAP = 1000L;
    private static final long BREAKOFF_ADDROWSTOSWT = 800L;
    private static final boolean TRIGGER_PAINT_ON_SELECTIONS = false;
    protected String sTableID;
    protected String sPropertiesPrefix;
    protected String sDefaultSortOn;
    private boolean bSkipFirstColumn;
    private Point ptIconSize = null;
    private TableColumnCore[] basicItems;
    private TableColumnCore[] tableColumns;
    private Composite mainComposite;
    private Composite tableComposite;
    private Table table;
    private TableEditor editor;
    protected int iTableStyle;
    private boolean bTableVirtual;
    private Menu menu;
    private Menu menuThisColumn;
    private Map mapDataSourceToRow;
    private AEMonitor dataSourceToRow_mon = new AEMonitor("TableView:OTSI");
    private List sortedRows;
    private AEMonitor sortedRows_mon = new AEMonitor("TableView:sR");
    private AEMonitor sortColumn_mon = new AEMonitor("TableView:sC");
    protected TableColumnCore sortColumn;
    private long lLastSortedOn;
    private int iMouseX = -1;
    protected int loopFactor;
    protected int graphicsUpdate = configMan.getIntParameter("Graphics Update");
    protected int reOrderDelay = configMan.getIntParameter("ReOrder Delay");
    private int checkColumnWidthsEvery = Constants.isOSX && SWT.getVersion() < 3054 ? 10000 / configMan.getIntParameter("GUI Refresh") : 0;
    private TableColumnCore[] columnsOrdered;
    private boolean[] columnsVisible;
    private ColumnMoveListener columnMoveListener = new ColumnMoveListener();
    private LightHashSet dataSourcesToAdd = new LightHashSet(4);
    private LightHashSet dataSourcesToRemove = new LightHashSet(4);
    private boolean bReallyAddingDataSources = false;
    public boolean bEnableTabViews = false;
    private CTabFolder tabFolder;
    private ArrayList tabViews = new ArrayList(1);
    private int lastTopIndex = 0;
    private int lastBottomIndex = -1;
    protected IView[] coreTabViews = null;
    private long lCancelSelectionTriggeredOn = -1L;
    private long lLastColumnResizeOn = -1L;
    private List listenersMenuFill = new ArrayList();
    private TableViewSWTPanelCreator mainPanelCreator;
    private List listenersKey = new ArrayList();
    private boolean columnPaddingAdjusted = false;
    private boolean columnVisibilitiesChanged = true;
    private Class dataSourceType;
    private AEMonitor listeners_mon = new AEMonitor("tablelisteners");
    private ArrayList refreshListeners;
    private Font fontBold;
    private Rectangle clientArea;
    private Utils.addDataSourceCallback processDataSourceQueueCallback = new Utils.addDataSourceCallback(){

        public void process() {
            TableViewSWTImpl.this.processDataSourceQueue();
        }

        public void debug(String str) {
            TableViewSWTImpl.this.debug(str);
        }
    };
    private Rectangle firstClientArea;
    private int lastHorizontalPos;
    private SourceReplaceListener cellEditNotifier;

    public TableViewSWTImpl(String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn, int _iTableStyle) {
        this.sTableID = _sTableID;
        this.basicItems = _basicItems;
        this.sPropertiesPrefix = _sPropertiesPrefix;
        this.sDefaultSortOn = _sDefaultSortOn;
        this.iTableStyle = _iTableStyle | 0x200;
        if (DISABLEVIRTUAL) {
            this.iTableStyle &= 0xEFFFFFFF;
        }
        this.bTableVirtual = (this.iTableStyle & 0x10000000) != 0;
        this.mapDataSourceToRow = new LightHashMap();
        this.sortedRows = new ArrayList();
    }

    public TableViewSWTImpl(String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn) {
        this(_sTableID, _sPropertiesPrefix, _basicItems, _sDefaultSortOn, 0x10010004);
    }

    private void initializeColumnDefs() {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (tcManager.getTableColumnCount(this.sTableID) != this.basicItems.length) {
            tcManager.addColumns(this.basicItems);
        }
        tcManager.ensureIntegrety(this.sTableID);
        this.tableColumns = tcManager.getAllTableColumnCoreAsArray(this.dataSourceType, this.sTableID);
    }

    public void setColumnList(TableColumnCore[] columns, String defaultSortColumnID, boolean defaultSortOrder, boolean titleIsMinWidth) {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (tcManager.getTableColumnCount(this.sTableID) != columns.length) {
            tcManager.addColumns(this.basicItems);
        }
        tcManager.ensureIntegrety(this.sTableID);
        this.tableColumns = tcManager.getAllTableColumnCoreAsArray(this.dataSourceType, this.sTableID);
    }

    public void initialize(Composite composite) {
        composite.setRedraw(false);
        this.mainComposite = this.createSashForm(composite);
        this.menu = this.createMenu();
        this.table = this.createTable(this.tableComposite);
        this.clientArea = this.table.getClientArea();
        this.editor = new TableEditor(this.table);
        this.editor.minimumWidth = 80;
        this.editor.grabHorizontal = true;
        this.initializeTable(this.table);
        this.triggerLifeCycleListener(0);
        configMan.addParameterListener("Graphics Update", this);
        configMan.addParameterListener("ReOrder Delay", this);
        Colors.getInstance().addColorsChangedListener(this);
        TableStructureEventDispatcher.getInstance(this.sTableID).addListener(this);
        composite.setRedraw(true);
    }

    private Composite createSashForm(Composite composite) {
        double pct;
        Composite cFixLayout;
        UISWTInstanceImpl pluginUI;
        if (!this.bEnableTabViews) {
            this.tableComposite = this.createMainPanel(composite);
            return this.tableComposite;
        }
        int iNumViews = this.coreTabViews == null ? 0 : this.coreTabViews.length;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        Map pluginViews = null;
        if (uiFunctions != null && (pluginUI = uiFunctions.getSWTPluginInstanceImpl()) != null && (pluginViews = pluginUI.getViewListeners(this.sTableID)) != null) {
            iNumViews += pluginViews.size();
        }
        if (iNumViews == 0) {
            this.tableComposite = this.createMainPanel(composite);
            return this.tableComposite;
        }
        final Composite form = new Composite(composite, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        form.setLayout((Layout)flayout);
        GridData gridData = new GridData(1808);
        form.setLayoutData((Object)gridData);
        int TABHEIGHT = 20;
        this.tabFolder = new CTabFolder(form, 2176);
        this.tabFolder.setMinimizeVisible(true);
        this.tabFolder.setTabHeight(20);
        final int iFolderHeightAdj = this.tabFolder.computeSize((int)-1, (int)0).y;
        final Sash sash = new Sash(form, 256);
        for (cFixLayout = this.tableComposite = this.createMainPanel(form); cFixLayout != null && cFixLayout.getParent() != form; cFixLayout = cFixLayout.getParent()) {
        }
        if (cFixLayout == null) {
            cFixLayout = this.tableComposite;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cFixLayout.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        int iSplitAt = configMan.getIntParameter(this.sPropertiesPrefix + ".SplitAt", 3000);
        if (iSplitAt < 100) {
            iSplitAt *= 100;
        }
        if ((pct = (double)iSplitAt / 10000.0) < 0.03) {
            pct = 0.03;
        } else if (pct > 0.97) {
            pct = 0.97;
        }
        sash.setData("PCT", (Object)new Double(pct));
        this.tabFolder.setLayoutData((Object)formData);
        final FormData tabFolderData = formData;
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)this.tabFolder);
        formData.height = 5;
        sash.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)sash);
        cFixLayout.setLayoutData((Object)formData);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean FASTDRAG = true;
                if (e.detail == 1) {
                    return;
                }
                if (TableViewSWTImpl.this.tabFolder.getMinimized()) {
                    TableViewSWTImpl.this.tabFolder.setMinimized(false);
                    TableViewSWTImpl.this.refreshSelectedSubView();
                    configMan.setParameter(TableViewSWTImpl.this.sPropertiesPrefix + ".subViews.minimized", false);
                }
                Rectangle area = form.getClientArea();
                tabFolderData.height = area.height - e.y - e.height - iFolderHeightAdj;
                form.layout();
                Double l = new Double((double)((TableViewSWTImpl)TableViewSWTImpl.this).tabFolder.getBounds().height / (double)form.getBounds().height);
                sash.setData("PCT", (Object)l);
                if (e.detail != 1) {
                    configMan.setParameter(TableViewSWTImpl.this.sPropertiesPrefix + ".SplitAt", (int)(l * 10000.0));
                }
            }
        });
        final CTabFolder2Adapter folderListener = new CTabFolder2Adapter(){

            public void minimize(CTabFolderEvent event2) {
                TableViewSWTImpl.this.tabFolder.setMinimized(true);
                tabFolderData.height = iFolderHeightAdj;
                CTabItem[] items = TableViewSWTImpl.this.tabFolder.getItems();
                for (int i = 0; i < items.length; ++i) {
                    CTabItem tabItem = items[i];
                    tabItem.getControl().setVisible(false);
                }
                form.layout();
                configMan.setParameter(TableViewSWTImpl.this.sPropertiesPrefix + ".subViews.minimized", true);
            }

            public void restore(CTabFolderEvent event2) {
                TableViewSWTImpl.this.tabFolder.setMinimized(false);
                CTabItem selection = TableViewSWTImpl.this.tabFolder.getSelection();
                if (selection != null) {
                    selection.getControl().setVisible(true);
                }
                form.notifyListeners(11, null);
                TableViewSWTImpl.this.refreshSelectedSubView();
                configMan.setParameter(TableViewSWTImpl.this.sPropertiesPrefix + ".subViews.minimized", false);
            }
        };
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)folderListener);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ((CTabItem)e.item).getControl().setVisible(true);
                    ((CTabItem)e.item).getControl().moveAbove(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TableViewSWTImpl.this.tabFolder.getMinimized()) {
                    folderListener.restore(null);
                    e.button = 0;
                    TableViewSWTImpl.this.tabFolder.notifyListeners(7, null);
                }
            }
        });
        form.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (TableViewSWTImpl.this.tabFolder.getMinimized()) {
                    return;
                }
                Double l = (Double)sash.getData("PCT");
                if (l != null) {
                    tabFolderData.height = (int)((double)form.getBounds().height * l) - iFolderHeightAdj;
                    form.layout();
                }
            }
        });
        if (this.coreTabViews != null) {
            for (int i = 0; i < this.coreTabViews.length; ++i) {
                this.addTabView(this.coreTabViews[i]);
            }
        }
        if (pluginViews != null) {
            String[] sNames = pluginViews.keySet().toArray(new String[0]);
            for (int i = 0; i < sNames.length; ++i) {
                UISWTViewEventListener l = (UISWTViewEventListener)pluginViews.get(sNames[i]);
                if (l == null) continue;
                try {
                    UISWTViewImpl view = new UISWTViewImpl(this.sTableID, sNames[i], l);
                    this.addTabView(view);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (configMan.getBooleanParameter(this.sPropertiesPrefix + ".subViews.minimized", false)) {
            this.tabFolder.setMinimized(true);
            tabFolderData.height = iFolderHeightAdj;
        } else {
            this.tabFolder.setMinimized(false);
        }
        this.tabFolder.setSelection(0);
        return form;
    }

    public Composite createMainPanel(Composite composite) {
        TableViewSWTPanelCreator mainPanelCreator = this.getMainPanelCreator();
        if (mainPanelCreator != null) {
            return mainPanelCreator.createTableViewPanel(composite);
        }
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        return panel;
    }

    public Table createTable(Composite panel) {
        this.table = new Table(panel, this.iTableStyle);
        this.table.setLayoutData((Object)new GridData(1808));
        return this.table;
    }

    public void initializeTable(final Table table) {
        ScrollBar horizontalBar;
        this.initializeColumnDefs();
        this.iTableStyle = table.getStyle();
        this.bTableVirtual = (this.iTableStyle & 0x10000000) != 0;
        table.setLinesVisible(Utils.TABLE_GRIDLINE_IS_ALTERNATING_COLOR);
        table.setMenu(this.menu);
        table.setData("Name", (Object)this.sTableID);
        table.setData("TableView", (Object)this);
        if (!Utils.SWT32_TABLEPAINT) {
            table.addPaintListener(new PaintListener(){
                boolean first = true;

                public void paintControl(PaintEvent event2) {
                    if (this.first) {
                        TableViewSWTImpl.this.changeColumnIndicator();
                        table.setRedraw(false);
                        table.setRedraw(true);
                        this.first = false;
                    }
                    if (event2.width == 0 || event2.height == 0) {
                        return;
                    }
                    TableViewSWTImpl.this.visibleRowsChanged();
                    TableViewSWTImpl.this.doPaint(event2.gc, new Rectangle(event2.x, event2.y, event2.width, event2.height));
                }
            });
        }
        if (Utils.SWT32_TABLEPAINT) {
            table.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event2) {
                    TableViewSWTImpl.this.changeColumnIndicator();
                    table.setRedraw(false);
                    table.setRedraw(true);
                    table.removePaintListener((PaintListener)this);
                }
            });
            table.addListener(42, new Listener(){

                public void handleEvent(Event event2) {
                    TableViewSWTImpl.this.visibleRowsChanged();
                    TableViewSWTImpl.this.paintItem(event2);
                }
            });
        }
        if ((horizontalBar = table.getHorizontalBar()) != null) {
            horizontalBar.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    TableViewSWTImpl.this.calculateClientArea();
                }

                public void widgetSelected(SelectionEvent e) {
                    TableViewSWTImpl.this.calculateClientArea();
                }
            });
        }
        table.addListener(41, new Listener(){

            public void handleEvent(Event event2) {
                int defaultHeight = TableViewSWTImpl.this.getRowDefaultHeight();
                if (event2.height < defaultHeight) {
                    event2.height = defaultHeight;
                }
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){
            TableRowCore lastClickRow;

            public void mouseDoubleClick(MouseEvent e) {
                TableCellMouseEvent event2;
                TableColumnCore tc = TableViewSWTImpl.this.getTableColumnByOffset(e.x);
                TableCellSWT cell = TableViewSWTImpl.this.getTableCell(e.x, e.y);
                if (cell != null && tc != null && (event2 = TableViewSWTImpl.this.createMouseEvent(cell, e, 2)) != null) {
                    tc.invokeCellMouseListeners(event2);
                    cell.invokeMouseListeners(event2);
                    if (event2.skipCoreFunctionality) {
                        TableViewSWTImpl.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
                TableCellMouseEvent event2;
                TableColumnCore tc = TableViewSWTImpl.this.getTableColumnByOffset(e.x);
                TableCellSWT cell = TableViewSWTImpl.this.getTableCell(e.x, e.y);
                if (cell != null && tc != null && (event2 = TableViewSWTImpl.this.createMouseEvent(cell, e, 1)) != null) {
                    tc.invokeCellMouseListeners(event2);
                    cell.invokeMouseListeners(event2);
                    if (event2.skipCoreFunctionality) {
                        TableViewSWTImpl.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                TableColumnCore tc = TableViewSWTImpl.this.getTableColumnByOffset(e.x);
                TableCellSWT cell = TableViewSWTImpl.this.getTableCell(e.x, e.y);
                TableViewSWTImpl.this.editCell(-1, -1);
                if (cell != null && tc != null) {
                    TableCellMouseEvent event2;
                    if (e.button == 2 && e.stateMask == 262144) {
                        ((TableCellImpl)cell).bDebug = !((TableCellImpl)cell).bDebug;
                        System.out.println("Set debug for " + cell + " to " + ((TableCellImpl)cell).bDebug);
                    }
                    if ((event2 = TableViewSWTImpl.this.createMouseEvent(cell, e, 0)) != null) {
                        tc.invokeCellMouseListeners(event2);
                        cell.invokeMouseListeners(event2);
                        if (event2.skipCoreFunctionality) {
                            TableViewSWTImpl.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                        }
                    }
                    if (tc.isInplaceEdit() && e.button == 1 && this.lastClickRow == cell.getTableRowCore()) {
                        TableViewSWTImpl.this.editCell(TableViewSWTImpl.this.getColumnNo(e.x), cell.getTableRowCore().getIndex());
                    }
                    if (e.button == 1) {
                        this.lastClickRow = cell.getTableRowCore();
                    }
                }
                TableViewSWTImpl.this.iMouseX = e.x;
                try {
                    if (table.getItemCount() <= 0) {
                        return;
                    }
                    Point pMousePosition = new Point(e.x, e.y);
                    if (TableViewSWTImpl.this.clientArea.contains(pMousePosition)) {
                        int[] columnOrder = table.getColumnOrder();
                        if (columnOrder.length == 0) {
                            return;
                        }
                        TableItem ti = table.getItem(table.getItemCount() - 1);
                        Rectangle cellBounds = ti.getBounds(columnOrder[columnOrder.length - 1]);
                        if (cellBounds.width <= 0 || cellBounds.height <= 0) {
                            return;
                        }
                        if (e.x > cellBounds.x + cellBounds.width || e.y > cellBounds.y + cellBounds.height) {
                            table.deselectAll();
                        }
                    }
                }
                catch (Exception ex) {
                    System.out.println("MouseDownError");
                    Debug.printStackTrace(ex);
                }
            }
        });
        table.addMouseMoveListener(new MouseMoveListener(){
            TableCellSWT lastCell = null;
            int lastCursorID = 0;

            public void mouseMove(MouseEvent e) {
                try {
                    TableCellMouseEvent event2;
                    TableViewSWTImpl.this.iMouseX = e.x;
                    TableCellSWT cell = TableViewSWTImpl.this.getTableCell(e.x, e.y);
                    int iCursorID = 0;
                    if (cell == null) {
                        this.lastCell = null;
                    } else if (cell == this.lastCell) {
                        iCursorID = this.lastCursorID;
                    } else {
                        iCursorID = cell.getCursorID();
                        this.lastCell = cell;
                    }
                    if (iCursorID < 0) {
                        iCursorID = 0;
                    }
                    if (iCursorID != this.lastCursorID) {
                        this.lastCursorID = iCursorID;
                        if (iCursorID >= 0) {
                            table.setCursor(table.getDisplay().getSystemCursor(iCursorID));
                        } else {
                            table.setCursor(null);
                        }
                    }
                    if (cell != null && (event2 = TableViewSWTImpl.this.createMouseEvent(cell, e, 3)) != null) {
                        TableColumnCore tc = (TableColumnCore)cell.getTableColumn();
                        if (tc.hasCellMouseMoveListener()) {
                            ((TableColumnCore)cell.getTableColumn()).invokeCellMouseListeners(event2);
                        }
                        cell.invokeMouseListeners(event2);
                    }
                }
                catch (Exception ex) {
                    Debug.out(ex);
                }
            }
        });
        table.addSelectionListener(new SelectionListener(){
            int[] wasSelected = new int[0];

            public void widgetSelected(SelectionEvent event2) {
                int[] nowSelected = table.getSelectionIndices();
                Arrays.sort(nowSelected);
                int x = 0;
                for (int i = 0; x < this.wasSelected.length && i < nowSelected.length; ++i) {
                    int index = nowSelected[i];
                    if (this.wasSelected[x] == index) {
                        ++x;
                        continue;
                    }
                    TableViewSWTImpl.this.triggerDeselectionListeners(new TableRowCore[]{TableViewSWTImpl.this.getRow(this.wasSelected[x])});
                }
                this.wasSelected = nowSelected;
                TableViewSWTImpl.this.triggerSelectionListeners(new TableRowCore[]{TableViewSWTImpl.this.getRow((TableItem)event2.item)});
                TableViewSWTImpl.this.triggerTabViewsDataSourceChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (TableViewSWTImpl.this.lCancelSelectionTriggeredOn > 0L && System.currentTimeMillis() - TableViewSWTImpl.this.lCancelSelectionTriggeredOn < 200L) {
                    e.doit = false;
                    TableViewSWTImpl.this.lCancelSelectionTriggeredOn = -1L;
                } else {
                    TableViewSWTImpl.this.runDefaultAction(e.stateMask);
                }
            }
        });
        if (SWT.getVersion() > 3200) {
            table.addListener(39, new Listener(){

                public void handleEvent(Event e) {
                    TableViewSWTImpl.this.tableInvalidate();
                }
            });
        }
        new TableTooltips(this, (Composite)table);
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event2) {
                TableViewSWTImpl.this.calculateClientArea();
                Object[] listeners = TableViewSWTImpl.this.listenersKey.toArray();
                for (int i = 0; i < listeners.length; ++i) {
                    KeyListener l = (KeyListener)listeners[i];
                    l.keyPressed(event2);
                    if (event2.doit) continue;
                    return;
                }
                if (event2.keyCode == 0x100000E) {
                    if ((event2.stateMask & 0x20000) > 0) {
                        TableViewSWTImpl.this.runForSelectedRows(new TableGroupRowRunner(){

                            public void run(TableRowCore row) {
                                row.invalidate();
                                row.refresh(true);
                            }
                        });
                    } else {
                        TableViewSWTImpl.this.sortColumn(true);
                    }
                    event2.doit = false;
                    return;
                }
                int key = event2.character;
                if (key <= 26 && key > 0) {
                    key += 96;
                }
                if (event2.stateMask == SWT.MOD1) {
                    switch (key) {
                        case 97: {
                            if ((table.getStyle() & 2) <= 0) break;
                            TableViewSWTImpl.this.selectAll();
                            event2.doit = false;
                            break;
                        }
                        case 43: {
                            if (!Constants.isUnix) break;
                            org.eclipse.swt.widgets.TableColumn[] tableColumnsSWT = table.getColumns();
                            for (int i = 0; i < tableColumnsSWT.length; ++i) {
                                TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                                if (tc == null) continue;
                                int w = tc.getPreferredWidth();
                                if (w <= 0 && (w = tc.getMinWidth()) <= 0) {
                                    w = 100;
                                }
                                tc.setWidth(w);
                            }
                            event2.doit = false;
                        }
                    }
                    if (!event2.doit) {
                        return;
                    }
                }
            }

            public void keyReleased(KeyEvent event2) {
                Object[] listeners = TableViewSWTImpl.this.listenersKey.toArray();
                for (int i = 0; i < listeners.length; ++i) {
                    KeyListener l = (KeyListener)listeners[i];
                    l.keyReleased(event2);
                    if (event2.doit) continue;
                    return;
                }
            }
        });
        ScrollBar bar = table.getVerticalBar();
        if (bar != null) {
            bar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!table.isFocusControl()) {
                        table.setFocus();
                    }
                }
            });
        }
        table.setHeaderVisible(true);
        this.clientArea = table.getClientArea();
        this.firstClientArea = table.getClientArea();
        table.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                TableViewSWTImpl.this.calculateClientArea();
            }
        });
        this.initializeTableColumns(table);
    }

    protected void calculateClientArea() {
        int pos;
        Rectangle oldClientArea = this.clientArea;
        this.clientArea = this.table.getClientArea();
        ScrollBar horizontalBar = this.table.getHorizontalBar();
        if (horizontalBar != null && (pos = horizontalBar.getSelection()) != this.lastHorizontalPos) {
            this.lastHorizontalPos = pos;
            this.columnVisibilitiesChanged = true;
        }
        if (oldClientArea != null && (oldClientArea.x != this.clientArea.x || oldClientArea.width != this.clientArea.width)) {
            this.columnVisibilitiesChanged = true;
        }
    }

    protected void triggerSelectionListeners(TableRowCore[] rows) {
        super.triggerSelectionListeners(rows);
    }

    protected void triggerDeselectionListeners(TableRowCore[] rows) {
        super.triggerDeselectionListeners(rows);
    }

    protected void triggerTabViewsDataSourceChanged() {
        if (this.tabViews == null || this.tabViews.size() == 0) {
            return;
        }
        Object[] dataSourcesCore = this.getSelectedDataSources(true);
        Object[] dataSourcesPlugin = null;
        for (int i = 0; i < this.tabViews.size(); ++i) {
            IView view = (IView)this.tabViews.get(i);
            if (view == null) continue;
            if (view instanceof UISWTViewImpl) {
                if (dataSourcesPlugin == null) {
                    dataSourcesPlugin = this.getSelectedDataSources(false);
                }
                ((UISWTViewImpl)view).dataSourceChanged(dataSourcesPlugin.length == 0 ? null : dataSourcesPlugin);
                continue;
            }
            view.dataSourceChanged(dataSourcesCore.length == 0 ? null : dataSourcesCore);
        }
    }

    private void editCell(int column, int row) {
        Text oldInput = (Text)this.editor.getEditor();
        if (column >= this.table.getColumnCount() || row < 0 || row >= this.table.getItemCount()) {
            this.cellEditNotifier = null;
            if (oldInput != null && !oldInput.isDisposed()) {
                this.editor.getEditor().dispose();
            }
            return;
        }
        org.eclipse.swt.widgets.TableColumn tcColumn = this.table.getColumn(column);
        TableItem item = this.table.getItem(row);
        String cellName = (String)tcColumn.getData("Name");
        TableRowSWT rowSWT = (TableRowSWT)this.getRow(row);
        TableCellSWT cell = rowSWT.getTableCellSWT(cellName);
        Text newInput = oldInput == null || oldInput.isDisposed() ? new Text((Composite)this.table, Constants.isOSX ? 0 : 2048) : oldInput;
        Object datasource = cell.getDataSource();
        if (this.cellEditNotifier != null) {
            this.cellEditNotifier.cleanup(newInput);
        }
        this.table.showItem(item);
        this.table.showColumn(tcColumn);
        newInput.setText(cell.getText());
        newInput.setSelection(0);
        newInput.selectAll();
        newInput.setFocus();
        class QuickEditListener
        implements ModifyListener,
        SelectionListener,
        KeyListener,
        TraverseListener,
        SourceReplaceListener,
        ControlListener {
            boolean resizing = true;
            final /* synthetic */ TableItem val$item;
            final /* synthetic */ TableCellSWT val$cell;
            final /* synthetic */ Text val$newInput;
            final /* synthetic */ TableRowSWT val$rowSWT;
            final /* synthetic */ int val$column;
            final /* synthetic */ int val$row;
            final /* synthetic */ Object val$datasource;

            public QuickEditListener(Text toAttach, TableItem tableItem, TableCellSWT tableCellSWT, Text text, TableRowSWT tableRowSWT, int n, int n2, Object object) {
                this.val$item = tableItem;
                this.val$cell = tableCellSWT;
                this.val$newInput = text;
                this.val$rowSWT = tableRowSWT;
                this.val$column = n;
                this.val$row = n2;
                this.val$datasource = object;
                toAttach.addModifyListener((ModifyListener)this);
                toAttach.addSelectionListener((SelectionListener)this);
                toAttach.addKeyListener((KeyListener)this);
                toAttach.addTraverseListener((TraverseListener)this);
                toAttach.addControlListener((ControlListener)this);
                TableViewSWTImpl.this.cellEditNotifier = this;
            }

            public void modifyText(ModifyEvent e) {
                if (this.val$item.isDisposed()) {
                    this.sourcesChanged();
                    return;
                }
                if (((TableColumnCore)this.val$cell.getTableColumn()).inplaceValueSet(this.val$cell, this.val$newInput.getText(), false)) {
                    this.val$newInput.setBackground(null);
                } else {
                    this.val$newInput.setBackground(Colors.colorErrorBG);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (this.val$item.isDisposed()) {
                    this.sourcesChanged();
                    this.val$newInput.traverse(4);
                    return;
                }
                ((TableColumnCore)this.val$cell.getTableColumn()).inplaceValueSet(this.val$cell, this.val$newInput.getText(), true);
                this.val$rowSWT.invalidate();
                TableViewSWTImpl.this.editCell(this.val$column, this.val$row + 1);
            }

            public void widgetSelected(SelectionEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    e.doit = false;
                    TableViewSWTImpl.this.editCell(this.val$column, this.val$row + (e.keyCode == 0x1000002 ? 1 : -1));
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = false;
                    TableViewSWTImpl.this.editCell(this.val$column, -1);
                }
            }

            public void sourcesChanged() {
                if (TableViewSWTImpl.this.getRow(this.val$datasource) == this.val$rowSWT || TableViewSWTImpl.this.getRow(this.val$datasource) == null || this.val$newInput.isDisposed()) {
                    return;
                }
                String newVal = this.val$newInput.getText();
                Point sel = this.val$newInput.getSelection();
                TableViewSWTImpl.this.editCell(this.val$column, TableViewSWTImpl.this.getRow(this.val$datasource).getIndex());
                if (this.val$newInput.isDisposed()) {
                    return;
                }
                this.val$newInput.setText(newVal);
                this.val$newInput.setSelection(sel);
            }

            public void cleanup(Text oldText) {
                if (!oldText.isDisposed()) {
                    oldText.removeModifyListener((ModifyListener)this);
                    oldText.removeSelectionListener((SelectionListener)this);
                    oldText.removeKeyListener((KeyListener)this);
                    oldText.removeTraverseListener((TraverseListener)this);
                    oldText.removeControlListener((ControlListener)this);
                }
            }

            public void controlMoved(ControlEvent e) {
                TableViewSWTImpl.this.table.showItem(this.val$item);
                if (this.resizing) {
                    return;
                }
                this.resizing = true;
                Point sel = this.val$newInput.getSelection();
                TableViewSWTImpl.this.editor.setEditor((Control)this.val$newInput, this.val$item, this.val$column);
                ((TableViewSWTImpl)TableViewSWTImpl.this).editor.minimumWidth = this.val$newInput.computeSize((int)-1, (int)-1).x;
                Rectangle leftAlignedBounds = this.val$item.getBounds(this.val$column);
                leftAlignedBounds.width = ((TableViewSWTImpl)TableViewSWTImpl.this).editor.minimumWidth = this.val$newInput.computeSize((int)-1, (int)-1).x;
                ((TableViewSWTImpl)TableViewSWTImpl.this).editor.horizontalAlignment = leftAlignedBounds.intersection(TableViewSWTImpl.this.clientArea).equals((Object)leftAlignedBounds) ? 16384 : 131072;
                TableViewSWTImpl.this.editor.layout();
                this.val$newInput.setSelection(0);
                this.val$newInput.setSelection(sel);
                this.resizing = false;
            }

            public void controlResized(ControlEvent e) {
            }
        }
        QuickEditListener l = new QuickEditListener(newInput, item, cell, newInput, rowSWT, column, row, datasource);
        l.modifyText(null);
        this.editor.setEditor((Control)newInput, item, column);
        this.table.deselectAll();
        this.table.select(row);
        l.resizing = false;
        l.controlMoved(null);
    }

    private TableCellMouseEvent createMouseEvent(TableCellSWT cell, MouseEvent e, int type) {
        TableCellMouseEvent event2 = new TableCellMouseEvent();
        event2.cell = cell;
        if (cell != null) {
            event2.row = cell.getTableRow();
        }
        event2.eventType = type;
        event2.button = e.button;
        event2.keyboardState = e.stateMask;
        event2.skipCoreFunctionality = false;
        Rectangle r = cell.getBounds();
        event2.x = e.x - r.x + VerticalAligner.getTableAdjustHorizontallyBy(this.table);
        if (event2.x < 0) {
            return null;
        }
        event2.y = e.y - r.y + VerticalAligner.getTableAdjustVerticalBy(this.table);
        if (event2.y < 0) {
            return null;
        }
        return event2;
    }

    protected void paintItem(Event event2) {
        try {
            int iMaxY;
            if (event2.gc.getClipping().isEmpty()) {
                return;
            }
            TableItem item = (TableItem)event2.item;
            if (item == null || item.isDisposed()) {
                return;
            }
            int iColumnNo = event2.index;
            if (this.bSkipFirstColumn) {
                if (iColumnNo == 0) {
                    return;
                }
                --iColumnNo;
            }
            if (iColumnNo >= this.columnsOrdered.length) {
                System.out.println(iColumnNo + " >= " + this.columnsOrdered.length);
                return;
            }
            if (!this.isColumnVisible(this.columnsOrdered[iColumnNo])) {
                return;
            }
            TableRowSWT row = (TableRowSWT)this.getRow(item);
            if (row == null) {
                return;
            }
            int rowAlpha = row.getAlpha();
            int fontStyle = row.getFontStyle();
            if (fontStyle == 1) {
                if (this.fontBold == null) {
                    FontData[] fontData = event2.gc.getFont().getFontData();
                    for (int i = 0; i < fontData.length; ++i) {
                        FontData fd = fontData[i];
                        fd.setStyle(1);
                    }
                    this.fontBold = new Font(event2.gc.getDevice(), fontData);
                }
                event2.gc.setFont(this.fontBold);
            }
            Rectangle cellBounds = item.getBounds(event2.index);
            if (cellBounds.width <= 0 || cellBounds.height <= 0) {
                return;
            }
            TableCellSWT cell = row.getTableCellSWT(this.columnsOrdered[iColumnNo].getName());
            if (cell == null) {
                return;
            }
            if (!cell.isUpToDate()) {
                cell.refresh(true, true);
            }
            String text = cell.getText();
            Rectangle clipping = new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
            int headerHeight = this.table.getHeaderHeight();
            int iMinY = headerHeight + this.clientArea.y;
            if (clipping.y < iMinY) {
                clipping.height -= iMinY - clipping.y;
                clipping.y = iMinY;
            }
            if (clipping.y + clipping.height > (iMaxY = this.clientArea.height + this.clientArea.y)) {
                clipping.height = iMaxY - clipping.y + 1;
            }
            if (clipping.width <= 0 || clipping.height <= 0) {
                return;
            }
            event2.gc.setClipping(clipping);
            if (rowAlpha < 255) {
                event2.gc.setAlpha(rowAlpha);
            }
            if (cell.needsPainting()) {
                cell.doPaint(event2.gc);
            } else if (text.length() > 0) {
                boolean fit;
                int textOpacity;
                Image image = item.getImage(event2.index);
                if (image != null) {
                    int ofs = image.getBounds().width;
                    cellBounds.x += ofs;
                    cellBounds.width -= ofs;
                }
                int style = CoreTableColumn.getSWTAlign(this.columnsOrdered[iColumnNo].getAlignment());
                if (cellBounds.height > 20) {
                    style |= 0x40;
                }
                if ((textOpacity = cell.getTextAlpha()) < 255) {
                    event2.gc.setAlpha(textOpacity);
                }
                cellBounds.x += 3;
                cellBounds.width -= 6;
                if (!cellBounds.isEmpty() && !(fit = GCStringPrinter.printString(event2.gc, text, cellBounds, true, cellBounds.height > 20, style))) {
                    cell.setToolTip(text);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runDefaultAction(int stateMask) {
        if (this.lCancelSelectionTriggeredOn > 0L && System.currentTimeMillis() - this.lCancelSelectionTriggeredOn < 200L) {
            this.lCancelSelectionTriggeredOn = -1L;
        } else {
            TableRowCore[] selectedRows = this.getSelectedRows();
            this.triggerDefaultSelectedListeners(selectedRows, stateMask);
        }
    }

    private void updateColumnVisibilities() {
        org.eclipse.swt.widgets.TableColumn[] columns = this.table.getColumns();
        int topIdx = this.table.getTopIndex();
        if (topIdx < 0 || this.table.getItemCount() < 1) {
            return;
        }
        this.columnVisibilitiesChanged = false;
        TableItem topRow = this.table.getItem(topIdx);
        for (int i = 0; i < columns.length; ++i) {
            boolean nowVisible;
            int position;
            final TableColumnCore tc = (TableColumnCore)columns[i].getData("TableColumnCore");
            if (tc == null || (position = tc.getPosition()) < 0 || position >= this.columnsVisible.length) continue;
            Rectangle size = topRow.getBounds(i);
            size.intersect(this.clientArea);
            boolean bl = nowVisible = !size.isEmpty();
            if (this.columnsVisible[position] == nowVisible) continue;
            this.columnsVisible[position] = nowVisible;
            if (!nowVisible) continue;
            this.runForVisibleRows(new TableGroupRowRunner(){

                public void run(TableRowCore row) {
                    TableCellCore cell = row.getTableCellCore(tc.getName());
                    cell.invalidate();
                    cell.redraw();
                }
            });
        }
    }

    public boolean isColumnVisible(TableColumn column) {
        int position = column.getPosition();
        if (position < 0 || position >= this.columnsVisible.length) {
            return false;
        }
        return this.columnsVisible[position];
    }

    protected void initializeTableColumns(final Table table) {
        TableColumnCore tc;
        int i;
        org.eclipse.swt.widgets.TableColumn[] oldColumns = table.getColumns();
        if (SWT.getVersion() >= 3100) {
            for (i = 0; i < oldColumns.length; ++i) {
                oldColumns[i].removeListener(10, (Listener)this.columnMoveListener);
            }
        }
        for (i = oldColumns.length - 1; i >= 0; --i) {
            oldColumns[i].dispose();
        }
        this.columnPaddingAdjusted = false;
        ControlAdapter resizeListener = new ControlAdapter(){
            private boolean bInFunction = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void controlResized(ControlEvent e) {
                org.eclipse.swt.widgets.TableColumn column = (org.eclipse.swt.widgets.TableColumn)e.widget;
                if (column == null || column.isDisposed() || this.bInFunction) {
                    return;
                }
                try {
                    this.bInFunction = true;
                    TableColumnCore tc = (TableColumnCore)column.getData("TableColumnCore");
                    if (tc != null) {
                        Long lPadding = (Long)column.getData("widthOffset");
                        int padding = lPadding == null ? 0 : lPadding.intValue();
                        tc.setWidth(column.getWidth() - padding);
                    }
                    int columnNumber = table.indexOf(column);
                    TableViewSWTImpl.this.locationChanged(columnNumber);
                }
                finally {
                    this.bInFunction = false;
                }
            }
        };
        boolean bl = this.bSkipFirstColumn = this.bSkipFirstColumn && !Constants.isOSX;
        if (this.bSkipFirstColumn) {
            org.eclipse.swt.widgets.TableColumn tc2 = new org.eclipse.swt.widgets.TableColumn(table, 0);
            tc2.setWidth(0);
            tc2.setResizable(false);
            tc2.setMoveable(false);
        }
        TableColumnCore[] tmpColumnsOrdered = new TableColumnCore[this.tableColumns.length];
        int columnOrderPos = 0;
        Arrays.sort(this.tableColumns, TableColumnManager.getTableColumnOrderComparator());
        for (int i2 = 0; i2 < this.tableColumns.length; ++i2) {
            int position = this.tableColumns[i2].getPosition();
            if (position == -1 || !this.tableColumns[i2].isVisible()) continue;
            new org.eclipse.swt.widgets.TableColumn(table, 0);
            tmpColumnsOrdered[columnOrderPos++] = this.tableColumns[i2];
        }
        int numSWTColumns = table.getColumnCount();
        int iNewLength = numSWTColumns - (this.bSkipFirstColumn ? 1 : 0);
        this.columnsOrdered = new TableColumnCore[iNewLength];
        System.arraycopy(tmpColumnsOrdered, 0, this.columnsOrdered, 0, iNewLength);
        this.columnsVisible = new boolean[this.tableColumns.length];
        ColumnSelectionListener columnSelectionListener = new ColumnSelectionListener();
        int swtColumnPos = this.bSkipFirstColumn ? 1 : 0;
        for (int i3 = 0; i3 < this.tableColumns.length; ++i3) {
            int position = this.tableColumns[i3].getPosition();
            if (position == -1 || !this.tableColumns[i3].isVisible()) continue;
            this.columnsVisible[i3] = true;
            String sName = this.tableColumns[i3].getName();
            if (swtColumnPos >= numSWTColumns) {
                Debug.out("Incorrect table column setup, skipping column '" + sName + "', position=" + swtColumnPos + ";numCols=" + numSWTColumns);
                continue;
            }
            org.eclipse.swt.widgets.TableColumn column = table.getColumn(swtColumnPos);
            try {
                column.setMoveable(true);
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            column.setAlignment(CoreTableColumn.getSWTAlign(this.tableColumns[i3].getAlignment()));
            Messages.setLanguageText((Widget)column, this.tableColumns[i3].getTitleLanguageKey());
            column.setWidth(this.tableColumns[i3].getWidth());
            if (this.tableColumns[i3].getMinWidth() == this.tableColumns[i3].getMaxWidth() && this.tableColumns[i3].getMinWidth() > 0) {
                column.setResizable(false);
            }
            column.setData("TableColumnCore", (Object)this.tableColumns[i3]);
            column.setData("configName", (Object)("Table." + this.sTableID + "." + sName));
            column.setData("Name", (Object)sName);
            column.addControlListener((ControlListener)resizeListener);
            column.addListener(13, (Listener)columnSelectionListener);
            ++swtColumnPos;
        }
        TableColumnManager tcManager = TableColumnManager.getInstance();
        String sSortColumn = tcManager.getDefaultSortColumnName(this.sTableID);
        if (sSortColumn == null) {
            sSortColumn = this.sDefaultSortOn;
        }
        if ((tc = tcManager.getTableColumnCore(this.sTableID, sSortColumn)) == null) {
            tc = this.tableColumns[0];
        }
        this.sortColumn = tc;
        this.fixAlignment(tc, true);
        this.changeColumnIndicator();
        if (SWT.getVersion() >= 3100) {
            Listener columnResizeListener = !COLUMN_CLICK_DELAY ? null : new Listener(){

                public void handleEvent(Event event2) {
                    TableViewSWTImpl.this.lLastColumnResizeOn = System.currentTimeMillis();
                }
            };
            org.eclipse.swt.widgets.TableColumn[] columns = table.getColumns();
            for (int i4 = 0; i4 < columns.length; ++i4) {
                org.eclipse.swt.widgets.TableColumn column = columns[i4];
                column.addListener(10, (Listener)this.columnMoveListener);
                if (!COLUMN_CLICK_DELAY) continue;
                column.addListener(11, columnResizeListener);
            }
        }
        this.columnVisibilitiesChanged = true;
    }

    public void fixAlignment(TableColumnCore tc, boolean sorted) {
        if (Constants.isOSX) {
            if (this.table.isDisposed()) {
                return;
            }
            int[] columnOrder = this.table.getColumnOrder();
            int i = tc.getPosition() - (this.bSkipFirstColumn ? 1 : 0);
            if (i < 0 || i >= columnOrder.length) {
                return;
            }
            org.eclipse.swt.widgets.TableColumn swtColumn = this.table.getColumn(columnOrder[i]);
            if (swtColumn != null) {
                if (swtColumn.getAlignment() == 131072 && sorted) {
                    swtColumn.setText("   " + swtColumn.getText() + "   ");
                } else {
                    swtColumn.setText(swtColumn.getText().trim());
                }
            }
        }
    }

    public Menu createMenu() {
        Menu menu = new Menu((Decorations)this.tableComposite.getShell(), 8);
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu menu) {
                TableViewSWTImpl.this.fillMenu(menu);
                TableViewSWTImpl.this.addThisColumnSubMenu(TableViewSWTImpl.this.getColumnNo(TableViewSWTImpl.this.iMouseX));
            }
        });
        return menu;
    }

    public void fillMenu(Menu menu) {
        Object[] listeners = this.listenersMenuFill.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TableViewSWTMenuFillListener l = (TableViewSWTMenuFillListener)listeners[i];
            l.fillMenu(menu);
        }
        MenuItem itemChangeTable = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemChangeTable, "MyTorrentsView.menu.editTableColumns");
        Utils.setMenuItemImage(itemChangeTable, "columns");
        itemChangeTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableViewSWTImpl.this.showColumnEditor();
            }
        });
        this.menuThisColumn = new Menu((Decorations)this.tableComposite.getShell(), 4);
        MenuItem itemThisColumn = new MenuItem(menu, 64);
        itemThisColumn.setMenu(this.menuThisColumn);
        boolean enable_items = this.table != null && this.table.getSelection().length > 0;
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] items = TableContextMenuManager.getInstance().getAllAsArray(this.sTableID);
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items = null;
        menu_items = "MySeeders".equals(this.sTableID) || "MyTorrents".equals(this.sTableID) ? MenuItemManager.getInstance().getAllAsArray("download_context") : MenuItemManager.getInstance().getAllAsArray((String)null);
        if (items.length > 0 || menu_items.length > 0) {
            new MenuItem(menu, 2);
            if (menu_items != null) {
                MenuBuildUtils.addPluginMenuItems(this.getComposite(), menu_items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(this.getSelectedDataSources(false)));
            }
            if (items.length > 0) {
                MenuBuildUtils.addPluginMenuItems(this.getComposite(), items, menu, true, enable_items, new MenuBuildUtils.PluginMenuController(){

                    public Listener makeSelectionListener(final org.gudy.azureus2.plugins.ui.menus.MenuItem plugin_menu_item) {
                        return new TableSelectedRowsListener(TableViewSWTImpl.this){

                            public boolean run(TableRowCore[] rows) {
                                if (rows.length != 0) {
                                    ((TableContextMenuItemImpl)plugin_menu_item).invokeListenersMulti(rows);
                                }
                                return true;
                            }
                        };
                    }

                    public void notifyFillListeners(org.gudy.azureus2.plugins.ui.menus.MenuItem menu_item) {
                        ((TableContextMenuItemImpl)menu_item).invokeMenuWillBeShownListeners(TableViewSWTImpl.this.getSelectedRows());
                    }
                });
            }
        }
    }

    void showColumnEditor() {
        new TableColumnEditorWindow(this.table.getShell(), this.sTableID, this.tableColumns, this.getFocusedRow(), this.dataSourceType, TableStructureEventDispatcher.getInstance(this.sTableID));
    }

    private void addThisColumnSubMenu(int iColumn) {
        if (this.menuThisColumn == null || this.menuThisColumn.isDisposed()) {
            return;
        }
        MenuItem[] oldItems = this.menuThisColumn.getItems();
        for (int i = 0; i < oldItems.length; ++i) {
            oldItems[i].dispose();
        }
        MenuItem item = this.menuThisColumn.getParentItem();
        if (iColumn == -1) {
            item.setEnabled(false);
            item.setText(MessageText.getString("GenericText.column"));
            return;
        }
        item.setEnabled(true);
        final org.eclipse.swt.widgets.TableColumn tcColumn = this.table.getColumn(iColumn);
        item.setText("'" + tcColumn.getText() + "' " + MessageText.getString("GenericText.column"));
        this.menu.setData("ColumnNo", (Object)new Long(iColumn));
        this.menu.setData("column", (Object)tcColumn);
        String sColumnName = (String)tcColumn.getData("Name");
        if (sColumnName != null) {
            Object[] listeners = this.listenersMenuFill.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                TableViewSWTMenuFillListener l = (TableViewSWTMenuFillListener)listeners[i];
                l.addThisColumnSubMenu(sColumnName, this.menuThisColumn);
            }
        }
        if (this.menuThisColumn.getItemCount() > 0) {
            new MenuItem(this.menuThisColumn, 2);
        }
        item = new MenuItem(this.menuThisColumn, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.sort");
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int iColumn = ((Long)TableViewSWTImpl.this.menu.getData("ColumnNo")).intValue();
                TableViewSWTImpl.this.table.getColumn(iColumn).notifyListeners(13, new Event());
            }
        });
        final MenuItem at_item = new MenuItem(this.menuThisColumn, 32);
        Messages.setLanguageText((Widget)at_item, "MyTorrentsView.menu.thisColumn.autoTooltip");
        at_item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                org.eclipse.swt.widgets.TableColumn tc = (org.eclipse.swt.widgets.TableColumn)TableViewSWTImpl.this.menu.getData("column");
                TableColumnCore tcc = (TableColumnCore)tc.getData("TableColumnCore");
                tcc.setAutoTooltip(at_item.getSelection());
                tcc.invalidateCells();
            }
        });
        at_item.setSelection(((TableColumnCore)tcColumn.getData("TableColumnCore")).doesAutoTooltip());
        item = new MenuItem(this.menuThisColumn, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.remove");
        item.setEnabled(false);
        item = new MenuItem(this.menuThisColumn, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.toClipboard");
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                String sToClipboard = "";
                int iColumn = ((Long)TableViewSWTImpl.this.menu.getData("ColumnNo")).intValue();
                org.eclipse.swt.widgets.TableColumn tc = (org.eclipse.swt.widgets.TableColumn)TableViewSWTImpl.this.menu.getData("column");
                if (tc == null) {
                    return;
                }
                String columnName = (String)tcColumn.getData("Name");
                if (columnName == null) {
                    return;
                }
                TableItem[] tis = TableViewSWTImpl.this.table.getSelection();
                for (int i = 0; i < tis.length; ++i) {
                    TableRowCore row;
                    TableCellCore cell;
                    if (i != 0) {
                        sToClipboard = sToClipboard + "\n";
                    }
                    if ((cell = (row = (TableRowCore)tis[i].getData("TableRow")).getTableCellCore(columnName)) == null) continue;
                    sToClipboard = sToClipboard + cell.getText();
                }
                if (sToClipboard == null || sToClipboard.length() == 0) {
                    return;
                }
                new Clipboard(TableViewSWTImpl.this.mainComposite.getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
        TableColumnCore tc = (TableColumnCore)tcColumn.getData("TableColumnCore");
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] items = tc.getContextMenuItems();
        if (items.length > 0) {
            new MenuItem(this.menuThisColumn, 2);
            MenuBuildUtils.addPluginMenuItems(this.getComposite(), items, this.menuThisColumn, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(this.getSelectedDataSources(true)));
        }
    }

    public Composite getComposite() {
        return this.mainComposite;
    }

    public Composite getTableComposite() {
        return this.tableComposite;
    }

    public IView getActiveSubView() {
        if (!this.bEnableTabViews || this.tabFolder == null || this.tabFolder.isDisposed() || this.tabFolder.getMinimized()) {
            return null;
        }
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            return (IView)item.getData("IView");
        }
        return null;
    }

    public void refreshSelectedSubView() {
        IView view = this.getActiveSubView();
        if (view != null) {
            view.refresh();
        }
    }

    public void refreshTable(final boolean bForceSort) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this._refreshTable(bForceSort);
                if (TableViewSWTImpl.this.bEnableTabViews && TableViewSWTImpl.this.tabFolder != null && !TableViewSWTImpl.this.tabFolder.isDisposed() && !TableViewSWTImpl.this.tabFolder.getMinimized()) {
                    TableViewSWTImpl.this.refreshSelectedSubView();
                }
            }
        });
        this.triggerTableRefreshListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _refreshTable(boolean bForceSort) {
        long lTimeDiff;
        boolean bWillSort;
        if (this.table == null) {
            return;
        }
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        if (this.checkColumnWidthsEvery != 0 && this.loopFactor % this.checkColumnWidthsEvery == 0) {
            org.eclipse.swt.widgets.TableColumn[] tableColumnsSWT = this.table.getColumns();
            for (int i = 0; i < tableColumnsSWT.length; ++i) {
                TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                if (tc == null || tc.getWidth() == tableColumnsSWT[i].getWidth()) continue;
                tc.setWidth(tableColumnsSWT[i].getWidth());
                int columnNumber = this.table.indexOf(tableColumnsSWT[i]);
                this.locationChanged(columnNumber);
            }
        }
        if (this.columnVisibilitiesChanged) {
            this.updateColumnVisibilities();
        }
        final boolean bDoGraphics = this.loopFactor % this.graphicsUpdate == 0;
        boolean bl = bWillSort = bForceSort || this.reOrderDelay != 0 && this.loopFactor % this.reOrderDelay == 0;
        if (bWillSort) {
            if (bForceSort) {
                this.sortColumn.setLastSortValueChange(SystemTime.getCurrentTime());
            }
            this.sortColumn(true);
        }
        long lTimeStart = SystemTime.getMonotonousTime();
        this.runForAllRows(new TableGroupRowVisibilityRunner(){

            public void run(TableRowCore row, boolean bVisible) {
                row.refresh(bDoGraphics, bVisible);
            }
        });
        if (DEBUGADDREMOVE && (lTimeDiff = SystemTime.getMonotonousTime() - lTimeStart) > 500L) {
            this.debug(lTimeDiff + "ms to refresh rows");
        }
        ++this.loopFactor;
    }

    private void refreshVisibleRows() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.runForVisibleRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                row.setAlternatingBGColor(true);
                row.refresh(false, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataSourceQueue() {
        Object[] dataSourcesAdd = null;
        Object[] dataSourcesRemove = null;
        try {
            this.dataSourceToRow_mon.enter();
            if (this.dataSourcesToAdd.size() > 0) {
                if (this.dataSourcesToAdd.removeAll(this.dataSourcesToRemove) && DEBUGADDREMOVE) {
                    this.debug("Saved time by not adding a row that was removed");
                }
                dataSourcesAdd = this.dataSourcesToAdd.toArray();
                this.dataSourcesToAdd.clear();
            }
            if (this.dataSourcesToRemove.size() > 0) {
                dataSourcesRemove = this.dataSourcesToRemove.toArray();
                if (DEBUGADDREMOVE && dataSourcesRemove.length > 1) {
                    this.debug("Streamlining removing " + dataSourcesRemove.length + " rows");
                }
                this.dataSourcesToRemove.clear();
            }
        }
        finally {
            this.dataSourceToRow_mon.exit();
        }
        if (dataSourcesAdd != null && dataSourcesAdd.length > 0) {
            this.reallyAddDataSources(dataSourcesAdd);
            if (DEBUGADDREMOVE && dataSourcesAdd.length > 1) {
                this.debug("Streamlined adding " + dataSourcesAdd.length + " rows");
            }
        }
        if (dataSourcesRemove != null && dataSourcesRemove.length > 0) {
            this.reallyRemoveDataSources(dataSourcesRemove);
        }
    }

    private void locationChanged(final int iStartColumn) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.columnVisibilitiesChanged = true;
        this.runForAllRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                row.locationChanged(iStartColumn);
            }
        });
    }

    private void doPaint(final GC gc, final Rectangle dirtyArea) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.runForVisibleRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                if (!(row instanceof TableRowSWT)) {
                    return;
                }
                TableRowSWT rowSWT = (TableRowSWT)row;
                Rectangle bounds = rowSWT.getBounds();
                if (bounds.intersects(dirtyArea)) {
                    if (Constants.isWindowsVista) {
                        Image imgBG = new Image(gc.getDevice(), bounds.width, bounds.height);
                        gc.copyArea(imgBG, bounds.x, bounds.y);
                        rowSWT.setBackgroundImage(imgBG);
                    }
                    Color oldBG = (Color)row.getData("bgColor");
                    Color newBG = rowSWT.getBackground();
                    if (oldBG == null || !oldBG.equals((Object)newBG)) {
                        row.invalidate();
                        row.redraw();
                        row.setData("bgColor", newBG);
                    } else {
                        rowSWT.doPaint(gc, true);
                    }
                }
            }
        });
    }

    public void delete() {
        this.triggerLifeCycleListener(1);
        if (this.tabViews != null && this.tabViews.size() > 0) {
            for (int i = 0; i < this.tabViews.size(); ++i) {
                IView view = (IView)this.tabViews.get(i);
                if (view == null) continue;
                view.delete();
            }
        }
        TableStructureEventDispatcher.getInstance(this.sTableID).removeListener(this);
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (tcManager != null) {
            tcManager.saveTableColumns(this.dataSourceType, this.sTableID);
        }
        if (this.table != null && !this.table.isDisposed()) {
            this.table.dispose();
        }
        this.removeAllTableRows();
        configMan.removeParameterListener("ReOrder Delay", this);
        configMan.removeParameterListener("Graphics Update", this);
        Colors.getInstance().removeColorsChangedListener(this);
        this.processDataSourceQueueCallback = null;
        Composite comp2 = this.getComposite();
        if (comp2 != null && !comp2.isDisposed()) {
            comp2.dispose();
        }
    }

    public void updateLanguage() {
        if (this.tabViews != null && this.tabViews.size() > 0) {
            for (int i = 0; i < this.tabViews.size(); ++i) {
                IView view = (IView)this.tabViews.get(i);
                if (view == null) continue;
                view.updateLanguage();
            }
        }
    }

    public void addDataSource(Object datasource, boolean immediate) {
        this.addDataSource(datasource);
    }

    public void addDataSource(Object dataSource) {
        this.addDataSources(new Object[]{dataSource});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSources(Object[] dataSources) {
        if (dataSources == null) {
            return;
        }
        try {
            this.dataSourceToRow_mon.enter();
            int count = 0;
            for (int i = 0; i < dataSources.length; ++i) {
                if (dataSources[i] == null || this.dataSourcesToAdd.contains(dataSources[i])) continue;
                ++count;
                this.dataSourcesToAdd.add(dataSources[i]);
            }
            if (DEBUGADDREMOVE) {
                this.debug("Queued " + count + " of " + dataSources.length + " dataSources to add.  Total Queued: " + this.dataSourcesToAdd.size());
            }
        }
        finally {
            this.dataSourceToRow_mon.exit();
        }
        this.refreshenProcessDataSourcesTimer();
    }

    private void refreshenProcessDataSourcesTimer() {
        boolean processQueueImmediately;
        if (this.bReallyAddingDataSources || this.processDataSourceQueueCallback == null) {
            return;
        }
        if (this.cellEditNotifier != null) {
            this.cellEditNotifier.sourcesChanged();
        }
        if (processQueueImmediately = Utils.addDataSourceAggregated(this.processDataSourceQueueCallback)) {
            this.processDataSourceQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyAddDataSources(Object[] dataSources) {
        if (this.mainComposite == null || this.table == null || this.mainComposite.isDisposed() || this.table.isDisposed()) {
            return;
        }
        this.bReallyAddingDataSources = true;
        if (DEBUGADDREMOVE) {
            this.debug(">> Add " + dataSources.length + " rows;");
        }
        Object[] remainingDataSources = null;
        Object[] doneDataSources = dataSources;
        try {
            this.dataSourceToRow_mon.enter();
            long lStartTime = SystemTime.getCurrentTime();
            for (int i = 0; i < dataSources.length; ++i) {
                if (dataSources[i] == null) continue;
                if (SystemTime.getCurrentTime() - lStartTime > 1000L) {
                    int iNewSize = dataSources.length - i;
                    if (DEBUGADDREMOVE) {
                        this.debug("Breaking off adding datasources to map after " + i + " took " + (SystemTime.getCurrentTime() - lStartTime) + "ms; # remaining: " + iNewSize);
                    }
                    remainingDataSources = new Object[iNewSize];
                    doneDataSources = new Object[i];
                    System.arraycopy(dataSources, i, remainingDataSources, 0, iNewSize);
                    System.arraycopy(dataSources, 0, doneDataSources, 0, i);
                    break;
                }
                if (this.mapDataSourceToRow.containsKey(dataSources[i])) {
                    dataSources[i] = null;
                    continue;
                }
                TableRowImpl row = new TableRowImpl(this, this.table, this.sTableID, this.columnsOrdered, dataSources[i], this.bSkipFirstColumn);
                this.mapDataSourceToRow.put(dataSources[i], row);
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error while added row to Table " + this.sTableID, e));
        }
        finally {
            this.dataSourceToRow_mon.exit();
        }
        if (DEBUGADDREMOVE) {
            this.debug("-- Add " + doneDataSources.length + " rows;");
        }
        if (remainingDataSources == null) {
            this.addDataSourcesToSWT(doneDataSources, true);
        } else {
            final Object[] fDoneDataSources = doneDataSources;
            final Object[] fRemainingDataSources = remainingDataSources;
            Utils.execSWTThread((Runnable)new AERunnable(){

                public void runSupport() {
                    TableViewSWTImpl.this.addDataSourcesToSWT(fDoneDataSources, false);
                    TableViewSWTImpl.this.reallyAddDataSources(fRemainingDataSources);
                }
            }, false);
        }
    }

    private void addDataSourcesToSWT(final Object[] dataSources, boolean async) {
        try {
            if (DEBUGADDREMOVE) {
                this.debug("-- Add " + dataSources.length + " rows to SWT " + (async ? " async " : " NOW"));
            }
            if (async) {
                this.table.getDisplay().asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        TableViewSWTImpl.this._addDataSourcesToSWT(dataSources);
                    }
                });
            } else {
                Utils.execSWTThread((Runnable)new AERunnable(){

                    public void runSupport() {
                        TableViewSWTImpl.this._addDataSourcesToSWT(dataSources);
                    }
                }, false);
            }
        }
        catch (Exception e) {
            this.bReallyAddingDataSources = false;
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addDataSourcesToSWT(Object[] dataSources) {
        if (this.table == null || this.table.isDisposed()) {
            this.bReallyAddingDataSources = false;
            return;
        }
        this.mainComposite.getParent().setCursor(this.table.getDisplay().getSystemCursor(1));
        TableRowCore[] selectedRows = this.getSelectedRows();
        boolean bBrokeEarly = false;
        boolean bReplacedVisible = false;
        boolean bWas0Rows = this.table.getItemCount() == 0;
        try {
            this.dataSourceToRow_mon.enter();
            this.sortedRows_mon.enter();
            if (DEBUGADDREMOVE) {
                this.debug("-- Add " + dataSources.length + " rows to SWT");
            }
            this.table.setItemCount(this.sortedRows.size() + dataSources.length);
            long lStartTime = SystemTime.getCurrentTime();
            int iTopIndex = this.table.getTopIndex();
            int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
            for (int i = 0; i < dataSources.length; ++i) {
                TableCellSWT cell;
                Object dataSource = dataSources[i];
                if (dataSource == null) continue;
                if (SystemTime.getCurrentTime() - lStartTime > 800L) {
                    int iNewSize = dataSources.length - i;
                    if (DEBUGADDREMOVE) {
                        this.debug("Breaking off adding datasources to SWT after " + i + " took " + (SystemTime.getCurrentTime() - lStartTime) + "ms; # remaining: " + iNewSize);
                    }
                    Object[] remainingDataSources = new Object[iNewSize];
                    System.arraycopy(dataSources, i, remainingDataSources, 0, iNewSize);
                    this.addDataSourcesToSWT(remainingDataSources, true);
                    bBrokeEarly = true;
                    break;
                }
                TableRowImpl row = (TableRowImpl)this.mapDataSourceToRow.get(dataSource);
                if (row == null || row.getIndex() >= 0) continue;
                if (this.sortColumn != null && (cell = row.getTableCellSWT(this.sortColumn.getName())) != null) {
                    try {
                        cell.invalidate();
                        cell.refresh(true);
                    }
                    catch (Exception e) {
                        Logger.log(new LogEvent(LOGID, "Minor error adding a row to table " + this.sTableID, e));
                    }
                }
                try {
                    int index = 0;
                    if (this.sortedRows.size() > 0) {
                        TableRowSWT lastRow = (TableRowSWT)this.sortedRows.get(this.sortedRows.size() - 1);
                        if (this.sortColumn.compare(row, lastRow) >= 0) {
                            index = this.sortedRows.size();
                            this.sortedRows.add(row);
                            if (DEBUGADDREMOVE) {
                                this.debug("Adding new row to bottom");
                            }
                        } else {
                            index = Collections.binarySearch(this.sortedRows, row, this.sortColumn);
                            if (index < 0) {
                                index = -1 * index - 1;
                            }
                            if (index > this.sortedRows.size()) {
                                index = this.sortedRows.size();
                            }
                            if (DEBUGADDREMOVE) {
                                this.debug("Adding new row at position " + index + " of " + (this.sortedRows.size() - 1));
                            }
                            this.sortedRows.add(index, row);
                        }
                    } else {
                        if (DEBUGADDREMOVE) {
                            this.debug("Adding new row to bottom (1st Entry)");
                        }
                        index = this.sortedRows.size();
                        this.sortedRows.add(row);
                    }
                    this.triggerListenerRowAdded(row);
                    if (!bReplacedVisible && index >= iTopIndex && index <= iBottomIndex) {
                        bReplacedVisible = true;
                    }
                    row.setIconSize(this.ptIconSize);
                    continue;
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "Error adding a row to table " + this.sTableID, e));
                    try {
                        if (this.sortedRows.contains(row)) continue;
                        this.sortedRows.add(row);
                        continue;
                    }
                    catch (Exception e2) {
                        Debug.out(e2);
                    }
                }
            }
            if (DEBUGADDREMOVE) {
                this.debug("Adding took " + (SystemTime.getCurrentTime() - lStartTime) + "ms");
            }
            if (this.table.getItemCount() > this.sortedRows.size() && !bBrokeEarly) {
                this.table.setItemCount(this.sortedRows.size());
            }
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error while adding row to Table " + this.sTableID, e));
        }
        finally {
            this.sortedRows_mon.exit();
            this.dataSourceToRow_mon.exit();
            if (!bBrokeEarly) {
                this.bReallyAddingDataSources = false;
                this.refreshenProcessDataSourcesTimer();
            }
        }
        if (!bBrokeEarly || bReplacedVisible) {
            this.fillRowGaps(false);
            if (bReplacedVisible) {
                this.lastTopIndex = 0;
                this.lastBottomIndex = -1;
                this.visibleRowsChanged();
            }
        }
        if (!this.columnPaddingAdjusted && this.table.getItemCount() > 0 && bWas0Rows) {
            org.eclipse.swt.widgets.TableColumn[] tableColumnsSWT = this.table.getColumns();
            TableItem item = this.table.getItem(0);
            int len = Constants.isUnix ? tableColumnsSWT.length - 1 : tableColumnsSWT.length;
            for (int i = 0; i < len; ++i) {
                int ofs;
                TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                if (tc == null) continue;
                Rectangle bounds = item.getBounds(i);
                int tcWidth = tc.getWidth();
                if (tcWidth == 0 || bounds.width == 0 || (ofs = tc.getWidth() - bounds.width) <= 0) continue;
                tableColumnsSWT[i].setResizable(true);
                tableColumnsSWT[i].setData("widthOffset", (Object)new Long(ofs));
                tc.triggerColumnSizeChange();
            }
            this.columnPaddingAdjusted = true;
        }
        this.setSelectedRows(selectedRows);
        if (DEBUGADDREMOVE) {
            this.debug("<< " + this.sortedRows.size());
        }
        this.mainComposite.getParent().setCursor(null);
    }

    public void removeDataSource(Object dataSource, boolean immediate) {
        this.removeDataSources(new Object[]{dataSource});
    }

    public void removeDataSource(Object dataSource) {
        this.removeDataSources(new Object[]{dataSource});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSources(Object[] dataSources) {
        if (dataSources == null) {
            return;
        }
        try {
            this.dataSourceToRow_mon.enter();
            for (int i = 0; i < dataSources.length; ++i) {
                this.dataSourcesToRemove.add(dataSources[i]);
            }
            if (DEBUGADDREMOVE) {
                this.debug("Queued " + dataSources.length + " dataSources to remove.  Total Queued: " + this.dataSourcesToRemove.size());
            }
        }
        finally {
            this.dataSourceToRow_mon.exit();
        }
        this.refreshenProcessDataSourcesTimer();
    }

    private void reallyRemoveDataSources(Object[] dataSources) {
        long lStart;
        boolean ok;
        if (DEBUGADDREMOVE) {
            this.debug(">> Remove rows");
        }
        if (!(ok = Utils.execSWTThread(new AERunnable(lStart = SystemTime.getCurrentTime(), dataSources){
            final /* synthetic */ long val$lStart;
            final /* synthetic */ Object[] val$dataSources;
            {
                this.val$lStart = l;
                this.val$dataSources = objectArray;
            }

            public void runSupport() {
                if (TableViewSWTImpl.this.table == null || TableViewSWTImpl.this.table.isDisposed()) {
                    return;
                }
                int numSelected = TableViewSWTImpl.this.table.getSelectionCount();
                TableViewSWTImpl.this.mainComposite.getParent().setCursor(TableViewSWTImpl.this.table.getDisplay().getSystemCursor(1));
                StringBuffer sbWillRemove = null;
                if (TableViewSWT.DEBUGADDREMOVE) {
                    TableViewSWTImpl.this.debug(">>> Remove rows.  Start w/" + TableViewSWTImpl.this.mapDataSourceToRow.size() + "ds; tc=" + TableViewSWTImpl.this.table.getItemCount() + ";" + (SystemTime.getCurrentTime() - this.val$lStart) + "ms wait");
                    sbWillRemove = new StringBuffer("Will soon remove row #");
                }
                ArrayList<TableRowSWT> itemsToRemove = new ArrayList<TableRowSWT>();
                ArrayList<Long> swtItemsToRemove = new ArrayList<Long>();
                int iTopIndex = TableViewSWTImpl.this.table.getTopIndex();
                int iBottomIndex = Utils.getTableBottomIndex(TableViewSWTImpl.this.table, iTopIndex);
                boolean bRefresh = false;
                for (int i = 0; i < this.val$dataSources.length; ++i) {
                    TableRowSWT item;
                    if (this.val$dataSources[i] == null || (item = (TableRowSWT)TableViewSWTImpl.this.mapDataSourceToRow.get(this.val$dataSources[i])) == null) continue;
                    int n = TableViewSWTImpl.this.sortedRows.indexOf(item);
                    if (!bRefresh) {
                        boolean bl = bRefresh = n >= iTopIndex && n <= iBottomIndex;
                    }
                    if (TableViewSWT.DEBUGADDREMOVE) {
                        if (i != 0) {
                            sbWillRemove.append(", ");
                        }
                        sbWillRemove.append(n);
                    }
                    if (n < 0) continue;
                    swtItemsToRemove.add(new Long(n));
                }
                if (TableViewSWT.DEBUGADDREMOVE) {
                    TableViewSWTImpl.this.debug(sbWillRemove.toString());
                    TableViewSWTImpl.this.debug("#swtItemsToRemove=" + swtItemsToRemove.size());
                }
                boolean hasSelected = false;
                for (int i = 0; i < this.val$dataSources.length; ++i) {
                    TableRowSWT tableRowSWT;
                    if (this.val$dataSources[i] == null || (tableRowSWT = (TableRowSWT)TableViewSWTImpl.this.mapDataSourceToRow.remove(this.val$dataSources[i])) == null) continue;
                    if (tableRowSWT.isSelected()) {
                        hasSelected = true;
                    }
                    itemsToRemove.add(tableRowSWT);
                    TableViewSWTImpl.this.sortedRows.remove(tableRowSWT);
                    TableViewSWTImpl.this.triggerListenerRowRemoved(tableRowSWT);
                }
                if (TableViewSWT.DEBUGADDREMOVE) {
                    TableViewSWTImpl.this.debug("-- Removed from map and list");
                }
                if (swtItemsToRemove.size() > 0) {
                    TableViewSWTImpl.this.table.setItemCount(TableViewSWTImpl.this.mapDataSourceToRow.size());
                }
                if (TableViewSWT.DEBUGADDREMOVE) {
                    TableViewSWTImpl.this.debug("-- Removed from SWT");
                }
                for (TableRowCore tableRowCore : itemsToRemove) {
                    tableRowCore.delete();
                }
                if (bRefresh) {
                    TableViewSWTImpl.this.fillRowGaps(false);
                    TableViewSWTImpl.this.refreshVisibleRows();
                }
                if (TableViewSWT.DEBUGADDREMOVE) {
                    TableViewSWTImpl.this.debug("<< Remove " + itemsToRemove.size() + " rows. now " + TableViewSWTImpl.this.mapDataSourceToRow.size() + "ds; tc=" + TableViewSWTImpl.this.table.getItemCount());
                }
                TableViewSWTImpl.this.mainComposite.getParent().setCursor(null);
                if (numSelected != TableViewSWTImpl.this.table.getSelectionCount()) {
                    TableViewSWTImpl.this.triggerDeselectionListeners(new TableRowCore[0]);
                }
                if (hasSelected) {
                    TableViewSWTImpl.this.triggerSelectionListeners(TableViewSWTImpl.this.getSelectedRows());
                }
            }
        }))) {
            for (int i = 0; i < dataSources.length; ++i) {
                if (dataSources[i] == null) continue;
                TableRowSWT item = (TableRowSWT)this.mapDataSourceToRow.get(dataSources[i]);
                this.mapDataSourceToRow.remove(dataSources[i]);
                if (item == null) continue;
                this.sortedRows.remove(item);
                item.delete();
            }
            this.fillRowGaps(false);
            if (DEBUGADDREMOVE) {
                this.debug("<< Remove 1 row, noswt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTableRows() {
        long lTimeDiff;
        long lTimeStart = System.currentTimeMillis();
        final TableRowCore[] rows = this.getRows();
        try {
            this.dataSourceToRow_mon.enter();
            this.sortedRows_mon.enter();
            this.mapDataSourceToRow.clear();
            this.sortedRows.clear();
            this.dataSourcesToAdd.clear();
            this.dataSourcesToRemove.clear();
            if (DEBUGADDREMOVE) {
                this.debug("removeAll");
            }
        }
        finally {
            this.sortedRows_mon.exit();
            this.dataSourceToRow_mon.exit();
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewSWTImpl.this.table != null && !TableViewSWTImpl.this.table.isDisposed()) {
                    TableViewSWTImpl.this.table.removeAll();
                }
                for (int i = 0; i < rows.length; ++i) {
                    rows[i].delete();
                }
            }
        });
        if (DEBUGADDREMOVE && (lTimeDiff = System.currentTimeMillis() - lTimeStart) > 10L) {
            this.debug("RemovaAll took " + lTimeDiff + "ms");
        }
    }

    public String getTableID() {
        return this.sTableID;
    }

    public void parameterChanged(String parameterName) {
        if (parameterName == null || parameterName.equals("Graphics Update")) {
            this.graphicsUpdate = configMan.getIntParameter("Graphics Update");
            return;
        }
        if (parameterName == null || parameterName.equals("ReOrder Delay")) {
            this.reOrderDelay = configMan.getIntParameter("ReOrder Delay");
            return;
        }
        if (parameterName == null || parameterName.startsWith("Color")) {
            this.tableInvalidate();
        }
    }

    public void tableStructureChanged() {
        this.triggerLifeCycleListener(1);
        this.removeAllTableRows();
        this.initializeTableColumns(this.table);
        this.refreshTable(false);
        this.triggerLifeCycleListener(0);
    }

    public void columnOrderChanged(int[] positions) {
        try {
            this.table.setColumnOrder(positions);
            this.updateColumnVisibilities();
        }
        catch (NoSuchMethodError e) {
            this.tableStructureChanged();
        }
    }

    public void columnSizeChanged(TableColumnCore tableColumn) {
        Long lOfs;
        int newWidth = tableColumn.getWidth();
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        org.eclipse.swt.widgets.TableColumn column = null;
        org.eclipse.swt.widgets.TableColumn[] tableColumnsSWT = this.table.getColumns();
        for (int i = 0; i < tableColumnsSWT.length; ++i) {
            if (tableColumnsSWT[i].getData("TableColumnCore") != tableColumn) continue;
            column = tableColumnsSWT[i];
            break;
        }
        if ((lOfs = (Long)column.getData("widthOffset")) != null) {
            newWidth += lOfs.intValue();
        }
        if (column.isDisposed() || column.getWidth() == newWidth) {
            return;
        }
        if (Constants.isUnix) {
            final int fNewWidth = newWidth;
            final org.eclipse.swt.widgets.TableColumn fTableColumn = column;
            column.getDisplay().asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (!fTableColumn.isDisposed()) {
                        fTableColumn.setWidth(fNewWidth);
                    }
                }
            });
        } else {
            column.setWidth(newWidth);
        }
    }

    public void columnInvalidate(TableColumnCore tableColumn) {
        this.columnInvalidate(tableColumn, true);
    }

    public void cellInvalidate(TableColumnCore tableColumn, Object data_source) {
        this.cellInvalidate(tableColumn, data_source, true);
    }

    public void columnRefresh(TableColumnCore tableColumn) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowVisibilityRunner(){

            public void run(TableRowCore row, boolean bVisible) {
                TableCellSWT cell = ((TableRowSWT)row).getTableCellSWT(sColumnName);
                if (cell != null) {
                    cell.refresh(true, bVisible);
                }
            }
        });
    }

    public void tableInvalidate() {
        this.runForAllRows(new TableGroupRowVisibilityRunner(){

            public void run(TableRowCore row, boolean bVisible) {
                row.invalidate();
                row.refresh(true, bVisible);
            }
        });
    }

    public void columnInvalidate(String sColumnName) {
        TableColumnCore tc = TableColumnManager.getInstance().getTableColumnCore(this.sTableID, sColumnName);
        if (tc != null) {
            this.columnInvalidate(tc, tc.getType() == 3);
        }
    }

    public void columnInvalidate(TableColumnCore tableColumn, final boolean bMustRefresh) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                TableCellSWT cell = ((TableRowSWT)row).getTableCellSWT(sColumnName);
                if (cell != null) {
                    cell.invalidate(bMustRefresh);
                }
            }
        });
    }

    public void cellInvalidate(TableColumnCore tableColumn, final Object data_source, final boolean bMustRefresh) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                TableCellSWT cell = ((TableRowSWT)row).getTableCellSWT(sColumnName);
                if (cell != null && cell.getDataSource() != null && cell.getDataSource().equals(data_source)) {
                    cell.invalidate(bMustRefresh);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCellCore[] getColumnCells(String sColumnName) {
        TableCellCore[] cells = new TableCellCore[this.sortedRows.size()];
        try {
            this.sortedRows_mon.enter();
            int i = 0;
            for (TableRowCore row : this.sortedRows) {
                cells[i++] = row.getTableCellCore(sColumnName);
            }
        }
        finally {
            this.sortedRows_mon.exit();
        }
        return cells;
    }

    public TableColumn getTableColumn(String sColumnName) {
        for (int i = 0; i < this.tableColumns.length; ++i) {
            TableColumnCore tc = this.tableColumns[i];
            if (!tc.getName().equals(sColumnName)) continue;
            return tc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRowCore[] getRows() {
        try {
            this.sortedRows_mon.enter();
            TableRowCore[] tableRowCoreArray = this.sortedRows.toArray(new TableRowCore[0]);
            return tableRowCoreArray;
        }
        finally {
            this.sortedRows_mon.exit();
        }
    }

    public TableRowCore getRow(Object dataSource) {
        return (TableRowCore)this.mapDataSourceToRow.get(dataSource);
    }

    public TableRowSWT getRowSWT(Object dataSource) {
        return (TableRowSWT)this.mapDataSourceToRow.get(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRowCore getRow(int iPos) {
        try {
            this.sortedRows_mon.enter();
            if (iPos >= 0 && iPos < this.sortedRows.size()) {
                TableRowCore row = (TableRowCore)this.sortedRows.get(iPos);
                if (row.getIndex() != iPos) {
                    row.setTableItem(iPos);
                }
                TableRowCore tableRowCore = row;
                return tableRowCore;
            }
        }
        finally {
            this.sortedRows_mon.exit();
        }
        return null;
    }

    protected TableRowCore getRowQuick(int iPos) {
        try {
            return (TableRowCore)this.sortedRows.get(iPos);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int indexOf(TableRowCore row) {
        int i = ((TableRowImpl)row).getRealIndex();
        if (i == -1 && (i = this.sortedRows.indexOf(row)) >= 0) {
            row.setTableItem(i);
        }
        return i;
    }

    private TableRowCore getRow(TableItem item) {
        try {
            Object o = item.getData("TableRow");
            if (o instanceof TableRowCore) {
                return (TableRowCore)o;
            }
            int iPos = this.table.indexOf(item);
            if (iPos >= 0 && iPos < this.sortedRows.size()) {
                TableRowSWT row = (TableRowSWT)this.sortedRows.get(iPos);
                if (row != null) {
                    row.setTableItem(iPos);
                }
                return row;
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    public int getRowCount() {
        return this.mapDataSourceToRow.size();
    }

    public Object[] getDataSources() {
        return this.mapDataSourceToRow.keySet().toArray();
    }

    public List getSelectedDataSourcesList() {
        return this.getSelectedDataSourcesList(true);
    }

    public List getSelectedDataSourcesList(final boolean bCoreDataSource) {
        final ArrayList l = new ArrayList();
        if (this.table == null || this.table.isDisposed()) {
            return l;
        }
        Utils.execSWTThread((Runnable)new AERunnable(){

            public void runSupport() {
                if (TableViewSWTImpl.this.table.isDisposed()) {
                    return;
                }
                TableItem[] tis = TableViewSWTImpl.this.table.getSelection();
                for (int i = 0; i < tis.length; ++i) {
                    TableRowSWT row = (TableRowSWT)TableViewSWTImpl.this.getRow(tis[i]);
                    if (row == null) {
                        TableViewSWTImpl.this.fillRowGaps(false);
                        row = (TableRowSWT)TableViewSWTImpl.this.getRow(tis[i]);
                        if (row == null) {
                            System.out.println("XXX Boo, row still null " + TableViewSWTImpl.this.table.indexOf(tis[i]) + ";sd=" + tis[i].getData("SD") + ";" + Debug.getCompressedStackTrace());
                        }
                    }
                    if (row == null || row.getDataSource(true) == null) continue;
                    l.add(row.getDataSource(bCoreDataSource));
                }
            }
        }, false);
        return l;
    }

    public Object[] getSelectedDataSources(Object[] a) {
        return this.getSelectedDataSourcesList().toArray(a);
    }

    public Object[] getSelectedDataSources() {
        return this.getSelectedDataSourcesList().toArray();
    }

    public Object[] getSelectedDataSources(boolean bCoreDataSource) {
        return this.getSelectedDataSourcesList(bCoreDataSource).toArray();
    }

    public TableRowCore[] getSelectedRows() {
        return this.getSelectedRowsList().toArray(new TableRowCore[0]);
    }

    public int getSelectedRowsSize() {
        if (this.table != null && !this.table.isDisposed()) {
            return this.table.getSelectionCount();
        }
        return 0;
    }

    public TableRowSWT[] getSelectedRowsSWT() {
        return this.getSelectedRowsList().toArray(new TableRowSWT[0]);
    }

    public List getSelectedRowsList() {
        ArrayList<TableRowSWT> l = new ArrayList<TableRowSWT>();
        if (this.table != null && !this.table.isDisposed()) {
            TableItem[] tis = this.table.getSelection();
            for (int i = 0; i < tis.length; ++i) {
                TableRowSWT row = (TableRowSWT)this.getRow(tis[i]);
                if (row == null || row.getDataSource(true) == null) continue;
                l.add(row);
            }
        }
        return l;
    }

    public TableRowCore getFocusedRow() {
        TableRowSWT[] selectedRows = this.getSelectedRowsSWT();
        if (selectedRows.length == 0) {
            return null;
        }
        return selectedRows[0];
    }

    public Object getFirstSelectedDataSource() {
        return this.getFirstSelectedDataSource(true);
    }

    public TableRowSWT[] getVisibleRows() {
        if (this.table == null || this.table.isDisposed()) {
            return new TableRowSWT[0];
        }
        int iTopIndex = this.table.getTopIndex();
        int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
        int size = iBottomIndex - iTopIndex + 1;
        if (size <= 0) {
            return new TableRowSWT[0];
        }
        TableRowSWT[] rows = new TableRowSWT[size];
        int pos = 0;
        for (int i = iTopIndex; i <= iBottomIndex; ++i) {
            TableRowSWT row;
            TableItem item = this.table.getItem(i);
            if (item == null || item.isDisposed() || (row = (TableRowSWT)this.getRow(item)) == null) continue;
            rows[pos++] = row;
        }
        if (pos <= rows.length) {
            TableRowSWT[] temp = new TableRowSWT[pos];
            System.arraycopy(rows, 0, temp, 0, pos);
            return temp;
        }
        return rows;
    }

    public Object getFirstSelectedDataSource(boolean bCoreObject) {
        if (this.table == null || this.table.isDisposed() || this.table.getSelectionCount() == 0) {
            return null;
        }
        TableRowCore row = this.getRow(this.table.getSelection()[0]);
        if (row == null) {
            return null;
        }
        return row.getDataSource(bCoreObject);
    }

    public void runForSelectedRows(TableGroupRowRunner runner) {
        TableRowCore[] rows;
        boolean ran;
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        TableItem[] tis = this.table.getSelection();
        ArrayList<TableRowCore> rows_to_use = new ArrayList<TableRowCore>(tis.length);
        for (int i = 0; i < tis.length; ++i) {
            TableRowCore row = this.getRow(tis[i]);
            if (row == null || rows_to_use == null) continue;
            rows_to_use.add(row);
        }
        if (rows_to_use != null && !(ran = runner.run(rows = rows_to_use.toArray(new TableRowCore[rows_to_use.size()])))) {
            for (int i = 0; i < rows.length; ++i) {
                TableRowCore row = rows[i];
                runner.run(row);
            }
        }
    }

    public void runForVisibleRows(TableGroupRowRunner runner) {
        TableRowCore[] rows = this.getVisibleRows();
        if (runner.run(rows)) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            runner.run(rows[i]);
        }
    }

    public void runForAllRows(TableGroupRowVisibilityRunner runner) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        TableRowCore[] rows = this.getRows();
        int iTopIndex = this.table.getTopIndex();
        int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
        for (int i = 0; i < rows.length; ++i) {
            runner.run(rows[i], i >= iTopIndex && i <= iBottomIndex);
        }
    }

    public void runForTableItems(List items, TableGroupRowRunner runner) {
        TableRowCore[] rows;
        boolean ran;
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        Iterator iter = items.iterator();
        ArrayList<TableRowSWT> rows_to_use = new ArrayList<TableRowSWT>(items.size());
        while (iter.hasNext()) {
            TableRowSWT row;
            TableItem tableItem = (TableItem)iter.next();
            if (tableItem.isDisposed() || (row = (TableRowSWT)this.getRow(tableItem)) == null) continue;
            rows_to_use.add(row);
        }
        if (rows_to_use != null && !(ran = runner.run(rows = rows_to_use.toArray(new TableRowCore[rows_to_use.size()])))) {
            for (int i = 0; i < rows.length; ++i) {
                TableRowCore row = rows[i];
                runner.run(row);
            }
        }
    }

    public void clipboardSelected() {
        String sToClipboard = "";
        for (int j = 0; j < this.table.getColumnCount(); ++j) {
            if (j != 0) {
                sToClipboard = sToClipboard + "\t";
            }
            sToClipboard = sToClipboard + this.table.getColumn(j).getText();
        }
        TableItem[] tis = this.table.getSelection();
        for (int i = 0; i < tis.length; ++i) {
            sToClipboard = sToClipboard + "\n";
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                if (j != 0) {
                    sToClipboard = sToClipboard + "\t";
                }
                sToClipboard = sToClipboard + tis[i].getText(j);
            }
        }
        new Clipboard(this.getComposite().getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
    }

    private int getColumnNo(int iMouseX) {
        int iColumn = -1;
        int itemCount = this.table.getItemCount();
        if (this.table.getItemCount() > 0) {
            int i;
            TableItem ti;
            int topIndex = this.table.getTopIndex();
            if (topIndex >= itemCount) {
                topIndex = itemCount - 1;
            }
            if ((ti = this.table.getItem(topIndex)).isDisposed()) {
                return -1;
            }
            int n = i = this.bSkipFirstColumn ? 1 : 0;
            while (i < this.table.getColumnCount()) {
                Rectangle cellBounds = ti.getBounds(i);
                if (iMouseX >= cellBounds.x && iMouseX < cellBounds.x + cellBounds.width && cellBounds.width > 0) {
                    iColumn = i;
                    break;
                }
                ++i;
            }
        }
        return iColumn;
    }

    public TableRowCore getRow(int x, int y) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        TableItem item = this.table.getItem(new Point(2, y));
        return this.getRow(item);
    }

    public TableCellSWT getTableCell(int x, int y) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        TableItem item = this.table.getItem(new Point(2, y));
        if (item == null) {
            return null;
        }
        TableRowSWT row = (TableRowSWT)this.getRow(item);
        if (row == null) {
            return null;
        }
        org.eclipse.swt.widgets.TableColumn tcColumn = this.table.getColumn(iColumn);
        String sCellName = (String)tcColumn.getData("Name");
        if (sCellName == null) {
            return null;
        }
        return row.getTableCellSWT(sCellName);
    }

    public TableRowSWT getTableRow(int x, int y) {
        TableItem item = this.table.getItem(new Point(2, y));
        if (item == null) {
            return null;
        }
        return (TableRowSWT)this.getRow(item);
    }

    private TableColumnCore getTableColumnByOffset(int x) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        org.eclipse.swt.widgets.TableColumn column = this.table.getColumn(iColumn);
        return (TableColumnCore)column.getData("TableColumnCore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate(IndentWriter writer) {
        writer.println("Diagnostics for " + this + " (" + this.sTableID + ")");
        try {
            this.dataSourceToRow_mon.enter();
            writer.println("DataSources scheduled to Add/Remove: " + this.dataSourcesToAdd.size() + "/" + this.dataSourcesToRemove.size());
            writer.println("TableView: " + this.mapDataSourceToRow.size() + " datasources");
            for (Object key : this.mapDataSourceToRow.keySet()) {
                writer.println("  " + key + " -> " + this.mapDataSourceToRow.get(key));
            }
            writer.println("# of SubViews: " + this.tabViews.size());
            writer.indent();
            try {
                for (IView view : this.tabViews) {
                    view.generateDiagnostics(writer);
                }
            }
            finally {
                writer.exdent();
            }
            writer.println("Columns:");
            writer.indent();
            try {
                org.eclipse.swt.widgets.TableColumn[] tableColumnsSWT = this.table.getColumns();
                int i = 0;
                while (true) {
                    if (i >= tableColumnsSWT.length) {
                        writer.exdent();
                        return;
                    }
                    TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                    if (tc != null) {
                        writer.println(tc.getName() + ";w=" + tc.getWidth() + ";w-offset=" + tableColumnsSWT[i].getData("widthOffset"));
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                return;
            }
            finally {
                writer.exdent();
            }
        }
        finally {
            this.dataSourceToRow_mon.exit();
        }
    }

    public boolean getSkipFirstColumn() {
        return this.bSkipFirstColumn;
    }

    public void setRowDefaultHeight(int iHeight) {
        if (this.ptIconSize == null) {
            this.ptIconSize = new Point(1, iHeight);
        } else {
            this.ptIconSize.y = iHeight;
        }
        this.bSkipFirstColumn = true;
    }

    public int getRowDefaultHeight() {
        if (this.ptIconSize == null) {
            return 0;
        }
        return this.ptIconSize.y;
    }

    public void setRowDefaultIconSize(Point size) {
        this.ptIconSize = size;
        this.bSkipFirstColumn = true;
    }

    public void addTabView(IView view) {
        if (view == null || this.tabFolder == null) {
            return;
        }
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setData("IView", (Object)view);
        Messages.setLanguageText((Widget)item, view.getData());
        view.initialize((Composite)this.tabFolder);
        item.setControl((Control)view.getComposite());
        this.tabViews.add(view);
    }

    private void fillRowGaps(boolean bForceDataRefresh) {
        this._sortColumn(bForceDataRefresh, true, true);
    }

    private void sortColumn(boolean bForceDataRefresh) {
        this._sortColumn(bForceDataRefresh, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sortColumn(boolean bForceDataRefresh, boolean bFillGapsOnly, boolean bFollowSelected) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        try {
            int i;
            this.sortColumn_mon.enter();
            int iNumMoves = 0;
            int iFocusIndex = this.table.getSelectionIndex();
            TableRowCore focusedRow = iFocusIndex == -1 ? null : this.getRow(iFocusIndex);
            int iTopIndex = this.table.getTopIndex();
            int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
            boolean allSelectedRowsVisible = true;
            int[] selectedRowIndices = this.table.getSelectionIndices();
            TableRowCore[] selectedRows = new TableRowCore[selectedRowIndices.length];
            for (i = 0; i < selectedRowIndices.length; ++i) {
                int index = selectedRowIndices[i];
                selectedRows[i] = this.getRow(this.table.getItem(index));
                if (!allSelectedRowsVisible || index >= iTopIndex && index <= iBottomIndex) continue;
                allSelectedRowsVisible = false;
            }
            try {
                int i2;
                int count;
                this.sortedRows_mon.enter();
                if (bForceDataRefresh && this.sortColumn != null) {
                    i = 0;
                    String sColumnID = this.sortColumn.getName();
                    for (TableRowSWT row : this.sortedRows) {
                        TableCellSWT cell = row.getTableCellSWT(sColumnID);
                        if (cell != null) {
                            cell.refresh(true, i >= iTopIndex && i <= iBottomIndex);
                        }
                        ++i;
                    }
                }
                if (!bFillGapsOnly && this.sortColumn != null && this.sortColumn.getLastSortValueChange() > this.lLastSortedOn) {
                    this.lLastSortedOn = SystemTime.getCurrentTime();
                    Collections.sort(this.sortedRows, this.sortColumn);
                }
                if (iBottomIndex >= (count = this.sortedRows.size())) {
                    iBottomIndex = count - 1;
                }
                if (this.bTableVirtual && allSelectedRowsVisible) {
                    for (i2 = 0; i2 < this.sortedRows.size(); ++i2) {
                        boolean visible;
                        TableRowSWT row = (TableRowSWT)this.sortedRows.get(i2);
                        boolean bl = visible = i2 >= iTopIndex && i2 <= iBottomIndex;
                        if (visible) {
                            if (!row.setTableItem(i2)) continue;
                            row.setAlternatingBGColor(true);
                            ++iNumMoves;
                            continue;
                        }
                        if (!(row instanceof TableRowImpl)) continue;
                        ((TableRowImpl)row).setShown(visible, false);
                    }
                } else {
                    for (i2 = 0; i2 < this.sortedRows.size(); ++i2) {
                        TableRowSWT row;
                        boolean visible = i2 >= iTopIndex && i2 <= iBottomIndex;
                        row = (TableRowSWT)this.sortedRows.get(i2);
                        if (row.setTableItem(i2, visible)) {
                            ++iNumMoves;
                            continue;
                        }
                        if (!(row instanceof TableRowImpl)) continue;
                        ((TableRowImpl)row).setShown(visible, false);
                    }
                }
            }
            finally {
                this.sortedRows_mon.exit();
            }
            if (focusedRow != null) {
                int pos = selectedRows.length == 1 ? 0 : 1;
                int numSame = 0;
                int[] newSelectedRowIndices = new int[selectedRows.length];
                Arrays.sort(selectedRowIndices);
                for (int i3 = 0; i3 < selectedRows.length; ++i3) {
                    if (selectedRows[i3] == null) continue;
                    int index = selectedRows[i3].getIndex();
                    int iNewPos = selectedRows[i3] == focusedRow ? 0 : pos++;
                    newSelectedRowIndices[iNewPos] = index;
                    if (Arrays.binarySearch(selectedRowIndices, index) < 0) continue;
                    ++numSame;
                }
                if (numSame < selectedRows.length) {
                    iTopIndex = 0;
                    if (!bFollowSelected) {
                        this.table.setRedraw(false);
                        iTopIndex = this.table.getTopIndex();
                    }
                    this.table.setSelection(newSelectedRowIndices);
                    if (!bFollowSelected) {
                        this.table.setTopIndex(iTopIndex);
                        this.table.setRedraw(true);
                    }
                }
            }
        }
        finally {
            this.sortColumn_mon.exit();
        }
    }

    public void sortColumnReverse(TableColumnCore sorter) {
        boolean bSameColumn = this.sortColumn.equals(sorter);
        if (!bSameColumn) {
            this.fixAlignment(this.sortColumn, false);
            this.sortColumn = sorter;
            this.fixAlignment(sorter, true);
            int iSortDirection = configMan.getIntParameter(CFG_SORTDIRECTION);
            if (iSortDirection == 0) {
                this.sortColumn.setSortAscending(true);
            } else if (iSortDirection == 1) {
                this.sortColumn.setSortAscending(false);
            } else {
                this.sortColumn.setSortAscending(!this.sortColumn.isSortAscending());
            }
            TableColumnManager.getInstance().setDefaultSortColumnName(this.sTableID, this.sortColumn.getName());
        } else {
            this.sortColumn.setSortAscending(!this.sortColumn.isSortAscending());
        }
        this.changeColumnIndicator();
        this.sortColumn(!bSameColumn);
    }

    private void changeColumnIndicator() {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        try {
            org.eclipse.swt.widgets.TableColumn[] tcs = this.table.getColumns();
            for (int i = 0; i < tcs.length; ++i) {
                String sName = (String)tcs[i].getData("Name");
                if (sName == null || !sName.equals(this.sortColumn.getName())) continue;
                this.table.setSortDirection(this.sortColumn.isSortAscending() ? 128 : 1024);
                this.table.setSortColumn(tcs[i]);
                return;
            }
            this.table.setSortColumn(null);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public boolean isRowVisible(TableRowCore row) {
        int i = row.getIndex();
        if (Utils.SWT32_TABLEPAINT) {
            int iTopIndex = this.table.getTopIndex();
            int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
            return i >= iTopIndex && i <= iBottomIndex;
        }
        return i >= this.lastTopIndex && i <= this.lastBottomIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visibleRowsChanged() {
        TableRowSWT row;
        int i;
        int tmpIndex;
        if (Utils.SWT32_TABLEPAINT) {
            return;
        }
        if (!this.table.isVisible()) {
            this.lastTopIndex = 0;
            this.lastBottomIndex = -1;
            return;
        }
        boolean bTableUpdate = false;
        int iTopIndex = this.table.getTopIndex();
        int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
        if (this.lastTopIndex != iTopIndex) {
            tmpIndex = this.lastTopIndex;
            this.lastTopIndex = iTopIndex;
            if (iTopIndex < tmpIndex) {
                if (tmpIndex > iBottomIndex + 1 && iBottomIndex >= 0) {
                    tmpIndex = iBottomIndex + 1;
                }
                try {
                    this.sortedRows_mon.enter();
                    for (i = iTopIndex; i < tmpIndex && i < this.sortedRows.size(); ++i) {
                        row = (TableRowSWT)this.getRow(i);
                        if (row == null) continue;
                        row.setAlternatingBGColor(true);
                        row.refresh(true, true);
                        if (row instanceof TableRowImpl) {
                            ((TableRowImpl)row).setShown(true, false);
                        }
                        if (!Constants.isOSX) continue;
                        bTableUpdate = true;
                    }
                }
                finally {
                    this.sortedRows_mon.exit();
                }
                iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
            } else {
                for (i = tmpIndex; i < iTopIndex; ++i) {
                    row = (TableRowSWT)this.getRow(i);
                    if (!(row instanceof TableRowImpl)) continue;
                    ((TableRowImpl)row).setShown(false, false);
                }
            }
        }
        if (this.lastBottomIndex != iBottomIndex) {
            tmpIndex = this.lastBottomIndex;
            this.lastBottomIndex = iBottomIndex;
            if (tmpIndex < iTopIndex - 1) {
                tmpIndex = iTopIndex - 1;
            }
            if (tmpIndex <= iBottomIndex) {
                try {
                    this.sortedRows_mon.enter();
                    for (i = tmpIndex + 1; i <= iBottomIndex && i < this.sortedRows.size(); ++i) {
                        row = (TableRowSWT)this.getRow(i);
                        if (row == null) continue;
                        row.setAlternatingBGColor(true);
                        row.refresh(true, true);
                        if (row instanceof TableRowImpl) {
                            ((TableRowImpl)row).setShown(true, false);
                        }
                        if (!Constants.isOSX) continue;
                        bTableUpdate = true;
                    }
                }
                finally {
                    this.sortedRows_mon.exit();
                }
            } else {
                for (i = tmpIndex; i <= iBottomIndex; ++i) {
                    row = (TableRowSWT)this.getRow(i);
                    if (!(row instanceof TableRowImpl)) continue;
                    ((TableRowImpl)row).setShown(false, false);
                }
            }
        }
        if (bTableUpdate) {
            this.table.update();
        }
    }

    public Image obfusticatedImage(Image image, Point shellOffset) {
        if (this.table.getItemCount() == 0) {
            return image;
        }
        org.eclipse.swt.widgets.TableColumn[] tableColumnsSWT = this.table.getColumns();
        for (int i = 0; i < tableColumnsSWT.length; ++i) {
            int iTopIndex;
            int iBottomIndex;
            int size;
            TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
            if (tc == null || !tc.isObfusticated() || (size = (iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex = this.table.getTopIndex())) - iTopIndex + 1) <= 0) continue;
            for (int j = iTopIndex; j <= iBottomIndex; ++j) {
                TableItem rowSWT = this.table.getItem(j);
                TableRowSWT row = (TableRowSWT)this.table.getItem(j).getData("TableRow");
                if (row == null) continue;
                TableCellSWT cell = row.getTableCellSWT(tc.getName());
                Rectangle columnBounds = rowSWT.getBounds(i);
                if (columnBounds.y + columnBounds.height > this.clientArea.y + this.clientArea.height) {
                    columnBounds.height -= columnBounds.y + columnBounds.height - (this.clientArea.y + this.clientArea.height);
                }
                if (columnBounds.x + columnBounds.width > this.clientArea.x + this.clientArea.width) {
                    columnBounds.width -= columnBounds.x + columnBounds.width - (this.clientArea.x + this.clientArea.width);
                }
                Point offset = this.table.toDisplay(columnBounds.x, columnBounds.y);
                columnBounds.x = offset.x - shellOffset.x;
                columnBounds.y = offset.y - shellOffset.y;
                String text = cell.getObfusticatedText();
                if (text == null) continue;
                UIDebugGenerator.obfusticateArea(this.table.getDisplay(), image, columnBounds, text);
            }
        }
        IView view = this.getActiveSubView();
        if (view instanceof ObfusticateImage) {
            try {
                ((ObfusticateImage)((Object)view)).obfusticatedImage(image, shellOffset);
            }
            catch (Exception e) {
                Debug.out("Obfusticating " + view, e);
            }
        }
        return image;
    }

    void debug(String s) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("table");
        diag_logger.log(s);
        System.out.println(SystemTime.getCurrentTime() + ": " + this.sTableID + ": " + s);
    }

    public boolean isEnableTabViews() {
        return this.bEnableTabViews;
    }

    public void setEnableTabViews(boolean enableTabViews) {
        this.bEnableTabViews = enableTabViews;
    }

    public IView[] getCoreTabViews() {
        return this.coreTabViews;
    }

    public void setCoreTabViews(IView[] coreTabViews) {
        this.coreTabViews = coreTabViews;
    }

    public void addMenuFillListener(TableViewSWTMenuFillListener l) {
        this.listenersMenuFill.add(l);
    }

    public boolean isDisposed() {
        return this.mainComposite == null || this.mainComposite.isDisposed() || this.table == null || this.table.isDisposed();
    }

    public int size(boolean bIncludeQueue) {
        int size = this.sortedRows.size();
        if (bIncludeQueue) {
            if (this.dataSourcesToAdd != null) {
                size += this.dataSourcesToAdd.size();
            }
            if (this.dataSourcesToRemove != null) {
                size += this.dataSourcesToRemove.size();
            }
        }
        return size;
    }

    public String getPropertiesPrefix() {
        return this.sPropertiesPrefix;
    }

    public void setFocus() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setFocus();
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (this.listenersKey.contains(listener)) {
            return;
        }
        this.listenersKey.add(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.listenersKey.remove(listener);
    }

    public TableColumnCore getSortColumn() {
        return this.sortColumn;
    }

    public void selectAll() {
        if (this.table != null && !this.table.isDisposed()) {
            this.ensureAllRowsHaveIndex();
            this.table.selectAll();
            this.triggerSelectionListeners(this.getSelectedRows());
            this.triggerTabViewsDataSourceChanged();
        }
    }

    private void ensureAllRowsHaveIndex() {
        for (int i = 0; i < this.sortedRows.size(); ++i) {
            TableRowSWT row = (TableRowSWT)this.sortedRows.get(i);
            row.setTableItem(i);
        }
    }

    public void setSelectedRows(TableRowCore[] rows) {
        this.table.deselectAll();
        for (int i = 0; i < rows.length; ++i) {
            TableRowCore row = rows[i];
            if (row.getIndex() == -1) {
                int j = this.sortedRows.indexOf(row);
                if (j == -1) {
                    System.err.println("BOO");
                } else {
                    row.setTableItem(j);
                }
            }
            row.setSelected(true);
        }
    }

    public boolean isTableFocus() {
        return this.table.isFocusControl();
    }

    public DragSource createDragSource(int style) {
        final DragSource dragSource = new DragSource((Control)this.table, style);
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (dragSource != null && !dragSource.isDisposed()) {
                    dragSource.dispose();
                }
            }
        });
        return dragSource;
    }

    public DropTarget createDropTarget(int style) {
        final DropTarget dropTarget = new DropTarget((Control)this.table, style);
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (dropTarget != null && !dropTarget.isDisposed()) {
                    dropTarget.dispose();
                }
            }
        });
        return dropTarget;
    }

    public TableRowCore getRow(DropTargetEvent event2) {
        if (event2.item instanceof TableItem) {
            TableItem ti = (TableItem)event2.item;
            return (TableRowCore)ti.getData("TableRow");
        }
        return null;
    }

    public boolean dataSourceExists(Object dataSource) {
        return this.mapDataSourceToRow.containsKey(dataSource) || this.dataSourcesToAdd.contains(dataSource);
    }

    public TableColumnCore[] getVisibleColumns() {
        return this.tableColumns;
    }

    protected TableViewSWTPanelCreator getMainPanelCreator() {
        return this.mainPanelCreator;
    }

    public void setMainPanelCreator(TableViewSWTPanelCreator mainPanelCreator) {
        this.mainPanelCreator = mainPanelCreator;
    }

    public TableCellCore getTableCellWithCursor() {
        Point pt = this.table.getDisplay().getCursorLocation();
        pt = this.table.toControl(pt);
        return this.getTableCell(pt.x, pt.y);
    }

    public TableRowCore getTableRowWithCursor() {
        Point pt = this.table.getDisplay().getCursorLocation();
        pt = this.table.toControl(pt);
        return this.getTableRow(pt.x, pt.y);
    }

    public Point getTableCellMouseOffset(TableCellSWT tableCell) {
        if (tableCell == null) {
            return null;
        }
        Point pt = this.table.getDisplay().getCursorLocation();
        pt = this.table.toControl(pt);
        Rectangle bounds = tableCell.getBounds();
        int x = pt.x - bounds.x + VerticalAligner.getTableAdjustHorizontallyBy(this.table);
        if (x < 0 || x > bounds.width) {
            return null;
        }
        int y = pt.y - bounds.y + VerticalAligner.getTableAdjustVerticalBy(this.table);
        if (y < 0 || y > bounds.height) {
            return null;
        }
        return new Point(x, y);
    }

    public Class getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(Class dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshListener(TableRowRefreshListener listener) {
        try {
            this.listeners_mon.enter();
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList(1);
            }
            this.refreshListeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshListener(TableRowRefreshListener listener) {
        try {
            this.listeners_mon.enter();
            if (this.refreshListeners == null) {
                return;
            }
            this.refreshListeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeRefreshListeners(TableRowCore row) {
        Object[] listeners;
        try {
            this.listeners_mon.enter();
            if (this.refreshListeners == null) {
                return;
            }
            listeners = this.refreshListeners.toArray();
        }
        finally {
            this.listeners_mon.exit();
        }
        for (int i = 0; i < listeners.length; ++i) {
            try {
                TableRowRefreshListener l = (TableRowRefreshListener)listeners[i];
                l.rowRefresh(row);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private class ColumnMoveListener
    implements Listener {
        private ColumnMoveListener() {
        }

        public void handleEvent(Event event2) {
            int[] iColumnOrder;
            int iAddedPosition;
            org.eclipse.swt.widgets.TableColumn column = (org.eclipse.swt.widgets.TableColumn)event2.widget;
            if (column == null) {
                return;
            }
            TableColumnCore tableColumnCore = (TableColumnCore)column.getData("TableColumnCore");
            if (tableColumnCore == null) {
                return;
            }
            Table table = column.getParent();
            org.eclipse.swt.widgets.TableColumn[] tableColumns = table.getColumns();
            for (iAddedPosition = 0; iAddedPosition < tableColumns.length && column != tableColumns[iAddedPosition]; ++iAddedPosition) {
            }
            if (iAddedPosition >= tableColumns.length) {
                return;
            }
            try {
                iColumnOrder = table.getColumnOrder();
            }
            catch (NoSuchMethodError e) {
                return;
            }
            for (int i = 0; i < iColumnOrder.length; ++i) {
                if (iColumnOrder[i] != iAddedPosition) continue;
                int iNewPosition = i - (TableViewSWTImpl.this.bSkipFirstColumn ? 1 : 0);
                if (tableColumnCore.getPosition() == iNewPosition) break;
                if (iNewPosition == -1) {
                    iColumnOrder[0] = 0;
                    iColumnOrder[1] = iAddedPosition;
                    table.setColumnOrder(iColumnOrder);
                    iNewPosition = 0;
                }
                tableColumnCore.setPositionNoShift(iNewPosition);
                tableColumnCore.saveSettings(null);
                TableStructureEventDispatcher.getInstance(TableViewSWTImpl.this.sTableID).columnOrderChanged(iColumnOrder);
                break;
            }
        }
    }

    private class ColumnSelectionListener
    implements Listener {
        private ColumnSelectionListener() {
        }

        public void handleEvent(final Event event2) {
            if (COLUMN_CLICK_DELAY) {
                final Timer timer = new Timer("Column Selection Wait");
                timer.addEvent(System.currentTimeMillis() + 85L, new TimerEventPerformer(){

                    public void perform(TimerEvent timerEvent2) {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                if (TableViewSWTImpl.this.lLastColumnResizeOn == -1L || System.currentTimeMillis() - TableViewSWTImpl.this.lLastColumnResizeOn > 220L) {
                                    ColumnSelectionListener.this.reallyHandleEvent(event2);
                                }
                            }
                        });
                        timer.destroy();
                    }
                });
            } else {
                this.reallyHandleEvent(event2);
            }
        }

        private void reallyHandleEvent(Event event2) {
            org.eclipse.swt.widgets.TableColumn column = (org.eclipse.swt.widgets.TableColumn)event2.widget;
            if (column == null) {
                return;
            }
            TableColumnCore tableColumnCore = (TableColumnCore)column.getData("TableColumnCore");
            if (tableColumnCore != null) {
                TableViewSWTImpl.this.sortColumnReverse(tableColumnCore);
                TableViewSWTImpl.this.columnVisibilitiesChanged = true;
                TableViewSWTImpl.this.refreshTable(true);
            }
        }
    }

    private static interface SourceReplaceListener {
        public void sourcesChanged();

        public void cleanup(Text var1);
    }
}

