/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCoreCreationListener;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AvailabilityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AvgAvailItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.BadAvailTimeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CommentIconItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CommentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.CompletionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateAddedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateCompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DownSpeedLimitItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ETAItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.FilesDoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.HealthItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.MaxUploadsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.NetworksItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.OnlyCDing4Item;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PeerSourcesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PeersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.PiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.RankItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.RemainingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SavePathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SecondsDownloadingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SecondsSeedingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SeedToPeerRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SeedsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.ShareRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.StatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SwarmAverageCompletion;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SwarmAverageSpeed;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TimeSinceDownloadItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TimeSinceUploadItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TorrentPathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TotalSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerNameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerNextAccessItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.TrackerStatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpSpeedLimitItem;

public class TableColumnCreator {
    public static int DATE_COLUMN_WIDTH = 110;

    public static TableColumnCore[] createIncompleteDM(String tableID) {
        String[] defaultVisibleOrder = new String[]{"health", "#", "name", "azsubs.ui.column.subs", "Info", "commenticon", "size", "down", "done", "status", "seeds", "peers", "downspeed", "upspeed", "eta", "shareRatio", "tracker"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map mapTCs = tcManager.getTableColumnsAsMap(DownloadTypeIncomplete.class, tableID);
        if (!tcManager.loadTableColumnSettings(DownloadTypeIncomplete.class, tableID) || TableColumnCreator.areNoneVisible(mapTCs)) {
            TableColumnCreator.setVisibility(mapTCs, defaultVisibleOrder);
            RankItem tc = (RankItem)mapTCs.get("#");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "#");
                tc.setSortAscending(true);
            }
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    public static TableColumnCore[] createCompleteDM(String tableID) {
        String[] defaultVisibleOrder = new String[]{"health", "#", "SeedingRank", "name", "azsubs.ui.column.subs", "Info", "RateIt", "commenticon", "size", "status", "seeds", "peers", "upspeed", "shareRatio", "up", "tracker"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map mapTCs = tcManager.getTableColumnsAsMap(DownloadTypeComplete.class, tableID);
        if (!tcManager.loadTableColumnSettings(DownloadTypeComplete.class, tableID) || TableColumnCreator.areNoneVisible(mapTCs)) {
            TableColumnCreator.setVisibility(mapTCs, defaultVisibleOrder);
            RankItem tc = (RankItem)mapTCs.get("#");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "#");
                tc.setSortAscending(true);
            }
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    private static boolean areNoneVisible(Map mapTCs) {
        boolean noneVisible = true;
        for (TableColumn tc : mapTCs.values()) {
            if (!tc.isVisible()) continue;
            noneVisible = false;
            break;
        }
        return noneVisible;
    }

    private static void setVisibility(Map mapTCs, String[] defaultVisibleOrder) {
        for (TableColumnCore tc : mapTCs.values()) {
            tc.setVisible(false);
        }
        for (int i = 0; i < defaultVisibleOrder.length; ++i) {
            String id = defaultVisibleOrder[i];
            TableColumnCore tc = (TableColumnCore)mapTCs.get(id);
            if (tc == null) continue;
            tc.setVisible(true);
            tc.setPositionNoShift(i);
        }
    }

    public static void initCoreColumns() {
        final LightHashMap c = new LightHashMap(50);
        Class<Download> all = Download.class;
        Class<DownloadTypeIncomplete> dl = DownloadTypeIncomplete.class;
        Class<DownloadTypeComplete> cd = DownloadTypeComplete.class;
        c.put("#", new cInfo(RankItem.class, all));
        c.put("name", new cInfo(NameItem.class, all));
        c.put("size", new cInfo(SizeItem.class, all));
        c.put("done", new cInfo(DoneItem.class, all));
        c.put("status", new cInfo(StatusItem.class, all));
        c.put("eta", new cInfo(ETAItem.class, dl));
        c.put("health", new cInfo(HealthItem.class, all));
        c.put("commenticon", new cInfo(CommentIconItem.class, all));
        c.put("down", new cInfo(DownItem.class, dl));
        c.put("seeds", new cInfo(SeedsItem.class, all));
        c.put("peers", new cInfo(PeersItem.class, all));
        c.put("downspeed", new cInfo(DownSpeedItem.class, dl));
        c.put("upspeed", new cInfo(UpSpeedItem.class, all));
        c.put("maxupspeed", new cInfo(UpSpeedLimitItem.class, all));
        c.put("tracker", new cInfo(TrackerStatusItem.class, all));
        c.put("completed", new cInfo(CompletedItem.class, all));
        c.put("shareRatio", new cInfo(ShareRatioItem.class, all));
        c.put("up", new cInfo(UpItem.class, all));
        c.put("remaining", new cInfo(RemainingItem.class, dl));
        c.put("pieces", new cInfo(PiecesItem.class, dl));
        c.put("completion", new cInfo(CompletionItem.class, dl));
        c.put("comment", new cInfo(CommentItem.class, all));
        c.put("maxuploads", new cInfo(MaxUploadsItem.class, all));
        c.put("totalspeed", new cInfo(TotalSpeedItem.class, all));
        c.put("filesdone", new cInfo(FilesDoneItem.class, all));
        c.put("savepath", new cInfo(SavePathItem.class, all));
        c.put("torrentpath", new cInfo(TorrentPathItem.class, all));
        c.put("category", new cInfo(CategoryItem.class, all));
        c.put("networks", new cInfo(NetworksItem.class, all));
        c.put("peersources", new cInfo(PeerSourcesItem.class, all));
        c.put("availability", new cInfo(AvailabilityItem.class, all));
        c.put("AvgAvail", new cInfo(AvgAvailItem.class, all));
        c.put("secondsseeding", new cInfo(SecondsSeedingItem.class, all));
        c.put("secondsdownloading", new cInfo(SecondsDownloadingItem.class, all));
        c.put("timesincedownload", new cInfo(TimeSinceDownloadItem.class, dl));
        c.put("timesinceupload", new cInfo(TimeSinceUploadItem.class, all));
        c.put("OnlyCDing4", new cInfo(OnlyCDing4Item.class, all));
        c.put("trackernextaccess", new cInfo(TrackerNextAccessItem.class, all));
        c.put("trackername", new cInfo(TrackerNameItem.class, all));
        c.put("seed_to_peer_ratio", new cInfo(SeedToPeerRatioItem.class, all));
        c.put("maxdownspeed", new cInfo(DownSpeedLimitItem.class, dl));
        c.put("swarm_average_speed", new cInfo(SwarmAverageSpeed.class, all));
        c.put("swarm_average_completion", new cInfo(SwarmAverageCompletion.class, all));
        c.put("bad_avail_time", new cInfo(BadAvailTimeItem.class, all));
        c.put("DateCompleted", new cInfo(DateCompletedItem.class, cd));
        c.put("date_added", new cInfo(DateAddedItem.class, all));
        TableColumnManager tcManager = TableColumnManager.getInstance();
        TableColumnCoreCreationListener tcCreator = new TableColumnCoreCreationListener(){

            public TableColumnCore createTableColumnCore(String tableID, String columnID) {
                cInfo info = (cInfo)c.get(columnID);
                try {
                    Constructor constructor = info.cla.getDeclaredConstructor(String.class);
                    TableColumnCore column = (TableColumnCore)constructor.newInstance(tableID);
                    return column;
                }
                catch (Exception e) {
                    Debug.out(e);
                    return null;
                }
            }

            public void tableColumnCreated(TableColumn column) {
            }
        };
        for (String id : c.keySet()) {
            cInfo info = (cInfo)c.get(id);
            tcManager.registerColumn(info.forDataSourceType, id, tcCreator);
        }
    }

    private static class cInfo {
        public Class cla;
        public Class forDataSourceType;

        public cInfo(Class cla, Class forDataSourceType) {
            this.cla = cla;
            this.forDataSourceType = forDataSourceType;
        }
    }
}

