/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class RemainingItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "remaining";
    private boolean bLastValueEstimate = false;

    public RemainingItem(String sTableID) {
        super(COLUMN_ID, 2, -1, 70, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    public void refresh(TableCell cell) {
        long lRemaining = this.getRemaining(cell);
        if (!cell.setSortValue(lRemaining) && cell.isValid()) {
            return;
        }
        if (this.bLastValueEstimate) {
            cell.setText("~ " + DisplayFormatters.formatByteCountToKiBEtc(lRemaining));
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(lRemaining));
        }
    }

    private long getRemaining(TableCell cell) {
        DownloadManager manager = (DownloadManager)cell.getDataSource();
        if (manager == null) {
            return 0L;
        }
        return manager.getStats().getRemaining();
    }
}

