/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.pieces;

import java.util.HashMap;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class WritersItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public WritersItem() {
        super("writers", 1, -1, 80, "Pieces");
        this.setObfustication(true);
        this.setRefreshInterval(4);
    }

    public void refresh(TableCell cell) {
        PEPiece piece = (PEPiece)cell.getDataSource();
        String[] core_writers = piece.getWriters();
        String[] my_writers = new String[core_writers.length];
        int writer_count = 0;
        HashMap<String, StringBuffer> map = new HashMap<String, StringBuffer>();
        int i = 0;
        while (true) {
            int end;
            int start;
            String this_writer = null;
            for (start = i; start < core_writers.length && (this_writer = core_writers[start]) == null; ++start) {
            }
            if (this_writer == null) break;
            for (end = start + 1; end < core_writers.length && this_writer.equals(core_writers[end]); ++end) {
            }
            StringBuffer pieces = (StringBuffer)map.get(this_writer);
            if (pieces == null) {
                pieces = new StringBuffer();
                map.put(this_writer, pieces);
                my_writers[writer_count++] = this_writer;
            } else {
                pieces.append(',');
            }
            pieces.append(start);
            if (end - 1 > start) {
                pieces.append('-').append(end - 1);
            }
            i = end;
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < writer_count; ++i2) {
            String writer = my_writers[i2];
            StringBuffer pieces = (StringBuffer)map.get(writer);
            if (i2 > 0) {
                sb.append(';');
            }
            sb.append(writer).append('[').append(pieces).append(']');
        }
        String value = sb.toString();
        if (!cell.setSortValue((Comparable)((Object)value)) && cell.isValid()) {
            return;
        }
        cell.setText(value);
    }
}

