/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.File;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableBoolean;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class ManagerUtils {
    private static RunDownloadManager run;

    public static void setRunRunnable(RunDownloadManager run) {
        ManagerUtils.run = run;
    }

    public static void run(DownloadManager dm) {
        if (dm != null) {
            if (run != null) {
                run.run(dm);
            } else {
                Utils.launch(dm.getSaveLocation().toString());
            }
        }
    }

    public static void open(DownloadManager dm) {
        ManagerUtils.open(dm, false);
    }

    public static void open(DownloadManager dm, boolean open_containing_folder_mode) {
        if (dm != null) {
            ManagerUtils.open(dm.getSaveLocation(), open_containing_folder_mode);
        }
    }

    public static void open(File f, boolean open_containing_folder_mode) {
        if (open_containing_folder_mode) {
            Utils.launch(f.getParent());
        } else {
            ManagerUtils.open(f);
        }
    }

    public static void open(File f) {
        while (f != null && !f.exists()) {
            f = f.getParentFile();
        }
        if (f == null) {
            return;
        }
        PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
        if (mgr.hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            try {
                PlatformManagerFactory.getPlatformManager().showFile(f.toString());
                return;
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
        if (f.isDirectory()) {
            Utils.launch(f.toString());
        } else {
            Utils.launch(f.getParent().toString());
        }
    }

    public static boolean isStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70;
    }

    public static boolean isStopable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70 && state != 65;
    }

    public static boolean isStopped(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 100;
    }

    public static boolean isForceStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 75 || state == 60 || state == 50;
    }

    public static void host(AzureusCore azureus_core, DownloadManager dm, Composite panel) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                azureus_core.getTrackerHost().hostTorrent(torrent, true, false);
            }
            catch (TRHostException e) {
                MessageBox mb = new MessageBox(panel.getShell(), 33);
                mb.setText(MessageText.getString("MyTorrentsView.menu.host.error.title"));
                mb.setMessage(MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
                mb.open();
            }
        }
    }

    public static void publish(AzureusCore azureus_core, DownloadManager dm, Composite panel) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                azureus_core.getTrackerHost().publishTorrent(torrent);
            }
            catch (TRHostException e) {
                MessageBox mb = new MessageBox(panel.getShell(), 33);
                mb.setText(MessageText.getString("MyTorrentsView.menu.host.error.title"));
                mb.setMessage(MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
                mb.open();
            }
        }
    }

    public static void start(DownloadManager dm) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateWaiting();
        }
    }

    public static void queue(DownloadManager dm, Composite panel) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateQueued();
        }
    }

    public static void stop(DownloadManager dm, Shell shell) {
        ManagerUtils.stop(dm, shell, 70);
    }

    public static void stop(final DownloadManager dm, Shell shell, int stateAfterStopped) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (state == 70 || state == 65 || state == stateAfterStopped) {
            return;
        }
        boolean stopme = true;
        if (state == 60) {
            if (dm.getStats().getShareRatio() >= 0 && dm.getStats().getShareRatio() < 1000 && COConfigurationManager.getBooleanParameter("Alert on close", false)) {
                if (shell == null) {
                    shell = Utils.findAnyShell();
                }
                MessageBox mb = new MessageBox(shell, 200);
                mb.setText(MessageText.getString("seedmore.title"));
                mb.setMessage(MessageText.getString("seedmore.shareratio") + dm.getStats().getShareRatio() / 10 + "%.\n" + MessageText.getString("seedmore.uploadmore"));
                int action = mb.open();
                stopme = action == 64;
            } else if (dm.getDownloadState().isOurContent() && dm.getStats().getAvailability() < 2.0f) {
                TRTrackerScraperResponse scrape = dm.getTrackerScrapeResponse();
                int numSeeds = scrape.getSeeds();
                long seedingStartedOn = dm.getStats().getTimeStartedSeeding();
                if (numSeeds > 0 && seedingStartedOn > 0L && scrape.getScrapeStartTime() > seedingStartedOn) {
                    --numSeeds;
                }
                if (numSeeds == 0) {
                    stopme = Utils.execSWTThreadWithBool("stopSeeding", new AERunnableBoolean(){

                        public boolean runSupport() {
                            String title = MessageText.getString("Content.alert.notuploaded.title");
                            String text = MessageText.getString("Content.alert.notuploaded.text", new String[]{dm.getDisplayName(), MessageText.getString("Content.alert.notuploaded.stop")});
                            MessageBoxShell mb = new MessageBoxShell(Utils.findAnyShell(), title, text, new String[]{MessageText.getString("Content.alert.notuploaded.button.stop"), MessageText.getString("Content.alert.notuploaded.button.continue")}, 1, null, null, false, 0);
                            mb.setRelatedObject(dm);
                            return mb.open() == 0;
                        }
                    });
                }
            }
        }
        if (stopme) {
            ManagerUtils.asyncStop(dm, stateAfterStopped);
        }
    }

    public static void remove(DownloadManager dm, Shell shell, boolean bDeleteTorrent, boolean bDeleteData) {
        ManagerUtils.remove(dm, shell, bDeleteTorrent, bDeleteData, null);
    }

    public static void remove(DownloadManager dm, Shell shell, boolean bDeleteTorrent, boolean bDeleteData, AERunnable deleteFailed) {
        if (!dm.getDownloadState().getFlag(16L)) {
            boolean confirmDataDelete;
            if (COConfigurationManager.getBooleanParameter("confirm_torrent_removal")) {
                String title = MessageText.getString("deletedata.title");
                String text = MessageText.getString("deletetorrent.message1") + dm.getDisplayName() + " :\n" + dm.getTorrentFileName() + MessageText.getString("deletetorrent.message2");
                MessageBoxShell mb = new MessageBoxShell(shell, title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                mb.setRelatedObject(dm);
                mb.setLeftImage(8);
                int result = mb.open();
                if (result != 0) {
                    if (deleteFailed != null) {
                        deleteFailed.runSupport();
                    }
                    return;
                }
            }
            if ((confirmDataDelete = COConfigurationManager.getBooleanParameter("Confirm Data Delete")) && bDeleteData) {
                String path = dm.getSaveLocation().toString();
                String title = MessageText.getString("deletedata.title");
                String text = MessageText.getString("deletedata.message1", new String[]{dm.getDisplayName()});
                MessageBoxShell mb = new MessageBoxShell(shell, title, text, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1, "deletedata.noconfirm.key2", MessageText.getString("deletedata.noprompt"), false, 0);
                mb.setRememberOnlyIfButton(0);
                mb.setRelatedObject(dm);
                mb.setLeftImage(8);
                int result = mb.open();
                if (result != 0) {
                    if (deleteFailed != null) {
                        deleteFailed.runSupport();
                    }
                    return;
                }
            }
        }
        ManagerUtils.asyncStopDelete(dm, 70, bDeleteTorrent, bDeleteData, deleteFailed);
    }

    public static void asyncStopDelete(final DownloadManager dm, int stateAfterStopped, final boolean bDeleteTorrent, final boolean bDeleteData, final AERunnable deleteFailed) {
        new AEThread("asyncStop", true){

            public void runSupport() {
                block5: {
                    try {
                        dm.getGlobalManager().removeDownloadManager(dm, bDeleteTorrent, bDeleteData);
                    }
                    catch (GlobalManagerDownloadRemovalVetoException f) {
                        if (!f.isSilent()) {
                            Alerts.showErrorMessageBoxUsingResourceString(new Object[]{dm}, "globalmanager.download.remove.veto", f, 0);
                        }
                        if (deleteFailed != null) {
                            deleteFailed.runSupport();
                        }
                    }
                    catch (Exception ex) {
                        Debug.printStackTrace(ex);
                        if (deleteFailed == null) break block5;
                        deleteFailed.runSupport();
                    }
                }
            }
        }.start();
    }

    public static void asyncStop(final DownloadManager dm, final int stateAfterStopped) {
        new AEThread("asyncStop", true){

            public void runSupport() {
                dm.stopIt(stateAfterStopped, false, false);
            }
        }.start();
    }

    public static void asyncStartAll() {
        new AEThread("asyncStartAll", true){

            public void runSupport() {
                AzureusCoreFactory.getSingleton().getGlobalManager().startAllDownloads();
            }
        }.start();
    }

    public static void asyncStopAll() {
        new AEThread("asyncStopAll", true){

            public void runSupport() {
                AzureusCoreFactory.getSingleton().getGlobalManager().stopAllDownloads();
            }
        }.start();
    }

    public static void asyncPause() {
        new AEThread("asyncPause", true){

            public void runSupport() {
                AzureusCoreFactory.getSingleton().getGlobalManager().pauseDownloads();
            }
        }.start();
    }

    public static void asyncResume() {
        new AEThread("asyncResume", true){

            public void runSupport() {
                AzureusCoreFactory.getSingleton().getGlobalManager().resumeDownloads();
            }
        }.start();
    }

    public static interface RunDownloadManager {
        public void run(DownloadManager var1);
    }
}

