/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.activities;

import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableColumnSortObject;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.ImageDownloader;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.PlayUtils;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class VuzeActivitiesEntry
implements TableColumnSortObject {
    private String text;
    private String iconID;
    private String id;
    private long timestamp;
    private String typeID;
    private String assetHash;
    private String assetImageURL;
    private DownloadManager dm;
    public Object urlInfo;
    public TableColumnCore tableColumn;
    private byte[] imageBytes;
    private boolean showThumb = true;
    private String torrentName;
    private TOTorrent torrent;
    private boolean isDRM;
    private boolean isPlatformContent;
    private boolean playable;
    private long readOn;
    private GlobalManagerAdapter globalManagerAdapter;

    public VuzeActivitiesEntry(long timestamp, String text, String typeID) {
        this.setText(text);
        this.timestamp = timestamp;
        this.setTypeID(typeID, true);
    }

    public VuzeActivitiesEntry(long timestamp, String text, String icon, String id, String typeID, String assetHash) {
        this.timestamp = timestamp;
        this.setText(text);
        this.setIconID(icon);
        this.setID(id);
        this.setTypeID(typeID, true);
        this.setAssetHash(assetHash);
    }

    public VuzeActivitiesEntry() {
        this.timestamp = SystemTime.getCurrentTime();
    }

    public void loadFromExternalMap(Map platformEntry) {
        this.timestamp = SystemTime.getCurrentTime() - MapUtils.getMapLong(platformEntry, "age-ms", 0L);
        this.setIconID(MapUtils.getMapString(platformEntry, "icon-id", null));
        this.setTypeID(MapUtils.getMapString(platformEntry, "type-id", null), true);
        this.setAssetHash(MapUtils.getMapString(platformEntry, "related-asset-hash", null));
        this.setAssetImageURL(MapUtils.getMapString(platformEntry, "related-image-url", null));
        this.setDRM(MapUtils.getMapBoolean(platformEntry, "no-play", false));
        this.setTorrentName(MapUtils.getMapString(platformEntry, "related-asset-name", null));
        this.setReadOn(MapUtils.getMapLong(platformEntry, "readOn", 0L));
        this.loadCommonFromMap(platformEntry);
    }

    public void loadFromInternalMap(Map map) {
        this.timestamp = MapUtils.getMapLong(map, "timestamp", 0L);
        if (this.timestamp == 0L) {
            this.timestamp = SystemTime.getCurrentTime();
        }
        this.setAssetHash(MapUtils.getMapString(map, "assetHash", null));
        this.setIconID(MapUtils.getMapString(map, "icon", null));
        this.setTypeID(MapUtils.getMapString(map, "typeID", null), true);
        this.setShowThumb(MapUtils.getMapLong(map, "showThumb", 1L) == 1L);
        this.setAssetImageURL(MapUtils.getMapString(map, "assetImageURL", null));
        this.setImageBytes(MapUtils.getMapByteArray(map, "imageBytes", null));
        this.setDRM(MapUtils.getMapBoolean(map, "isDRM", false));
        this.setReadOn(MapUtils.getMapLong(map, "readOn", SystemTime.getCurrentTime()));
        this.loadCommonFromMap(map);
    }

    public void loadCommonFromMap(Map map) {
        if (!this.isPlatformContent) {
            this.setIsPlatformContent(MapUtils.getMapBoolean(map, "is-platform", this.isPlatformContent));
        }
        if (!this.playable) {
            this.setPlayable(MapUtils.getMapBoolean(map, "playable", false));
        }
        this.setID(MapUtils.getMapString(map, "id", null));
        this.setText(MapUtils.getMapString(map, "text", null));
        Map torrentMap = MapUtils.getMapMap(map, "torrent", null);
        if (torrentMap != null) {
            TOTorrent torrent = null;
            try {
                torrent = TOTorrentFactory.deserialiseFromMap(torrentMap);
                this.setTorrent(torrent);
            }
            catch (TOTorrentException e) {
                // empty catch block
            }
        }
        if (this.dm == null && this.torrentName == null) {
            this.setTorrentName(MapUtils.getMapString(map, "torrent-name", null));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof VuzeActivitiesEntry && this.id != null) {
            return this.id.equals(((VuzeActivitiesEntry)obj).id);
        }
        return super.equals(obj);
    }

    public int compareTo(Object obj) {
        if (obj instanceof VuzeActivitiesEntry) {
            VuzeActivitiesEntry otherEntry = (VuzeActivitiesEntry)obj;
            long x = this.timestamp - otherEntry.timestamp;
            return x == 0L ? 0 : (x > 0L ? 1 : -1);
        }
        return 1;
    }

    public void setAssetImageURL(String url) {
        if (url == null && this.assetImageURL == null) {
            return;
        }
        if (url == null || url.length() == 0) {
            this.assetImageURL = null;
            VuzeActivitiesManager.triggerEntryChanged(this);
            return;
        }
        if (url.equals(this.assetImageURL)) {
            return;
        }
        this.assetImageURL = url;
        ImageDownloader.loadImage(url, new ImageDownloader.ImageDownloaderListener(){

            public void imageDownloaded(byte[] image) {
                VuzeActivitiesEntry.this.setImageBytes(image);
                VuzeActivitiesManager.triggerEntryChanged(VuzeActivitiesEntry.this);
            }
        });
    }

    public String getAssetImageURL() {
        return this.assetImageURL;
    }

    public Map toDeletedMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timestamp", new Long(this.timestamp));
        map.put("id", this.id);
        return map;
    }

    public Map toMap() {
        byte[] thumbnail;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timestamp", new Long(this.timestamp));
        if (this.assetHash != null) {
            map.put("assetHash", this.assetHash);
        }
        map.put("icon", this.getIconID());
        map.put("id", this.id);
        map.put("text", this.getText());
        map.put("typeID", this.getTypeID());
        map.put("assetImageURL", this.assetImageURL);
        map.put("showThumb", new Long(this.getShowThumb() ? 1L : 0L));
        if (this.imageBytes != null) {
            map.put("imageBytes", this.imageBytes);
        } else if (this.dm != null && (thumbnail = PlatformTorrentUtils.getContentThumbnail(this.dm.getTorrent())) != null) {
            map.put("imageBytes", thumbnail);
        }
        if (this.torrent != null && (this.dm == null || this.assetHash == null)) {
            try {
                TOTorrent torrent_to_send = TOTorrentFactory.deserialiseFromMap(this.torrent.serialiseToMap());
                torrent_to_send.removeAdditionalProperties();
                map.put("torrent", torrent_to_send.serialiseToMap());
            }
            catch (TOTorrentException e) {
                Debug.outNoStack("VuzeActivityEntry.toMap: " + e.toString());
            }
        }
        map.put("isDRM", new Long(this.isDRM() ? 1L : 0L));
        if (this.torrentName != null) {
            map.put("torrent-name", this.torrentName);
        }
        map.put("is-platform", new Long(this.isPlatformContent ? 1L : 0L));
        if (this.playable) {
            map.put("playable", new Long(this.playable ? 1L : 0L));
        }
        map.put("readOn", new Long(this.readOn));
        return map;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        if (this.timestamp == timestamp) {
            return;
        }
        this.timestamp = timestamp;
        if (this.tableColumn != null) {
            this.tableColumn.setLastSortValueChange(SystemTime.getCurrentTime());
        }
    }

    public void setTypeID(String typeID, boolean autoSetIcon) {
        this.typeID = typeID;
        if (this.getIconID() == null && typeID != null) {
            this.setIconID("image.vuze-entry." + typeID.toLowerCase());
        }
        if ("CONTENT_PROMO".equals(typeID)) {
            this.setIsPlatformContent(true);
            this.setPlayable(true);
        }
    }

    public String getTypeID() {
        return this.typeID;
    }

    public void setIconID(String iconID) {
        if (iconID != null && iconID.indexOf("image.") < 0) {
            iconID = "image.vuze-entry." + iconID;
        }
        this.iconID = iconID;
    }

    public String getIconID() {
        return this.iconID;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setAssetHash(String assetHash) {
        this.assetHash = assetHash;
        if (assetHash != null) {
            GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            this.setDownloadManager(gm.getDownloadManager(new HashWrapper(Base32.decode(assetHash))));
        } else {
            this.setDownloadManager(null);
        }
    }

    public String getAssetHash() {
        return this.assetHash;
    }

    public void setDownloadManager(DownloadManager dm) {
        GlobalManager gm;
        if (this.dm == dm) {
            return;
        }
        if (dm == null && this.globalManagerAdapter != null) {
            gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            gm.removeListener(this.globalManagerAdapter);
            this.globalManagerAdapter = null;
        }
        if (dm != null && this.globalManagerAdapter == null) {
            gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            this.globalManagerAdapter = new GlobalManagerAdapter(){

                public void downloadManagerRemoved(DownloadManager dm) {
                    VuzeActivitiesEntry.this.setDownloadManager(null);
                }
            };
            gm.addListener(this.globalManagerAdapter, false);
        }
        this.dm = dm;
        if (dm != null) {
            this.setTorrent(dm.getTorrent());
        }
    }

    public DownloadManager getDownloadManger() {
        return this.dm;
    }

    public void setImageBytes(byte[] imageBytes) {
        this.imageBytes = imageBytes;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public void setShowThumb(boolean showThumb) {
        this.showThumb = showThumb;
    }

    public boolean getShowThumb() {
        return this.showThumb;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void setTorrent(TOTorrent torrent) {
        this.torrent = torrent;
        try {
            this.assetHash = torrent.getHashWrapper().toBase32String();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDRM(torrent == null ? false : PlatformTorrentUtils.isContentDRM(torrent));
        this.setIsPlatformContent(torrent == null ? false : PlatformTorrentUtils.isContent(torrent, true));
    }

    public boolean isDRM() {
        return this.isDRM;
    }

    public void setDRM(boolean isDRM) {
        this.isDRM = isDRM;
    }

    public String getTorrentName() {
        if (this.torrentName == null) {
            if (this.dm != null) {
                return PlatformTorrentUtils.getContentTitle2(this.dm);
            }
            if (this.torrent != null) {
                return TorrentUtils.getLocalisedName(this.torrent);
            }
        }
        return this.torrentName;
    }

    public void setTorrentName(String torrentName) {
        this.torrentName = torrentName;
    }

    public SelectedContentV3 createSelectedContentObject() throws Exception {
        boolean ourContent = DataSourceUtils.isPlatformContent(this);
        SelectedContentV3 sc = new SelectedContentV3();
        this.dm = this.getDownloadManger();
        if (this.dm != null) {
            sc.setDisplayName(PlatformTorrentUtils.getContentTitle2(this.dm));
            sc.setDM(this.dm);
            return sc;
        }
        sc.setDisplayName(this.getTorrentName());
        if (sc.getDisplayName() == null) {
            TOTorrent torrent = this.getTorrent();
            if (torrent != null) {
                sc.setDisplayName(TorrentUtils.getLocalisedName(torrent));
                sc.setHash(torrent.getHashWrapper().toBase32String(), ourContent);
            } else {
                throw new Exception("No Display Name");
            }
        }
        if (sc.getHash() != null || this.assetHash == null) {
            throw new Exception("No Download Info");
        }
        sc.setHash(this.assetHash, true);
        sc.setThumbURL(this.assetImageURL);
        sc.setImageBytes(this.imageBytes);
        return sc;
    }

    public boolean isPlatformContent() {
        return this.isPlatformContent;
    }

    public void setIsPlatformContent(boolean isPlatformContent) {
        this.isPlatformContent = isPlatformContent;
    }

    public boolean isPlayable() {
        if (this.playable) {
            return true;
        }
        return PlayUtils.canPlayDS(DataSourceUtils.getTorrent(this));
    }

    public void setPlayable(boolean playable) {
        this.playable = playable;
    }

    public long getReadOn() {
        return this.readOn;
    }

    public void setReadOn(long readOn) {
        if (this.readOn == readOn) {
            return;
        }
        this.readOn = readOn;
        VuzeActivitiesManager.triggerEntryChanged(this);
    }

    public void setRead(boolean read) {
        long now = SystemTime.getCurrentTime();
        if (read) {
            this.setReadOn(now);
        } else {
            this.setReadOn(now * -1L);
        }
    }

    public boolean isRead() {
        return this.readOn > 0L;
    }

    public boolean canFlipRead() {
        long ofs = SystemTime.getOffsetTime(-300L);
        if (this.readOn > 0L) {
            return ofs > this.readOn;
        }
        return ofs > -1L * this.readOn;
    }
}

