/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.crypto;

import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.crypto.VuzeCryptoException;
import com.aelitis.azureus.core.crypto.VuzeCryptoListener;
import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.security.CryptoManagerPasswordHandler;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import java.util.Iterator;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;

public class VuzeCryptoManager {
    private static VuzeCryptoManager singleton;
    private boolean init_tried;
    private CryptoManager crypt_man;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private volatile CryptoManagerPasswordHandler.passwordDetails session_pw;

    public static synchronized VuzeCryptoManager getSingleton() {
        if (singleton == null) {
            singleton = new VuzeCryptoManager();
        }
        return singleton;
    }

    protected VuzeCryptoManager() {
        this.crypt_man = CryptoManagerFactory.getSingleton();
        this.crypt_man.addPasswordHandler(new CryptoManagerPasswordHandler(){
            private boolean error_logged = !Constants.isCVSVersion();

            public int getHandlerType() {
                return 2;
            }

            public void passwordOK(int handler_type, CryptoManagerPasswordHandler.passwordDetails details) {
                Iterator it = VuzeCryptoManager.this.listeners.iterator();
                while (it.hasNext()) {
                    ((VuzeCryptoListener)it.next()).sessionPasswordCorrect();
                }
            }

            public CryptoManagerPasswordHandler.passwordDetails getPassword(int handler_type, int action_type, boolean last_pw_incorrect, String reason) {
                if (last_pw_incorrect) {
                    Iterator it = VuzeCryptoManager.this.listeners.iterator();
                    while (it.hasNext()) {
                        ((VuzeCryptoListener)it.next()).sessionPasswordIncorrect();
                    }
                    return null;
                }
                if (VuzeCryptoManager.this.session_pw != null) {
                    return VuzeCryptoManager.this.session_pw;
                }
                Iterator it = VuzeCryptoManager.this.listeners.iterator();
                while (it.hasNext()) {
                    try {
                        final char[] pw = ((VuzeCryptoListener)it.next()).getSessionPassword(reason);
                        VuzeCryptoManager.this.session_pw = new CryptoManagerPasswordHandler.passwordDetails(){

                            public char[] getPassword() {
                                return pw;
                            }

                            public int getPersistForSeconds() {
                                return -1;
                            }
                        };
                        this.error_logged = false;
                        return VuzeCryptoManager.this.session_pw;
                    }
                    catch (VuzeCryptoException ve) {
                        if (this.error_logged) continue;
                        this.error_logged = true;
                        Debug.out("Listener failed " + ve.toString() + " on " + reason);
                        if (ve.getCause() == null) continue;
                        Debug.out(ve.getCause());
                    }
                    catch (Throwable e) {
                        Debug.out("Listener failed", e);
                    }
                }
                if (!this.error_logged) {
                    this.error_logged = true;
                    Debug.out("VuzeCryptoManager: no listeners returned session key");
                }
                return null;
            }
        });
        boolean init_done = COConfigurationManager.getBooleanParameter("vuze.crypto.manager.initial.login.done", false);
        if (!init_done) {
            AzureusCore core = AzureusCoreFactory.getSingleton();
            AzureusCoreFactory.getSingleton().addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                public void started(AzureusCore core) {
                    VuzeCryptoManager.this.initialise(core);
                }
            });
            if (core.isStarted()) {
                this.initialise(core);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(AzureusCore core) {
        BuddyPlugin buddy_plugin;
        Plugin plugin;
        VuzeCryptoManager vuzeCryptoManager = this;
        synchronized (vuzeCryptoManager) {
            if (this.init_tried) {
                return;
            }
            this.init_tried = true;
        }
        PluginInterface pi = core.getPluginManager().getPluginInterfaceByID("azbuddy");
        if (pi != null && (plugin = pi.getPlugin()) instanceof BuddyPlugin && !(buddy_plugin = (BuddyPlugin)plugin).isEnabled()) {
            CryptoHandler handler = this.crypt_man.getECCHandler();
            if (handler.peekPublicKey() == null) {
                try {
                    handler.setDefaultPasswordHandlerType(2);
                }
                catch (Throwable e) {
                    VuzeBuddyManager.log("CRYPTO: Failed to set default password handler type: " + Debug.getNestedExceptionMessage(e));
                }
            }
            buddy_plugin.setEnabled(true);
            COConfigurationManager.setParameter("vuze.crypto.manager.initial.login.done", true);
            COConfigurationManager.save();
            VuzeBuddyManager.log("CRYPTO: initialised buddy plugin and default handler type");
        }
    }

    public byte[] getPlatformAZID() {
        return this.crypt_man.getSecureID();
    }

    public String getPublicKey(String reason) throws VuzeCryptoException {
        try {
            return Base32.encode(this.crypt_man.getECCHandler().getPublicKey(reason));
        }
        catch (Throwable e) {
            throw new VuzeCryptoException("Failed to access public key", e);
        }
    }

    public boolean hasPublicKey() {
        return this.crypt_man.getECCHandler().peekPublicKey() != null;
    }

    public void createNewKeys() throws VuzeCryptoException {
        try {
            this.crypt_man.getECCHandler().resetKeys("Creating new keys");
        }
        catch (Throwable e) {
            throw new VuzeCryptoException("Failed to access public key", e);
        }
    }

    public void clearPassword() {
        this.session_pw = null;
        this.crypt_man.clearPasswords(2);
    }

    public void setPassword(String pw) {
        final char[] pw_chars = pw.toCharArray();
        this.session_pw = new CryptoManagerPasswordHandler.passwordDetails(){

            public char[] getPassword() {
                return pw_chars;
            }

            public int getPersistForSeconds() {
                return -1;
            }
        };
        new AEThread2("VuzeCryptoManager:testUnlock", true){

            public void run() {
                try {
                    VuzeCryptoManager.this.crypt_man.getECCHandler().unlock();
                }
                catch (Throwable e) {
                    Debug.out("Password incorrect", e);
                }
            }
        }.start();
    }

    public void addListener(VuzeCryptoListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(VuzeCryptoListener listener) {
        this.listeners.remove(listener);
    }
}

