/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacket;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;

public class DHTUDPPacketReply
extends PRUDPPacketReply
implements DHTUDPPacket {
    public static final int DHT_HEADER_SIZE = 22;
    private DHTTransportUDPImpl transport;
    private long connection_id;
    private byte protocol_version;
    private byte vendor_id = (byte)-1;
    private int network;
    private int target_instance_id;
    private long skew;
    private DHTNetworkPosition[] network_positions;

    public DHTUDPPacketReply(DHTTransportUDPImpl _transport, int _type, int _trans_id, long _conn_id, DHTTransportContact _local_contact, DHTTransportContact _remote_contact) {
        super(_type, _trans_id);
        this.transport = _transport;
        this.connection_id = _conn_id;
        this.protocol_version = _remote_contact.getProtocolVersion();
        if (this.protocol_version > _transport.getProtocolVersion()) {
            this.protocol_version = _transport.getProtocolVersion();
        }
        this.target_instance_id = _local_contact.getInstanceID();
        this.skew = _remote_contact.getClockSkew();
    }

    protected DHTUDPPacketReply(DHTUDPPacketNetworkHandler network_handler, InetSocketAddress originator, DataInputStream is, int type, int trans_id) throws IOException {
        super(type, trans_id);
        this.setAddress(originator);
        this.connection_id = is.readLong();
        this.protocol_version = is.readByte();
        if (this.protocol_version >= 14) {
            this.vendor_id = is.readByte();
        }
        if (this.protocol_version >= 9) {
            this.network = is.readInt();
        }
        if (this.protocol_version < (this.network == 1 ? (byte)21 : 16)) {
            throw new IOException("Invalid DHT protocol version, please update Azureus");
        }
        this.transport = network_handler.getTransport(this);
        this.target_instance_id = is.readInt();
    }

    public DHTTransportUDPImpl getTransport() {
        return this.transport;
    }

    protected int getTargetInstanceID() {
        return this.target_instance_id;
    }

    public long getConnectionId() {
        return this.connection_id;
    }

    protected long getClockSkew() {
        return this.skew;
    }

    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    protected byte getVendorID() {
        return this.vendor_id;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int _network) {
        this.network = _network;
    }

    protected DHTNetworkPosition[] getNetworkPositions() {
        return this.network_positions;
    }

    protected void setNetworkPositions(DHTNetworkPosition[] _network_positions) {
        this.network_positions = _network_positions;
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeLong(this.connection_id);
        os.writeByte(this.protocol_version);
        if (this.protocol_version >= 14) {
            os.writeByte(0);
        }
        if (this.protocol_version >= 9) {
            os.writeInt(this.network);
        }
        os.writeInt(this.target_instance_id);
    }

    public String getString() {
        return super.getString() + ",[con=" + this.connection_id + ",prot=" + this.protocol_version + ",ven=" + this.vendor_id + ",net=" + this.network + "]";
    }
}

