/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.util;

import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.gudy.azureus2.core3.util.SystemTime;

public abstract class DHTTransportStatsImpl
implements DHTTransportStats {
    private byte protocol_version;
    private long[] pings = new long[4];
    private long[] find_nodes = new long[4];
    private long[] find_values = new long[4];
    private long[] stores = new long[4];
    private long[] stats = new long[4];
    private long[] data = new long[4];
    private long[] key_blocks = new long[4];
    private long[] aliens = new long[6];
    private long incoming_requests;
    private long outgoing_requests;
    private long incoming_version_requests;
    private long[] incoming_request_versions;
    private long outgoing_version_requests;
    private long[] outgoing_request_versions;
    private static final int SKEW_VALUE_MAX = 256;
    private final int[] skew_values = new int[256];
    private int skew_pos = 0;
    private long last_skew_average;
    private long last_skew_average_time;
    private BloomFilter skew_originator_bloom = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(1024), 2);

    protected DHTTransportStatsImpl(byte _protocol_version) {
        this.protocol_version = _protocol_version;
        this.incoming_request_versions = new long[this.protocol_version + 1];
        this.outgoing_request_versions = new long[this.protocol_version + 1];
        Arrays.fill(this.skew_values, Integer.MAX_VALUE);
    }

    protected byte getProtocolVersion() {
        return this.protocol_version;
    }

    public void add(DHTTransportStatsImpl other) {
        this.add(this.pings, other.pings);
        this.add(this.find_nodes, other.find_nodes);
        this.add(this.find_values, other.find_values);
        this.add(this.stores, other.stores);
        this.add(this.stats, other.stats);
        this.add(this.data, other.data);
        this.add(this.key_blocks, other.key_blocks);
        this.add(this.aliens, other.aliens);
        this.incoming_requests += other.incoming_requests;
        this.outgoing_requests += other.outgoing_requests;
    }

    protected void add(long[] a, long[] b) {
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
    }

    protected void snapshotSupport(DHTTransportStatsImpl clone) {
        clone.pings = (long[])this.pings.clone();
        clone.find_nodes = (long[])this.find_nodes.clone();
        clone.find_values = (long[])this.find_values.clone();
        clone.stores = (long[])this.stores.clone();
        clone.data = (long[])this.data.clone();
        clone.key_blocks = (long[])this.key_blocks.clone();
        clone.aliens = (long[])this.aliens.clone();
        clone.incoming_requests = this.incoming_requests;
        clone.outgoing_requests = this.outgoing_requests;
    }

    public void pingSent(DHTUDPPacketRequest request2) {
        this.pings[0] = this.pings[0] + 1L;
        this.outgoingRequestSent(request2);
    }

    public void pingOK() {
        this.pings[1] = this.pings[1] + 1L;
    }

    public void pingFailed() {
        this.pings[2] = this.pings[2] + 1L;
    }

    public void pingReceived() {
        this.pings[3] = this.pings[3] + 1L;
    }

    public long[] getPings() {
        return this.pings;
    }

    public void keyBlockSent(DHTUDPPacketRequest request2) {
        this.key_blocks[0] = this.key_blocks[0] + 1L;
        this.outgoingRequestSent(request2);
    }

    public void keyBlockOK() {
        this.key_blocks[1] = this.key_blocks[1] + 1L;
    }

    public void keyBlockFailed() {
        this.key_blocks[2] = this.key_blocks[2] + 1L;
    }

    public void keyBlockReceived() {
        this.key_blocks[3] = this.key_blocks[3] + 1L;
    }

    public long[] getKeyBlocks() {
        return this.key_blocks;
    }

    public void findNodeSent(DHTUDPPacketRequest request2) {
        this.find_nodes[0] = this.find_nodes[0] + 1L;
        this.outgoingRequestSent(request2);
    }

    public void findNodeOK() {
        this.find_nodes[1] = this.find_nodes[1] + 1L;
    }

    public void findNodeFailed() {
        this.find_nodes[2] = this.find_nodes[2] + 1L;
    }

    public void findNodeReceived() {
        this.find_nodes[3] = this.find_nodes[3] + 1L;
    }

    public long[] getFindNodes() {
        return this.find_nodes;
    }

    public void findValueSent(DHTUDPPacketRequest request2) {
        this.find_values[0] = this.find_values[0] + 1L;
        this.outgoingRequestSent(request2);
    }

    public void findValueOK() {
        this.find_values[1] = this.find_values[1] + 1L;
    }

    public void findValueFailed() {
        this.find_values[2] = this.find_values[2] + 1L;
    }

    public void findValueReceived() {
        this.find_values[3] = this.find_values[3] + 1L;
    }

    public long[] getFindValues() {
        return this.find_values;
    }

    public void storeSent(DHTUDPPacketRequest request2) {
        this.stores[0] = this.stores[0] + 1L;
        this.outgoingRequestSent(request2);
    }

    public void storeOK() {
        this.stores[1] = this.stores[1] + 1L;
    }

    public void storeFailed() {
        this.stores[2] = this.stores[2] + 1L;
    }

    public void storeReceived() {
        this.stores[3] = this.stores[3] + 1L;
    }

    public long[] getStores() {
        return this.stores;
    }

    public void statsSent(DHTUDPPacketRequest request2) {
        this.stats[0] = this.stats[0] + 1L;
        this.outgoingRequestSent(request2);
    }

    public void statsOK() {
        this.stats[1] = this.stats[1] + 1L;
    }

    public void statsFailed() {
        this.stats[2] = this.stats[2] + 1L;
    }

    public void statsReceived() {
        this.stats[3] = this.stats[3] + 1L;
    }

    public void dataSent(DHTUDPPacketRequest request2) {
        this.data[0] = this.data[0] + 1L;
        this.outgoingRequestSent(request2);
    }

    public void dataOK() {
        this.data[1] = this.data[1] + 1L;
    }

    public void dataFailed() {
        this.data[2] = this.data[2] + 1L;
    }

    public void dataReceived() {
        this.data[3] = this.data[3] + 1L;
    }

    public long[] getData() {
        return this.data;
    }

    protected void outgoingRequestSent(DHTUDPPacketRequest request2) {
        ++this.outgoing_requests;
    }

    public void incomingRequestReceived(DHTUDPPacketRequest request2, boolean alien) {
        ++this.incoming_requests;
        if (alien) {
            int type = request2.getAction();
            if (type == 1028) {
                this.aliens[0] = this.aliens[0] + 1L;
            } else if (type == 1030) {
                this.aliens[1] = this.aliens[1] + 1L;
            } else if (type == 1024) {
                this.aliens[2] = this.aliens[2] + 1L;
            } else if (type == 1034) {
                this.aliens[3] = this.aliens[3] + 1L;
            } else if (type == 1026) {
                this.aliens[4] = this.aliens[4] + 1L;
            } else if (type == 1036) {
                this.aliens[5] = this.aliens[5] + 1L;
            }
        }
    }

    public long[] getAliens() {
        return this.aliens;
    }

    public long getIncomingRequests() {
        return this.incoming_requests;
    }

    public void recordSkew(InetSocketAddress originator_address, long skew) {
        byte[] bytes = originator_address.getAddress().getAddress();
        if (this.skew_originator_bloom.contains(bytes)) {
            return;
        }
        this.skew_originator_bloom.add(bytes);
        int i_skew = skew < Integer.MAX_VALUE ? (int)skew : 0x7FFFFFFE;
        int pos = this.skew_pos;
        this.skew_values[pos++] = i_skew;
        if (pos == 256) {
            pos = 0;
        }
        this.skew_pos = pos;
    }

    public long getSkewAverage() {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_skew_average_time || now - this.last_skew_average_time > 30000L) {
            int pos;
            int[] values = (int[])this.skew_values.clone();
            int num_values = values[pos = this.skew_pos] == Integer.MAX_VALUE ? pos : 256;
            Arrays.sort(values, 0, num_values);
            int start = num_values / 3;
            int end = 2 * num_values / 3;
            int entries = end - start;
            if (entries < 5) {
                this.last_skew_average = 0L;
            } else {
                long total = 0L;
                for (int i = start; i < end; ++i) {
                    total += (long)values[i];
                }
                this.last_skew_average = total / (long)entries;
            }
            this.last_skew_average_time = now;
        }
        return this.last_skew_average;
    }

    public String getString() {
        return "ping:" + this.getString(this.pings) + "," + "store:" + this.getString(this.stores) + "," + "node:" + this.getString(this.find_nodes) + "," + "value:" + this.getString(this.find_values) + "," + "stats:" + this.getString(this.stats) + "," + "data:" + this.getString(this.data) + "," + "kb:" + this.getString(this.key_blocks) + "," + "incoming:" + this.incoming_requests + "," + "alien:" + this.getString(this.aliens);
    }

    protected String getString(long[] x) {
        String str = "";
        for (int i = 0; i < x.length; ++i) {
            str = str + (i == 0 ? "" : ",") + x[i];
        }
        return str;
    }
}

