/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import java.io.File;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class CacheFileWithoutCache
implements CacheFile {
    protected CacheFileManagerImpl manager;
    protected FMFile file;
    protected TOTorrentFile torrent_file;

    protected CacheFileWithoutCache(CacheFileManagerImpl _manager, FMFile _file, TOTorrentFile _torrent_file) {
        this.manager = _manager;
        this.file = _file;
        this.torrent_file = _torrent_file;
    }

    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void moveFile(File new_file) throws CacheFileManagerException {
        try {
            this.file.moveFile(new_file);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void setAccessMode(int mode) throws CacheFileManagerException {
        try {
            this.file.setAccessMode(mode == 1 ? 1 : 2);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public int getAccessMode() {
        return this.file.getAccessMode() == 1 ? 1 : 2;
    }

    public void setStorageType(int type) throws CacheFileManagerException {
        try {
            this.file.setStorageType(type == 2 ? 2 : 1);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public int getStorageType() {
        return this.file.getStorageType() == 2 ? 2 : 1;
    }

    public long getLength() throws CacheFileManagerException {
        try {
            return this.file.exists() ? this.file.getLength() : 0L;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return 0L;
        }
    }

    public long compareLength(long compare_to) throws CacheFileManagerException {
        return this.getLength() - compare_to;
    }

    public void setLength(long length) throws CacheFileManagerException {
        try {
            this.file.setLength(length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void read(DirectByteBuffer[] buffers, long position, short policy) throws CacheFileManagerException {
        int read_length = 0;
        for (int i = 0; i < buffers.length; ++i) {
            read_length += buffers[i].remaining((byte)3);
        }
        try {
            this.file.read(buffers, position);
            this.manager.fileBytesRead(read_length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void read(DirectByteBuffer buffer, long position, short policy) throws CacheFileManagerException {
        int read_length = buffer.remaining((byte)3);
        try {
            this.file.read(buffer, position);
            this.manager.fileBytesRead(read_length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void write(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        try {
            this.file.write(buffer, position);
            this.manager.fileBytesWritten(write_length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void write(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        int write_length = 0;
        for (int i = 0; i < buffers.length; ++i) {
            write_length += buffers[i].remaining((byte)3);
        }
        try {
            this.file.write(buffers, position);
            this.manager.fileBytesWritten(write_length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndHandoverBuffer(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        int write_length = buffer.remaining((byte)3);
        boolean write_ok = false;
        try {
            this.file.write(buffer, position);
            this.manager.fileBytesWritten(write_length);
            write_ok = true;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
        finally {
            if (write_ok) {
                buffer.returnToPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAndHandoverBuffers(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        block7: {
            int write_length = 0;
            for (int i = 0; i < buffers.length; ++i) {
                write_length += buffers[i].remaining((byte)3);
            }
            boolean write_ok = false;
            try {
                this.file.write(buffers, position);
                this.manager.fileBytesWritten(write_length);
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
            }
            finally {
                if (!write_ok) break block7;
                for (int i = 0; i < buffers.length; ++i) {
                    buffers[i].returnToPool();
                }
            }
        }
    }

    public void flushCache() throws CacheFileManagerException {
        try {
            this.file.flush();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public void clearCache() throws CacheFileManagerException {
    }

    public void close() throws CacheFileManagerException {
        try {
            this.file.close();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    public boolean isOpen() {
        return this.file.isOpen();
    }

    public void delete() throws CacheFileManagerException {
        try {
            this.file.delete();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }
}

