/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.drm.msdrm;

import com.aelitis.azureus.core.drm.msdrm.CheckVersionRequiredException;
import com.aelitis.azureus.core.drm.msdrm.DRMUpdateRequiredException;
import com.aelitis.azureus.core.drm.msdrm.ExceededDRMDeliveryLimitException;
import com.aelitis.azureus.core.drm.msdrm.LicenseAquisitionException;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.json.simple.JSONObject;

public class LicenseAquirer {
    private static final String STATUS_REQUESTED = "requested";
    private static final String STATUS_INSTALLED = "installed";
    private static final String STATUS_SUCCESS = "success";
    private static final String STATUS_UPDATE = "update";
    private static final String STATUS_FAILURE = "failure";
    private static final String STATUS_CLIENT_FAILURE = "client-failure";
    private static final String ERROR_INCOMPATIBLE_CLIENT = "Incompatible Client";
    private static final String ERROR_SERVER_COMMUNICATION = "Server did not send a valid response";
    private static final String ERROR_EXCEEDED_DRM_DELIVERY_LIMIT = "Key delivery limit exceeded.";
    private Browser browser;

    public LicenseAquirer(Composite composite) {
        this.browser = new Browser(composite, 0);
        this.browser.setText("<html><body><object id=\"netobj\" classid=\"clsid:A9FC132B-096D-460B-B7D5-1DB0FAE0C062\" width=\"0\" height=\"0\"></object></body></html>");
        this.browser.setVisible(false);
    }

    private String getSystemInfo() throws LicenseAquisitionException {
        final AESemaphore sem = new AESemaphore("waitForBrowserResponse");
        final String[] result = new String[]{null};
        this.browser.getDisplay().asyncExec(new Runnable(){

            public void run() {
                LicenseAquirer.this.browser.addStatusTextListener(new StatusTextListener(){

                    public void changed(StatusTextEvent event2) {
                        if (!"".equals(event2.text)) {
                            LicenseAquirer.this.browser.removeStatusTextListener((StatusTextListener)this);
                            result[0] = event2.text;
                            sem.release();
                        }
                    }
                });
                LicenseAquirer.this.browser.execute("try {window.status = netobj.GetSystemInfo(); } catch(e) { window.status= 'ERROR : ' + e ; }");
            }
        });
        sem.reserve(10000L);
        if (result[0] == null) {
            throw new LicenseAquisitionException("JS Call did not complete");
        }
        if (result[0].startsWith("ERROR : ")) {
            throw new LicenseAquisitionException("JS Call returned : " + result[0]);
        }
        return result[0];
    }

    private String getDRMVersion() throws LicenseAquisitionException {
        final AESemaphore sem = new AESemaphore("waitForBrowserResponse");
        final String[] result = new String[]{null};
        this.browser.getDisplay().asyncExec(new Runnable(){

            public void run() {
                LicenseAquirer.this.browser.addStatusTextListener(new StatusTextListener(){

                    public void changed(StatusTextEvent event2) {
                        LicenseAquirer.this.browser.removeStatusTextListener((StatusTextListener)this);
                        result[0] = event2.text;
                        sem.release();
                    }
                });
                LicenseAquirer.this.browser.execute("try { window.status = netobj.GetDRMVersion(); } catch(e) { window.status= 'ERROR : ' + e ; }");
            }
        });
        sem.reserve(10000L);
        if (result[0] == null) {
            throw new LicenseAquisitionException("JS Call did not complete");
        }
        if (result[0].startsWith("ERROR : ")) {
            throw new LicenseAquisitionException("JS Call returned : " + result[0]);
        }
        return result[0];
    }

    private void storeLicense(final String license) throws LicenseAquisitionException {
        this.browser.getDisplay().asyncExec(new Runnable(){

            public void run() {
                LicenseAquirer.this.browser.execute("netobj.StoreLicense(" + license + ");");
            }
        });
    }

    private void makeRPCRequest(String rpcCommand, JSONObject rpcParameters, PlatformMessengerListener listener) throws LicenseAquisitionException {
        PlatformMessage message = new PlatformMessage("drm", "drm", rpcCommand, rpcParameters, 60000L);
        PlatformMessenger.queueMessage(message, listener);
    }

    private boolean checkDRMVersion(String systemInfo, String drmVersion) throws LicenseAquisitionException, DRMUpdateRequiredException {
        JSONObject parameters = new JSONObject();
        parameters.put("drmVersion", drmVersion);
        parameters.put("clientInfo", systemInfo);
        final AESemaphore sem = new AESemaphore("waitForPlatformResponse");
        final Boolean[] result = new Boolean[]{null};
        final Exception[] error = new Exception[]{null};
        this.makeRPCRequest("check", parameters, new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                try {
                    if ("response".equals(replyType) && reply.get("action") != null) {
                        Map action = (Map)reply.get("action");
                        if (action.get("name") != null) {
                            String name = (String)action.get("name");
                            if (LicenseAquirer.STATUS_UPDATE.equals(name)) {
                                error[0] = new DRMUpdateRequiredException((String)action.get("url"));
                            }
                            if (LicenseAquirer.STATUS_SUCCESS.equals(name)) {
                                result[0] = new Boolean(true);
                            }
                        }
                        error[0] = new LicenseAquisitionException("no action, or invalid action in response");
                        return;
                    }
                    if ("exception".equals(replyType)) {
                        error[0] = new LicenseAquisitionException("Platform Call returned : " + reply.toString());
                    }
                }
                finally {
                    sem.release();
                }
            }
        });
        sem.reserve();
        if (result[0] == null && error[0] == null) {
            throw new LicenseAquisitionException("Platform Call did not complete");
        }
        if (error[0] != null) {
            if (error[0] instanceof LicenseAquisitionException) {
                throw (LicenseAquisitionException)error[0];
            }
            if (error[0] instanceof DRMUpdateRequiredException) {
                throw (DRMUpdateRequiredException)error[0];
            }
            throw new LicenseAquisitionException(error[0].getMessage());
        }
        Boolean res = result[0];
        if (res != null) {
            return res;
        }
        return false;
    }

    private String getLicenseFromPlatform(String systemInfo, String contentHash) throws LicenseAquisitionException, CheckVersionRequiredException, ExceededDRMDeliveryLimitException {
        JSONObject parameters = new JSONObject();
        parameters.put("hash", contentHash);
        parameters.put("clientInfo", systemInfo);
        final AESemaphore sem = new AESemaphore("waitForPlatformResponse");
        final String[] result = new String[]{null};
        final Exception[] error = new Exception[]{null};
        this.makeRPCRequest("deliver", parameters, new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
                System.out.println("sent");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                try {
                    if ("response".equals(replyType)) {
                        if (reply.get("license") != null) {
                            result[0] = (String)reply.get("license");
                            return;
                        }
                        if (reply.get("rejected") != null && LicenseAquirer.ERROR_EXCEEDED_DRM_DELIVERY_LIMIT.equals(reply.get("rejected"))) {
                            error[0] = new ExceededDRMDeliveryLimitException(LicenseAquirer.ERROR_EXCEEDED_DRM_DELIVERY_LIMIT);
                            return;
                        }
                        if (reply.get("action") != null) {
                            String name;
                            Map action = (Map)reply.get("action");
                            if (action.get("name") != null && "check".equals(name = (String)action.get("name"))) {
                                error[0] = new CheckVersionRequiredException(LicenseAquirer.ERROR_EXCEEDED_DRM_DELIVERY_LIMIT);
                            }
                            error[0] = new LicenseAquisitionException("no action, or invalid action in response");
                            return;
                        }
                    }
                    if ("exception".equals(replyType)) {
                        error[0] = new LicenseAquisitionException("Platform Call returned : " + reply.toString());
                    }
                }
                finally {
                    sem.release();
                }
            }
        });
        sem.reserve();
        if (result[0] == null && error[0] == null) {
            throw new LicenseAquisitionException("Platform Call did not complete");
        }
        if (error[0] != null) {
            if (error[0] instanceof LicenseAquisitionException) {
                throw (LicenseAquisitionException)error[0];
            }
            if (error[0] instanceof CheckVersionRequiredException) {
                throw (CheckVersionRequiredException)error[0];
            }
            if (error[0] instanceof ExceededDRMDeliveryLimitException) {
                throw (ExceededDRMDeliveryLimitException)error[0];
            }
            throw new LicenseAquisitionException(error[0].getMessage());
        }
        String res = result[0];
        return res;
    }

    public void aquireLicenseFor(String contentHash) throws LicenseAquisitionException, ExceededDRMDeliveryLimitException, DRMUpdateRequiredException {
        String systemInfo = this.getSystemInfo();
        String license = null;
        try {
            license = this.getLicenseFromPlatform(systemInfo, contentHash);
        }
        catch (CheckVersionRequiredException e) {
            this.checkDRMSystem();
        }
        if (license == null) {
            throw new LicenseAquisitionException("failed to aquire a license");
        }
        this.storeLicense(license);
        System.out.println("license aquired");
    }

    public boolean checkDRMSystem() throws LicenseAquisitionException, DRMUpdateRequiredException {
        String systemInfo = this.getSystemInfo();
        String drmVersion = this.getDRMVersion();
        return this.checkDRMVersion(systemInfo, drmVersion);
    }

    public static void main(String[] args) throws Exception {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.open();
        final LicenseAquirer la = new LicenseAquirer((Composite)shell);
        Thread t = new Thread(){

            public void run() {
                try {
                    la.aquireLicenseFor("SNWEAY7K6RJPAJF2HD52BEX27ERKJXAO");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.setDaemon(true);
        t.start();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

