/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.RatingUpdateListener2;
import com.aelitis.azureus.core.torrent.GlobalRatingUtils;
import com.aelitis.azureus.core.torrent.PlatformRatingInfoList;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.torrent.RatingInfoList;
import com.aelitis.azureus.core.torrent.SingleUserRatingInfo;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class PlatformRatingMessenger {
    private static final int GLOBAL_DEF_EXPIRY_MINS = 2880;
    private static final long GLOBAL_RETRY_UPDATERATING = 600000L;
    public static final String LISTENER_ID = "rating";
    public static final String OP_GET = "get";
    public static final String OP_SET = "set";
    public static final String RATE_TYPE_CONTENT = "content";
    public static final ArrayList listeners = new ArrayList();

    public static void getUserRating(String[] rateTypes, final String[] torrentHashes, long maxDelayMS) {
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "get-user", new Object[]{"rating-type", rateTypes, "torrent-hash", torrentHashes}, maxDelayMS);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
            }

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                PlatformRatingInfoList ratingReply = new PlatformRatingInfoList(reply);
                AzureusCore core = AzureusCoreFactory.getSingleton();
                for (int i = 0; i < torrentHashes.length; ++i) {
                    DownloadManager dm;
                    String hash = torrentHashes[i];
                    long value = ((GetRatingReply)ratingReply).getRatingValue(hash, PlatformRatingMessenger.RATE_TYPE_CONTENT);
                    if (value < -1L || (dm = core.getGlobalManager().getDownloadManager(new HashWrapper(Base32.decode(hash)))) == null || dm.getTorrent() == null) continue;
                    if (PlatformRatingMessenger.ratingSucceeded(reply)) {
                        PlatformTorrentUtils.setUserRating(dm.getTorrent(), (int)value);
                        continue;
                    }
                    PlatformTorrentUtils.setUserRating(dm.getTorrent(), -1);
                }
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    private static void getGlobalRating(String[] rateTypes, String[] torrentHashes, long maxDelayMS, final GetRatingReplyListener replyListener) {
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "get-global", new Object[]{"rating-type", rateTypes, "torrent-hash", torrentHashes}, maxDelayMS);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
                replyListener.messageSent();
            }

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                PlatformRatingInfoList ratingReply = new PlatformRatingInfoList(reply);
                PlatformRatingMessenger.invokeUpdateListeners(ratingReply);
                replyListener.replyReceived(replyType, ratingReply);
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void setUserRating(final TOTorrent torrent, final int rating, final boolean updateGlobalRatingAfter, long maxDelayMS, final PlatformMessengerListener l) {
        if (torrent == null) {
            return;
        }
        String torrentHash = null;
        try {
            torrentHash = torrent.getHashWrapper().toBase32String();
        }
        catch (TOTorrentException e) {
            // empty catch block
        }
        if (torrentHash == null) {
            return;
        }
        String fTorrentHash = torrentHash;
        ArrayList<Map> array = new ArrayList<Map>();
        array.add(PlatformMessage.parseParams(new Object[]{"rating-type", RATE_TYPE_CONTENT, "rating-value", new Integer(rating)}));
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_SET, new Object[]{"torrent-hash", torrentHash, "ratings", array}, maxDelayMS);
        final int oldRating = PlatformTorrentUtils.getUserRating(torrent);
        SingleUserRatingInfo ratingReply = new SingleUserRatingInfo(torrent);
        PlatformTorrentUtils.setUserRating(torrent, -2);
        PlatformMessenger.queueMessage(message, new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
                if (l != null) {
                    l.messageSent(message);
                }
            }

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                if (PlatformRatingMessenger.ratingSucceeded(reply)) {
                    PlatformTorrentUtils.setUserRating(torrent, rating);
                    if (updateGlobalRatingAfter) {
                        PlatformRatingMessenger.updateGlobalRating(torrent, 2000L);
                    }
                } else {
                    PlatformTorrentUtils.setUserRating(torrent, oldRating == -2 ? -1 : oldRating);
                }
                if (l != null) {
                    l.replyReceived(message, replyType, reply);
                }
            }
        });
    }

    public static boolean ratingSucceeded(Map map) {
        String message = MapUtils.getMapString(map, "message", null);
        if (message != null) {
            return message.equals("Ok");
        }
        return MapUtils.getMapBoolean(map, "success", false);
    }

    public static void addListener(RatingUpdateListener2 l) {
        if (!listeners.contains(l)) {
            listeners.add(l);
        }
    }

    public static void removeListener(RatingUpdateListener2 l) {
        listeners.remove(l);
    }

    public static void addListener(RatingUpdateListener l) {
        if (!listeners.contains(l)) {
            listeners.add(l);
        }
    }

    public static void removeListener(RatingUpdateListener l) {
        listeners.remove(l);
    }

    public static void invokeUpdateListeners(RatingInfoList rating) {
        Object[] listArray = listeners.toArray();
        for (int i = 0; i < listArray.length; ++i) {
            try {
                if (listArray[i] instanceof RatingUpdateListener) {
                    ((RatingUpdateListener)listArray[i]).ratingUpdated(rating);
                    continue;
                }
                if (!(listArray[i] instanceof RatingUpdateListener2)) continue;
                ((RatingUpdateListener2)listArray[i]).ratingUpdated(rating);
                continue;
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public static void updateGlobalRating(final TOTorrent torrent, long maxDelayMS) {
        try {
            final String hash = torrent.getHashWrapper().toBase32String();
            if (PlatformTorrentUtils.DEBUG_CACHING) {
                PlatformTorrentUtils.log("v3.GR.caching: updateFromPlatform for " + torrent);
            }
            PlatformRatingMessenger.getGlobalRating(new String[]{RATE_TYPE_CONTENT}, new String[]{hash}, 5000L, new GetRatingReplyListener(){

                public void replyReceived(String replyType, RatingInfoList reply) {
                    if (PlatformTorrentUtils.DEBUG_CACHING) {
                        PlatformTorrentUtils.log("v3.GR.caching: reply '" + replyType + "' for " + torrent);
                    }
                    if (replyType.equals(PlatformMessenger.REPLY_RESULT)) {
                        String type = PlatformRatingMessenger.RATE_TYPE_CONTENT;
                        String rating = reply.getRatingString(hash, type);
                        String color = reply.getRatingColor(hash, type);
                        long count = reply.getRatingCount(hash, type);
                        long expireyMins = reply.getRatingExpireyMins(hash, type);
                        if (expireyMins <= 0L) {
                            expireyMins = 2880L;
                        }
                        long refreshOn = SystemTime.getCurrentTime() + expireyMins * 60L * 1000L;
                        GlobalRatingUtils.setRating(torrent, rating, color, count, refreshOn);
                    } else if (replyType.equals(PlatformMessenger.REPLY_EXCEPTION)) {
                        SimpleTimer.addEvent("Update MD Retry", SystemTime.getCurrentTime() + 600000L, new TimerEventPerformer(){

                            public void perform(TimerEvent event2) {
                                if (PlatformTorrentUtils.DEBUG_CACHING) {
                                    PlatformTorrentUtils.log("v3.GR.caching: retrying..");
                                }
                                PlatformRatingMessenger.updateGlobalRating(torrent, 15000L);
                            }
                        });
                    }
                }

                public void messageSent() {
                }
            });
        }
        catch (TOTorrentException e) {
            e.printStackTrace();
        }
    }

    public static abstract class GetRatingReply {
        public abstract boolean hasHash(String var1);

        public abstract long getRatingValue(String var1, String var2);

        public abstract long getRatingCount(String var1, String var2);

        public abstract String getRatingString(String var1, String var2);

        public abstract String getRatingColor(String var1, String var2);

        public abstract long getRatingExpireyMins(String var1, String var2);
    }

    private static abstract class GetRatingReplyListener {
        private GetRatingReplyListener() {
        }

        public abstract void messageSent();

        public abstract void replyReceived(String var1, RatingInfoList var2);
    }

    public static interface RatingUpdateListener {
        public void ratingUpdated(GetRatingReply var1);
    }
}

