/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.crypto.VuzeCryptoException;
import com.aelitis.azureus.core.crypto.VuzeCryptoManager;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.VuzeRelayListener;
import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessage;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginPasswordException;
import com.aelitis.azureus.util.LoginInfoManager;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class PlatformRelayMessenger {
    public static final String MSG_ID = "AZMSG";
    public static final String LISTENER_ID = "relay";
    public static final long DEFAULT_RECHECKIN_MINS = 30L;
    private static final long ERROR_RECHECKIN_MINS = 90L;
    private static final boolean TEST_ERRORACK = System.getProperty("relay.errack.test", "0").equals("1");
    public static String OP_FETCH = "fetch";
    public static String OP_PUT = "put";
    public static String OP_ACK = "ack";
    public static String OP_ERRORACK = "error_ack";
    public static String OP_COUNT = "count";
    public static List listeners = new ArrayList();
    private static TimerEventPerformer relayCheckPerformer;
    private static TimerEvent timerEvent;
    private static long lastPendingCount;

    public static final void put(final BuddyPluginBuddyMessage buddyMessage2, long maxDelayMS, final putListener putListener2) {
        try {
            final String myPK = VuzeCryptoManager.getSingleton().getPublicKey("RelayMessenger put");
            BuddyPluginBuddy pluginBuddy = buddyMessage2.getBuddy();
            final String pk = pluginBuddy.getPublicKey();
            byte[] encode = BEncoder.encode(buddyMessage2.getRequest());
            BuddyPlugin.cryptoResult encryptResult = pluginBuddy.encrypt(encode);
            final HashMap<String, String> mapParameters = new HashMap<String, String>();
            mapParameters.put("sender_pk", myPK);
            mapParameters.put("recipient_pk", pk);
            mapParameters.put("payload", Base32.encode(encryptResult.getPayload()));
            mapParameters.put("ack_hash", Base32.encode(encryptResult.getChallenge()));
            PlatformMessage message = new PlatformMessage(MSG_ID, LISTENER_ID, OP_PUT, mapParameters, maxDelayMS){

                public String toString() {
                    return "PlaformMessage {" + this.getSequenceNo() + ", " + this.getMessageID() + ", " + this.getListenerID() + ", " + this.getOperationID() + ", sender=" + myPK + ", recipient=" + pk + ", ack_hash=" + mapParameters.get("ack_hash") + "}";
                }
            };
            PlatformMessengerListener listener = new PlatformMessengerListener(){

                public void messageSent(PlatformMessage message) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                    boolean ok = false;
                    try {
                        String replyMessage = MapUtils.getMapString(reply, "message", null);
                        if (replyMessage != null && replyMessage.equals("Ok")) {
                            PlatformMessenger.debug("Relay: Ok to " + pk);
                            putListener2.putOK(buddyMessage2);
                            ok = true;
                        } else {
                            PlatformMessenger.debug("Relay: FAILED for " + pk);
                        }
                    }
                    finally {
                        if (!ok) {
                            putListener2.putFailed(buddyMessage2, new Exception("Reply indicated failure: " + reply));
                        }
                    }
                }
            };
            PlatformMessenger.queueMessage(message, listener);
        }
        catch (Throwable e) {
            putListener2.putFailed(buddyMessage2, e);
        }
    }

    public static final void fetch(long maxDelayMS) throws NotLoggedInException {
        String myPK;
        if (!LoginInfoManager.getInstance().isLoggedIn() || PlatformMessenger.isAuthorizedDelayed()) {
            PlatformRelayMessenger.resetTimerEvent(30L);
            throw new NotLoggedInException();
        }
        try {
            myPK = VuzeCryptoManager.getSingleton().getPublicKey(null);
        }
        catch (VuzeCryptoException e) {
            PlatformRelayMessenger.resetTimerEvent(30L);
            Debug.out(e);
            return;
        }
        PlatformMessage message = new PlatformMessage(MSG_ID, LISTENER_ID, OP_FETCH, new Object[]{"pk", myPK}, maxDelayMS);
        final BuddyPlugin buddyPlugin = VuzeBuddyManager.getBuddyPlugin();
        if (buddyPlugin == null) {
            PlatformRelayMessenger.resetTimerEvent(30L);
            return;
        }
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
            }

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                List list = (List)MapUtils.getMapObject(reply, "messages", Collections.EMPTY_LIST, List.class);
                long recheckInMins = MapUtils.getMapLong(reply, "recheck-in-mins", PlatformMessenger.REPLY_EXCEPTION.equals(replyType) ? 90L : 30L);
                PlatformRelayMessenger.resetTimerEvent(recheckInMins);
                for (Map map : list) {
                    String pkSender = MapUtils.getMapString(map, "sender", null);
                    long addedOn = SystemTime.getOffsetTime(MapUtils.getMapLong(map, "added-secs-ago", 0L) * -1000L);
                    VuzeBuddy buddy = VuzeBuddyManager.getBuddyByPK(pkSender);
                    BuddyPluginBuddy pluginBuddy = buddyPlugin.getBuddyFromPublicKey(pkSender);
                    long ack_id = MapUtils.getMapLong(map, "id", -1L);
                    byte[] enc_payload = Base32.decode(MapUtils.getMapString(map, "payload", ""));
                    try {
                        BuddyPlugin.cryptoResult decrypt = pluginBuddy == null ? buddyPlugin.decrypt(pkSender, enc_payload) : pluginBuddy.decrypt(enc_payload);
                        byte[] payload = decrypt.getPayload();
                        Map decodedMap = BDecoder.decode(payload);
                        PlatformMessenger.debug("Relay: got message from " + pkSender);
                        if (TEST_ERRORACK) {
                            PlatformRelayMessenger.errorAck(ack_id);
                        } else {
                            PlatformRelayMessenger.ack(ack_id, decrypt.getChallenge());
                        }
                        for (VuzeRelayListener l : listeners) {
                            l.newRelayServerPayLoad(buddy, pkSender, decodedMap, addedOn);
                        }
                    }
                    catch (BuddyPluginPasswordException e) {
                    }
                    catch (Exception e) {
                        PlatformMessenger.debug("Relay: send ack_fail: " + e.toString());
                        PlatformRelayMessenger.errorAck(ack_id);
                    }
                }
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    protected static void resetTimerEvent(long recheckInMins) {
        PlatformMessenger.debug("Relay: rechecking in " + recheckInMins + "m");
        if (timerEvent != null) {
            timerEvent.cancel();
        }
        timerEvent = SimpleTimer.addEvent("Relay Server Check", SystemTime.getOffsetTime(recheckInMins * 1000L * 60L), relayCheckPerformer);
    }

    public static final void addRelayServerListener(VuzeRelayListener l) {
        listeners.add(l);
    }

    public static final void removeRelayServerListener(VuzeRelayListener l) {
        listeners.remove(l);
    }

    private static final void ack(long id, byte[] ack) {
        String myPK;
        try {
            myPK = VuzeCryptoManager.getSingleton().getPublicKey(null);
        }
        catch (VuzeCryptoException e) {
            Debug.out(e);
            return;
        }
        HashMap<String, Object> mapACK = new HashMap<String, Object>();
        mapACK.put("id", new Long(id));
        mapACK.put("ack", Base32.encode(ack));
        HashMap<String, Object> mapParameters = new HashMap<String, Object>();
        mapParameters.put("recipient_pk", myPK);
        mapParameters.put("acks", new Object[]{mapACK});
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                int numDeleted = MapUtils.getMapInt(reply, "deleted", 0);
                PlatformMessenger.debug("Relay: deleted " + numDeleted);
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessage message = new PlatformMessage(MSG_ID, LISTENER_ID, OP_ACK, mapParameters, 500L);
        PlatformMessenger.queueMessage(message, listener);
    }

    private static final void errorAck(long id) {
        byte[] encryptBytes;
        String myPK;
        try {
            myPK = VuzeCryptoManager.getSingleton().getPublicKey("errorAck");
        }
        catch (VuzeCryptoException e) {
            Debug.out(e);
            return;
        }
        try {
            byte[] content = String.valueOf(id).getBytes("UTF-8");
            CryptoHandler ecc_handler = CryptoManagerFactory.getSingleton().getECCHandler();
            encryptBytes = ecc_handler.sign(content, "Encrypting message for " + myPK);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String s = Base32.encode(encryptBytes);
        HashMap<String, Object> mapACK = new HashMap<String, Object>();
        mapACK.put("id", new Long(id));
        mapACK.put("signature", s);
        HashMap<String, Object> mapParameters = new HashMap<String, Object>();
        mapParameters.put("recipient_pk", myPK);
        mapParameters.put("error_acks", new Object[]{mapACK});
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                int numDeleted = MapUtils.getMapInt(reply, "deleted", 0);
                PlatformMessenger.debug("Relay: deleted " + numDeleted);
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessage message = new PlatformMessage(MSG_ID, LISTENER_ID, OP_ERRORACK, mapParameters, 500L);
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void relayCheck() {
        String myPK;
        if (!VuzeCryptoManager.getSingleton().hasPublicKey()) {
            return;
        }
        try {
            myPK = VuzeCryptoManager.getSingleton().getPublicKey(null);
        }
        catch (VuzeCryptoException e) {
            Debug.out(e);
            return;
        }
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                int count = MapUtils.getMapInt(reply, "count", 0);
                long recheckInMins = MapUtils.getMapLong(reply, "recheck-in-mins", PlatformMessenger.REPLY_EXCEPTION.equals(replyType) ? 90L : 30L);
                PlatformRelayMessenger.resetTimerEvent(recheckInMins);
                if (count > 0 || lastPendingCount != (long)count) {
                    lastPendingCount = count;
                    for (VuzeRelayListener l : listeners) {
                        l.hasPendingRelayMessage(count);
                    }
                }
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessage message = new PlatformMessage(MSG_ID, LISTENER_ID, OP_COUNT, new Object[]{"pk", myPK}, 0L);
        PlatformMessenger.queueMessage(message, listener);
    }

    static {
        lastPendingCount = 0L;
        relayCheckPerformer = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                PlatformRelayMessenger.relayCheck();
            }
        };
    }

    public static interface putListener {
        public void putOK(BuddyPluginBuddyMessage var1);

        public void putFailed(BuddyPluginBuddyMessage var1, Throwable var2);
    }
}

