/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.security.CryptoECCUtils;
import java.security.Signature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.json.simple.JSONArray;

public class PlatformSubscriptionsMessenger {
    public static final String LISTENER_ID_TEMPLATE = "subscription";
    public static final String OP_CREATE_SUBS = "create-subscription";
    public static final String OP_UPDATE_SUBS = "update-subscription";
    public static final String OP_GET_SUBS_BY_SID = "get-subscriptions";
    public static final String OP_GET_POP_BY_SID = "get-subscription-infos";
    public static final String OP_SET_SELECTED = "set-selected";

    public static void updateSubscription(boolean create, String name, byte[] public_key, byte[] private_key, byte[] sid, int version, String content) throws PlatformMessengerException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String sid_str = Base32.encode(sid);
        String pk_str = Base32.encode(public_key);
        parameters.put("name", name);
        parameters.put("subscription_id", sid_str);
        parameters.put("version_number", new Long(version));
        parameters.put("content", content);
        if (create) {
            parameters.put("public_key", pk_str);
        }
        try {
            Signature sig = CryptoECCUtils.getSignature(CryptoECCUtils.rawdataToPrivkey(private_key));
            sig.update((name + pk_str + sid_str + version + content).getBytes("UTF-8"));
            byte[] sig_bytes = sig.sign();
            parameters.put("signature", Base32.encode(sig_bytes));
            PlatformSubscriptionsMessenger.syncInvoke(create ? OP_CREATE_SUBS : OP_UPDATE_SUBS, parameters);
        }
        catch (Throwable e) {
            throw new PlatformMessengerException("Failed to create/update subscription", e);
        }
    }

    public static subscriptionDetails getSubscriptionBySID(byte[] sid) throws PlatformMessengerException {
        HashMap<String, JSONArray> parameters = new HashMap<String, JSONArray>();
        JSONArray sid_list = new JSONArray();
        sid_list.add(Base32.encode(sid));
        parameters.put("subscription_ids", sid_list);
        Map reply = PlatformSubscriptionsMessenger.syncInvoke(OP_GET_SUBS_BY_SID, parameters);
        for (int i = 0; i < sid_list.size(); ++i) {
            Map map = (Map)reply.get((String)sid_list.get(i));
            if (map == null) continue;
            subscriptionDetails details = new subscriptionDetails(map);
            return details;
        }
        throw new PlatformMessengerException("Unknown sid '" + ByteFormatter.encodeString(sid) + "'");
    }

    public static long getPopularityBySID(byte[] sid) throws PlatformMessengerException {
        HashMap<String, JSONArray> parameters = new HashMap<String, JSONArray>();
        JSONArray sid_list = new JSONArray();
        sid_list.add(Base32.encode(sid));
        parameters.put("subscription_ids", sid_list);
        Map reply = PlatformSubscriptionsMessenger.syncInvoke(OP_GET_POP_BY_SID, parameters);
        for (int i = 0; i < sid_list.size(); ++i) {
            Map map = (Map)reply.get((String)sid_list.get(i));
            if (map == null) continue;
            subscriptionInfo info = new subscriptionInfo(map);
            return info.getPopularity();
        }
        return -1L;
    }

    public static List[] setSelected(List sids) throws PlatformMessengerException {
        ArrayList popularities;
        HashMap<String, JSONArray> parameters = new HashMap<String, JSONArray>();
        JSONArray sid_list = new JSONArray();
        for (int i = 0; i < sids.size(); ++i) {
            sid_list.add(Base32.encode((byte[])sids.get(i)));
        }
        parameters.put("subscription_ids", sid_list);
        Map reply = PlatformSubscriptionsMessenger.syncInvoke(OP_SET_SELECTED, parameters);
        ArrayList<Long> versions = (ArrayList<Long>)reply.get("version_numbers");
        if (versions == null) {
            versions = new ArrayList<Long>();
            for (int i = 0; i < sids.size(); ++i) {
                versions.add(new Long(1L));
            }
        }
        if ((popularities = (ArrayList)reply.get("popularities")) == null) {
            popularities = new ArrayList();
            for (int i = 0; i < sids.size(); ++i) {
                versions.add(new Long(-1L));
            }
        }
        return new List[]{versions, popularities};
    }

    protected static Map syncInvoke(String operationID, Map parameters) throws PlatformMessengerException {
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID_TEMPLATE, operationID, parameters, 0L);
        message.setSendAZID(false);
        final AESemaphore sem = new AESemaphore("PlatformMetaSearch:syncInvoke");
        final Object[] result = new Object[]{null};
        PlatformMessenger.queueMessage(message, new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                try {
                    if (replyType.equals(PlatformMessenger.REPLY_EXCEPTION)) {
                        String e_message = (String)reply.get("message");
                        if (e_message != null) {
                            result[0] = new PlatformMessengerException(e_message);
                        } else {
                            String text = (String)reply.get("text");
                            Throwable e = (Throwable)reply.get("Throwable");
                            result[0] = text == null && e == null ? new PlatformMessengerException("Unknown error") : (text == null ? new PlatformMessengerException("Failed to send RPC", e) : (e == null ? new PlatformMessengerException(text) : new PlatformMessengerException(text, e)));
                        }
                    } else {
                        result[0] = reply;
                    }
                }
                finally {
                    sem.release();
                }
            }
        });
        sem.reserve();
        if (result[0] instanceof PlatformMessengerException) {
            throw (PlatformMessengerException)result[0];
        }
        return (Map)result[0];
    }

    public static class subscriptionDetails {
        private Map details;

        protected subscriptionDetails(Map _details) {
            this.details = _details;
        }

        public String getName() {
            return this.getString("name");
        }

        public String getContent() {
            return this.getString("content");
        }

        public int getPopularity() {
            Long l_pop = (Long)this.details.get("popularity");
            if (l_pop != null) {
                return l_pop.intValue();
            }
            return -1;
        }

        protected String getString(String key) {
            Object obj = this.details.get(key);
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof byte[]) {
                byte[] bytes = (byte[])obj;
                try {
                    return new String(bytes, "UTF-8");
                }
                catch (Throwable e) {
                    return new String(bytes);
                }
            }
            return null;
        }
    }

    public static class subscriptionInfo {
        private Map info;

        protected subscriptionInfo(Map _info) {
            this.info = _info;
        }

        public long getPopularity() {
            return ((Long)this.info.get("popularity")).intValue();
        }
    }
}

