/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.messenger.config.PlatformMetaSearchMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearch;
import com.aelitis.azureus.core.metasearch.MetaSearchException;
import com.aelitis.azureus.core.metasearch.MetaSearchListener;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchManagerImpl;
import com.aelitis.azureus.core.metasearch.impl.SearchExecuter;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginEngine;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.regex.RegexEngine;
import com.aelitis.azureus.core.metasearch.impl.web.rss.RSSEngine;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;

public class MetaSearchImpl
implements MetaSearch {
    private static final String CONFIG_FILE = "metasearch.config";
    private MetaSearchManagerImpl manager;
    private CopyOnWriteList engines = new CopyOnWriteList();
    private Map plugin_map = new HashMap();
    private boolean config_dirty;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private TimerEventPeriodic update_check_timer;
    private static final int UPDATE_CHECK_PERIOD = 900000;
    private static final int MIN_UPDATE_CHECK_SECS = 600;
    private Object MS_UPDATE_CONSEC_FAIL_KEY = new Object();

    protected MetaSearchImpl(MetaSearchManagerImpl _manager) {
        this.manager = _manager;
        this.loadConfig();
    }

    protected MetaSearchImpl() {
    }

    public Engine importFromBEncodedMap(Map map) throws IOException {
        return EngineImpl.importFromBEncodedMap(this, map);
    }

    public Engine importFromJSONString(int type, long id, long last_updated, String name, String content) throws IOException {
        return EngineImpl.importFromJSONString(this, type, id, last_updated, name, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EngineImpl importFromPlugin(String pid, SearchProvider provider) throws IOException {
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            long id;
            Long l_id = (Long)this.plugin_map.get(pid);
            if (l_id == null) {
                id = this.manager.getLocalTemplateID();
                this.plugin_map.put(pid, new Long(id));
                this.configDirty();
            } else {
                id = l_id;
            }
            EngineImpl engine = (EngineImpl)this.getEngine(id);
            if (engine == null) {
                engine = new PluginEngine(this, id, provider);
                engine.setSource(2);
                engine.setSelectionState(2);
                this.addEngine(engine);
            } else if (engine instanceof PluginEngine) {
                ((PluginEngine)engine).setProvider(provider);
            } else {
                Debug.out("Inconsistent: plugin must be a PluginEngine!");
                this.plugin_map.remove(pid);
                this.removeEngine(engine);
                throw new IOException("Inconsistent");
            }
            return engine;
        }
    }

    public Engine createRSSEngine(String name, URL url) throws MetaSearchException {
        RSSEngine engine = new RSSEngine(this, this.manager.getLocalTemplateID(), SystemTime.getCurrentTime(), name, url.toExternalForm(), false, "transparent", null, new String[0]);
        engine.setSource(3);
        this.addEngine(engine, false);
        this.log("Created RSS engine '" + url + "'");
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableUpdateChecks() {
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            if (this.update_check_timer == null) {
                this.update_check_timer = SimpleTimer.addPeriodicEvent("MS:updater", 900000L, new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        MetaSearchImpl.this.checkUpdates();
                    }
                });
            }
        }
    }

    protected void checkUpdates() {
        Iterator it = this.engines.iterator();
        while (it.hasNext()) {
            int consec_fails;
            long check_secs;
            EngineImpl engine = (EngineImpl)it.next();
            String update_url = engine.getUpdateURL();
            if (update_url == null) continue;
            long now = SystemTime.getCurrentTime();
            long last_check = engine.getLastUpdateCheck();
            if (last_check > now) {
                last_check = now;
                engine.setLastUpdateCheck(now);
            }
            if ((check_secs = (long)engine.getUpdateCheckSecs()) < 600L) {
                this.log("Engine '" + engine.getName() + "': Update check period too small (" + check_secs + " secs) adjusting to " + 600 + ": " + engine.getName());
                check_secs = 600L;
            }
            long check_millis = check_secs * 1000L;
            long next_check = last_check + check_millis;
            Object consec_fails_o = engine.getUserData(this.MS_UPDATE_CONSEC_FAIL_KEY);
            int n = consec_fails = consec_fails_o == null ? 0 : (Integer)consec_fails_o;
            if (consec_fails > 0) {
                next_check += (long)(900000 << consec_fails);
            }
            if (next_check >= now) continue;
            if (this.updateEngine(engine)) {
                consec_fails = 0;
                engine.setLastUpdateCheck(now);
            } else if (++consec_fails > 3) {
                consec_fails = 0;
                engine.setLastUpdateCheck(now);
            }
            engine.setUserData(this.MS_UPDATE_CONSEC_FAIL_KEY, consec_fails == 0 ? null : new Integer(consec_fails));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean updateEngine(EngineImpl engine) {
        String update_url = engine.getUpdateURL();
        int pos = update_url.indexOf(63);
        update_url = pos == -1 ? update_url + "?" : update_url + "&";
        update_url = update_url + "az_template_uid=" + engine.getUID() + "&az_template_version=" + engine.getVersion() + "&az_version=" + "4.0.0.4" + "&az_locale=" + MessageText.getCurrentLocale().toString() + "&az_rand=" + Math.abs(new Random().nextLong());
        this.log("Engine " + engine.getName() + ": auto-update check via " + update_url);
        try {
            ResourceDownloaderFactory rdf = StaticUtilities.getResourceDownloaderFactory();
            ResourceDownloader url_rd = rdf.create(new URL(update_url));
            ResourceDownloader rd = rdf.getMetaRefreshDownloader(url_rd);
            InputStream is = rd.download();
            try {
                Map map = BDecoder.decode(new BufferedInputStream(is));
                this.log("    update check reply: " + map);
                Map response = (Map)map.get("response");
                if (response != null) {
                    int check_secs;
                    Long update_secs = (Long)response.get("update_url_check_secs");
                    if (update_secs == null) {
                        engine.setLocalUpdateCheckSecs(0);
                    } else {
                        check_secs = update_secs.intValue();
                        if (check_secs < 600) {
                            this.log("    update check secs for to small, min is 600");
                            check_secs = 600;
                        }
                        engine.setLocalUpdateCheckSecs(check_secs);
                    }
                    check_secs = 1;
                    return check_secs != 0;
                }
                VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(map);
                if (vf == null) {
                    this.log("    failed to decode vuze file");
                    boolean check_secs = false;
                    return check_secs;
                }
                Engine[] updated_engines = this.manager.loadFromVuzeFile(vf);
                if (updated_engines.length <= 0) {
                    this.log("    no engines found in vuze file");
                } else {
                    String existing_uid = engine.getUID();
                    boolean found = false;
                    String engine_str = "";
                    for (int i = 0; i < updated_engines.length; ++i) {
                        Engine updated_engine = updated_engines[i];
                        engine_str = engine_str + (i == 0 ? "" : ",") + updated_engine.getName() + ": uid=" + updated_engine.getUID() + ",version=" + updated_engine.getVersion();
                        if (!updated_engine.getUID().equals(existing_uid)) continue;
                        found = true;
                    }
                    if (!found) {
                        this.log("    existing engine not found in updated set, deleting");
                        engine.delete();
                    }
                    this.log("    update complete: new engines=" + engine_str);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                is.close();
            }
        }
        catch (Throwable e) {
            this.log("    update check failed", e);
            return false;
        }
    }

    public void addEngine(Engine engine) {
        this.addEngine((EngineImpl)engine, false);
    }

    public Engine addEngine(long id) throws MetaSearchException {
        try {
            PlatformMetaSearchMessenger.templateDetails details = PlatformMetaSearchMessenger.getTemplate(id);
            this.log("Downloading definition of template " + id);
            this.log(details.getValue());
            if (details.isVisible()) {
                Engine engine = this.importFromJSONString(details.getType() == 1 ? 2 : 1, details.getId(), details.getModifiedDate(), details.getName(), details.getValue());
                engine.setSource(1);
                engine.setSelectionState(0);
                this.addEngine(engine);
                return engine;
            }
            throw new MetaSearchException("Search template is not visible");
        }
        catch (MetaSearchException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new MetaSearchException("Template load failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEngine(EngineImpl new_engine, boolean loading) {
        boolean add_op = true;
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            Iterator it = this.engines.iterator();
            while (it.hasNext()) {
                Engine existing_engine = (Engine)it.next();
                if (existing_engine.getId() == new_engine.getId()) {
                    this.log("Updating engine with same ID " + existing_engine.getId() + ": " + existing_engine.getName() + "/" + existing_engine.getUID());
                    it.remove();
                    new_engine.setUID(existing_engine.getUID());
                    if (existing_engine.sameLogicAs(new_engine)) {
                        new_engine.setVersion(existing_engine.getVersion());
                    } else {
                        new_engine.setVersion(existing_engine.getVersion() + 1);
                        this.log("    new version=" + new_engine.getVersion());
                    }
                    add_op = false;
                    continue;
                }
                if (!existing_engine.getUID().equals(new_engine.getUID())) continue;
                this.log("Removing engine with same UID " + existing_engine.getUID() + "(" + existing_engine.getName() + ")");
                it.remove();
            }
            this.engines.add(new_engine);
        }
        if (new_engine.getUpdateURL() != null) {
            this.enableUpdateChecks();
        }
        if (!loading) {
            this.log("Engine '" + new_engine.getName() + "' added");
            this.saveConfig();
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                MetaSearchListener listener = (MetaSearchListener)it.next();
                try {
                    if (add_op) {
                        listener.engineAdded(new_engine);
                        continue;
                    }
                    listener.engineUpdated(new_engine);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void removeEngine(Engine engine) {
        if (this.engines.remove(engine)) {
            this.log("Engine '" + engine.getName() + "' removed");
            this.saveConfig();
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    ((MetaSearchListener)it.next()).engineRemoved(engine);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public Engine[] getEngines(boolean active_only, boolean ensure_up_to_date) {
        ArrayList<Engine> result;
        if (ensure_up_to_date) {
            this.manager.ensureEnginesUpToDate();
        }
        ArrayList<Engine> l = this.engines.getList();
        if (active_only) {
            result = new ArrayList<Engine>();
            for (int i = 0; i < l.size(); ++i) {
                Engine e = (Engine)l.get(i);
                if (!e.isActive()) continue;
                result.add(e);
            }
        } else {
            result = l;
        }
        return result.toArray(new Engine[result.size()]);
    }

    public Engine getEngine(long id) {
        List l = this.engines.getList();
        for (int i = 0; i < l.size(); ++i) {
            Engine e = (Engine)l.get(i);
            if (e.getId() != id) continue;
            return e;
        }
        return null;
    }

    public Engine getEngineByUID(String uid) {
        List l = this.engines.getList();
        for (int i = 0; i < l.size(); ++i) {
            Engine e = (Engine)l.get(i);
            if (!e.getUID().equals(uid)) continue;
            return e;
        }
        return null;
    }

    public int getEngineCount() {
        return this.engines.size();
    }

    public Engine[] search(ResultListener original_listener, SearchParameter[] searchParameters, String headers, int max_results_per_engine) {
        return this.search(original_listener, searchParameters, headers, new HashMap(), max_results_per_engine);
    }

    public Engine[] search(ResultListener original_listener, SearchParameter[] searchParameters, String headers, Map context, int max_results_per_engine) {
        return this.search(null, original_listener, searchParameters, headers, context, max_results_per_engine);
    }

    public Engine[] search(Engine[] engines, ResultListener listener, SearchParameter[] search_parameters, String headers, int max_results_per_engine) {
        return this.search(engines, listener, search_parameters, headers, new HashMap(), max_results_per_engine);
    }

    public Engine[] search(Engine[] engines, final ResultListener original_listener, SearchParameter[] searchParameters, String headers, Map context, final int max_results_per_engine) {
        int i;
        String param_str = "";
        for (int i2 = 0; i2 < searchParameters.length; ++i2) {
            SearchParameter param = searchParameters[i2];
            param_str = param_str + (i2 == 0 ? "" : ",") + param.getMatchPattern() + "->" + param.getValue();
        }
        ResultListener listener = new ResultListener(){
            private AsyncDispatcher dispatcher = new AsyncDispatcher(5000);

            public void contentReceived(final Engine engine, final String content) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        original_listener.contentReceived(engine, content);
                    }
                });
            }

            public void matchFound(final Engine engine, final String[] fields) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        original_listener.matchFound(engine, fields);
                    }
                });
            }

            public void resultsReceived(final Engine engine, final Result[] results) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        Result[] results_to_return = MetaSearchImpl.this.truncateResults(engine, results, max_results_per_engine);
                        original_listener.resultsReceived(engine, results_to_return);
                    }
                });
            }

            public void resultsComplete(final Engine engine) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        original_listener.resultsComplete(engine);
                    }
                });
            }

            public void engineFailed(final Engine engine, final Throwable e) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        original_listener.engineFailed(engine, e);
                    }
                });
            }

            public void engineRequiresLogin(final Engine engine, final Throwable e) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        original_listener.engineRequiresLogin(engine, e);
                    }
                });
            }
        };
        SearchExecuter se = new SearchExecuter(context, listener);
        if (engines == null) {
            engines = this.getEngines(true, true);
        }
        String engines_str = "";
        for (i = 0; i < engines.length; ++i) {
            engines_str = engines_str + (i == 0 ? "" : ",") + engines[i].getId();
        }
        this.log("Search: params=" + param_str + "; engines=" + engines_str);
        for (i = 0; i < engines.length; ++i) {
            se.search(engines[i], searchParameters, headers, max_results_per_engine);
        }
        return engines;
    }

    protected Result[] truncateResults(Engine engine, Result[] results, int max) {
        if (max < results.length) {
            this.log("Truncating search results for " + engine.getName() + " from " + results.length + " to " + max);
            Arrays.sort(results, new Comparator(){
                Map ranks = new HashMap();

                public int compare(Object o1, Object o2) {
                    Float rank2;
                    Result r1 = (Result)o1;
                    Result r2 = (Result)o2;
                    Float rank1 = (Float)this.ranks.get(r1);
                    if (rank1 == null) {
                        rank1 = new Float(r1.getRank());
                        this.ranks.put(r1, rank1);
                    }
                    if ((rank2 = (Float)this.ranks.get(r2)) == null) {
                        rank2 = new Float(r2.getRank());
                        this.ranks.put(r2, rank2);
                    }
                    return -rank1.compareTo(rank2);
                }
            });
            Result[] x = new Result[max];
            System.arraycopy(results, 0, x, 0, max);
            return x;
        }
        return results;
    }

    public void addListener(MetaSearchListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MetaSearchListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        this.log("Loading configuration");
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            Map p_map;
            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
            List l_engines = (List)map.get("engines");
            if (l_engines != null) {
                for (int i = 0; i < l_engines.size(); ++i) {
                    Map m = (Map)l_engines.get(i);
                    try {
                        Engine e = this.importFromBEncodedMap(m);
                        this.addEngine((EngineImpl)e, true);
                        this.log("    loaded " + e.getString());
                        continue;
                    }
                    catch (Throwable e) {
                        this.log("Failed to import engine from " + m, e);
                    }
                }
            }
            if ((p_map = (Map)map.get("plugin_map")) != null) {
                this.plugin_map = p_map;
            }
        }
        if (this.update_check_timer != null) {
            new AsyncDispatcher().dispatch(new AERunnable(){

                public void runSupport() {
                    MetaSearchImpl.this.checkUpdates();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("MetaSearch:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    5 var1_1 = this;
                    synchronized (var1_1) {
                        if (!MetaSearchImpl.this.config_dirty) {
                            return;
                        }
                        MetaSearchImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        this.log("Saving configuration");
        MetaSearchImpl metaSearchImpl = this;
        synchronized (metaSearchImpl) {
            this.config_dirty = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<Map> l_engines = new ArrayList<Map>();
            map.put("engines", l_engines);
            Iterator it = this.engines.iterator();
            while (it.hasNext()) {
                Engine e = (Engine)it.next();
                try {
                    l_engines.add(e.exportToBencodedMap());
                }
                catch (Throwable f) {
                    this.log("Failed to export engine " + e.getName(), f);
                }
            }
            if (this.plugin_map != null) {
                map.put("plugin_map", this.plugin_map);
            }
            FileUtil.writeResilientConfigFile(CONFIG_FILE, map);
        }
    }

    protected void log(String str) {
        this.manager.log("search :" + str);
    }

    protected void log(String str, Throwable e) {
        this.manager.log("search :" + str, e);
    }

    protected void generate(IndentWriter writer) {
        Iterator it = this.engines.iterator();
        while (it.hasNext()) {
            EngineImpl e = (EngineImpl)it.next();
            writer.println(e.getString(true));
        }
    }

    public static void main(String[] args) {
        try {
            MetaSearchImpl ms = new MetaSearchImpl();
            RegexEngine e = new RegexEngine(ms, -2147473658L, SystemTime.getCurrentTime(), "UpdateTest", "http://localhost:1234/search=%s", "", "GMT", true, null, new FieldMapping[]{new FieldMapping("1", 6), new FieldMapping("2", 103), new FieldMapping("3", 1), new FieldMapping("4", 102), new FieldMapping("5", 7), new FieldMapping("6", 2), new FieldMapping("7", 3), new FieldMapping("8", 10), new FieldMapping("9", 5), new FieldMapping("10", 4)}, false, "transparent", "", new String[]{""});
            e.setUpdateURL("http://localhost:5678/update");
            e.setDefaultUpdateCheckSecs(60);
            e.setVersion(2);
            e.exportToVuzeFile(new File("c:\\temp\\updatetest.vuze"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

