/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationManager;
import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.messenger.config.PlatformMetaSearchMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearch;
import com.aelitis.azureus.core.metasearch.MetaSearchException;
import com.aelitis.azureus.core.metasearch.MetaSearchManager;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import com.aelitis.azureus.util.ConstantsV3;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class MetaSearchManagerImpl
implements MetaSearchManager,
UtilitiesImpl.searchManager,
AEDiagnosticsEvidenceGenerator {
    private static final boolean AUTO_MODE_DEFAULT = false;
    private static final String LOGGER_NAME = "MetaSearch";
    private static final int REFRESH_MILLIS = 82800000;
    private static MetaSearchManager singleton;
    private MetaSearchImpl meta_search;
    private AsyncDispatcher dispatcher = new AsyncDispatcher(10000);
    private AESemaphore initial_refresh_sem = new AESemaphore("MetaSearch:initrefresh");
    private AESemaphore refresh_sem = new AESemaphore("MetaSearch:refresh", 1);
    private boolean checked_customization;

    public static void preInitialise() {
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            public void process(VuzeFile[] files, int expected_types) {
                for (int i = 0; i < files.length; ++i) {
                    VuzeFile vf = files[i];
                    VuzeFileComponent[] comps = vf.getComponents();
                    for (int j = 0; j < comps.length; ++j) {
                        VuzeFileComponent comp2 = comps[j];
                        if (comp2.getType() != 1) continue;
                        try {
                            Engine e = MetaSearchManagerImpl.getSingleton().importEngine(comp2.getContent(), (expected_types & 1) == 0);
                            comp2.setProcessed();
                            if (e == null) continue;
                            comp2.setData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY, e);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        });
    }

    public static synchronized MetaSearchManager getSingleton() {
        if (singleton == null) {
            singleton = new MetaSearchManagerImpl();
        }
        return singleton;
    }

    protected MetaSearchManagerImpl() {
        this.meta_search = new MetaSearchImpl(this);
        AEDiagnostics.addEvidenceGenerator(this);
        SimpleTimer.addPeriodicEvent("MetaSearchRefresh", 82800000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                MetaSearchManagerImpl.this.refresh();
            }
        });
        this.refresh();
        UtilitiesImpl.addSearchManager(this);
    }

    public void addProvider(PluginInterface pi, SearchProvider provider) {
        String id = pi.getPluginID() + "." + provider.getProperty(1);
        try {
            this.meta_search.importFromPlugin(id, provider);
        }
        catch (Throwable e) {
            Debug.out("Failed to add search provider '" + id + "' (" + provider + ")", e);
        }
    }

    protected void refresh() {
        this.dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                if (MetaSearchManagerImpl.this.dispatcher.getQueueSize() == 0) {
                    try {
                        MetaSearchManagerImpl.this.syncRefresh();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    protected void ensureEnginesUpToDate() {
        long timeout;
        long l = timeout = this.meta_search.getEngineCount() == 0 ? 30000L : 10000L;
        if (!this.initial_refresh_sem.reserve(timeout)) {
            this.log("Timeout waiting for initial refresh to complete, continuing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncRefresh() throws MetaSearchException {
        boolean refresh_completed = false;
        boolean first_run = false;
        try {
            this.refresh_sem.reserve();
            first_run = COConfigurationManager.getBooleanParameter("metasearch.refresh.first_run", true);
            if (!this.checked_customization) {
                this.checked_customization = true;
                CustomizationManager cust_man = CustomizationManagerFactory.getSingleton();
                Customization cust = cust_man.getActiveCustomization();
                if (cust != null) {
                    boolean new_version;
                    String cust_name = COConfigurationManager.getStringParameter("metasearch.custom.name", "");
                    String cust_version = COConfigurationManager.getStringParameter("metasearch.custom.version", "0");
                    boolean new_name = !cust_name.equals(cust.getName());
                    boolean bl = new_version = Constants.compareVersions(cust_version, cust.getVersion()) < 0;
                    if (new_name || new_version) {
                        this.log("Customization: checking templates for " + cust.getName() + "/" + cust.getVersion());
                        try {
                            InputStream[] streams = cust.getResources("metasearch");
                            if (streams.length > 0 && new_name) {
                                this.log("    setting auto-mode to false");
                                this.setAutoMode(false);
                            }
                            for (int i = 0; i < streams.length; ++i) {
                                InputStream is = streams[i];
                                try {
                                    VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(is);
                                    if (vf == null) continue;
                                    VuzeFileComponent[] comps = vf.getComponents();
                                    for (int j = 0; j < comps.length; ++j) {
                                        VuzeFileComponent comp2 = comps[j];
                                        if (comp2.getType() != 1) continue;
                                        try {
                                            Engine e = MetaSearchManagerImpl.getSingleton().importEngine(comp2.getContent(), false);
                                            this.log("    updated " + e.getName());
                                            e.setSelectionState(2);
                                            continue;
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                    }
                                    continue;
                                }
                                finally {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable e) {}
                                }
                            }
                        }
                        finally {
                            COConfigurationManager.setParameter("metasearch.custom.name", cust.getName());
                            COConfigurationManager.setParameter("metasearch.custom.version", cust.getVersion());
                        }
                    }
                }
            }
            this.log("Refreshing engines");
            HashMap<Long, Long> vuze_selected_ids = new HashMap<Long, Long>();
            HashMap<Long, Long> vuze_preload_ids = new HashMap<Long, Long>();
            HashSet<Long> featured_ids = new HashSet<Long>();
            HashSet<Long> popular_ids = new HashSet<Long>();
            HashSet<Long> manual_vuze_ids = new HashSet<Long>();
            boolean auto_mode = this.isAutoMode();
            Engine[] engines = this.meta_search.getEngines(false, false);
            try {
                int i;
                PlatformMetaSearchMessenger.templateInfo[] featured = PlatformMetaSearchMessenger.listFeaturedTemplates();
                String featured_str = "";
                for (int i2 = 0; i2 < featured.length; ++i2) {
                    PlatformMetaSearchMessenger.templateInfo template = featured[i2];
                    if (!template.isVisible()) continue;
                    Long key = new Long(template.getId());
                    vuze_selected_ids.put(key, new Long(template.getModifiedDate()));
                    featured_ids.add(key);
                    featured_str = featured_str + (featured_str.length() == 0 ? "" : ",") + key;
                }
                this.log("Featured templates: " + featured_str);
                if (auto_mode || first_run) {
                    PlatformMetaSearchMessenger.templateInfo[] popular = PlatformMetaSearchMessenger.listTopPopularTemplates();
                    String popular_str = "";
                    String preload_str = "";
                    for (int i3 = 0; i3 < popular.length; ++i3) {
                        PlatformMetaSearchMessenger.templateInfo template = popular[i3];
                        if (!template.isVisible()) continue;
                        Long key = new Long(template.getId());
                        if (auto_mode) {
                            if (vuze_selected_ids.containsKey(key)) continue;
                            vuze_selected_ids.put(key, new Long(template.getModifiedDate()));
                            popular_ids.add(key);
                            popular_str = popular_str + (popular_str.length() == 0 ? "" : ",") + key;
                            continue;
                        }
                        if (vuze_preload_ids.containsKey(key)) continue;
                        vuze_preload_ids.put(key, new Long(template.getModifiedDate()));
                        preload_str = preload_str + (preload_str.length() == 0 ? "" : ",") + key;
                    }
                    this.log("Popular templates: " + popular_str);
                    if (preload_str.length() > 0) {
                        this.log("Pre-load templates: " + popular_str);
                    }
                }
                String manual_str = "";
                for (int i4 = 0; i4 < engines.length; ++i4) {
                    Engine engine = engines[i4];
                    Long key = new Long(engine.getId());
                    if (engine.getSource() != 1 || engine.getSelectionState() != 2 || vuze_selected_ids.containsKey(key)) continue;
                    manual_vuze_ids.add(key);
                }
                if (manual_vuze_ids.size() > 0) {
                    long[] manual_ids = new long[manual_vuze_ids.size()];
                    Iterator it = manual_vuze_ids.iterator();
                    int pos = 0;
                    while (it.hasNext()) {
                        manual_ids[pos++] = (Long)it.next();
                    }
                    PlatformMetaSearchMessenger.templateInfo[] manual = PlatformMetaSearchMessenger.getTemplateDetails(manual_ids);
                    for (int i5 = 0; i5 < manual.length; ++i5) {
                        PlatformMetaSearchMessenger.templateInfo template = manual[i5];
                        if (!template.isVisible()) continue;
                        Long key = new Long(template.getId());
                        vuze_selected_ids.put(key, new Long(template.getModifiedDate()));
                        manual_str = manual_str + (manual_str.length() == 0 ? "" : ",") + key;
                    }
                }
                this.log("Manual templates: " + manual_str);
                HashMap<Long, Engine> existing_engine_map = new HashMap<Long, Engine>();
                String existing_str = "";
                for (int i6 = 0; i6 < engines.length; ++i6) {
                    Engine engine = engines[i6];
                    Long key = new Long(engine.getId());
                    existing_engine_map.put(key, engine);
                    existing_str = existing_str + (existing_str.length() == 0 ? "" : ",") + key + "[source=" + Engine.ENGINE_SOURCE_STRS[engine.getSource()] + ",type=" + engine.getType() + ",selected=" + Engine.SEL_STATE_STRINGS[engine.getSelectionState()] + "]";
                }
                this.log("Existing templates: " + existing_str);
                for (Map.Entry entry : vuze_selected_ids.entrySet()) {
                    boolean update;
                    vuze_preload_ids.remove(entry.getKey());
                    long id = (Long)entry.getKey();
                    long modified = (Long)entry.getValue();
                    Engine this_engine = (Engine)existing_engine_map.get(new Long(id));
                    boolean bl = update = this_engine == null || this_engine.getLastUpdated() < modified;
                    if (update) {
                        PlatformMetaSearchMessenger.templateDetails details = PlatformMetaSearchMessenger.getTemplate(id);
                        this.log("Downloading definition of template " + id);
                        this.log(details.getValue());
                        if (details.isVisible()) {
                            try {
                                this_engine = this.meta_search.importFromJSONString(details.getType() == 1 ? 2 : 1, details.getId(), details.getModifiedDate(), details.getName(), details.getValue());
                                this_engine.setSource(1);
                                this.meta_search.addEngine(this_engine);
                            }
                            catch (Throwable e) {
                                this.log("Failed to import engine '" + details.getValue() + "'", e);
                            }
                        }
                    } else {
                        this.log("Not updating " + this_engine.getString() + " as unchanged");
                    }
                    if (this_engine == null || this_engine.getSelectionState() != 0) continue;
                    this.log("Auto-selecting " + this_engine.getString());
                    this_engine.setSelectionState(1);
                }
                for (Map.Entry entry : vuze_preload_ids.entrySet()) {
                    long id = (Long)entry.getKey();
                    Engine this_engine = (Engine)existing_engine_map.get(new Long(id));
                    if (this_engine != null) continue;
                    PlatformMetaSearchMessenger.templateDetails details = PlatformMetaSearchMessenger.getTemplate(id);
                    this.log("Downloading pre-load definition of template " + id);
                    this.log(details.getValue());
                    if (!details.isVisible()) continue;
                    try {
                        this_engine = this.meta_search.importFromJSONString(details.getType() == 1 ? 2 : 1, details.getId(), details.getModifiedDate(), details.getName(), details.getValue());
                        this_engine.setSource(1);
                        this_engine.setSelectionState(0);
                        this.meta_search.addEngine(this_engine);
                    }
                    catch (Throwable e) {
                        this.log("Failed to import engine '" + details.getValue() + "'", e);
                    }
                }
                for (i = 0; i < engines.length; ++i) {
                    Engine engine = engines[i];
                    if (engine.getSource() != 1 || engine.getSelectionState() == 0 || vuze_selected_ids.containsKey(new Long(engine.getId()))) continue;
                    this.log("Deselecting " + engine.getString() + " as no longer visible on Vuze");
                    engine.setSelectionState(0);
                }
                for (i = 0; i < engines.length; ++i) {
                    Engine engine = engines[i];
                    if (engine.getSource() == 1 && engine.getSelectionState() == 2) {
                        engine.recordSelectionState();
                        continue;
                    }
                    engine.checkSelectionStateRecorded();
                }
                refresh_completed = true;
            }
            catch (Throwable e) {
                this.log("Refresh failed", e);
                throw new MetaSearchException("Refresh failed", e);
            }
        }
        finally {
            if (first_run && refresh_completed) {
                COConfigurationManager.setParameter("metasearch.refresh.first_run", false);
            }
            this.refresh_sem.release();
            this.initial_refresh_sem.releaseForever();
        }
    }

    public MetaSearch getMetaSearch() {
        return this.meta_search;
    }

    public boolean isAutoMode() {
        return COConfigurationManager.getBooleanParameter("metasearch.auto.mode", false);
    }

    protected void setAutoMode(boolean auto) {
        COConfigurationManager.setParameter("metasearch.auto.mode", auto);
    }

    public void setSelectedEngines(long[] ids, boolean auto) throws MetaSearchException {
        try {
            Engine existing;
            long id;
            int i;
            String s = "";
            for (int i2 = 0; i2 < ids.length; ++i2) {
                s = s + (i2 == 0 ? "" : ",") + ids[i2];
            }
            this.log("setSelectedIds: " + s + ", auto=" + auto);
            COConfigurationManager.setParameter("metasearch.auto.mode", auto);
            Engine[] engines = this.meta_search.getEngines(false, false);
            HashMap<Long, Engine> engine_map = new HashMap<Long, Engine>();
            for (int i3 = 0; i3 < engines.length; ++i3) {
                engine_map.put(new Long(engines[i3].getId()), engines[i3]);
            }
            HashSet<Engine> selected_engine_set = new HashSet<Engine>();
            for (i = 0; i < ids.length; ++i) {
                id = ids[i];
                existing = (Engine)engine_map.get(new Long(id));
                if (existing == null) continue;
                existing.setSelectionState(2);
                selected_engine_set.add(existing);
            }
            this.syncRefresh();
            engines = this.meta_search.getEngines(false, false);
            for (i = 0; i < ids.length; ++i) {
                id = ids[i];
                existing = (Engine)engine_map.get(new Long(id));
                if (existing != null) continue;
                PlatformMetaSearchMessenger.templateDetails details = PlatformMetaSearchMessenger.getTemplate(id);
                this.log("Downloading definition of template " + id);
                this.log(details.getValue());
                Engine new_engine = this.meta_search.importFromJSONString(details.getType() == 1 ? 2 : 1, details.getId(), details.getModifiedDate(), details.getName(), details.getValue());
                new_engine.setSelectionState(2);
                new_engine.setSource(1);
                this.meta_search.addEngine(new_engine);
                selected_engine_set.add(new_engine);
            }
            for (i = 0; i < engines.length; ++i) {
                Engine e = engines[i];
                if (e.getSelectionState() != 2 || selected_engine_set.contains(e)) continue;
                e.setSelectionState(0);
            }
        }
        catch (Throwable e) {
            if (e instanceof MetaSearchException) {
                throw (MetaSearchException)e;
            }
            throw new MetaSearchException("Failed to set selected engines", e);
        }
    }

    public Engine addEngine(long id, int type, String name, String json_value) throws MetaSearchException {
        if (id == -1L) {
            id = this.getLocalTemplateID();
        }
        try {
            Engine engine = this.meta_search.importFromJSONString(type, id, SystemTime.getCurrentTime(), name, json_value);
            engine.setSource(2);
            engine.setSelectionState(2);
            this.meta_search.addEngine(engine);
            return engine;
        }
        catch (Throwable e) {
            throw new MetaSearchException("Failed to add engine", e);
        }
    }

    public Engine importEngine(Map map, boolean warn_user) throws MetaSearchException {
        try {
            String details;
            UIManager ui_manager;
            EngineImpl engine = (EngineImpl)this.meta_search.importFromBEncodedMap(map);
            long id = engine.getId();
            Engine existing = this.meta_search.getEngine(id);
            if (existing != null && existing.sameLogicAs(engine)) {
                if (warn_user) {
                    UIManager ui_manager2 = StaticUtilities.getUIManager(120000L);
                    String details2 = MessageText.getString("metasearch.addtemplate.dup.desc", new String[]{engine.getName()});
                    ui_manager2.showMessageBox("metasearch.addtemplate.dup.title", "!" + details2 + "!", 1L);
                }
                return existing;
            }
            if (warn_user) {
                ui_manager = StaticUtilities.getUIManager(120000L);
                details = MessageText.getString("metasearch.addtemplate.desc", new String[]{engine.getName()});
                long res = ui_manager.showMessageBox("metasearch.addtemplate.title", "!" + details + "!", 12L);
                if (res != 4L) {
                    throw new MetaSearchException("User declined the template");
                }
            }
            if (id >= 0L && id < Integer.MAX_VALUE) {
                id = this.getLocalTemplateID();
                engine.setId(id);
            }
            engine.setSource(2);
            engine.setSelectionState(2);
            this.meta_search.addEngine(engine);
            if (warn_user) {
                ui_manager = StaticUtilities.getUIManager(120000L);
                details = MessageText.getString("metasearch.addtemplate.done.desc", new String[]{engine.getName()});
                ui_manager.showMessageBox("metasearch.addtemplate.done.title", "!" + details + "!", 1L);
            }
            return engine;
        }
        catch (Throwable e) {
            if (warn_user) {
                UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                String details = MessageText.getString("metasearch.addtemplate.failed.desc", new String[]{Debug.getNestedExceptionMessage(e)});
                ui_manager.showMessageBox("metasearch.addtemplate.failed.title", "!" + details + "!", 1L);
            }
            throw new MetaSearchException("Failed to add engine", e);
        }
    }

    public Engine[] loadFromVuzeFile(File file) {
        VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(file.getAbsolutePath());
        if (vf != null) {
            return this.loadFromVuzeFile(vf);
        }
        return new Engine[0];
    }

    public Engine[] loadFromVuzeFile(VuzeFile vf) {
        ArrayList<Engine> result = new ArrayList<Engine>();
        VuzeFileComponent[] comps = vf.getComponents();
        for (int j = 0; j < comps.length; ++j) {
            VuzeFileComponent comp2 = comps[j];
            if (comp2.getType() != 1) continue;
            try {
                result.add(this.importEngine(comp2.getContent(), false));
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return result.toArray(new Engine[result.size()]);
    }

    public long getLocalTemplateID() {
        MetaSearchManagerImpl metaSearchManagerImpl = this;
        synchronized (metaSearchManagerImpl) {
            long id;
            Random random = new Random();
            while (this.meta_search.getEngine(id = Integer.MAX_VALUE + (long)random.nextInt(Integer.MAX_VALUE)) != null) {
            }
            return id;
        }
    }

    public void log(String s, Throwable e) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger(LOGGER_NAME);
        diag_logger.log(s);
        diag_logger.log(e);
        if (ConstantsV3.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + s + ": " + Debug.getNestedExceptionMessage(e));
        }
    }

    public void log(String s) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger(LOGGER_NAME);
        diag_logger.log(s);
        if (ConstantsV3.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Metasearch: auto=" + this.isAutoMode());
        try {
            writer.indent();
            this.meta_search.generate(writer);
        }
        finally {
            writer.exdent();
        }
    }
}

