/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web.rss;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSChannel;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSItem;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.json.simple.JSONObject;

public class RSSEngine
extends WebEngine {
    public static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        return new RSSEngine(meta_search, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl meta_search, long id, long last_updated, String name, JSONObject map) throws IOException {
        return new RSSEngine(meta_search, id, last_updated, name, map);
    }

    public RSSEngine(MetaSearchImpl meta_search, long id, long last_updated, String name, String searchURLFormat, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, 4, id, last_updated, name, searchURLFormat, "GMT", false, "EEE, d MMM yyyy HH:mm:ss Z", new FieldMapping[0], needs_auth, auth_method, login_url, required_cookies);
    }

    protected RSSEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
    }

    protected RSSEngine(MetaSearchImpl meta_search, long id, long last_updated, String name, JSONObject map) throws IOException {
        super(meta_search, 1, id, last_updated, name, map);
    }

    public Map exportToBencodedMap() throws IOException {
        HashMap res = new HashMap();
        super.exportToBencodedMap(res);
        return res;
    }

    public boolean supportsField(int field_id) {
        switch (field_id) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 102: 
            case 103: 
            case 105: {
                return true;
            }
        }
        return false;
    }

    protected Result[] searchSupport(SearchParameter[] searchParameters, Map searchContext, int desired_max_matches, int absolute_max_matches, String headers, ResultListener listener) throws SearchException {
        this.debugStart();
        WebEngine.pageDetails page_details = super.getWebPageContent(searchParameters, searchContext, headers, true);
        String page = page_details.getContent();
        if (listener != null) {
            listener.contentReceived(this, page);
        }
        if (page == null || page.length() == 0) {
            return new Result[0];
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(page.getBytes("UTF-8"));
            RSSFeed rssFeed = StaticUtilities.getRSSFeed(bais);
            RSSChannel[] channels = rssFeed.getChannels();
            ArrayList<WebResult> results = new ArrayList<WebResult>();
            block6: for (int i = 0; i < channels.length; ++i) {
                RSSChannel channel = channels[i];
                RSSItem[] items = channel.getItems();
                for (int j = 0; j < items.length; ++j) {
                    SimpleXMLParserDocumentNode node;
                    String uid;
                    RSSItem item = items[j];
                    WebResult result = new WebResult(this, this.getRootPage(), this.getBasePage(), this.getDateParser(), "");
                    result.setPublishedDate(item.getPublicationDate());
                    result.setNameFromHTML(item.getTitle());
                    URL cdp_link = item.getLink();
                    if (cdp_link != null) {
                        result.setCDPLink(cdp_link.toExternalForm());
                    }
                    if ((uid = item.getUID()) != null) {
                        result.setUID(uid);
                    }
                    if ((node = item.getNode()) != null) {
                        SimpleXMLParserDocumentNode[] children = node.getChildren();
                        for (int k = 0; k < children.length; ++k) {
                            SimpleXMLParserDocumentNode child = children[k];
                            String lc_child_name = child.getName().toLowerCase();
                            String lc_full_child_name = child.getFullName().toLowerCase();
                            String value = child.getValue();
                            if (lc_child_name.equals("enclosure")) {
                                SimpleXMLParserDocumentAttribute lengthAtt;
                                SimpleXMLParserDocumentAttribute typeAtt = child.getAttribute("type");
                                if (typeAtt == null || !typeAtt.getValue().equalsIgnoreCase("application/x-bittorrent")) continue;
                                SimpleXMLParserDocumentAttribute urlAtt = child.getAttribute("url");
                                if (urlAtt != null) {
                                    result.setTorrentLink(urlAtt.getValue());
                                }
                                if ((lengthAtt = child.getAttribute("length")) == null) continue;
                                result.setSizeFromHTML(lengthAtt.getValue());
                                continue;
                            }
                            if (lc_child_name.equals("category")) {
                                result.setCategory(value);
                                continue;
                            }
                            if (lc_child_name.equals("comments")) {
                                result.setCommentsFromHTML(value);
                                continue;
                            }
                            if (lc_child_name.equals("link") || lc_child_name.equals("guid")) {
                                String lc_value = value.toLowerCase();
                                try {
                                    if (!lc_value.endsWith(".torrent") && !lc_value.startsWith("magnet:") && !lc_value.startsWith("dht:")) continue;
                                    new URL(value);
                                    result.setTorrentLink(value);
                                }
                                catch (Throwable e) {}
                                continue;
                            }
                            if (lc_child_name.equals("content") && rssFeed.isAtomFeed()) {
                                String src;
                                SimpleXMLParserDocumentAttribute srcAtt = child.getAttribute("src");
                                String string = src = srcAtt == null ? null : srcAtt.getValue();
                                if (src == null) continue;
                                boolean is_dl_link = false;
                                SimpleXMLParserDocumentAttribute typeAtt = child.getAttribute("type");
                                if (typeAtt != null && typeAtt.getValue().equalsIgnoreCase("application/x-bittorrent")) {
                                    is_dl_link = true;
                                }
                                if (!is_dl_link) {
                                    boolean bl = is_dl_link = src.toLowerCase().indexOf(".torrent") != -1;
                                }
                                if (!is_dl_link) continue;
                                try {
                                    new URL(src);
                                    result.setTorrentLink(src);
                                }
                                catch (Throwable e) {}
                                continue;
                            }
                            if (lc_full_child_name.equals("vuze:size")) {
                                result.setSizeFromHTML(value);
                                continue;
                            }
                            if (lc_full_child_name.equals("vuze:seeds")) {
                                result.setNbSeedsFromHTML(value);
                                continue;
                            }
                            if (lc_full_child_name.equals("vuze:superseeds")) {
                                result.setNbSuperSeedsFromHTML(value);
                                continue;
                            }
                            if (lc_full_child_name.equals("vuze:peers")) {
                                result.setNbPeersFromHTML(value);
                                continue;
                            }
                            if (lc_full_child_name.equals("vuze:contenttype")) {
                                String type = value.toLowerCase();
                                if (type.startsWith("video")) {
                                    type = "video";
                                } else if (type.startsWith("audio")) {
                                    type = "audio";
                                } else if (type.startsWith("games")) {
                                    type = "game";
                                }
                                result.setContentType(type);
                                continue;
                            }
                            if (lc_full_child_name.equals("vuze:downloadurl")) {
                                result.setTorrentLink(value);
                                continue;
                            }
                            if (lc_full_child_name.equals("vuze:playurl")) {
                                result.setPlayLink(value);
                                continue;
                            }
                            if (lc_full_child_name.equals("vuze:drmkey")) {
                                result.setDrmKey(value);
                                continue;
                            }
                            if (!lc_full_child_name.equals("vuze:assethash")) continue;
                            result.setHash(value);
                        }
                    }
                    results.add(result);
                    if (absolute_max_matches >= 0 && results.size() == absolute_max_matches) continue block6;
                }
            }
            Result[] res = results.toArray(new Result[results.size()]);
            this.debugLog("success: found " + res.length + " results");
            return res;
        }
        catch (Throwable e) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(e));
            if (e instanceof SearchException) {
                throw (SearchException)e;
            }
            throw new SearchException("RSS matching failed", e);
        }
    }
}

