/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionFactory;
import com.aelitis.azureus.core.networkmanager.NetworkManagerStats;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.IncomingConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.networkmanager.impl.ReadController;
import com.aelitis.azureus.core.networkmanager.impl.TransferProcessor;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.WriteController;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import com.aelitis.azureus.core.util.FeatureAvailability;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.util.Debug;

public class NetworkManager {
    public static final int UNLIMITED_RATE = 0x6400000;
    private static final NetworkManager instance = new NetworkManager();
    private static int max_download_rate_bps;
    private static int external_max_download_rate_bps;
    private static int max_upload_rate_bps_normal;
    private static int max_upload_rate_bps_seeding_only;
    private static int max_upload_rate_bps;
    private static boolean lan_rate_enabled;
    private static int max_lan_upload_rate_bps;
    private static int max_lan_download_rate_bps;
    private static boolean seeding_only_mode_allowed;
    private static boolean seeding_only_mode;
    public static boolean REQUIRE_CRYPTO_HANDSHAKE;
    public static boolean INCOMING_HANDSHAKE_FALLBACK_ALLOWED;
    public static boolean OUTGOING_HANDSHAKE_FALLBACK_ALLOWED;
    public static boolean INCOMING_CRYPTO_ALLOWED;
    private static boolean USE_REQUEST_LIMITING;
    private final WriteController write_controller = new WriteController();
    private final ReadController read_controller = new ReadController();
    private final TransferProcessor upload_processor = new TransferProcessor(0, new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return max_upload_rate_bps;
        }
    });
    private final TransferProcessor download_processor = new TransferProcessor(1, new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return max_download_rate_bps;
        }
    });
    private final TransferProcessor lan_upload_processor = new TransferProcessor(0, new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return max_lan_upload_rate_bps;
        }
    });
    private final TransferProcessor lan_download_processor = new TransferProcessor(1, new LimitedRateGroup(){

        public int getRateLimitBytesPerSecond() {
            return max_lan_download_rate_bps;
        }
    });
    private NetworkManagerStats stats = new NetworkManagerStats();
    public static final int CRYPTO_OVERRIDE_NONE = 0;
    public static final int CRYPTO_OVERRIDE_REQUIRED = 1;
    public static final int CRYPTO_OVERRIDE_NOT_REQUIRED = 2;

    public static boolean isLANRateEnabled() {
        return lan_rate_enabled;
    }

    private NetworkManager() {
    }

    public static int getMinMssSize() {
        return Math.min(TCPNetworkManager.getTcpMssSize(), UDPNetworkManager.getUdpMssSize());
    }

    private static void refreshRates() {
        max_upload_rate_bps = NetworkManager.isSeedingOnlyUploadRate() ? max_upload_rate_bps_seeding_only : max_upload_rate_bps_normal;
        if (max_upload_rate_bps < 1024) {
            Debug.out("max_upload_rate_bps < 1024=" + max_upload_rate_bps);
        }
        int min_rate = Math.min(max_upload_rate_bps, Math.min(max_download_rate_bps, Math.min(max_lan_upload_rate_bps, max_lan_download_rate_bps)));
        TCPNetworkManager.refreshRates(min_rate);
        UDPNetworkManager.refreshRates(min_rate);
    }

    public static boolean isSeedingOnlyUploadRate() {
        return seeding_only_mode_allowed && seeding_only_mode;
    }

    public static int getMaxUploadRateBPSNormal() {
        if (max_upload_rate_bps_normal == 0x6400000) {
            return 0;
        }
        return max_upload_rate_bps_normal;
    }

    public static int getMaxUploadRateBPSSeedingOnly() {
        if (max_upload_rate_bps_seeding_only == 0x6400000) {
            return 0;
        }
        return max_upload_rate_bps_seeding_only;
    }

    public static int getMaxDownloadRateBPS() {
        if (max_download_rate_bps == 0x6400000) {
            return 0;
        }
        return external_max_download_rate_bps;
    }

    public static boolean getCryptoRequired(int override_level) {
        if (override_level == 0) {
            return REQUIRE_CRYPTO_HANDSHAKE;
        }
        return override_level == 1;
    }

    public void initialize() {
        HTTPNetworkManager.getSingleton();
        AzureusCoreFactory.getSingleton().getGlobalManager().addListener(new GlobalManagerListener(){

            public void downloadManagerAdded(DownloadManager dm) {
            }

            public void downloadManagerRemoved(DownloadManager dm) {
            }

            public void destroyInitiated() {
            }

            public void destroyed() {
            }

            public void seedingStatusChanged(boolean seeding_only, boolean b) {
                seeding_only_mode = seeding_only;
                NetworkManager.refreshRates();
            }
        });
    }

    public static NetworkManager getSingleton() {
        return instance;
    }

    public NetworkConnection createConnection(ConnectionEndpoint target, MessageStreamEncoder encoder, MessageStreamDecoder decoder, boolean connect_with_crypto, boolean allow_fallback, byte[][] shared_secrets) {
        return NetworkConnectionFactory.create(target, encoder, decoder, connect_with_crypto, allow_fallback, shared_secrets);
    }

    public void requestIncomingConnectionRouting(ByteMatcher matcher, final RoutingListener listener, final MessageStreamFactory factory) {
        IncomingConnectionManager.getSingleton().registerMatchBytes(matcher, new IncomingConnectionManager.MatchListener(){

            public boolean autoCryptoFallback() {
                return listener.autoCryptoFallback();
            }

            public void connectionMatched(Transport transport, Object routing_data) {
                listener.connectionRouted(NetworkConnectionFactory.create(transport, factory.createEncoder(), factory.createDecoder()), routing_data);
            }
        });
    }

    public NetworkConnection bindTransport(Transport transport, MessageStreamEncoder encoder, MessageStreamDecoder decoder) {
        return NetworkConnectionFactory.create(transport, encoder, decoder);
    }

    public void cancelIncomingConnectionRouting(ByteMatcher matcher) {
        IncomingConnectionManager.getSingleton().deregisterMatchBytes(matcher);
    }

    public void addWriteEntity(RateControlledEntity entity) {
        this.write_controller.addWriteEntity(entity);
    }

    public void removeWriteEntity(RateControlledEntity entity) {
        this.write_controller.removeWriteEntity(entity);
    }

    public void addReadEntity(RateControlledEntity entity) {
        this.read_controller.addReadEntity(entity);
    }

    public void removeReadEntity(RateControlledEntity entity) {
        this.read_controller.removeReadEntity(entity);
    }

    public void startTransferProcessing(NetworkConnectionBase peer_connection) {
        if (peer_connection.isLANLocal() && lan_rate_enabled) {
            this.lan_upload_processor.registerPeerConnection(peer_connection, true);
            this.lan_download_processor.registerPeerConnection(peer_connection, false);
        } else {
            this.upload_processor.registerPeerConnection(peer_connection, true);
            this.download_processor.registerPeerConnection(peer_connection, false);
        }
    }

    public void stopTransferProcessing(NetworkConnectionBase peer_connection) {
        if (this.lan_upload_processor.isRegistered(peer_connection)) {
            this.lan_upload_processor.deregisterPeerConnection(peer_connection);
            this.lan_download_processor.deregisterPeerConnection(peer_connection);
        } else {
            this.upload_processor.deregisterPeerConnection(peer_connection);
            this.download_processor.deregisterPeerConnection(peer_connection);
        }
    }

    public void upgradeTransferProcessing(NetworkConnectionBase peer_connection) {
        if (this.lan_upload_processor.isRegistered(peer_connection)) {
            this.lan_upload_processor.upgradePeerConnection(peer_connection);
            this.lan_download_processor.upgradePeerConnection(peer_connection);
        } else {
            this.upload_processor.upgradePeerConnection(peer_connection);
            this.download_processor.upgradePeerConnection(peer_connection);
        }
    }

    public void downgradeTransferProcessing(NetworkConnectionBase peer_connection) {
        if (this.lan_upload_processor.isRegistered(peer_connection)) {
            this.lan_upload_processor.downgradePeerConnection(peer_connection);
            this.lan_download_processor.downgradePeerConnection(peer_connection);
        } else {
            this.upload_processor.downgradePeerConnection(peer_connection);
            this.download_processor.downgradePeerConnection(peer_connection);
        }
    }

    public void addRateLimiter(NetworkConnectionBase peer_connection, LimitedRateGroup group, boolean upload) {
        if (upload) {
            if (this.lan_upload_processor.isRegistered(peer_connection)) {
                this.lan_upload_processor.addRateLimiter(peer_connection, group);
            } else {
                this.upload_processor.addRateLimiter(peer_connection, group);
            }
        } else if (this.lan_download_processor.isRegistered(peer_connection)) {
            this.lan_download_processor.addRateLimiter(peer_connection, group);
        } else {
            this.download_processor.addRateLimiter(peer_connection, group);
        }
    }

    public void removeRateLimiter(NetworkConnectionBase peer_connection, LimitedRateGroup group, boolean upload) {
        if (upload) {
            if (this.lan_upload_processor.isRegistered(peer_connection)) {
                this.lan_upload_processor.removeRateLimiter(peer_connection, group);
            } else {
                this.upload_processor.removeRateLimiter(peer_connection, group);
            }
        } else if (this.lan_download_processor.isRegistered(peer_connection)) {
            this.lan_download_processor.removeRateLimiter(peer_connection, group);
        } else {
            this.download_processor.removeRateLimiter(peer_connection, group);
        }
    }

    public NetworkManagerStats getStats() {
        return this.stats;
    }

    static {
        seeding_only_mode = false;
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.transport.encrypted.require", "network.transport.encrypted.fallback.incoming", "network.transport.encrypted.fallback.outgoing", "network.transport.encrypted.allow.incoming", "LAN Speed Enabled", "Max Upload Speed KBs", "Max LAN Upload Speed KBs", "Max Upload Speed Seeding KBs", "enable.seedingonly.upload.rate", "Max Download Speed KBs", "Max LAN Download Speed KBs", "network.tcp.mtu.size", "network.udp.mtu.size", "Use Request Limiting"}, new ParameterListener(){

            public void parameterChanged(String ignore) {
                REQUIRE_CRYPTO_HANDSHAKE = COConfigurationManager.getBooleanParameter("network.transport.encrypted.require");
                INCOMING_HANDSHAKE_FALLBACK_ALLOWED = COConfigurationManager.getBooleanParameter("network.transport.encrypted.fallback.incoming");
                OUTGOING_HANDSHAKE_FALLBACK_ALLOWED = COConfigurationManager.getBooleanParameter("network.transport.encrypted.fallback.outgoing");
                INCOMING_CRYPTO_ALLOWED = COConfigurationManager.getBooleanParameter("network.transport.encrypted.allow.incoming");
                USE_REQUEST_LIMITING = COConfigurationManager.getBooleanParameter("Use Request Limiting");
                max_upload_rate_bps_normal = COConfigurationManager.getIntParameter("Max Upload Speed KBs") * 1024;
                if (max_upload_rate_bps_normal < 1024) {
                    max_upload_rate_bps_normal = 0x6400000;
                }
                if (max_upload_rate_bps_normal > 0x6400000) {
                    max_upload_rate_bps_normal = 0x6400000;
                }
                max_lan_upload_rate_bps = COConfigurationManager.getIntParameter("Max LAN Upload Speed KBs") * 1024;
                if (max_lan_upload_rate_bps < 1024) {
                    max_lan_upload_rate_bps = 0x6400000;
                }
                if (max_lan_upload_rate_bps > 0x6400000) {
                    max_lan_upload_rate_bps = 0x6400000;
                }
                max_upload_rate_bps_seeding_only = COConfigurationManager.getIntParameter("Max Upload Speed Seeding KBs") * 1024;
                if (max_upload_rate_bps_seeding_only < 1024) {
                    max_upload_rate_bps_seeding_only = 0x6400000;
                }
                if (max_upload_rate_bps_seeding_only > 0x6400000) {
                    max_upload_rate_bps_seeding_only = 0x6400000;
                }
                seeding_only_mode_allowed = COConfigurationManager.getBooleanParameter("enable.seedingonly.upload.rate");
                external_max_download_rate_bps = (max_download_rate_bps = COConfigurationManager.getIntParameter("Max Download Speed KBs") * 1024);
                if (max_download_rate_bps < 1024 || max_download_rate_bps > 0x6400000) {
                    max_download_rate_bps = 0x6400000;
                } else if (USE_REQUEST_LIMITING && FeatureAvailability.isRequestLimitingEnabled()) {
                    max_download_rate_bps = (int)((double)max_download_rate_bps + Math.max((double)max_download_rate_bps * 0.1, 5120.0));
                }
                lan_rate_enabled = COConfigurationManager.getBooleanParameter("LAN Speed Enabled");
                max_lan_download_rate_bps = COConfigurationManager.getIntParameter("Max LAN Download Speed KBs") * 1024;
                if (max_lan_download_rate_bps < 1024) {
                    max_lan_download_rate_bps = 0x6400000;
                }
                if (max_lan_download_rate_bps > 0x6400000) {
                    max_lan_download_rate_bps = 0x6400000;
                }
                NetworkManager.refreshRates();
            }
        });
    }

    public static interface ByteMatcher {
        public int matchThisSizeOrBigger();

        public int maxSize();

        public int minSize();

        public Object matches(TransportHelper var1, ByteBuffer var2, int var3);

        public Object minMatches(TransportHelper var1, ByteBuffer var2, int var3);

        public byte[][] getSharedSecrets();

        public int getSpecificPort();
    }

    public static interface RoutingListener {
        public boolean autoCryptoFallback();

        public void connectionRouted(NetworkConnection var1, Object var2);
    }
}

