/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProgressListener;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolTester;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.net.InetAddress;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatChecker;

public class NetworkAdminTCPTester
implements NetworkAdminProtocolTester {
    private AzureusCore core;
    private NetworkAdminProgressListener listener;

    protected NetworkAdminTCPTester(AzureusCore _core, NetworkAdminProgressListener _listener) {
        this.core = _core;
        this.listener = _listener;
    }

    public InetAddress testOutbound(InetAddress bind_ip, int bind_port) throws NetworkAdminException {
        try {
            return VersionCheckClient.getSingleton().getExternalIpAddressTCP(bind_ip, bind_port, false);
        }
        catch (Throwable e) {
            throw new NetworkAdminException("Outbound test failed", e);
        }
    }

    public InetAddress testInbound(InetAddress bind_ip, int local_port) throws NetworkAdminException {
        NatChecker checker = new NatChecker(this.core, bind_ip, local_port, false);
        if (checker.getResult() == 1) {
            return checker.getExternalAddress();
        }
        throw new NetworkAdminException("NAT test failed: " + checker.getAdditionalInfo());
    }
}

