/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TransportEndpointTCP;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class LightweightTCPTransport
implements Transport {
    private final TransportEndpoint transport_endpoint;
    private final TransportHelperFilter filter;

    public LightweightTCPTransport(ProtocolEndpoint pe, TransportHelperFilter filter) {
        SocketChannel channel = ((TCPTransportHelper)filter.getHelper()).getSocketChannel();
        this.transport_endpoint = new TransportEndpointTCP(pe, channel);
        this.filter = filter;
    }

    public TransportEndpoint getTransportEndpoint() {
        return this.transport_endpoint;
    }

    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        return this.filter.write(buffers, array_offset, length);
    }

    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        return this.filter.read(buffers, array_offset, length);
    }

    public SocketChannel getSocketChannel() {
        return ((TCPTransportHelper)this.filter.getHelper()).getSocketChannel();
    }

    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.getSocketChannel().socket().getInetAddress(), this.getSocketChannel().socket().getPort());
    }

    public String getDescription() {
        return this.getSocketChannel().socket().getInetAddress().getHostAddress() + ": " + this.getSocketChannel().socket().getPort();
    }

    public void close(String reason) {
        try {
            this.getSocketChannel().close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public int getMssSize() {
        return TCPNetworkManager.getTcpMssSize();
    }

    public void setAlreadyRead(ByteBuffer bytes_already_read) {
        throw new RuntimeException("not implemented");
    }

    public boolean isReadyForWrite(EventWaiter waiter) {
        throw new RuntimeException("not implemented");
    }

    public long isReadyForRead(EventWaiter waiter) {
        throw new RuntimeException("not implemented");
    }

    public void setReadyForRead() {
        throw new RuntimeException("not implemented");
    }

    public void connectOutbound(ByteBuffer initial_data, Transport.ConnectListener listener, int priority) {
        throw new RuntimeException("not implemented");
    }

    public void connectedInbound() {
        throw new RuntimeException("not implemented");
    }

    public void setTransportMode(int mode) {
        throw new RuntimeException("not implemented");
    }

    public int getTransportMode() {
        throw new RuntimeException("not implemented");
    }

    public void setTrace(boolean on) {
    }

    public String getEncryption(boolean verbose) {
        return this.filter.getName(verbose);
    }

    public boolean isEncrypted() {
        return this.filter.isEncrypted();
    }

    public boolean isTCP() {
        return true;
    }
}

